/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.ui.RunnerUiUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public abstract class AbstractLaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    @Inject
    private IN4JSCore in4jsCore;
    protected static final String MAIN_TAB_NAME = "Main";
    protected Text txtResource;
    protected Text txtTestMethod;
    protected Text txtImplementationId;

    public static String getResourceRunAsText(ILaunchConfiguration configuration) throws CoreException {
        String uriStr = configuration.getAttribute("USER_SELECTION", "");
        URI uri = uriStr.trim().length() > 0 ? URI.createURI((String)uriStr) : null;
        String wsRelativePath = uri != null ? uri.toPlatformString(true) : null;
        return wsRelativePath != null ? wsRelativePath : "";
    }

    public String getTestMethod(ILaunchConfiguration configuration) {
        URI uri;
        block7: {
            String uriStr;
            block6: {
                uriStr = configuration.getAttribute("USER_SELECTION", "");
                if (uriStr != null) break block6;
                return "";
            }
            URI uRI = uri = uriStr.trim().length() > 0 ? URI.createURI((String)uriStr) : null;
            if (uri != null) break block7;
            return "";
        }
        try {
            EObject eobject;
            ResourceSet resSet;
            URI trimmedUri = uri.hasFragment() ? uri.trimFragment() : uri;
            IN4JSProject project = (IN4JSProject)this.in4jsCore.findProject(trimmedUri).orNull();
            if (project != null && (resSet = this.in4jsCore.createResourceSet(Optional.of((Object)project))) != null && (eobject = resSet.getEObject(uri, true)) instanceof N4MethodDeclaration) {
                N4MethodDeclaration method = (N4MethodDeclaration)eobject;
                String name = ((N4MethodDeclaration)eobject).getName();
                if (method.getOwner() instanceof N4ClassDeclaration) {
                    return String.valueOf(((N4ClassDeclaration)method.getOwner()).getName()) + "." + name;
                }
                return name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getName() {
        return MAIN_TAB_NAME;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = AbstractLaunchConfigurationMainTab.createComposite(parent, font, 1, 1, 1808);
        this.createResourceGroup(comp);
        this.createImplementationIdGroup(comp);
        this.setControl((Control)comp);
    }

    protected void createResourceGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(this.getResourceLabel());
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(parent.getFont());
        this.txtResource = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.txtResource.setLayoutData((Object)gd);
        this.txtResource.setFont(parent.getFont());
        this.txtResource.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button btnSearch = this.createPushButton((Composite)group, "Search...", null);
        gd = new GridData(768);
        btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String resourceStr = AbstractLaunchConfigurationMainTab.this.searchResource();
                if (resourceStr != null) {
                    AbstractLaunchConfigurationMainTab.this.txtResource.setText(resourceStr);
                }
            }
        });
        this.txtTestMethod = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.txtTestMethod.setLayoutData((Object)gd);
        this.txtTestMethod.setFont(parent.getFont());
        this.txtTestMethod.setEditable(false);
    }

    protected void createImplementationIdGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Implementation ID");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setFont(parent.getFont());
        this.txtImplementationId = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.txtImplementationId.setLayoutData((Object)gd);
        this.txtImplementationId.setFont(parent.getFont());
        this.txtImplementationId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected abstract String getResourceLabel();

    protected abstract String getResourceRunConfigKey();

    protected abstract int getAcceptedResourceTypes();

    protected String searchResource() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)root, this.getAcceptedResourceTypes());
        dialog.setTitle("Search " + this.getResourceLabel());
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            return file.getFullPath().toString();
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("RUNNER_ID", RunnerUiUtils.getRunnerId((ILaunchConfiguration)configuration, true));
        configuration.setAttribute("IMPLEMENTATION_ID", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String wsRelativePath = AbstractLaunchConfigurationMainTab.getResourceRunAsText(configuration);
            this.txtResource.setText(wsRelativePath);
            String testMethod = this.getTestMethod(configuration);
            this.txtTestMethod.setText(testMethod);
            String implId = configuration.getAttribute("IMPLEMENTATION_ID", "");
            this.txtImplementationId.setText(implId);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wsRelativePath = this.txtResource.getText();
        URI uri = wsRelativePath.trim().length() > 0 ? URI.createPlatformResourceURI((String)wsRelativePath, (boolean)true) : null;
        String uriStr = uri != null ? uri.toString() : null;
        configuration.setAttribute(this.getResourceRunConfigKey(), uriStr);
        String implementationId = this.txtImplementationId.getText();
        String actualImplId = implementationId.trim().length() > 0 ? implementationId.trim() : null;
        configuration.setAttribute("IMPLEMENTATION_ID", actualImplId);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String uriStr;
        this.setMessage(null);
        this.setErrorMessage(null);
        try {
            uriStr = launchConfig.getAttribute(this.getResourceRunConfigKey(), "");
        }
        catch (CoreException e1) {
            this.setErrorMessage("cannot read resource URI from launch configuration");
            return false;
        }
        if (uriStr.trim().isEmpty()) {
            this.setErrorMessage("launch configuration must specify a " + this.getResourceLabel().toLowerCase());
            return false;
        }
        URI resourceUri = URI.createURI((String)uriStr, (boolean)true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(resourceUri.toPlatformString(true));
        if (resource == null) {
            this.setErrorMessage("unable to locate resource in workspace: " + resourceUri.toPlatformString(true));
            return false;
        }
        if (!this.checkResourceIsInAvailableProject(resourceUri)) {
            return false;
        }
        if (!this.checkResourceIsOfAcceptedType(resource)) {
            return false;
        }
        return this.checkSubclassSpecificConstraints(launchConfig, resource, resourceUri);
    }

    protected boolean checkResourceIsInAvailableProject(URI resourceUri) {
        Optional oProject = this.in4jsCore.findProject(resourceUri);
        if (!oProject.isPresent()) {
            this.setErrorMessage("cannot locate N4JS project for " + resourceUri.toPlatformString(true));
            return false;
        }
        return true;
    }

    protected boolean checkResourceIsOfAcceptedType(IResource resource) {
        boolean isOfAcceptedOfType;
        boolean bl = isOfAcceptedOfType = (this.getAcceptedResourceTypes() & resource.getType()) != 0;
        if (!isOfAcceptedOfType) {
            this.setErrorMessage("resource is of wrong type");
            return false;
        }
        return true;
    }

    protected abstract boolean checkSubclassSpecificConstraints(ILaunchConfiguration var1, IResource var2, URI var3);

    protected static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }
}

