/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.ui.building.BuilderStateLogger;
import org.eclipse.n4js.ui.building.N4ClusteringBuilderState;
import org.eclipse.n4js.ui.building.N4JSBuildTypeTracker;
import org.eclipse.n4js.ui.building.N4JSBuilderParticipant;
import org.eclipse.n4js.ui.building.N4JSResourceSetCleanerUtils;
import org.eclipse.n4js.ui.building.instructions.IBuildParticipantInstruction;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.RegistryBuilderParticipant;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;

public class N4JSGenerateImmediatelyBuilderState
extends N4ClusteringBuilderState {
    @Inject
    private RegistryBuilderParticipant builderParticipant;
    @Inject
    @BuilderStateLogger.BuilderState
    private IBuildLogger builderStateLogger;
    private ExternalLibraryWorkspace externalLibraryWorkspace;

    @Inject
    private void injectExternalLibraryWorkspace(ISharedStateContributionRegistry contributionRegistry) {
        try {
            this.externalLibraryWorkspace = (ExternalLibraryWorkspace)contributionRegistry.getSingleContributedInstance(ExternalLibraryWorkspace.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Collection<IResourceDescription.Delta> doUpdate(BuildData buildData, ResourceDescriptionsData newData, IProgressMonitor monitor) {
        this.builderStateLogger.log((Object)"N4JSGenerateImmediatelyBuilderState.doUpdate() >>>");
        monitor.subTask("Building " + buildData.getProjectName());
        this.logBuildData(buildData, " of before #doUpdate");
        Throwable throwable = null;
        Object var5_6 = null;
        try (Measurement m = N4JSDataCollectors.dcBuild.getMeasurement("build " + Instant.now());){
            try {
                IBuildParticipantInstruction instruction = IBuildParticipantInstruction.NOOP;
                IProject project = this.findProject(buildData);
                if (project != null) {
                    IXtextBuilderParticipant.BuildType buildType = N4JSBuildTypeTracker.getBuildType(project);
                    instruction = this.findJSBuilderParticipant().prepareBuild(project, buildType);
                }
                buildData.getResourceSet().eAdapters().add((Object)instruction);
            }
            catch (CoreException e) {
                this.handleCoreException(e);
            }
            Collection<IResourceDescription.Delta> modifiedDeltas = super.doUpdate(buildData, newData, monitor);
            this.logBuildData(buildData, " of after #doUpdate");
            this.builderStateLogger.log((Object)("Modified deltas: " + modifiedDeltas));
            this.builderStateLogger.log((Object)"N4JSGenerateImmediatelyBuilderState.doUpdate() <<<");
            return modifiedDeltas;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void logBuildData(BuildData buildData, String ... tags) {
        String tag = Arrays2.isEmpty((Object[])tags) ? "" : Joiner.on((String)" - ").join((Object[])tags);
        String header = "---------------------- Build data" + tag + " --------------------------------------";
        this.builderStateLogger.log((Object)header);
        this.builderStateLogger.log((Object)("Project name: " + buildData.getProjectName()));
        this.builderStateLogger.log((Object)("To be deleted: " + this.ensureNotNull(buildData.getToBeDeleted())));
        this.builderStateLogger.log((Object)("To be updated: " + this.ensureNotNull(buildData.getToBeUpdated())));
        this.builderStateLogger.log((Object)("URI queue: " + buildData.getURIQueue()));
        this.builderStateLogger.log((Object)("All remaining URIs: " + buildData.getAllRemainingURIs()));
        this.builderStateLogger.log((Object)(String.valueOf(Strings.repeat((String)"-", (int)header.length())) + "\n"));
    }

    @Override
    protected void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        URI uri = delta.getUri();
        DataCollector dc = uri != null && "package.json".equals(uri.lastSegment()) ? N4JSDataCollectors.dcValidationsPackageJson : N4JSDataCollectors.dcValidations;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (Measurement m = dc.getMeasurement("validation");){
            super.updateMarkers(delta, resourceSet, monitor);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (resourceSet != null) {
            IBuildParticipantInstruction instruction = (IBuildParticipantInstruction)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), IBuildParticipantInstruction.class);
            if (instruction == null) {
                throw new IllegalStateException();
            }
            try {
                throwable2 = null;
                Object var9_13 = null;
                try (Measurement m = N4JSDataCollectors.dcTranspilation.getMeasurement("transpilation");){
                    instruction.process(delta, resourceSet, (IProgressMonitor)subMonitor.split(1));
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            catch (CoreException e) {
                this.handleCoreException(e);
            }
        }
    }

    @Override
    protected void clearResourceSet(ResourceSet resourceSet) {
        N4JSResourceSetCleanerUtils.clearResourceSet(resourceSet);
    }

    private N4JSBuilderParticipant findJSBuilderParticipant() {
        ImmutableList all = this.builderParticipant.getParticipants();
        for (IXtextBuilderParticipant candidate : all) {
            IXtextBuilderParticipant delegate;
            RegistryBuilderParticipant.DeferredBuilderParticipant dbp;
            if (!(candidate instanceof RegistryBuilderParticipant.DeferredBuilderParticipant) || !this.isParticipating(dbp = (RegistryBuilderParticipant.DeferredBuilderParticipant)candidate) || !((delegate = dbp.getDelegate()) instanceof N4JSBuilderParticipant)) continue;
            return (N4JSBuilderParticipant)delegate;
        }
        throw new IllegalStateException();
    }

    private boolean isParticipating(RegistryBuilderParticipant.DeferredBuilderParticipant dbp) {
        for (String ext : N4JSGlobals.ALL_N4_FILE_EXTENSIONS) {
            if (!dbp.isParticipating(ext)) continue;
            return true;
        }
        return false;
    }

    private void handleCoreException(CoreException e) {
        N4JSActivator.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.n4js.N4JS", e.getMessage(), (Throwable)e));
    }

    private IProject findProject(BuildData buildData) {
        String n4jsProjectName;
        N4JSExternalProject externalProject;
        String eclipseProjectName = buildData.getProjectName();
        if (eclipseProjectName == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(eclipseProjectName);
        if ((project == null || !project.isAccessible()) && (externalProject = this.externalLibraryWorkspace.getProject(n4jsProjectName = ProjectDescriptionUtils.convertEclipseProjectNameToN4JSProjectName((String)eclipseProjectName))) != null && externalProject.exists()) {
            project = externalProject;
        }
        return project;
    }
}

