/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import java.util.ArrayList;
import java.util.List;

public class MD2HTMLConvertingBuilder {
    private String md;
    private int pos;
    private final StringBuilder html;
    private boolean bol = true;
    private char current;
    private final List<Block> blocks = new ArrayList<Block>();
    private int depth = 0;

    public static String convert(String markdown) {
        MD2HTMLConvertingBuilder m2h = new MD2HTMLConvertingBuilder();
        m2h.convertAndAppend(markdown);
        return m2h.done();
    }

    public MD2HTMLConvertingBuilder() {
        this.html = new StringBuilder();
        this.resetMarkdownConverter();
    }

    public void convertAndAppend(CharSequence markdown) {
        if (markdown == null) {
            return;
        }
        this.md = markdown.toString();
        this.pos = 0;
        do {
            this.next();
            switch (this.current) {
                case '\u0000': {
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    this.handleEOL();
                    break;
                }
                case '-': {
                    this.handleUL();
                    break;
                }
                default: {
                    this.handleChar();
                }
            }
        } while (this.current != '\u0000');
    }

    public MD2HTMLConvertingBuilder append(CharSequence cs) {
        this.html.append(cs);
        return this;
    }

    public String done() {
        this.closeAllBlocks();
        String result = this.html.toString();
        this.resetMarkdownConverter();
        return result;
    }

    public void resetMarkdownConverter() {
        this.closeAllBlocks();
        this.bol = true;
        this.depth = 0;
        this.md = "";
        this.pos = 0;
    }

    private void openBlock(int blockDepth, String mdTag, String startTag, String endTag) {
        Block b = new Block(blockDepth, mdTag, startTag, endTag);
        this.html.append(startTag);
        this.blocks.add(b);
    }

    private void closeBlock() {
        int i = this.blocks.size() - 1;
        if (i >= 0) {
            this.html.append(this.blocks.get((int)i).endTag);
            this.html.append("\n");
        }
        this.blocks.remove(i);
    }

    private void closeAllBlocks() {
        while (!this.blocks.isEmpty()) {
            this.closeBlock();
        }
    }

    private Block closeNestedBlocks(String mdTag) {
        int i = this.blocks.size() - 1;
        while (i >= 0) {
            Block b = this.blocks.get(i);
            if (b.depth > this.depth) {
                this.closeBlock();
            } else if (b.depth == this.depth) {
                if (mdTag != null && mdTag.equals(b.mdTag)) {
                    return b;
                }
                this.closeBlock();
            } else {
                return b;
            }
            --i;
        }
        return null;
    }

    private void next() {
        if (this.pos < this.md.length()) {
            this.current = this.md.charAt(this.pos);
            ++this.pos;
        } else {
            this.current = '\u0000';
        }
    }

    private char peek() {
        if (this.pos < this.md.length()) {
            char p = this.md.charAt(this.pos);
            return p;
        }
        return '\u0000';
    }

    private void handleEOL() {
        this.html.append("\n");
        int currentDepth = this.depth;
        this.depth = 0;
        boolean parFound = false;
        char s = this.peek();
        while (Character.isWhitespace(s)) {
            switch (s) {
                case '\n': {
                    parFound = true;
                    this.depth = 0;
                    break;
                }
                case '\t': {
                    this.depth += 4;
                    break;
                }
                case ' ': {
                    ++this.depth;
                }
            }
            this.next();
            s = this.peek();
        }
        if (parFound) {
            if (this.depth > currentDepth) {
                this.html.append("<p>");
            } else {
                Block b = this.closeNestedBlocks(null);
                if (b == null) {
                    this.html.append("<p>");
                }
            }
        }
        this.bol = true;
    }

    private void handleUL() {
        if (!Character.isWhitespace(this.peek())) {
            this.handleChar();
        }
        if (!this.bol) {
            this.html.append(this.current);
            return;
        }
        String mdTag = String.valueOf(this.current);
        Block b = this.closeNestedBlocks(mdTag);
        if (b == null || this.depth > b.depth) {
            this.openBlock(this.depth, mdTag, "<ul>\n", "</ul>");
        }
        this.html.append("<li>");
        this.next();
        this.bol = false;
    }

    private void handleChar() {
        if (this.bol) {
            if (this.depth > 0) {
                this.closeNestedBlocks(null);
            }
            this.bol = false;
        }
        this.html.append(this.current);
    }

    public String toString() {
        int from = this.pos - 4;
        int to = this.pos + 4;
        if (from < 0) {
            from = 0;
        }
        if (to >= this.md.length()) {
            to = this.md.length() - 1;
        }
        StringBuilder strb = new StringBuilder();
        if (from > 0) {
            strb.append("\u2026");
        }
        int i = from;
        while (i <= to) {
            if (i == this.pos - 1) {
                strb.append("\u00bb");
            }
            strb.append(MD2HTMLConvertingBuilder.encode(this.md.charAt(i)));
            if (i == this.pos - 1) {
                strb.append("\u00ab");
            }
            ++i;
        }
        if (to < this.md.length() - 1) {
            strb.append("\u2026");
        }
        strb.append(", depth " + this.depth);
        if (!this.blocks.isEmpty()) {
            strb.append(", blocks[" + (this.blocks.size() - 1) + "]=");
            strb.append(this.blocks.get(this.blocks.size() - 1));
        }
        return strb.toString();
    }

    private static String encode(char raw) {
        switch (raw) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
            case '0': {
                return "\u2020";
            }
        }
        return String.valueOf(raw);
    }

    private static String encode(String raw) {
        if (raw == null) {
            return "null";
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < raw.length()) {
            strb.append(MD2HTMLConvertingBuilder.encode(raw.charAt(i)));
            ++i;
        }
        return strb.toString();
    }

    private static class Block {
        final int depth;
        final String startTag;
        final String endTag;
        final String mdTag;

        Block(int depth, String mdTag, String startTag, String endTag) {
            this.depth = depth;
            this.startTag = startTag;
            this.endTag = endTag;
            this.mdTag = mdTag;
        }

        public String toString() {
            return String.valueOf(this.depth) + " " + MD2HTMLConvertingBuilder.encode(this.mdTag) + " --> " + MD2HTMLConvertingBuilder.encode(this.startTag) + " / " + MD2HTMLConvertingBuilder.encode(this.endTag);
        }
    }
}

