/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.doctools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.n4js.doctools.ChunkHelper;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseHelpTOCGenerator
extends DefaultHandler {
    private static final String XML_ID = "xml:id";
    String title;
    List<Topic> maintopics = new ArrayList<Topic>(5);
    Stack<Topic> topics = new Stack();
    StringBuilder titleBuffer = new StringBuilder();
    boolean requireTitle = false;
    private String dir;

    public static void main(String[] args) {
        if (args.length % 2 != 1) {
            EclipseHelpTOCGenerator.printHelp();
            System.exit(1);
        }
        String in = null;
        String tocName = "toc.xml";
        String linkPrefix = "";
        int f = 0;
        while (f < args.length - 1) {
            String flag = args[f];
            String value = args[f + 1];
            switch (flag) {
                case "-t": {
                    tocName = value;
                    break;
                }
                case "-p": {
                    linkPrefix = value;
                    break;
                }
                default: {
                    System.out.println("Flag " + flag + " not recognized.");
                    EclipseHelpTOCGenerator.printHelp();
                    System.exit(2);
                }
            }
            f += 2;
        }
        in = args[args.length - 1];
        File f2 = new File(in);
        try {
            String toc = EclipseHelpTOCGenerator.generateTOC(f2, linkPrefix);
            Files.write(Paths.get(tocName, new String[0]), toc.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    private static void printHelp() {
        System.out.println("etoc [-t tocfilename] [p link prefix] inputfile\n-t string   The tocfile to create (incl. xml). Existing file will be overwritten. Default is 'toc.xml'\n-p path     Path to prepend to all links in the tocfile. Default is empty string.");
    }

    public static String generateTOC(File file, String linkPrefix) throws ParserConfigurationException, SAXException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            EclipseHelpTOCGenerator handler = new EclipseHelpTOCGenerator();
            handler.dir = String.valueOf(linkPrefix) + file.getName().substring(0, file.getName().indexOf(".xml"));
            reader.setContentHandler(handler);
            reader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            InputSource input = new InputSource(fis);
            reader.parse(input);
            String string = handler.getResult();
            return string;
        }
    }

    EclipseHelpTOCGenerator() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if ("chapter".equals(qName)) {
            this.startChapter(attributes);
        } else if ("section".equals(qName)) {
            this.startSection(attributes);
        } else if ("book".equals(qName)) {
            this.startBook();
        }
    }

    private void startBook() {
        this.requireTitle = true;
    }

    private void startChapter(Attributes attributes) {
        this.requireTitle = true;
        this.topics.clear();
        Topic topic = new Topic();
        this.maintopics.add(topic);
        this.topics.push(topic);
        topic.id = attributes.getValue(XML_ID);
    }

    private void startSection(Attributes attributes) {
        this.requireTitle = true;
        Topic topic = new Topic();
        Topic parent = this.topics.peek();
        parent.subtopics.add(topic);
        this.topics.push(topic);
        topic.id = attributes.getValue(XML_ID);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if ("chapter".equals(qName)) {
            this.endChapter();
        } else if ("section".equals(qName)) {
            this.endSection();
        } else if ("title".equals(qName)) {
            this.endTitle();
        }
    }

    private void endChapter() {
        this.topics.clear();
    }

    private void endSection() {
        this.topics.pop();
    }

    private void endTitle() {
        if (this.requireTitle) {
            if (this.topics.isEmpty()) {
                this.title = this.titleBuffer.toString().trim();
            } else {
                this.topics.peek().label = this.titleBuffer.toString().trim();
            }
            this.requireTitle = false;
            this.titleBuffer.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.requireTitle) {
            this.titleBuffer.append(ch, start, length);
        }
    }

    String getResult() {
        StringBuilder out = new StringBuilder();
        out.append("<?xml version='1.0' encoding='utf-8' ?>\n");
        out.append("<toc topic=\"" + this.dir + "/index.html\" label=\"" + this.title + "\">");
        for (Topic topic : this.maintopics) {
            this.appendTopic(out, "\t", topic, this.getFilename(topic.label));
        }
        out.append("\n</toc>");
        return out.toString();
    }

    private String getFilename(String label) {
        String name = "index";
        if (label != null) {
            name = ChunkHelper.extractFileNameFromTitle(label, 0, label.length());
        }
        return String.valueOf(name) + ".html";
    }

    private void appendTopic(StringBuilder out, String indent, Topic topic, String fileName) {
        out.append("\n" + indent);
        String href = String.valueOf(this.dir) + "/" + fileName + "#" + topic.id;
        out.append("<topic href=\"" + href + "\" label=\"" + topic.label + "\">");
        for (Topic sub : topic.subtopics) {
            this.appendTopic(out, String.valueOf(indent) + "\t", sub, fileName);
        }
        if (!topic.subtopics.isEmpty()) {
            out.append("\n" + indent);
        }
        out.append("</topic>");
    }

    private static class Topic {
        String id;
        String label;
        List<Topic> subtopics = new ArrayList<Topic>(5);

        private Topic() {
        }
    }
}

