/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.n4js.external.N4JSExternalProject;

@Singleton
public class ExternalLibraryBuildQueue {
    private final Deque<Task> internalQueue = new ConcurrentLinkedDeque<Task>();

    void enqueue(Collection<N4JSExternalProject> toBuild, Collection<N4JSExternalProject> toClean) {
        this.internalQueue.addLast(new Task((ImmutableSet<N4JSExternalProject>)ImmutableSet.copyOf(toBuild), (ImmutableSet<N4JSExternalProject>)ImmutableSet.copyOf(toClean)));
    }

    void insert(Collection<N4JSExternalProject> toBuild, Collection<N4JSExternalProject> toClean) {
        this.internalQueue.addFirst(new Task((ImmutableSet<N4JSExternalProject>)ImmutableSet.copyOf(toBuild), (ImmutableSet<N4JSExternalProject>)ImmutableSet.copyOf(toClean)));
    }

    Task exhaust() {
        LinkedHashSet<N4JSExternalProject> toBuild = new LinkedHashSet<N4JSExternalProject>();
        LinkedHashSet<N4JSExternalProject> toClean = new LinkedHashSet<N4JSExternalProject>();
        Task next = this.internalQueue.poll();
        while (next != null) {
            toBuild.removeAll(next.toClean);
            toClean.removeAll(next.toBuild);
            toBuild.addAll(next.toBuild);
            toClean.addAll(next.toClean);
            next = this.internalQueue.poll();
        }
        return new Task((ImmutableSet<N4JSExternalProject>)ImmutableSet.copyOf(toBuild), (ImmutableSet<N4JSExternalProject>)ImmutableSet.copyOf(toClean));
    }

    class Task {
        final Collection<N4JSExternalProject> toBuild;
        final Collection<N4JSExternalProject> toClean;

        Task(ImmutableSet<N4JSExternalProject> toBuild, ImmutableSet<N4JSExternalProject> toClean) {
            this.toBuild = toBuild;
            this.toClean = toClean;
        }

        public boolean isEmpty() {
            return this.toBuild.isEmpty() && this.toClean.isEmpty();
        }

        public void reschedule() {
            ExternalLibraryBuildQueue.this.insert(this.toBuild, this.toClean);
        }
    }
}

