/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.selection;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.selection.AstSelectionProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.TextRegion;

public class AstSelectionProvider2
extends AstSelectionProvider {
    private static final Pattern VALID_IDENTIFIER_CHARS_PATTERN = Pattern.compile("[a-zA-Z0-9_]");
    @Inject
    private EObjectAtOffsetHelper offsetHelper;

    public EObject getSelectedAstElement(IXtextDocument doc, ITextRegion currentSelection) {
        return (EObject)doc.modify(resource -> {
            Pair selectedAstElements;
            String selectedText = doc.get(currentSelection.getOffset(), currentSelection.getLength());
            int offset = currentSelection.getOffset();
            int length = currentSelection.getLength();
            if (!Strings.isNullOrEmpty((String)selectedText)) {
                boolean containsNonWhiteSpace = false;
                int i = 0;
                while (i < selectedText.length()) {
                    if (containsNonWhiteSpace) break;
                    containsNonWhiteSpace |= !Character.isWhitespace(selectedText.charAt(i));
                    ++i;
                }
                if (!containsNonWhiteSpace) {
                    return null;
                }
                i = 0;
                while (i < selectedText.length()) {
                    if (!Character.isWhitespace(selectedText.charAt(i))) break;
                    ++offset;
                    --length;
                    ++i;
                }
                i = selectedText.length() - 1;
                while (i >= 0) {
                    if (!Character.isWhitespace(selectedText.charAt(i))) break;
                    --length;
                    --i;
                }
            }
            TextRegion trimmedRegion = new TextRegion(offset, length);
            String trimmedText = doc.get(offset, length);
            if (Strings.isNullOrEmpty((String)trimmedText)) {
                int leadingCharOffset = offset == 0 ? 0 : offset - 1;
                int trailingCharOffset = leadingCharOffset == doc.getLength() ? doc.getLength() : leadingCharOffset + 1;
                String leadingChar = doc.get(leadingCharOffset, 1);
                String trailingChar = doc.get(trailingCharOffset, 1);
                if (!this.isValidIdentifierChar(leadingChar) && !this.isValidIdentifierChar(trailingChar)) {
                    return null;
                }
            }
            if ((selectedAstElements = this.getSelectedAstElements((XtextResource)resource, (ITextRegion)trimmedRegion)) != null) {
                return (EObject)selectedAstElements.getFirst();
            }
            IParseResult parseResult = resource.getParseResult();
            if (parseResult == null) {
                return null;
            }
            ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)trimmedRegion.getOffset());
            if (node == null) {
                return null;
            }
            EObject objectAtOffset = NodeModelUtils.findActualSemanticObjectFor((INode)node);
            if (objectAtOffset == null) {
                return null;
            }
            ITextRegion actualTextRegion = this.getTextRegion(objectAtOffset);
            int i = actualTextRegion.getOffset() + 1;
            while (i < this.getEndOffset((ITextRegion)trimmedRegion)) {
                EObject followingObject = this.offsetHelper.resolveElementAt(resource, i);
                if (followingObject == null || objectAtOffset != followingObject) {
                    return null;
                }
                ++i;
            }
            return objectAtOffset;
        });
    }

    private boolean isValidIdentifierChar(String leadingChar) {
        return VALID_IDENTIFIER_CHARS_PATTERN.matcher(Strings.nullToEmpty((String)leadingChar)).matches();
    }
}

