/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PostfixOperator implements Enumerator
{
    INC(0, "inc", "++"),
    DEC(1, "dec", "--");

    public static final int INC_VALUE = 0;
    public static final int DEC_VALUE = 1;
    private static final PostfixOperator[] VALUES_ARRAY;
    public static final List<PostfixOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PostfixOperator[]{INC, DEC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PostfixOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PostfixOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PostfixOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PostfixOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PostfixOperator get(int value) {
        switch (value) {
            case 0: {
                return INC;
            }
            case 1: {
                return DEC;
            }
        }
        return null;
    }

    private PostfixOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

