/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.processes.handlers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.clientserver.processes.ISystemProcessRemoteConstants;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessComparator;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalServerProcessImpl;

public class UniversalMacOSXProcessHandler
implements ProcessHandler {
    private static final Map stateMap = new HashMap();

    static {
        String[] strings = ISystemProcessRemoteConstants.ALL_STATES_STR;
        stateMap.put("I", strings[1]);
        stateMap.put("R", strings[4]);
        stateMap.put("S", strings[5]);
        stateMap.put("T", strings[2]);
        stateMap.put("U", strings[7]);
        stateMap.put("Z", strings[8]);
    }

    public SortedSet lookupProcesses(IHostProcessFilter rpfs) throws Exception {
        TreeSet<UniversalServerProcessImpl> results = new TreeSet<UniversalServerProcessImpl>(new ProcessComparator());
        String command = "/bin/ps -awwo pid,ucomm,state,ppid,uid,user,gid,vsz,rss";
        Process ps = Runtime.getRuntime().exec(command);
        InputStreamReader isr = new InputStreamReader(ps.getInputStream());
        BufferedReader reader = new BufferedReader(isr);
        String line = reader.readLine();
        line = reader.readLine();
        while (line != null) {
            String[] words = line.trim().split("\\s+");
            UniversalServerProcessImpl usp = new UniversalServerProcessImpl();
            usp.setPid(words[0]);
            usp.setName(words[1]);
            usp.setState(this.convertToStateCode(words[2]));
            usp.setPPid(words[3]);
            usp.setUid(words[4]);
            usp.setUsername(words[5]);
            usp.setGid(words[6]);
            usp.setVmSizeInKB(words[7]);
            usp.setVmRSSInKB(words[8]);
            usp.setTgid("");
            usp.setTracerPid("");
            if (rpfs.allows(usp.getAllProperties())) {
                results.add(usp);
            }
            line = reader.readLine();
        }
        reader.close();
        isr.close();
        return results;
    }

    public IHostProcess kill(IHostProcess process, String type) throws Exception {
        type = type.equals("default") ? "" : "-" + type;
        String cmdLine = "kill " + type + " " + process.getPid();
        Runtime.getRuntime().exec(cmdLine);
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPid("" + process.getPid());
        SortedSet results = this.lookupProcesses(rpfs);
        if (results == null || results.size() == 0) {
            return null;
        }
        return (IHostProcess)results.first();
    }

    protected String convertToStateCode(String state) {
        String key = state.substring(0, 1);
        String stateCode = (String)stateMap.get(key);
        if (stateCode == null) {
            stateCode = Character.toString('R');
        }
        return stateCode;
    }
}

