/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.osgi.util.NLS;

public class IndexToolApplication
implements IApplication {
    public synchronized Object start(IApplicationContext context) throws Exception {
        try {
            String directory = System.getProperty("indexOutput");
            if (directory == null || directory.length() == 0) {
                throw new Exception(NLS.bind((String)HelpBaseResources.IndexToolApplication_propertyNotSet, (Object)"indexOutput"));
            }
            String localeStr = System.getProperty("indexLocale");
            if (localeStr == null || localeStr.length() < 2) {
                throw new Exception(NLS.bind((String)HelpBaseResources.IndexToolApplication_propertyNotSet, (Object)"indexLocale"));
            }
            Locale locale = localeStr.length() >= 5 ? new Locale(localeStr.substring(0, 2), localeStr.substring(3, 5)) : new Locale(localeStr.substring(0, 2), "");
            this.preindex(directory, locale);
        }
        catch (Exception e) {
            e.printStackTrace();
            HelpBasePlugin.logError("Preindexing failed.", e);
        }
        return EXIT_OK;
    }

    public synchronized void stop() {
    }

    private void preindex(String outputDir, Locale locale) throws Exception {
        File indexPath = new File(HelpBasePlugin.getConfigurationDirectory(), "index/" + locale);
        if (indexPath.exists()) {
            IndexToolApplication.delete(indexPath);
        }
        BaseHelpSystem.getLocalSearchManager().ensureIndexUpdated((IProgressMonitor)new NullProgressMonitor(), BaseHelpSystem.getLocalSearchManager().getIndex(locale.toString()));
        File d = new File(outputDir, "nl" + File.separator + locale.getLanguage());
        if (locale.getCountry().length() > 0) {
            d = new File(d, locale.getCountry());
        }
        if (!d.exists()) {
            d.mkdirs();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(new File(d, "doc_index.zip")));){
            IndexToolApplication.zipDirectory(indexPath, zout, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new IOException("Content from directory '" + file.getAbsolutePath() + "' can not be listed.");
            }
            int i = 0;
            while (i < files.length) {
                IndexToolApplication.delete(files[i]);
                ++i;
            }
        }
        if (!file.delete()) {
            throw new IOException(NLS.bind((String)HelpBaseResources.IndexToolApplication_cannotDelete, (Object)file.getAbsolutePath()));
        }
    }

    private static void zipDirectory(File dir, ZipOutputStream zout, String base) throws IOException {
        byte[] buffer = new byte[8192];
        String[] files = dir.list();
        if (files == null || files.length == 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String path = base == null ? files[i] : String.valueOf(base) + "/" + files[i];
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                IndexToolApplication.zipDirectory(f, zout, path);
            } else {
                ZipEntry zentry = new ZipEntry(path);
                zout.putNextEntry(zentry);
                Throwable throwable = null;
                Object var10_11 = null;
                try (FileInputStream inputStream = new FileInputStream(f);){
                    int len;
                    while ((len = inputStream.read(buffer)) != -1) {
                        zout.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                zout.flush();
                zout.closeEntry();
            }
            ++i;
        }
    }
}

