/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import java.util.Objects;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.scoping.utils.ImportType;
import org.eclipse.xtext.naming.QualifiedName;

public class ImportSpecifierUtil {
    public static IN4JSProject getDependencyWithID(String projectName, IN4JSProject project) {
        if (Objects.equals(project.getProjectName(), projectName)) {
            return project;
        }
        for (IN4JSProject p : project.getDependencies()) {
            if (!Objects.equals(p.getProjectName(), projectName)) continue;
            return p;
        }
        return null;
    }

    public static ImportType computeImportType(QualifiedName name, IN4JSProject project) {
        String firstSegment = name.getFirstSegment();
        IN4JSProject targetProject = ImportSpecifierUtil.getDependencyWithID(firstSegment, project);
        boolean firstSegmentIsProjectName = targetProject != null;
        return ImportSpecifierUtil.computeImportType(name, firstSegmentIsProjectName, targetProject);
    }

    public static ImportType computeImportType(QualifiedName name, boolean useProjectName, IN4JSProject project) {
        if (useProjectName) {
            if (name.getSegmentCount() == 1) {
                QualifiedName moduleSpecifier = ImportSpecifierUtil.getMainModuleOfProject(project);
                if (moduleSpecifier == null) {
                    return ImportType.PROJECT_IMPORT_NO_MAIN;
                }
                return ImportType.PROJECT_IMPORT;
            }
            return ImportType.COMPLETE_IMPORT;
        }
        return ImportType.SIMPLE_IMPORT;
    }

    public static QualifiedName getMainModuleOfProject(IN4JSProject project) {
        String mainModuleSpec;
        if (project != null && (mainModuleSpec = project.getMainModule()) != null) {
            QualifiedName mainModuleQN = QualifiedName.create((String[])mainModuleSpec.split("/"));
            return mainModuleQN;
        }
        return null;
    }
}

