/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.constraints;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeCompareUtils;
import org.eclipse.n4js.ts.utils.TypeUtils;

final class TypeBound {
    public final InferenceVariable left;
    public final TypeRef right;
    public final Variance variance;
    private Integer hashCode = null;

    public TypeBound(InferenceVariable left, TypeRef right, Variance variance) {
        this.left = left;
        this.right = right;
        this.variance = variance;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeBound) {
            TypeBound other = (TypeBound)obj;
            return other.left == this.left && TypeCompareUtils.isEqual((TypeArgument)other.right, (TypeArgument)this.right) && other.variance == this.variance;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.left.getTypeAsString())) + " " + this.variance.getRelationString() + " " + this.right.getTypeRefAsString();
    }

    public boolean isTrivial() {
        return this.right.getDeclaredType() == this.left;
    }

    public TypeBound sanitizeRawTypeRef() {
        if (TypeUtils.isRawTypeRef((TypeRef)this.right)) {
            TypeBound cpy = new TypeBound(this.left, (TypeRef)TypeUtils.copy((EObject)this.right), this.variance);
            TypeUtils.sanitizeRawTypeRef((TypeRef)cpy.right);
            return cpy;
        }
        return this;
    }
}

