/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.compatibility.SiteVerifier;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.discovery.util.CatalogCategoryComparator;
import org.eclipse.equinox.internal.p2.discovery.util.CatalogItemComparator;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.FilteredViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.PatternFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.util.SelectionProviderAdapter;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CategoryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class CatalogViewer
extends FilteredViewer {
    private static final int DEFAULT_HEIGHT = 250;
    final Catalog catalog;
    private final List<CatalogItem> checkedItems = new ArrayList<CatalogItem>();
    private boolean complete;
    private final CatalogConfiguration configuration;
    protected final IRunnableContext context;
    boolean ignoreUpdates;
    Set<String> installedFeatures;
    DiscoveryResources resources;
    private final SelectionProviderAdapter selectionProvider;
    protected final IShellProvider shellProvider;
    boolean showInstalled;
    Button showInstalledCheckbox;
    Set<Tag> visibleTags;
    private boolean showCategories;
    private CatalogContentProvider contentProvider;

    public CatalogViewer(Catalog catalog, IShellProvider shellProvider, IRunnableContext context, CatalogConfiguration configuration) {
        Assert.isNotNull((Object)catalog);
        Assert.isNotNull((Object)shellProvider);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)configuration);
        this.catalog = catalog;
        this.shellProvider = shellProvider;
        this.context = context;
        this.configuration = configuration;
        this.selectionProvider = new SelectionProviderAdapter();
        this.showInstalled = configuration.isShowInstalled();
        this.showCategories = configuration.isShowCategories();
        this.visibleTags = configuration.getSelectedTags() != null ? new HashSet<Tag>(configuration.getSelectedTags()) : new HashSet<Tag>();
        this.setMinimumHeight(250);
        this.setComplete(false);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    protected void catalogUpdated(boolean wasCancelled, boolean wasError) {
        if (this.catalog != null && !wasCancelled && !wasError) {
            this.doCheckCatalog();
        }
        this.viewer.setInput((Object)this.catalog);
        this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void doCheckCatalog() {
        int categoryWithConnectorCount = 0;
        for (CatalogCategory category : this.catalog.getCategories()) {
            categoryWithConnectorCount += category.getItems().size();
        }
        if (categoryWithConnectorCount == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound, (String)Messages.ConnectorDiscoveryWizardMainPage_noConnectorsFound_description);
        }
    }

    protected IStatus computeStatus(InvocationTargetException e, String message) {
        Throwable cause = e.getCause();
        if (cause.getMessage() != null) {
            message = NLS.bind((String)Messages.ConnectorDiscoveryWizardMainPage_message_with_cause, (Object)message, (Object)cause.getMessage());
        }
        return new Status(4, "org.eclipse.equinox.p2.ui.discovery", message, (Throwable)e);
    }

    protected Pattern createPattern(String filterText) {
        if (filterText == null || filterText.length() == 0) {
            return null;
        }
        String regex = filterText;
        regex.replace("\\", "\\\\").replace("?", ".").replace("*", ".*?");
        return Pattern.compile(regex, 34);
    }

    @Override
    protected PatternFilter doCreateFilter() {
        return new FindFilter();
    }

    @Override
    protected void doCreateHeaderControls(Composite parent) {
        if (this.configuration.isShowInstalledFilter()) {
            this.showInstalledCheckbox = new Button(parent, 32);
            this.showInstalledCheckbox.setSelection(this.showInstalled);
            this.showInstalledCheckbox.setText(Messages.DiscoveryViewer_Show_Installed);
            this.showInstalledCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    if (CatalogViewer.this.ignoreUpdates) {
                        return;
                    }
                    CatalogViewer.this.ignoreUpdates = true;
                    CatalogViewer.this.setShowInstalled(CatalogViewer.this.showInstalledCheckbox.getSelection());
                    CatalogViewer.this.ignoreUpdates = false;
                }
            });
        }
        if (this.configuration.isShowTagFilter()) {
            for (final Tag tag : this.catalog.getTags()) {
                final Button checkbox = new Button(parent, 32);
                checkbox.setSelection(this.visibleTags.contains(tag));
                checkbox.setText(tag.getLabel());
                checkbox.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean selection = checkbox.getSelection();
                        if (selection) {
                            CatalogViewer.this.visibleTags.add(tag);
                        } else {
                            CatalogViewer.this.visibleTags.remove(tag);
                        }
                        CatalogViewer.this.refresh();
                    }
                });
            }
        }
    }

    @Override
    protected StructuredViewer doCreateViewer(Composite container) {
        ControlListViewer _viewer = new ControlListViewer(container, 2048){

            @Override
            protected ControlListItem<?> doCreateItem(Composite parent, Object element) {
                return CatalogViewer.this.doCreateViewerItem(parent, element);
            }
        };
        this.contentProvider = this.doCreateContentProvider();
        this.contentProvider.setHasCategories(this.isShowCategories());
        _viewer.setContentProvider((IContentProvider)this.contentProvider);
        _viewer.setComparator(new ViewerComparator(){
            CatalogCategoryComparator categoryComparator = new CatalogCategoryComparator();
            CatalogItemComparator itemComparator = new CatalogItemComparator();

            public int compare(Viewer v, Object o1, Object o2) {
                CatalogCategory cat1 = this.getCategory(o1);
                CatalogCategory cat2 = this.getCategory(o2);
                if (cat1 == null) {
                    return cat2 != null ? 1 : 0;
                }
                if (cat2 == null) {
                    return 1;
                }
                int i = this.categoryComparator.compare(cat1, cat2);
                if (i == 0) {
                    if (o1 instanceof CatalogCategory) {
                        return -1;
                    }
                    if (o2 instanceof CatalogCategory) {
                        return 1;
                    }
                    if (cat1 == cat2 && o1 instanceof CatalogItem && o2 instanceof CatalogItem) {
                        return this.itemComparator.compare((CatalogItem)o1, (CatalogItem)o2);
                    }
                    return super.compare(v, o1, o2);
                }
                return i;
            }

            private CatalogCategory getCategory(Object o) {
                if (o instanceof CatalogCategory) {
                    return (CatalogCategory)o;
                }
                if (o instanceof CatalogItem) {
                    return ((CatalogItem)o).getCategory();
                }
                return null;
            }
        });
        this.resources = new DiscoveryResources(container.getDisplay());
        _viewer.getControl().addDisposeListener(e -> {
            this.resources.dispose();
            if (this.catalog != null) {
                this.catalog.dispose();
            }
        });
        _viewer.addFilter(new Filter());
        return _viewer;
    }

    protected CatalogContentProvider doCreateContentProvider() {
        return new CatalogContentProvider();
    }

    protected ControlListItem<?> doCreateViewerItem(Composite parent, Object element) {
        if (element instanceof CatalogItem) {
            return new DiscoveryItem<CatalogItem>(parent, 0, this.resources, this.shellProvider, (CatalogItem)element, this);
        }
        if (element instanceof CatalogCategory) {
            return new CategoryItem<CatalogCategory>(parent, 0, this.resources, (CatalogCategory)element);
        }
        return null;
    }

    protected boolean doFilter(CatalogItem item) {
        if (!this.showInstalled && item.isInstalled()) {
            return false;
        }
        if (!this.isTagVisible(item)) {
            return false;
        }
        for (CatalogFilter filter : this.configuration.getFilters()) {
            if (filter.select(item)) continue;
            return false;
        }
        return true;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public List<CatalogItem> getCheckedItems() {
        return new ArrayList<CatalogItem>(this.checkedItems);
    }

    public CatalogConfiguration getConfiguration() {
        return this.configuration;
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        HashSet<String> features = new HashSet<String>();
        IProfile profile = ProvUI.getProfileRegistry((ProvisioningSession)ProvisioningUI.getDefaultUI().getSession()).getProfile(ProvisioningUI.getDefaultUI().getProfileId());
        if (profile != null) {
            IQueryResult result = profile.available(QueryUtil.createIUGroupQuery(), monitor);
            for (IInstallableUnit unit : result) {
                features.add(unit.getId());
            }
        }
        return features;
    }

    protected DiscoveryResources getResources() {
        return this.resources;
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.selectionProvider.getSelection();
    }

    private Shell getShell() {
        return this.shellProvider.getShell();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isShowCategories() {
        return this.showCategories;
    }

    public boolean isShowInstalled() {
        return this.showInstalled;
    }

    private boolean isTagVisible(CatalogItem item) {
        if (!this.configuration.isShowTagFilter()) {
            return true;
        }
        for (Tag selectedTag : this.visibleTags) {
            for (Tag tag : item.getTags()) {
                if (!tag.equals((Object)selectedTag)) continue;
                return true;
            }
        }
        return false;
    }

    protected void modifySelection(CatalogItem connector, boolean selected) {
        this.modifySelectionInternal(connector, selected);
        this.updateState();
    }

    private void modifySelectionInternal(CatalogItem connector, boolean selected) {
        connector.setSelected(selected);
        if (selected) {
            this.checkedItems.add(connector);
        } else {
            this.checkedItems.remove(connector);
        }
    }

    protected void postDiscovery() {
        for (CatalogItem connector : this.catalog.getItems()) {
            connector.setInstalled(this.installedFeatures != null && this.installedFeatures.containsAll(connector.getInstallableUnits()));
        }
    }

    public void refresh() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setSelection(IStructuredSelection selection) {
        HashSet<CatalogItem> selected = new HashSet<CatalogItem>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object descriptor = objectArray[n2];
            if (descriptor instanceof CatalogItem) {
                selected.add((CatalogItem)descriptor);
            }
            ++n2;
        }
        for (CatalogItem connector : this.catalog.getItems()) {
            this.modifySelectionInternal(connector, selected.contains(connector));
        }
        this.updateState();
    }

    public void setShowInstalled(boolean showInstalled) {
        this.showInstalled = showInstalled;
        this.showInstalledCheckbox.setSelection(showInstalled);
        this.refresh();
    }

    public void setShowCategories(boolean showCategories) {
        this.showCategories = showCategories;
        if (this.contentProvider != null) {
            this.contentProvider.setHasCategories(showCategories);
            this.refresh();
        }
    }

    public void updateCatalog() {
        boolean wasCancelled = false;
        boolean wasError = false;
        try {
            IStatus[] result = new IStatus[1];
            this.context.run(true, true, monitor -> {
                if (this.installedFeatures == null) {
                    this.installedFeatures = this.getInstalledFeatures(monitor);
                }
                iStatusArray[0] = this.catalog.performDiscovery(monitor);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.postDiscovery();
            });
            if (result[0] != null && !result[0].isOK()) {
                StatusManager.getManager().handle(result[0], 7);
                wasError = true;
            }
        }
        catch (InvocationTargetException e) {
            IStatus status = this.computeStatus(e, Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
            StatusManager.getManager().handle(status, 7);
            wasError = true;
        }
        catch (InterruptedException interruptedException) {
            wasCancelled = true;
        }
        if (this.catalog != null) {
            this.catalogUpdated(wasCancelled, wasError);
            this.verifyUpdateSiteAvailability();
        }
        this.viewer.setData("discoveryComplete", (Object)"true");
    }

    protected void verifyUpdateSiteAvailability() {
        if (this.configuration.isVerifyUpdateSiteAvailability() && !this.catalog.getItems().isEmpty()) {
            try {
                this.context.run(true, true, monitor -> {
                    SiteVerifier verifier = new SiteVerifier(this.catalog);
                    verifier.verifySiteAvailability(monitor);
                });
            }
            catch (InvocationTargetException e) {
                IStatus status = this.computeStatus(e, Messages.ConnectorDiscoveryWizardMainPage_unexpectedException);
                StatusManager.getManager().handle(status, 7);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void updateState() {
        this.setComplete(!this.checkedItems.isEmpty());
        this.selectionProvider.setSelection((ISelection)new StructuredSelection(this.getCheckedItems()));
    }

    protected static class CatalogContentProvider
    implements ITreeContentProvider {
        private Catalog catalog;
        private boolean hasCategories;

        protected CatalogContentProvider() {
        }

        public boolean hasCategories() {
            return this.hasCategories;
        }

        public void setHasCategories(boolean hasCategories) {
            this.hasCategories = hasCategories;
        }

        public void dispose() {
            this.catalog = null;
        }

        public Catalog getCatalog() {
            return this.catalog;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CatalogCategory) {
                return ((CatalogCategory)parentElement).getItems().toArray();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (this.catalog != null) {
                ArrayList elements = new ArrayList();
                if (this.hasCategories()) {
                    elements.addAll(this.catalog.getCategories());
                }
                elements.addAll(this.catalog.getItems());
                return elements.toArray(new Object[0]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof CatalogCategory) {
                return this.catalog;
            }
            if (element instanceof CatalogItem) {
                return ((CatalogItem)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof CatalogCategory) {
                return ((CatalogCategory)element).getItems().size() > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.catalog = (Catalog)newInput;
        }
    }

    private class Filter
    extends ViewerFilter {
        public boolean select(Viewer filteredViewer, Object parentElement, Object element) {
            if (element instanceof CatalogItem) {
                return CatalogViewer.this.doFilter((CatalogItem)element);
            }
            if (element instanceof CatalogCategory) {
                CatalogCategory category = (CatalogCategory)element;
                for (CatalogItem item : category.getItems()) {
                    if (!CatalogViewer.this.doFilter(item)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    private class FindFilter
    extends PatternFilter {
        private boolean filterMatches(String text) {
            return text != null && this.wordMatches(text);
        }

        @Override
        protected Object[] getChildren(Object element) {
            if (element instanceof CatalogCategory) {
                return ((CatalogCategory)element).getItems().toArray();
            }
            return super.getChildren(element);
        }

        @Override
        protected boolean isLeafMatch(Viewer filteredViewer, Object element) {
            if (element instanceof CatalogItem) {
                CatalogItem descriptor = (CatalogItem)element;
                return this.filterMatches(descriptor.getName()) || this.filterMatches(descriptor.getDescription()) || this.filterMatches(descriptor.getProvider()) || this.filterMatches(descriptor.getLicense());
            }
            return false;
        }
    }
}

