/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.example;

import com.google.inject.Inject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.wizard.AbstractExampleInstallerWizard;
import org.eclipse.emf.common.ui.wizard.ExampleInstallerWizard;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class N4JSTasksExampleWizard
extends ExampleInstallerWizard {
    public static final String ID = N4JSTasksExampleWizard.class.getName();
    @Inject
    private LibraryManager libManager;

    public boolean performFinish() {
        if (super.performFinish()) {
            this.runNpmInstall();
            return true;
        }
        return false;
    }

    protected void installExample(IProgressMonitor progressMonitor) throws Exception {
        super.installExample(progressMonitor);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceFolder = workspace.getRoot().getLocation().toFile().getAbsoluteFile();
        for (AbstractExampleInstallerWizard.ProjectDescriptor pd : this.getProjectDescriptors()) {
            File projectFolder = new File(workspaceFolder, pd.getName());
            File packagesFolder = new File(projectFolder, "packages");
            File[] fileArray = packagesFolder.listFiles(File::isDirectory);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File memberProject = fileArray[n2];
                N4JSTasksExampleWizard.importProject(workspace, memberProject, progressMonitor);
                ++n2;
            }
        }
    }

    private void runNpmInstall() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.subTask("Installing dependencies");
                        for (AbstractExampleInstallerWizard.ProjectDescriptor pd : N4JSTasksExampleWizard.this.getProjectDescriptors()) {
                            IProject project = pd.getProject();
                            URI projectFolderURI = URI.createFileURI((String)project.getLocation().toFile().getAbsolutePath());
                            IStatus status = N4JSTasksExampleWizard.this.libManager.runNpmYarnInstall(projectFolderURI, monitor);
                            if (!status.matches(4)) continue;
                            throw status.getException();
                        }
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e, "An error occurred while installing dependencies");
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            String pluginId = N4JSActivator.getInstance().getBundle().getSymbolicName();
            Status status = new Status(4, pluginId, e.getCause().getMessage(), e.getCause());
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage(), (IStatus)status);
            StatusManager.getManager().handle((IStatus)status);
        }
    }

    private static void importProject(IWorkspace workspace, File rootFolder, IProgressMonitor progressMonitor) throws CoreException {
        Path path = new Path(new File(rootFolder, ".project").getAbsolutePath());
        IProjectDescription desc = workspace.loadProjectDescription((IPath)path);
        IProject project = workspace.getRoot().getProject(desc.getName());
        project.create(desc, progressMonitor);
        project.open(progressMonitor);
    }
}

