/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NodeYarnProcessBuilder;
import org.eclipse.n4js.utils.process.OutputRedirection;
import org.eclipse.n4js.utils.process.ProcessExecutionCommand;
import org.eclipse.n4js.utils.process.ProcessExecutor;
import org.eclipse.n4js.utils.process.ProcessResult;

@Singleton
public class BinariesCommandFactory {
    @Inject
    private ProcessExecutor processExecutor;
    @Inject
    private NodeYarnProcessBuilder nodeProccessBuilder;

    public ProcessExecutionCommand createInstallEverythingCommand(File invocationPath, boolean saveDependency) {
        return this.createInstallPackageCommand(invocationPath, Collections.emptyList(), saveDependency);
    }

    public ProcessExecutionCommand createInstallPackageCommand(File invocationPath, String packageName, boolean saveDependency) {
        return this.createInstallPackageCommand(invocationPath, Collections.singletonList(packageName), saveDependency);
    }

    public ProcessExecutionCommand createInstallPackageCommand(final File invocationPath, final List<String> packageNames, final boolean saveDependency) {
        return new ProcessExecutionCommand(){
            private static final String COMMAND_NAME = "install_npm_package";

            public ProcessResult execute() {
                String escapedPackageNames = !packageNames.isEmpty() ? "\"" + Joiner.on((String)"\" \"").join((Iterable)packageNames) + "\"" : "";
                boolean actualSaveDependency = saveDependency && !packageNames.isEmpty();
                ProcessBuilder processBuilder = BinariesCommandFactory.this.nodeProccessBuilder.getInstallNpmPackageProcessBuilder(invocationPath, escapedPackageNames, actualSaveDependency);
                return BinariesCommandFactory.this.processExecutor.createAndExecute(processBuilder, COMMAND_NAME, OutputRedirection.REDIRECT);
            }
        };
    }

    public ProcessExecutionCommand createUninstallPackageCommand(final File invocationPath, final List<String> packageNames, final boolean saveDependency) {
        return new ProcessExecutionCommand(){
            private static final String COMMAND_NAME = "uninstall_npm_package";

            public ProcessResult execute() {
                String escapedPackageNames = "\"" + Joiner.on((String)"\" \"").join((Iterable)packageNames) + "\"";
                ProcessBuilder processBuilder = BinariesCommandFactory.this.nodeProccessBuilder.getUninstallNpmPackageProcessBuilder(invocationPath, escapedPackageNames, saveDependency);
                return BinariesCommandFactory.this.processExecutor.createAndExecute(processBuilder, COMMAND_NAME, OutputRedirection.REDIRECT);
            }
        };
    }

    public ProcessExecutionCommand createCacheCleanCommand(final File invocationPath) {
        return new ProcessExecutionCommand(){
            private static final String COMMAND_NAME = "clean_npm_package_cache";

            public ProcessResult execute() {
                ProcessBuilder processBuilder = BinariesCommandFactory.this.nodeProccessBuilder.getNpmCacheCleanProcessBuilder(invocationPath);
                return BinariesCommandFactory.this.processExecutor.createAndExecute(processBuilder, COMMAND_NAME, OutputRedirection.REDIRECT);
            }
        };
    }

    public boolean isYarnUsed(File invocationPath) {
        return this.nodeProccessBuilder.isYarnUsed(invocationPath.toPath());
    }

    public ProcessExecutionCommand checkBinaryVersionCommand(final Binary binary) {
        return new ProcessExecutionCommand(){

            public ProcessResult execute() {
                ProcessBuilder processBuilder = BinariesCommandFactory.this.nodeProccessBuilder.createVersionCheckProcess(binary);
                return BinariesCommandFactory.this.processExecutor.createAndExecute(processBuilder, binary.getLabel(), OutputRedirection.SUPPRESS);
            }
        };
    }
}

