/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.validators.StaticPolyfillValidatorExtension;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4JSEnumValidator
extends AbstractN4JSDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkEnumLiterals(N4EnumDeclaration n4EnumDeclaration) {
        Set<String> builtInEnumMembersNames = this.findBuiltInN4EnumMembers(n4EnumDeclaration);
        StaticPolyfillValidatorExtension.internalCheckNotInStaticPolyfillModule(n4EnumDeclaration, this);
        n4EnumDeclaration.getLiterals().stream().filter(it -> it.getName() != null).collect(Collectors.groupingBy(N4EnumLiteral::getName)).forEach((name, literals) -> {
            if (literals.size() > 1) {
                this.addIssue(IssueCodes.getMessageForENM_DUPLICTAE_LITERALS(name), (EObject)literals.get(0), (EStructuralFeature)N4JSPackage.Literals.N4_ENUM_LITERAL__NAME, "ENM_DUPLICTAE_LITERALS", new String[0]);
                return;
            }
            if (builtInEnumMembersNames.contains(name)) {
                this.addIssue(IssueCodes.getMessageForENM_LITERALS_HIDE_META(name), (EObject)literals.get(0), (EStructuralFeature)N4JSPackage.Literals.N4_ENUM_LITERAL__NAME, "ENM_LITERALS_HIDE_META", new String[0]);
            }
        });
    }

    private Set<String> findBuiltInN4EnumMembers(N4EnumDeclaration n4EnumDeclaration) {
        return BuiltInTypeScope.get((ResourceSet)n4EnumDeclaration.eResource().getResourceSet()).getN4EnumType().getOwnedMembers().stream().map(tm -> tm.getName()).collect(Collectors.toSet());
    }

    @Check
    public void checkUsageOfStringBasedEnum(IdentifierRef identRef) {
        IdentifiableElement prop;
        IdentifiableElement id = identRef.getId();
        if (id == null || id.eIsProxy()) {
            return;
        }
        if (!(id instanceof TEnum)) {
            return;
        }
        TEnum tEnum = (TEnum)id;
        if (!AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)tEnum)) {
            return;
        }
        EObject parent = N4JSASTUtils.skipParenExpressionUpward((EObject)identRef.eContainer());
        ParameterizedPropertyAccessExpression parentPAE = parent instanceof ParameterizedPropertyAccessExpression ? (ParameterizedPropertyAccessExpression)parent : null;
        IdentifiableElement identifiableElement = prop = parentPAE != null ? parentPAE.getProperty() : null;
        if (prop != null) {
            if (prop.eIsProxy()) {
                return;
            }
            if (tEnum.getLiterals().contains((Object)prop)) {
                return;
            }
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)identRef);
            TMember getterLiterals = RuleEnvironmentExtensions.n4StringBasedEnumType(G).findOwnedMember("literals", false, true);
            if (prop == getterLiterals) {
                return;
            }
        }
        this.addIssue(IssueCodes.getMessageForENM_INVALID_USE_OF_STRINGBASED_ENUM(), (EObject)identRef, "ENM_INVALID_USE_OF_STRINGBASED_ENUM");
    }

    public void addIssue(String message, EObject source, EStructuralFeature feature, String issueCode, String ... issueData) {
        super.addIssue(message, source, feature, issueCode, issueData);
    }
}

