/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contentmodel.chtml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.wst.html.core.internal.contentmodel.chtml.CMGroupImpl;
import org.eclipse.wst.html.core.internal.contentmodel.chtml.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

abstract class DeclCollection
implements CMNamedNodeMap {
    CMNode[] fDecls = null;
    protected static final boolean STRICT_CASE = false;
    protected static final boolean TOLERANT_CASE = true;
    protected static final int ID_UNKNOWN = -1;
    private DualMap fMap = null;

    public DeclCollection(String[] names, boolean tolerant) {
        this.fDecls = new CMNode[names.length];
        this.fMap = tolerant ? new TolerantStringDualMap(names) : new DualMap(names);
    }

    protected abstract CMNode create(String var1);

    public CMNamedNodeMap getDeclarations(String[] names) {
        CMNamedNodeMapImpl map = new CMNamedNodeMapImpl();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            CMNode node = this.getNamedItem(name);
            if (node != null) {
                map.putNamedItem(name, node);
            }
            ++i;
        }
        return map;
    }

    public void getDeclarations(CMGroupImpl group, Iterator names) {
        while (names.hasNext()) {
            String entityName = (String)names.next();
            CMNode dec = this.getNamedItem(entityName);
            if (dec == null) continue;
            group.appendChild(dec);
        }
    }

    protected int getID(String name) {
        return this.fMap.getKey(name);
    }

    public int getLength() {
        return this.fDecls.length;
    }

    protected String getName(int id) {
        return (String)this.fMap.getValue(id);
    }

    public CMNode getNamedItem(String name) {
        int id = this.getID(name);
        if (!this.isValidID(id)) {
            return null;
        }
        return this.item(id);
    }

    private boolean isValidID(int id) {
        return id >= 0 && id < this.fDecls.length;
    }

    public CMNode item(int index) {
        if (!this.isValidID(index)) {
            return null;
        }
        CMNode decl = this.fDecls[index];
        if (decl != null) {
            return decl;
        }
        this.fDecls[index] = decl = this.create(this.getName(index));
        return decl;
    }

    public Iterator iterator() {
        return new DeclIterator();
    }

    private class DeclIterator
    implements Iterator {
        private int id = -1;
        private int maxid = -1;

        public DeclIterator() {
            this.maxid = DeclCollection.this.fDecls.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.id < this.maxid;
        }

        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            return DeclCollection.this.item(++this.id);
        }

        @Override
        public void remove() {
        }
    }

    protected class DualMap {
        private Object[] table = null;
        private HashMap map = null;

        public DualMap() {
        }

        public DualMap(Object[] objects) {
            this.initialize(objects);
        }

        public int size() {
            return this.table.length;
        }

        public Object getValue(int key) {
            if (!this.isValidIndex(key)) {
                return null;
            }
            return this.table[key];
        }

        public int getKey(Object value) {
            Integer keyObj = (Integer)this.map.get(value);
            if (keyObj == null) {
                return -1;
            }
            return keyObj;
        }

        protected void initialize(Object[] objects) {
            if (objects == null) {
                return;
            }
            this.table = objects;
            this.map = new HashMap();
            int key = 0;
            while (key < objects.length) {
                Object value = this.table[key];
                this.map.put(value, new Integer(key));
                ++key;
            }
        }

        private boolean isValidIndex(int index) {
            return index >= 0 && index < this.table.length;
        }
    }

    protected class TolerantStringDualMap
    extends DualMap {
        public TolerantStringDualMap(String[] names) {
            Object[] objects = new Object[names.length];
            int i = 0;
            while (i < names.length) {
                objects[i] = this.makeCanonicalForm(names[i]);
                ++i;
            }
            this.initialize(objects);
        }

        @Override
        public int getKey(Object value) {
            try {
                String name = (String)value;
                return super.getKey(this.makeCanonicalForm(name));
            }
            catch (ClassCastException classCastException) {
                return -1;
            }
        }

        private String makeCanonicalForm(String raw) {
            return raw.toUpperCase(Locale.US);
        }
    }
}

