/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.collect.FluentIterable;
import java.io.File;
import java.util.Arrays;
import java.util.Stack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.ui.navigator.internal.ResourceNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

interface Node
extends IWorkbenchAdapter {
    public static final Node[] EMPTY_NODES = new Node[0];

    public Image getImage();

    public String getText();

    public Object[] getChildren();

    public Object getParent();

    public boolean hasChildren();

    default public Object[] getChildren(Object o) {
        return this.getChildren();
    }

    default public String getLabel(Object o) {
        return this.getText();
    }

    default public Object getParent(Object o) {
        return this.getParent();
    }

    default public ImageDescriptor getImageDescriptor(Object object) {
        Image image = this.getImage();
        return image == null ? null : ImageDescriptor.createFromImage((Image)image);
    }

    default public Node findChild(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        if (this instanceof ResourceNode && ((ResourceNode)this).getResource().equals(file)) {
            return this;
        }
        Stack<Node> stack = new Stack<Node>();
        for (Node node : FluentIterable.from(Arrays.asList(this.getChildren())).filter(Node.class)) {
            stack.push(node);
        }
        while (!stack.isEmpty()) {
            Node currentNode = (Node)stack.pop();
            if (currentNode instanceof ResourceNode && ((ResourceNode)currentNode).getResource().equals(file)) {
                return currentNode;
            }
            for (Node node : FluentIterable.from(Arrays.asList(currentNode.getChildren())).filter(Node.class)) {
                stack.push(node);
            }
        }
        return null;
    }
}

