/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public abstract class AbstractNLSProcessor
extends AbstractClassProcessor {
    @Extension
    protected ReflectExtensions reflExt = new ReflectExtensions();
    protected static final String BUNDLE_NAME_FIELD = "BUNDLE_NAME";
    protected static final String RESOURCE_BUNDLE_FIELD = "RESOURCE_BUNDLE";
    protected static final String nlsClass = "org.eclipse.osgi.util.NLS";

    protected abstract Class<?> getAnnotationType();

    public String getAnnotationName() {
        return this.getAnnotationType().getSimpleName();
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        boolean _tripleEquals;
        AnnotationReference nlsAnnotation = this.getNLSAnnotation(annotatedClass, context);
        if (nlsAnnotation == null) {
            throw new NullPointerException("Unable to retrieve the annotation");
        }
        Type _findTypeGlobally = context.findTypeGlobally(nlsClass);
        boolean bl = _tripleEquals = _findTypeGlobally == null;
        if (_tripleEquals) {
            context.addError((Element)nlsAnnotation, "org.eclipse.osgi.util.NLS isn't on the classpath.");
        }
        String propertyFileNameValue = this.getNLSAnnotationPropertyValue(nlsAnnotation, context);
        InputStream propertiesFileInputStream = this.getPropertiesFile(annotatedClass, context, propertyFileNameValue, nlsAnnotation);
        Properties properties = this.loadPropertiesFile(propertiesFileInputStream, context, nlsAnnotation);
        this.addMembers(annotatedClass, nlsAnnotation, context, propertyFileNameValue);
        Functions.Function1 _function = it -> String.valueOf(it.getKey());
        Consumer<Map.Entry> _function_1 = it -> {
            this.addField((Map.Entry<Object, Object>)it, annotatedClass, nlsAnnotation, context);
            this.addMethod((Map.Entry<Object, Object>)it, annotatedClass, nlsAnnotation, context);
        };
        IterableExtensions.sortBy(properties.entrySet(), (Functions.Function1)_function).forEach(_function_1);
    }

    protected void addMembers(MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, TransformationContext context, String propertyFileNameValue) {
        this.addBundleNameField(annotatedClass, nlsAnnotation, context, propertyFileNameValue);
        this.addResourceBundleField(annotatedClass, nlsAnnotation, context);
        this.addStaticBlock(annotatedClass, nlsAnnotation, context);
        this.addGetStringMethod(annotatedClass, nlsAnnotation, context);
    }

    protected void addStaticBlock(final MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, final @Extension TransformationContext context) {
        String fieldName = "INITIALIZER";
        this.checkForExistentField(annotatedClass, "INITIALIZER", context, nlsAnnotation);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            it.setType(context.getString());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"new ");
                    _builder.append(Functions.Function0.class);
                    _builder.append((Object)"<");
                    _builder.append(String.class);
                    _builder.append((Object)">() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"public ");
                    TypeReference _string = context.getString();
                    _builder.append((Object)_string, "    ");
                    _builder.append((Object)" apply() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"      ");
                    _builder.append((Object)AbstractNLSProcessor.nlsClass, "      ");
                    _builder.append((Object)".initializeMessages(");
                    String _simpleName = annotatedClass.findDeclaredField(AbstractNLSProcessor.BUNDLE_NAME_FIELD).getSimpleName();
                    _builder.append((Object)_simpleName, "      ");
                    _builder.append((Object)", ");
                    TypeReference _newTypeReference = context.newTypeReference((Type)annotatedClass, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference, "      ");
                    _builder.append((Object)".class);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"      ");
                    _builder.append((Object)"return \"\";");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"  ");
                    _builder.append((Object)"}.apply();");
                    _builder.newLine();
                }
            };
            it.setInitializer(_client);
        };
        annotatedClass.addField("INITIALIZER", _function);
    }

    protected void addBundleNameField(final MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, final @Extension TransformationContext context, final String propertyFileName) {
        this.checkForExistentField(annotatedClass, BUNDLE_NAME_FIELD, context, nlsAnnotation);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            it.setType(context.getString());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    TypeReference _newTypeReference = context.newTypeReference((Type)annotatedClass, new TypeReference[0]);
                    _builder.append((Object)_newTypeReference);
                    _builder.append((Object)".class.getPackage().getName() + \".");
                    String _replace = propertyFileName.replace(".properties", "");
                    _builder.append((Object)_replace);
                    _builder.append((Object)"\"");
                }
            };
            it.setInitializer(_client);
        };
        annotatedClass.addField(BUNDLE_NAME_FIELD, _function);
    }

    protected void addResourceBundleField(final MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, @Extension TransformationContext context) {
        this.checkForExistentField(annotatedClass, RESOURCE_BUNDLE_FIELD, context, nlsAnnotation);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setStatic(true);
            it.setFinal(true);
            it.setType(context.newTypeReference(ResourceBundle.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(ResourceBundle.class);
                    _builder.append((Object)".getBundle(");
                    String _simpleName = annotatedClass.findDeclaredField(AbstractNLSProcessor.BUNDLE_NAME_FIELD).getSimpleName();
                    _builder.append((Object)_simpleName);
                    _builder.append((Object)")");
                }
            };
            it.setInitializer(_client);
        };
        annotatedClass.addField(RESOURCE_BUNDLE_FIELD, _function);
    }

    protected void addGetStringMethod(final MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, final @Extension TransformationContext context) {
        String methodName = "getString";
        this.checkForExistentMethod(annotatedClass, "getString", context, nlsAnnotation, 1);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setStatic(true);
            it.setReturnType(context.getString());
            it.addParameter("key", context.getString());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"try {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    TypeReference _string = context.getString();
                    _builder.append((Object)_string, "\t");
                    _builder.append((Object)" value = ");
                    String _simpleName = annotatedClass.findDeclaredField(AbstractNLSProcessor.RESOURCE_BUNDLE_FIELD).getSimpleName();
                    _builder.append((Object)_simpleName, "\t");
                    _builder.append((Object)".getString(key);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return value;");
                    _builder.newLine();
                    _builder.append((Object)"} catch (");
                    _builder.append(MissingResourceException.class);
                    _builder.append((Object)" e) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return '!' + key + '!';");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("getString", _function);
    }

    protected void addField(final Map.Entry<Object, Object> entry, MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, @Extension TransformationContext context) {
        Object _key = entry.getKey();
        String fieldName = (String)_key;
        this.checkForExistentField(annotatedClass, fieldName, context, nlsAnnotation);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setStatic(true);
            it.setFinal(true);
            it.setType(context.getString());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"\"");
                    Object _key = entry.getKey();
                    _builder.append(_key);
                    _builder.append((Object)"\"");
                }
            };
            it.setInitializer(_client);
            try {
                Object delegate = this.reflExt.invoke(it, "getDelegate", new Object[0]);
                this.reflExt.invoke(delegate, "setConstant", new Object[]{true});
            }
            catch (Throwable _t) {
                if (_t instanceof NoSuchFieldException) {
                    NoSuchFieldException exc = (NoSuchFieldException)_t;
                    throw new RuntimeException(exc);
                }
                if (_t instanceof IllegalAccessException) {
                    IllegalAccessException exc_1 = (IllegalAccessException)_t;
                    throw new RuntimeException(exc_1);
                }
                if (_t instanceof NoSuchMethodException) {
                    NoSuchMethodException exc_2 = (NoSuchMethodException)_t;
                    throw new RuntimeException(exc_2);
                }
                if (_t instanceof InvocationTargetException) {
                    InvocationTargetException exc_3 = (InvocationTargetException)_t;
                    throw new RuntimeException(exc_3);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        annotatedClass.addField(fieldName, _function);
    }

    protected void checkForExistentField(MutableClassDeclaration annotatedClass, String fieldName, @Extension TransformationContext context, AnnotationReference nlsAnnotation) {
        boolean _tripleNotEquals;
        MutableFieldDeclaration _findDeclaredField = annotatedClass.findDeclaredField(fieldName);
        boolean bl = _tripleNotEquals = _findDeclaredField != null;
        if (_tripleNotEquals) {
            context.addError((Element)nlsAnnotation, "Field " + fieldName + " already present in class.");
        }
    }

    protected void addMethod(final Map.Entry<Object, Object> entry, MutableClassDeclaration annotatedClass, AnnotationReference nlsAnnotation, @Extension TransformationContext context) {
        Object _value = entry.getValue();
        String message = (String)_value;
        int wildcardCount = this.getWildcardCount(message);
        Iterable _xifexpression = null;
        if (wildcardCount > 0) {
            Functions.Function1 _function = it -> "param" + it;
            _xifexpression = IterableExtensions.map((Iterable)new IntegerRange(0, wildcardCount - 1), (Functions.Function1)_function);
        } else {
            _xifexpression = CollectionLiterals.newArrayList();
        }
        final ArrayList params = _xifexpression;
        Object _key = entry.getKey();
        String msgMethodName = "msg" + _key;
        this.checkForExistentMethod(annotatedClass, msgMethodName, context, nlsAnnotation, IterableExtensions.size((Iterable)params));
        Procedures.Procedure1 _function_1 = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setStatic(true);
            it.setReturnType(context.getString());
            Consumer<String> _function_2 = param -> it.addParameter(param, context.getObject());
            params.forEach(_function_2);
            it.setDocComment(message);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)AbstractNLSProcessor.nlsClass);
                    _builder.append((Object)".bind(getString(");
                    Object _key = entry.getKey();
                    _builder.append(_key);
                    _builder.append((Object)"), new Object [] { ");
                    String _join = IterableExtensions.join((Iterable)params, (CharSequence)", ");
                    _builder.append((Object)_join);
                    _builder.append((Object)" });");
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod(msgMethodName, _function_1);
    }

    protected void checkForExistentMethod(MutableClassDeclaration annotatedClass, String methodName, @Extension TransformationContext context, AnnotationReference nlsAnnotation, int parameterListSize) {
        MutableMethodDeclaration existentMethod = annotatedClass.findDeclaredMethod(methodName, new TypeReference[0]);
        if (existentMethod != null) {
            boolean _equals;
            int _size = IterableExtensions.size((Iterable)existentMethod.getParameters());
            boolean bl = _equals = _size == parameterListSize;
            if (_equals) {
                context.addError((Element)nlsAnnotation, "Method " + methodName + "/" + Integer.valueOf(parameterListSize) + " already present in class.");
            }
        }
    }

    protected int getWildcardCount(String unboundMessage) {
        int _xblockexpression = 0;
        Pattern pattern = Pattern.compile("\\{\\d*\\}");
        Matcher matcher = pattern.matcher(unboundMessage);
        HashSet matches = CollectionLiterals.newHashSet();
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            matches.add(matchResult.group());
        }
        _xblockexpression = matches.size();
        return _xblockexpression;
    }

    private AnnotationReference getNLSAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        return annotatedClass.findAnnotation(context.newTypeReference(this.getAnnotationType(), new TypeReference[0]).getType());
    }

    private String getNLSAnnotationPropertyValue(AnnotationReference nlsAnnotation, @Extension TransformationContext context) {
        String _xblockexpression = null;
        Object _value = nlsAnnotation.getValue("propertyFileName");
        String value = (String)_value;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)value);
        if (_isNullOrEmpty) {
            String _annotationName = this.getAnnotationName();
            String _plus = String.valueOf(_annotationName) + " requires non empty propertyFileName property value.";
            context.addError((Element)nlsAnnotation, _plus);
        }
        _xblockexpression = value;
        return _xblockexpression;
    }

    private InputStream getPropertiesFile(MutableClassDeclaration annotatedClass, @Extension TransformationContext context, String propertyFileName, AnnotationReference nlsAnnotation) {
        boolean _not_1;
        Path folder;
        InputStream _xblockexpression = null;
        Path _filePath = annotatedClass.getCompilationUnit().getFilePath();
        Path _parent = null;
        if (_filePath != null) {
            _parent = _filePath.getParent();
        }
        if ((folder = _parent) == null || !context.exists(folder)) {
            String _qualifiedName = annotatedClass.getQualifiedName();
            String _plus = "Cannot find folder for class " + _qualifiedName;
            String _plus_1 = String.valueOf(_plus) + ": ";
            String _plus_2 = String.valueOf(_plus_1) + folder;
            context.addError((Element)nlsAnnotation, _plus_2);
            String _qualifiedName_1 = annotatedClass.getQualifiedName();
            String _plus_3 = "Cannot find folder for class " + _qualifiedName_1;
            String _plus_4 = String.valueOf(_plus_3) + ": ";
            String _plus_5 = String.valueOf(_plus_4) + folder;
            throw new IllegalArgumentException(_plus_5);
        }
        String _xifexpression = null;
        boolean _endsWith = propertyFileName.endsWith(".properties");
        boolean _not = !_endsWith;
        _xifexpression = _not ? ".properties" : "";
        String _plus_6 = String.valueOf(propertyFileName) + _xifexpression;
        Path propertiesFilePath = folder.append(_plus_6);
        boolean _exists = context.exists(propertiesFilePath);
        boolean bl = _not_1 = !_exists;
        if (_not_1) {
            String _lastSegment = propertiesFilePath.getLastSegment();
            String _plus_7 = String.valueOf(_lastSegment) + " doesn't exist.";
            context.addError((Element)nlsAnnotation, _plus_7);
        }
        _xblockexpression = context.getContentsAsStream(propertiesFilePath);
        return _xblockexpression;
    }

    private Properties loadPropertiesFile(InputStream propertiesFile, @Extension TransformationContext transformationContext, AnnotationReference nlsAnnotation) {
        Properties _xblockexpression = null;
        Properties properties = new Properties();
        try {
            properties.load(propertiesFile);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException ioe = (IOException)_t;
                String _message = ioe.getMessage();
                String _plus = "Cannot load properties file: " + _message;
                transformationContext.addError((Element)nlsAnnotation, _plus);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = properties;
        return _xblockexpression;
    }
}

