/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.members.TMemberEntry;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.NameAndAccess;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.AbstractHierachyTraverser;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.ts.types.util.NameStaticPair;
import org.eclipse.n4js.ts.types.util.NonSymetricMemberKey;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ImportedNamesRecordingScopeAccess;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ContainerTypesHelper {
    private static final Logger logger = Logger.getLogger(ContainerTypesHelper.class);
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private ImportedNamesRecordingScopeAccess polyfillScopeAccess;
    @Inject
    private IResourceScopeCache cache;

    public MemberCollector fromContext(Resource contextResource) {
        if (contextResource == null) {
            throw new NullPointerException("Context resource used to collect members must not be null.");
        }
        if (!(contextResource instanceof N4JSResource)) {
            throw new IllegalArgumentException("polyfills etc are only supported by n4js");
        }
        return new MemberCollector(contextResource);
    }

    public MemberCollector fromContext(EObject contextObject) {
        if (contextObject == null) {
            throw new NullPointerException("Context object used to collect members must not be null.");
        }
        return this.fromContext(contextObject.eResource());
    }

    public class MemberCollector {
        private final Resource contextResource;

        private MemberCollector(Resource contextResource) {
            this.contextResource = contextResource;
        }

        public TMethod findConstructor(ContainerType<?> type) {
            TMember member = this.findMember(type, "constructor", false, false, true, true);
            if (member instanceof TMethod) {
                return (TMethod)member;
            }
            return null;
        }

        public TMember findMember(ContainerType<?> type, String name, boolean writable, boolean staticAccess) {
            return this.findMember(type, name, writable, staticAccess, true, true);
        }

        public TMember findMember(ContainerType<?> type, String name, boolean writable, boolean staticAccess, boolean includeImplicitSuperTypes, boolean includePolyfills) {
            return (TMember)ContainerTypesHelper.this.cache.get(Arrays.asList("findMember", type, name, writable, staticAccess, includeImplicitSuperTypes, includePolyfills), this.contextResource, () -> (TMember)new FindMemberHelper(type, name, writable, staticAccess, includeImplicitSuperTypes, includePolyfills).getResult());
        }

        public boolean isMixedIn(TClassifier classifier, TMember member) {
            if (member == null || !(member.eContainer() instanceof TInterface)) {
                return false;
            }
            TMember actualMember = this.findMember((ContainerType<?>)classifier, member.getName(), member.isWriteable(), member.isStatic(), true, true);
            return actualMember == member;
        }

        public ContainerType<?> directSuperTypeBequestingMember(TClassifier classifier, TMember inheritedMember) {
            ContainerType containingType = inheritedMember.getContainingType();
            for (ParameterizedTypeRef superTypeRef : classifier.getSuperClassifierRefs()) {
                if (!(superTypeRef.getDeclaredType() instanceof ContainerType)) continue;
                ContainerType superType = (ContainerType)superTypeRef.getDeclaredType();
                if (containingType == superType) {
                    return superType;
                }
                TMember superTypesMember = this.findMember(superType, inheritedMember.getName(), inheritedMember.isWriteable(), inheritedMember.isStatic());
                if (superTypesMember != inheritedMember) continue;
                return superType;
            }
            throw new IllegalArgumentException("Member " + inheritedMember.getMemberAsString() + " was not inherited by " + classifier.getTypeAsString());
        }

        public MemberList<TMember> members(ContainerType<?> type) {
            return this.members(type, true, true);
        }

        private MemberList<TMember> members(ContainerType<?> type, Predicate<TMember> filter) {
            return (MemberList)new CollectMembersHelper(type, true, true, filter).getResult();
        }

        public MemberList<TMember> members(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean includePolyfills) {
            return (MemberList)ContainerTypesHelper.this.cache.get(Arrays.asList("members", type, includeImplicitSuperTypes, includePolyfills), this.contextResource, () -> (MemberList)new CollectMembersHelper(type, includeImplicitSuperTypes, includePolyfills, m -> true).getResult());
        }

        public MemberList<TMember> allMembers(ContainerType<?> type) {
            return this.allMembers(type, true, true);
        }

        public MemberList<TMember> allMembers(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean includePolyfills) {
            return this.allMembers(type, includeImplicitSuperTypes, includePolyfills, true);
        }

        public MemberList<TMember> allMembers(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean includePolyfills, boolean includeInheritedMembers) {
            return (MemberList)ContainerTypesHelper.this.cache.get(Arrays.asList("allMembers", type, includeImplicitSuperTypes, includePolyfills, includeInheritedMembers), this.contextResource, () -> (MemberList)new AllMembersCollector(type, includeImplicitSuperTypes, includePolyfills, includeInheritedMembers).getResult());
        }

        public Collection<TMemberEntry> memberEntries(ContainerType<?> type) {
            return (Collection)new MemberEntriesCollector(type, true, true).getResult();
        }

        public MemberList<TMember> inheritedMembers(TClass clazz) {
            TClassifier superType = this.explicitOrImplicitSuperType((TClassifier)clazz);
            if (superType != null) {
                return this.members((ContainerType<?>)superType, m -> m.getContainingType() != clazz);
            }
            return MemberList.emptyList();
        }

        public MemberList<TMember> membersOfImplementedInterfacesForConsumption(TClassifier classifier) {
            Iterator iter = classifier.getImplementedOrExtendedInterfaceRefs().iterator();
            if (!iter.hasNext()) {
                return MemberList.emptyList();
            }
            ParameterizedTypeRef first = (ParameterizedTypeRef)iter.next();
            if (!iter.hasNext()) {
                if (first.getDeclaredType() instanceof TInterface) {
                    TInterface tinterface = (TInterface)first.getDeclaredType();
                    return this.members((ContainerType<?>)tinterface, false, true);
                }
                return MemberList.emptyList();
            }
            MemberList memberList = new MemberList();
            for (ParameterizedTypeRef interfaceRef : classifier.getImplementedOrExtendedInterfaceRefs()) {
                if (!(interfaceRef.getDeclaredType() instanceof TInterface)) continue;
                TInterface tinterface = (TInterface)interfaceRef.getDeclaredType();
                memberList.addAll(this.members((ContainerType<?>)tinterface, false, true));
            }
            return memberList;
        }

        private TClassifier explicitOrImplicitSuperType(TClassifier tclassifier) {
            Optional<TClassifier> expl = this.explicitSuperType(tclassifier);
            if (expl.isPresent()) {
                return (TClassifier)expl.get();
            }
            List<ParameterizedTypeRef> superTypes = this.implicitSuperTypes((Type)tclassifier);
            if (!superTypes.isEmpty()) {
                return (TClassifier)superTypes.get(0).getDeclaredType();
            }
            return null;
        }

        private Optional<TClassifier> explicitSuperType(TClassifier tclassifier) {
            TClass tclass;
            if (tclassifier instanceof TClass && (tclass = (TClass)tclassifier).getSuperClassRef() != null && tclass.getSuperClassRef().getDeclaredType() instanceof TClassifier) {
                return Optional.of((Object)((TClassifier)tclass.getSuperClassRef().getDeclaredType()));
            }
            return Optional.absent();
        }

        private List<Type> getPolyfillTypesFromScope(QualifiedName fqn) {
            IScope contextScope = ContainerTypesHelper.this.polyfillScopeAccess.getRecordingPolyfillScope(this.contextResource);
            ArrayList<Type> types = new ArrayList<Type>();
            for (IEObjectDescription descr : contextScope.getElements(fqn)) {
                Type polyfillType = (Type)descr.getEObjectOrProxy();
                if (polyfillType.eIsProxy() && (polyfillType = (Type)EcoreUtil.resolve((EObject)polyfillType, (Resource)this.contextResource)).eIsProxy()) {
                    throw new IllegalStateException("unexpected proxy");
                }
                types.add(polyfillType);
            }
            return types;
        }

        public MemberList<TMember> computeOwnedAndMixedInConcreteMembers(TClassifier type) {
            Object interfaces;
            TClassifier superType;
            if (type instanceof TClass) {
                superType = this.explicitOrImplicitSuperType(type);
                interfaces = ((TClass)type).getImplementedInterfaceRefs();
            } else if (type instanceof TInterface) {
                superType = null;
                interfaces = ((TInterface)type).getSuperInterfaceRefs();
            } else if (type instanceof TObjectPrototype) {
                superType = this.explicitOrImplicitSuperType(type);
                interfaces = Collections.emptyList();
            } else {
                return MemberList.emptyList();
            }
            MemberList ownedAndMixedInConcreteMembers = type.getOwnedMembers().stream().filter(m -> !m.isAbstract() && !"constructor".equals(m.getName())).collect(Collectors.toCollection(MemberList::new));
            Set ownedTypeMemberKeys = ownedAndMixedInConcreteMembers.stream().map(it -> NonSymetricMemberKey.of((TMember)it)).collect(Collectors.toSet());
            Set superTypeMemberKeys = superType != null ? (Collection)this.allMembers((ContainerType<?>)superType, false, true).stream().map(it -> NonSymetricMemberKey.of((TMember)it)).collect(Collectors.toSet()) : Collections.emptySet();
            HashMap mixedInMemberListsByNameStatic = new HashMap();
            interfaces.stream().map(it -> it.getDeclaredType()).filter(it -> it instanceof TInterface).forEach(intf -> this.members((ContainerType<?>)((TInterface)intf), false, true).stream().filter(m -> !m.isAbstract() && !m.isStatic()).forEach(it -> {
                NameStaticPair nsp = NameStaticPair.of((TMember)it);
                MemberList c = (MemberList)mixedInMemberListsByNameStatic.get(nsp);
                if (c == null) {
                    c = new MemberList();
                    mixedInMemberListsByNameStatic.put(nsp, c);
                }
                if (!c.contains(it)) {
                    c.add(it);
                }
            }));
            mixedInMemberListsByNameStatic.values().stream().filter(it -> {
                switch (it.size()) {
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return TypeUtils.isAccessorPair((TMember)((TMember)it.get(0)), (TMember)((TMember)it.get(1)));
                    }
                }
                return false;
            }).forEach(tmemberColl -> {
                for (TMember m : tmemberColl) {
                    NonSymetricMemberKey key = NonSymetricMemberKey.of((TMember)m);
                    if (ownedTypeMemberKeys.contains(key) || superTypeMemberKeys.contains(key)) continue;
                    ownedAndMixedInConcreteMembers.add((Object)m);
                }
            });
            return ownedAndMixedInConcreteMembers;
        }

        public MemberList<TMember> computeOwnedAndMixedInConcreteMembers(TClassifier type, TClassifier spolyBuddy) {
            List<Object> interfaces;
            TClassifier superType;
            if (spolyBuddy == null) {
                throw new IllegalArgumentException("Parameter must not be null. If not static polyfill is available, call #computeOwnedAndMixedInConcreteMembers() with one arg only.Type=" + type.getRawTypeAsString());
            }
            if (!(spolyBuddy.isStaticPolyfill() && (spolyBuddy instanceof TClass && type.equals(this.explicitSuperType(spolyBuddy).orNull()) || spolyBuddy instanceof TInterface && ((TInterface)spolyBuddy).getSuperInterfaceRefs().stream().filter(ptr -> type.equals(ptr.getDeclaredType())).findFirst().isPresent()))) {
                throw new IllegalArgumentException("Passed in static polyfill " + spolyBuddy.getRawTypeAsString() + " is not filling passed in type " + type.getRawTypeAsString());
            }
            if (type instanceof TClass) {
                superType = this.explicitOrImplicitSuperType(type);
                interfaces = new ArrayList(((TClass)type).getImplementedInterfaceRefs());
                interfaces.addAll((Collection<Object>)((TClass)spolyBuddy).getImplementedInterfaceRefs());
            } else if (type instanceof TInterface) {
                superType = null;
                interfaces = new ArrayList(((TInterface)type).getSuperInterfaceRefs());
                interfaces.addAll((Collection<Object>)((TInterface)spolyBuddy).getSuperInterfaceRefs());
            } else if (type instanceof TObjectPrototype) {
                superType = this.explicitOrImplicitSuperType(type);
                interfaces = Collections.emptyList();
            } else {
                return MemberList.emptyList();
            }
            List polyfilledMembers = spolyBuddy.getOwnedMembers().stream().filter(m -> !m.isAbstract() && !"constructor".equals(m.getName())).collect(Collectors.toList());
            Stream<TMember> origOwnedAndMixedInConcreteMembers = type.getOwnedMembers().stream().filter(m -> !m.isAbstract() && !"constructor".equals(m.getName())).filter(m -> !polyfilledMembers.stream().filter(c -> c.getMemberType() == m.getMemberType() && c.isStatic() == m.isStatic() && c.getName().equals(m.getName())).findFirst().isPresent());
            MemberList ownedAndMixedInConcreteMembers = Stream.concat(polyfilledMembers.stream(), origOwnedAndMixedInConcreteMembers).collect(Collectors.toCollection(MemberList::new));
            Set ownedTypeMemberKeys = ownedAndMixedInConcreteMembers.stream().map(it -> NonSymetricMemberKey.of((TMember)it)).collect(Collectors.toSet());
            Set superTypeMemberKeys = superType != null ? (Collection)this.allMembers((ContainerType<?>)superType, false, true).stream().map(it -> NonSymetricMemberKey.of((TMember)it)).collect(Collectors.toSet()) : Collections.emptySet();
            HashMap mixedInMemberListsByNameStatic = new HashMap();
            interfaces.stream().map(it -> it.getDeclaredType()).filter(it -> it instanceof TInterface).forEach(intf -> this.members((ContainerType<?>)((TInterface)intf), false, true).stream().filter(m -> !m.isAbstract() && !m.isStatic()).forEach(it -> {
                NameStaticPair nsp = NameStaticPair.of((TMember)it);
                MemberList c = (MemberList)mixedInMemberListsByNameStatic.get(nsp);
                if (c == null) {
                    c = new MemberList();
                    mixedInMemberListsByNameStatic.put(nsp, c);
                }
                if (!c.contains(it)) {
                    c.add(it);
                }
            }));
            mixedInMemberListsByNameStatic.values().stream().filter(it -> {
                switch (it.size()) {
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return TypeUtils.isAccessorPair((TMember)((TMember)it.get(0)), (TMember)((TMember)it.get(1)));
                    }
                }
                return false;
            }).forEach(tmemberColl -> {
                for (TMember m : tmemberColl) {
                    NonSymetricMemberKey key = NonSymetricMemberKey.of((TMember)m);
                    if (ownedTypeMemberKeys.contains(key) || superTypeMemberKeys.contains(key)) continue;
                    ownedAndMixedInConcreteMembers.add((Object)m);
                }
            });
            return ownedAndMixedInConcreteMembers;
        }

        private List<ParameterizedTypeRef> implicitSuperTypes(Type type) {
            return RuleEnvironmentExtensions.collectAllImplicitSuperTypesOfType(RuleEnvironmentExtensions.newRuleEnvironment(this.contextResource), type);
        }

        private abstract class AbstractMemberCollector<Result>
        extends AbstractHierachyTraverser<Result> {
            private final boolean includeImplicitSuperTypes;
            protected final boolean includePolyfills;

            public AbstractMemberCollector(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean includePolyfills) {
                super(type);
                this.includeImplicitSuperTypes = includeImplicitSuperTypes;
                this.includePolyfills = includePolyfills;
            }

            protected boolean isIgnoredMember(TMember m) {
                return m.isStatic() && m.getContainingType() instanceof TInterface && m.getContainingType() != this.bottomType;
            }

            protected List<ParameterizedTypeRef> getImplicitSuperTypes(Type type) {
                if (this.includeImplicitSuperTypes) {
                    return MemberCollector.this.implicitSuperTypes(type);
                }
                return Collections.emptyList();
            }

            protected List<ParameterizedTypeRef> getPolyfills(Type filledType) {
                if (this.includePolyfills && (filledType instanceof TClass || filledType instanceof TObjectPrototype)) {
                    QualifiedName qn;
                    TClassifier tClassifier = (TClassifier)filledType;
                    if (filledType.isProvidedByRuntime() && (qn = N4TSQualifiedNameProvider.getPolyfillFQN((TClassifier)tClassifier, (IQualifiedNameProvider)ContainerTypesHelper.this.qualifiedNameProvider)) != null) {
                        List polyfills = MemberCollector.this.getPolyfillTypesFromScope(qn);
                        return polyfills.stream().map(polyFill -> TypeUtils.createTypeRef((Type)polyFill, (TypeArgument[])new TypeArgument[0])).collect(Collectors.toList());
                    }
                    if (N4JSLanguageUtils.isContainedInStaticPolyfillAware((TAnnotableElement)filledType) && (qn = N4TSQualifiedNameProvider.getStaticPolyfillFQN((TClassifier)tClassifier, (IQualifiedNameProvider)ContainerTypesHelper.this.qualifiedNameProvider)) != null) {
                        List polyfills = MemberCollector.this.getPolyfillTypesFromScope(qn);
                        return polyfills.stream().map(polyFill -> TypeUtils.createTypeRef((Type)polyFill, (TypeArgument[])new TypeArgument[0])).collect(Collectors.toList());
                    }
                }
                return Collections.emptyList();
            }
        }

        private class AllMembersCollector
        extends AbstractMemberCollector<MemberList<TMember>> {
            private final MemberList<TMember> result;
            private final boolean includeInheritedMembers;

            public AllMembersCollector(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean includePolyfills, boolean includeInheritedMembers) {
                super(type, includeImplicitSuperTypes, includePolyfills);
                this.includeInheritedMembers = includeInheritedMembers;
                this.result = new MemberList();
            }

            protected MemberList<TMember> doGetResult() {
                return this.result;
            }

            protected boolean process(ContainerType<?> containerType) {
                if (this.includeInheritedMembers || this.bottomType.equals(containerType) || this.includePolyfills && this.isDirectPolyfill(containerType)) {
                    for (TMember member : containerType.getOwnedMembers()) {
                        if (this.isIgnoredMember(member)) continue;
                        this.result.add((Object)member);
                    }
                }
                return false;
            }

            private boolean isDirectPolyfill(ContainerType<?> containerType) {
                if (!containerType.isStaticPolyfill() || !(this.bottomType instanceof TClassifier)) {
                    return false;
                }
                QualifiedName qn = N4TSQualifiedNameProvider.getStaticPolyfillFQN((TClassifier)((TClassifier)this.bottomType), (IQualifiedNameProvider)ContainerTypesHelper.this.qualifiedNameProvider);
                if (containerType instanceof TClass) {
                    return qn.equals((Object)ContainerTypesHelper.this.qualifiedNameProvider.getFullyQualifiedName(containerType));
                }
                if (containerType instanceof TN4Classifier) {
                    return Iterables.any((Iterable)((TN4Classifier)containerType).getSuperClassifierRefs(), ref -> qn.equals((Object)ContainerTypesHelper.this.qualifiedNameProvider.getFullyQualifiedName((EObject)ref.getDeclaredType())));
                }
                return false;
            }
        }

        private class CollectMembersHelper
        extends AbstractMemberCollector<MemberList<TMember>> {
            private final Map<NameAndAccess, TMember> nameAccessToMember;
            private final Predicate<TMember> filter;

            public CollectMembersHelper(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean includePolyfills, Predicate<TMember> filter) {
                super(type, includeImplicitSuperTypes, includePolyfills);
                this.filter = filter == null ? m -> true : filter;
                this.nameAccessToMember = Maps.newLinkedHashMap();
            }

            protected MemberList<TMember> doGetResult() {
                return new MemberList(this.nameAccessToMember.values());
            }

            protected boolean process(ContainerType<?> containerType) {
                for (Map.Entry entry : containerType.getOrCreateOwnedMembersByNameAndAccess().entrySet()) {
                    TMember prev;
                    boolean isDuplicate;
                    NameAndAccess key = (NameAndAccess)entry.getKey();
                    TMember m = (TMember)entry.getValue();
                    boolean bl = isDuplicate = m.isReadable() && m.isWriteable() && key.isWriteAccess();
                    if (isDuplicate || this.isIgnoredMember(m) || !this.filter.test(m) || (prev = this.nameAccessToMember.put(key, m)) == null || prev.isAbstract() && !m.isAbstract() && prev.getContainingType() != this.bottomType) continue;
                    this.nameAccessToMember.put(key, prev);
                }
                return false;
            }
        }

        private class FindMemberHelper
        extends AbstractMemberCollector<TMember> {
            private TMember foundMember;
            private final String name;
            private final boolean writeAccess;
            private final boolean staticAccess;

            FindMemberHelper(ContainerType<?> type, String name, boolean writeAccess, boolean staticAccess, boolean includeImplicitSuperTypes, boolean includePolyfills) {
                super(type, includeImplicitSuperTypes, includePolyfills);
                this.foundMember = null;
                this.name = name;
                this.writeAccess = writeAccess;
                this.staticAccess = staticAccess;
            }

            protected boolean process(ContainerType<?> containerType) {
                TMember m = containerType.findOwnedMember(this.name, this.writeAccess, this.staticAccess);
                if (m != null && !this.isIgnoredMember(m)) {
                    if (this.foundMember == null || !m.isAbstract()) {
                        this.foundMember = m;
                    }
                    if (this.foundMember.getContainingType() == this.bottomType || !this.foundMember.isAbstract()) {
                        return true;
                    }
                }
                return false;
            }

            protected TMember doGetResult() {
                return this.foundMember;
            }
        }

        private class MemberEntriesCollector
        extends AbstractMemberCollector<Collection<TMemberEntry>> {
            private final Map<Pair<String, Boolean>, TMemberEntry> memberEntries;
            private TMemberEntry.MemberSource source;

            public MemberEntriesCollector(ContainerType<?> type, boolean includeImplicitSuperTypes, boolean includePolyfills) {
                super(type, includeImplicitSuperTypes, includePolyfills);
                this.memberEntries = new HashMap<Pair<String, Boolean>, TMemberEntry>();
                this.source = type instanceof TInterface ? TMemberEntry.MemberSource.MIXEDIN : TMemberEntry.MemberSource.INHERITED;
            }

            protected Collection<TMemberEntry> doGetResult() {
                return this.memberEntries.values();
            }

            private TMemberEntry getOrCreateEntry(TMember member) {
                Pair p = Tuples.pair((Object)member.getName(), (Object)member.isStatic());
                TMemberEntry entry = this.memberEntries.get(p);
                if (entry == null) {
                    entry = new TMemberEntry(member.getName(), member.isStatic());
                    this.memberEntries.put((Pair<String, Boolean>)p, entry);
                }
                return entry;
            }

            protected boolean process(ContainerType<?> containerType) {
                TMemberEntry.MemberSource currentSource = containerType == this.bottomType ? TMemberEntry.MemberSource.OWNED : this.source;
                for (TMember member : containerType.getOwnedMembers()) {
                    if (this.isIgnoredMember(member)) continue;
                    TMemberEntry entry = this.getOrCreateEntry(member);
                    entry.add(member, currentSource);
                }
                return false;
            }

            protected boolean doProcessConsumedRoles(TClass object) {
                if (object == this.bottomType) {
                    this.source = TMemberEntry.MemberSource.MIXEDIN;
                }
                return super.doProcessConsumedRoles(object);
            }
        }
    }
}

