/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.ObjectId;

abstract class FetchRequest {
    final Set<ObjectId> wantIds;
    final int depth;
    final Set<ObjectId> clientShallowCommits;
    final long filterBlobLimit;
    final Set<String> clientCapabilities;
    final int deepenSince;
    final List<String> deepenNotRefs;
    @Nullable
    final String agent;

    FetchRequest(@NonNull Set<ObjectId> wantIds, int depth, @NonNull Set<ObjectId> clientShallowCommits, long filterBlobLimit, @NonNull Set<String> clientCapabilities, int deepenSince, @NonNull List<String> deepenNotRefs, @Nullable String agent) {
        this.wantIds = Objects.requireNonNull(wantIds);
        this.depth = depth;
        this.clientShallowCommits = Objects.requireNonNull(clientShallowCommits);
        this.filterBlobLimit = filterBlobLimit;
        this.clientCapabilities = Objects.requireNonNull(clientCapabilities);
        this.deepenSince = deepenSince;
        this.deepenNotRefs = Objects.requireNonNull(deepenNotRefs);
        this.agent = agent;
    }

    @NonNull
    Set<ObjectId> getWantIds() {
        return this.wantIds;
    }

    int getDepth() {
        return this.depth;
    }

    @NonNull
    Set<ObjectId> getClientShallowCommits() {
        return this.clientShallowCommits;
    }

    long getFilterBlobLimit() {
        return this.filterBlobLimit;
    }

    @NonNull
    Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    int getDeepenSince() {
        return this.deepenSince;
    }

    @NonNull
    List<String> getDeepenNotRefs() {
        return this.deepenNotRefs;
    }

    @Nullable
    String getAgent() {
        return this.agent;
    }
}

