/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.fileextensions;

import com.google.inject.Inject;
import org.eclipse.n4js.fileextensions.FileExtensionType;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;

public class FileExtensionTypeHelper {
    @Inject
    private FileExtensionsRegistry fileExtensionsRegistry;

    public boolean isOfType(String fileExtension, FileExtensionType extensionType) {
        return this.fileExtensionsRegistry.getFileExtensions(extensionType).contains(fileExtension);
    }

    public boolean isRunnable(String fileExtension) {
        return this.isOfType(fileExtension, FileExtensionType.RUNNABLE_FILE_EXTENSION);
    }

    public boolean isTranspilable(String fileExtension) {
        return this.isOfType(fileExtension, FileExtensionType.TRANSPILABLE_FILE_EXTENSION);
    }

    public boolean isTestable(String fileExtension) {
        return this.isOfType(fileExtension, FileExtensionType.TESTABLE_FILE_EXTENSION);
    }

    public boolean isTypable(String fileExtension) {
        return this.isOfType(fileExtension, FileExtensionType.TYPABLE_FILE_EXTENSION);
    }
}

