/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.packagejson;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.validation.JSONIssueCodes;
import org.eclipse.n4js.json.validation.extension.IJSONValidatorExtension;
import org.eclipse.n4js.packagejson.PackageJsonHelper;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.n4js.validation.N4JSValidator;
import org.eclipse.n4js.validation.validators.packagejson.CheckProperty;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class AbstractJSONValidatorExtension
extends AbstractDeclarativeValidator
implements IJSONValidatorExtension {
    private static final Logger LOGGER = Logger.getLogger(AbstractJSONValidatorExtension.class);
    private static final String JSON_DOCUMENT_VALUES = "JSON_DOCUMENT_VALUES";
    private static final String JSON_DOCUMENT = "JSON_DOCUMENT";
    @Inject
    private XpectAwareFileExtensionCalculator fileExtensionCalculator;
    @Inject
    private PackageJsonHelper pckjsonHelper;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public final void validateJSON(JSONDocument document, DiagnosticChain diagnosticChain) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (!this.isResponsible(context, (EObject)document)) {
            return;
        }
        context.put(JSON_DOCUMENT, document);
        this.validate(JSONPackage.Literals.JSON_DOCUMENT, (EObject)document, diagnosticChain, context);
        document.eAllContents().forEachRemaining(child -> this.validate(child.eClass(), (EObject)child, diagnosticChain, context));
    }

    public AbstractDeclarativeValidator.MethodWrapper createMethodWrapper(AbstractDeclarativeValidator instanceToUse, Method method) {
        boolean isCheckMethodInsideThisClass;
        boolean bl = isCheckMethodInsideThisClass = method.getDeclaringClass() == AbstractJSONValidatorExtension.class;
        if (isCheckMethodInsideThisClass) {
            return super.createMethodWrapper(instanceToUse, method);
        }
        return new N4JSValidator.N4JSMethodWrapperCancelable(instanceToUse, method, this.operationCanceledManager);
    }

    @Check
    public void checkUsingCheckPropertyMethods(JSONDocument document) {
        List<Method> allMethods = Arrays.asList(((Object)((Object)this)).getClass().getDeclaredMethods());
        List checkKeyMethods = allMethods.stream().filter(m -> ((CheckProperty[])m.getAnnotationsByType(CheckProperty.class)).length != 0).filter(m -> this.isValidCheckKeyMethod((Method)m)).map(m -> Pair.of((Object)((CheckProperty[])m.getAnnotationsByType(CheckProperty.class))[0], (Object)m)).collect(Collectors.toList());
        Multimap<String, JSONValue> documentValues = this.collectDocumentValues(document);
        for (Pair methodPair : checkKeyMethods) {
            CheckProperty annotation = (CheckProperty)methodPair.getKey();
            Method method = (Method)methodPair.getValue();
            PackageJsonProperties property = annotation.property();
            Collection values = documentValues.get((Object)property.getPath());
            DataCollector dcCheckMethod = N4JSDataCollectors.createDataCollectorForCheckMethod((String)method.getName());
            for (JSONValue value : values) {
                if (value == null) continue;
                try {
                    Throwable throwable = null;
                    Object var15_18 = null;
                    try (Measurement m2 = dcCheckMethod.getMeasurement();){
                        if (method.getParameterTypes().length == 0) {
                            method.invoke((Object)this, new Object[0]);
                            continue;
                        }
                        method.invoke((Object)this, value);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to invoke @CheckProperty method " + method + ": " + e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.error((Object)("Failed to invoke @CheckProperty method " + method + ": " + e.getTargetException()));
                    e.getTargetException().printStackTrace();
                }
            }
        }
    }

    public void register(EValidatorRegistrar registrar) {
    }

    protected Multimap<String, JSONValue> getDocumentValues() {
        return (Multimap)this.contextMemoize(JSON_DOCUMENT_VALUES, () -> this.collectDocumentValues((JSONDocument)this.getContext().get(JSON_DOCUMENT)));
    }

    protected JSONDocument getDocument() {
        return (JSONDocument)this.getContext().get(JSON_DOCUMENT);
    }

    protected <T> T contextMemoize(String key, Supplier<T> supplier) {
        if (this.getContext().containsKey(key)) {
            return (T)this.getContext().get(key);
        }
        Object value = supplier.get();
        this.getContext().put(key, value);
        return (T)value;
    }

    protected Collection<JSONValue> getDocumentValues(PackageJsonProperties property) {
        return this.getDocumentValues().get((Object)property.getPath());
    }

    protected <T extends JSONValue> T getSingleDocumentValue(PackageJsonProperties property, Class<T> expectedClass) {
        JSONValue value;
        Collection values = this.getDocumentValues().get((Object)property.getPath());
        JSONValue jSONValue = value = !values.isEmpty() ? (JSONValue)values.iterator().next() : null;
        if (!expectedClass.isInstance(value)) {
            return null;
        }
        return (T)((JSONValue)expectedClass.cast(value));
    }

    protected JSONValue getSingleDocumentValue(PackageJsonProperties property) {
        return this.getSingleDocumentValue(property, JSONValue.class);
    }

    protected static String getJSONValueDescription(JSONValue value) {
        return AbstractJSONValidatorExtension.getJSONValueDescription(value.eClass());
    }

    protected static String getJSONValueDescription(EClass valueClass) {
        if (valueClass == JSONPackage.eINSTANCE.getJSONStringLiteral()) {
            return "string";
        }
        if (valueClass == JSONPackage.eINSTANCE.getJSONNumericLiteral()) {
            return "number";
        }
        if (valueClass == JSONPackage.eINSTANCE.getJSONBooleanLiteral()) {
            return "boolean";
        }
        if (valueClass == JSONPackage.eINSTANCE.getJSONObject()) {
            return "object";
        }
        if (valueClass == JSONPackage.eINSTANCE.getJSONArray()) {
            return "array";
        }
        return "<unknown>";
    }

    protected List<EPackage> getEPackages() {
        return Arrays.asList(JSONPackage.eINSTANCE);
    }

    protected boolean isResponsible(Map<Object, Object> context, EObject eObject) {
        return eObject.eClass().getEPackage() == JSONPackage.eINSTANCE;
    }

    protected void checkIsPresent(EObject issueTarget, Multimap<String, JSONValue> documentValues, String propertyPath) {
        if (!documentValues.containsKey((Object)propertyPath)) {
            this.addIssue(JSONIssueCodes.getMessageForJSON_MISSING_PROPERTY((Object)propertyPath), issueTarget, "JSON_MISSING_PROPERTY");
        }
    }

    protected void addIssue(String message, EObject source, EStructuralFeature feature, int index, String issueCode, String ... issueData) {
        Severity severity = this.getJSONSeverity(issueCode);
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    this.getMessageAcceptor().acceptWarning(message, source, feature, index, issueCode, issueData);
                    break;
                }
                case INFO: {
                    this.getMessageAcceptor().acceptInfo(message, source, feature, index, issueCode, issueData);
                    break;
                }
                case ERROR: {
                    this.getMessageAcceptor().acceptError(message, source, feature, index, issueCode, issueData);
                    break;
                }
            }
        }
    }

    private Severity getJSONSeverity(String issueCode) {
        Severity jsonSeverity = JSONIssueCodes.getDefaultSeverity((String)issueCode);
        if (jsonSeverity != null) {
            return jsonSeverity;
        }
        return this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity(issueCode);
    }

    protected boolean checkIsType(JSONValue value, EClass valueClass) {
        return this.checkIsType(value, valueClass, "");
    }

    protected boolean checkIsType(JSONValue value, EClass valueClass, String locationClause) {
        if (value == null) {
            return false;
        }
        if (!valueClass.isInstance((Object)value)) {
            this.addIssue(JSONIssueCodes.getMessageForJSON_EXPECTED_DIFFERENT_VALUE_TYPE((Object)AbstractJSONValidatorExtension.getJSONValueDescription(valueClass), (Object)AbstractJSONValidatorExtension.getJSONValueDescription(value), (Object)locationClause), (EObject)value, "JSON_EXPECTED_DIFFERENT_VALUE_TYPE");
            return false;
        }
        return true;
    }

    protected boolean checkIsNonEmptyString(JSONStringLiteral stringLiteral, PackageJsonProperties property) {
        if (stringLiteral.getValue().isEmpty()) {
            this.addIssue(JSONIssueCodes.getMessageForJSON_EMPTY_STRING((Object)property.name), (EObject)stringLiteral, "JSON_EMPTY_STRING");
            return false;
        }
        return true;
    }

    private boolean isValidCheckKeyMethod(Method method) {
        return method.getParameterTypes().length == 0 || method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == JSONValue.class;
    }

    protected Multimap<String, JSONValue> collectDocumentValues(JSONDocument document) {
        if (document == null || document.getContent() == null) {
            return ImmutableMultimap.of();
        }
        JSONValue documentContent = document.getContent();
        if (!(documentContent instanceof JSONObject)) {
            return ImmutableMultimap.of();
        }
        return this.collectDocumentValues((JSONObject)documentContent, (Multimap<String, JSONValue>)LinkedHashMultimap.create(), "", -1);
    }

    protected Multimap<String, JSONValue> collectObjectValues(JSONObject object) {
        if (object == null) {
            return ImmutableMultimap.of();
        }
        return this.collectDocumentValues(object, (Multimap<String, JSONValue>)LinkedHashMultimap.create(), "", 1);
    }

    private Multimap<String, JSONValue> collectDocumentValues(JSONObject object, Multimap<String, JSONValue> documentValues, String prefix, int depth) {
        if (depth == 0) {
            return documentValues;
        }
        for (NameValuePair pair : object.getNameValuePairs()) {
            String pairName = pair.getName();
            String name = prefix.isEmpty() ? pairName : String.valueOf(prefix) + "." + pairName;
            JSONValue value = pair.getValue();
            documentValues.put((Object)name, (Object)value);
            if (!(value instanceof JSONObject)) continue;
            this.collectDocumentValues((JSONObject)value, documentValues, name, depth - 1);
        }
        return documentValues;
    }

    protected IssueSeverities getIssueSeverities(Map<Object, Object> context, EObject eObject) {
        JSONDocument jsonDocument = (JSONDocument)EcoreUtil2.getContainerOfType((EObject)eObject, JSONDocument.class);
        IssueSeverities originalIssueSeverities = super.getIssueSeverities(context, eObject);
        if (this.isPckjsonOfPlainJS(jsonDocument)) {
            class IssueSeveritiesDelegator
            extends IssueSeverities {
                final IssueSeverities delegate;

                IssueSeveritiesDelegator(IssueSeverities delegate) {
                    super(null, null, null);
                    this.delegate = delegate;
                }

                public Severity getSeverity(String code) {
                    Severity originalSeverity = this.delegate.getSeverity(code);
                    if (originalSeverity == Severity.ERROR) {
                        return Severity.WARNING;
                    }
                    return originalSeverity;
                }
            }
            return new IssueSeveritiesDelegator(originalIssueSeverities);
        }
        return originalIssueSeverities;
    }

    private boolean isPckjsonOfPlainJS(JSONDocument jsonDocument) {
        URI uri = jsonDocument.eResource().getURI();
        String fileExtension = this.fileExtensionCalculator.getFilenameWithoutXpectExtension(uri);
        boolean isPckjson = fileExtension.equals("package.json");
        if (isPckjson) {
            ProjectDescription pd = this.pckjsonHelper.convertToProjectDescription(jsonDocument, true, "xyz");
            return pd.getProjectType() == ProjectType.PLAINJS;
        }
        return false;
    }
}

