/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleUtil {
    public static String[] getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        String[] result = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            StringBuilder buffer = new StringBuilder();
            buffer.append(locale.toString());
            buffer.append(" - ");
            buffer.append(locale.getDisplayName());
            result[i] = buffer.toString();
            ++i;
        }
        return result;
    }

    public static String expandLocaleName(String name) {
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(name, "_");
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        Locale locale = new Locale(language, country, variant);
        return String.valueOf(locale.toString()) + " - " + locale.getDisplayName();
    }

    public static String trimLocalization(String localization) {
        Pattern p;
        Matcher m;
        String sTrim = localization.trim();
        if (sTrim.endsWith(".properties")) {
            sTrim = sTrim.replaceAll(".properties", "");
        }
        if ((m = (p = Pattern.compile(".*(_[a-z]{2}(_[A-Z]{2})?)$")).matcher(sTrim)).matches()) {
            sTrim = sTrim.substring(0, m.start(1));
        }
        return sTrim;
    }
}

