/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.eclipse.n4js.tester.TestDiscoveryHelper;
import org.eclipse.n4js.tester.TestTreeTransformer;
import org.eclipse.n4js.tester.domain.TestTree;

public class TestCatalogSupplier
implements Supplier<String> {
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private TestTreeTransformer treeTransformer;
    @Inject
    private TestDiscoveryHelper testDiscoveryHelper;

    public String get() {
        try {
            TestTree testTree = this.getTreeForAllTests();
            Object testCatalogObject = this.treeTransformer.apply(testTree);
            return this.objectMapper.writeValueAsString(testCatalogObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while assembling test catalog.", e);
        }
    }

    protected TestTree getTreeForAllTests() {
        return this.testDiscoveryHelper.collectAllTestsFromWorkspace();
    }
}

