/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.semver.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.semver.Semver.SemverPackage;
import org.eclipse.n4js.semver.Semver.SimpleVersion;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.validation.AbstractSemverValidator;
import org.eclipse.n4js.semver.validation.SemverIssueCodes;
import org.eclipse.xtext.validation.Check;

public class SemverValidator
extends AbstractSemverValidator {
    @Check
    public void checkNoAdditionalParts(VersionNumber versionNumber) {
        EList extended = versionNumber.getExtended();
        if (extended != null && !extended.isEmpty()) {
            String msg = SemverIssueCodes.getMessageForSEMVER_TOO_MANY_NUMBERS();
            this.addIssue(msg, (EObject)versionNumber, (EStructuralFeature)SemverPackage.Literals.VERSION_NUMBER__EXTENDED, "SEMVER_TOO_MANY_NUMBERS", new String[0]);
        }
    }

    @Check
    public void checkNoMultipleComparators(SimpleVersion simpleVersion) {
        EList comparators = simpleVersion.getComparators();
        if (comparators.size() > 1) {
            String msg = SemverIssueCodes.getMessageForSEMVER_TOO_MANY_COMPARATORS();
            this.addIssue(msg, (EObject)simpleVersion, (EStructuralFeature)SemverPackage.Literals.SIMPLE_VERSION__COMPARATORS, "SEMVER_TOO_MANY_COMPARATORS", new String[0]);
        }
    }
}

