/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.ui.IStartup;

public class WorkingSetManagerStartup
implements IStartup {
    private static final Logger LOGGER = Logger.getLogger(WorkingSetManagerStartup.class);
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;

    public void earlyStartup() {
        this.workingSetManagerBroker.getWorkingSetManagers();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
            if (event != null && event.getDelta() != null) {
                try {
                    event.getDelta().accept(delta -> {
                        IResource resource = delta.getResource();
                        if (resource instanceof IWorkspaceRoot) {
                            return true;
                        }
                        if (resource instanceof IProject && (1 == delta.getKind() || 4 == delta.getKind() && (delta.getFlags() & 0x4000) != 0)) {
                            this.workingSetManagerBroker.refreshNavigator();
                        }
                        return false;
                    });
                }
                catch (CoreException e) {
                    LOGGER.error((Object)"Error occurred while visiting resource delta.", (Throwable)e);
                }
            }
        });
    }
}

