/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.lazy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

public class LazyLinkingResource
extends XtextResource {
    private static Logger log = Logger.getLogger(LazyLinkingResource.class);
    public static final String UNRESOLVEABLE_PROXIES_KEY = "UNRESOLVEABLE_PROXIES";
    public static final String CYCLIC_LINKING_DECTECTION_COUNTER_LIMIT = "CYCLIC_LINKING_DECTECTION_COUNTER_LIMIT";
    @Inject
    private ILinkingService linkingService;
    @Inject
    private LazyURIEncoder encoder;
    @Inject
    private ILinkingDiagnosticMessageProvider diagnosticMessageProvider;
    @Inject
    private ILinkingDiagnosticMessageProvider.Extended linkingDiagnosticMessageProvider;
    @Inject
    private LinkingHelper linkingHelper;
    private boolean eagerLinking = false;
    @Named(value="CYCLIC_LINKING_DECTECTION_COUNTER_LIMIT")
    @Inject(optional=true)
    protected int cyclicLinkingDectectionCounterLimit = 100;
    private int cyclicLinkingDetectionCounter = 0;
    protected LinkedHashSet<Triple<EObject, EReference, INode>> resolving = Sets.newLinkedHashSet();
    private ArrayList<Triple<EObject, EReference, INode>> proxyInformation = Lists.newArrayList();

    @Override
    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
        if (options != null && Boolean.TRUE.equals(options.get(OPTION_RESOLVE_ALL))) {
            EcoreUtil.resolveAll((Resource)this);
        }
    }

    @Override
    protected void doLinking() {
        super.doLinking();
        if (this.isEagerLinking()) {
            EcoreUtil.resolveAll((Resource)this);
        }
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        CancelIndicator monitor = mon == null ? CancelIndicator.NullImpl : mon;
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)this, (boolean)true);
        while (iterator.hasNext()) {
            this.operationCanceledManager.checkCanceled(monitor);
            InternalEObject source = (InternalEObject)iterator.next();
            EStructuralFeature[] eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)source.eClass().getEAllStructuralFeatures()).crossReferences();
            if (eStructuralFeatures == null) continue;
            for (EStructuralFeature crossRef : eStructuralFeatures) {
                this.operationCanceledManager.checkCanceled(monitor);
                this.resolveLazyCrossReference(source, crossRef);
            }
        }
    }

    protected void resolveLazyCrossReference(InternalEObject source, EStructuralFeature crossRef) {
        if (this.isPotentialLazyCrossReference(crossRef)) {
            this.doResolveLazyCrossReference(source, crossRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResolveLazyCrossReference(InternalEObject source, EStructuralFeature crossRef) {
        block10: {
            block9: {
                if (!crossRef.isMany()) break block9;
                InternalEList list = (InternalEList)source.eGet(crossRef);
                for (int i = 0; i < list.size(); ++i) {
                    EObject target;
                    EObject proxy = (EObject)list.basicGet(i);
                    if (!proxy.eIsProxy()) continue;
                    URI proxyURI = ((InternalEObject)proxy).eProxyURI();
                    if (!this.getURI().equals(proxyURI.trimFragment())) continue;
                    String fragment = proxyURI.fragment();
                    if (!this.getEncoder().isCrossLinkFragment((Resource)this, fragment) || (target = this.getEObject(fragment)) == null) continue;
                    try {
                        source.eSetDeliver(false);
                        list.setUnique(i, (Object)target);
                        continue;
                    }
                    finally {
                        source.eSetDeliver(true);
                    }
                }
                break block10;
            }
            EObject proxy = (EObject)source.eGet(crossRef, false);
            if (proxy == null || !proxy.eIsProxy()) break block10;
            URI proxyURI = ((InternalEObject)proxy).eProxyURI();
            if (this.getURI().equals(proxyURI.trimFragment())) {
                EObject target;
                String fragment = proxyURI.fragment();
                if (this.getEncoder().isCrossLinkFragment((Resource)this, fragment) && (target = this.getEObject(fragment)) != null) {
                    try {
                        source.eSetDeliver(false);
                        source.eSet(crossRef, (Object)target);
                    }
                    finally {
                        source.eSetDeliver(true);
                    }
                }
            }
        }
    }

    protected boolean isPotentialLazyCrossReference(EStructuralFeature feature) {
        return !feature.isDerived() && !feature.isTransient() && feature instanceof EReference && ((EReference)feature).isResolveProxies();
    }

    @Override
    public synchronized EObject getEObject(String uriFragment) {
        try {
            if (this.getEncoder().isCrossLinkFragment((Resource)this, uriFragment)) {
                Triple<EObject, EReference, INode> triple = this.getEncoder().decode((Resource)this, uriFragment);
                return this.getEObject(uriFragment, triple);
            }
        }
        catch (RuntimeException e) {
            this.operationCanceledManager.propagateAsErrorIfCancelException(e);
            this.getErrors().add((Object)new ExceptionDiagnostic(e));
            log.error((Object)("resolution of uriFragment '" + uriFragment + "' failed."), (Throwable)e);
            throw new WrappedException((Exception)e);
        }
        return super.getEObject(uriFragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EObject getEObject(String uriFragment, Triple<EObject, EReference, INode> triple) throws AssertionError {
        ++this.cyclicLinkingDetectionCounter;
        if (this.cyclicLinkingDetectionCounter > this.cyclicLinkingDectectionCounterLimit && !this.resolving.add(triple)) {
            return this.handleCyclicResolution(triple);
        }
        try {
            EObject result;
            Set<String> unresolveableProxies = this.getUnresolvableURIFragments();
            if (unresolveableProxies.contains(uriFragment)) {
                EObject eObject = null;
                return eObject;
            }
            EReference reference = (EReference)triple.getSecond();
            try {
                List<EObject> linkedObjects = this.getLinkingService().getLinkedObjects((EObject)triple.getFirst(), reference, (INode)triple.getThird());
                if (linkedObjects.isEmpty()) {
                    if (this.isUnresolveableProxyCacheable(triple)) {
                        unresolveableProxies.add(uriFragment);
                    }
                    this.createAndAddDiagnostic(triple);
                    EObject eObject = null;
                    return eObject;
                }
                if (linkedObjects.size() > 1) {
                    throw new IllegalStateException("linkingService returned more than one object for fragment " + uriFragment);
                }
                result = linkedObjects.get(0);
            }
            catch (CyclicLinkingException e) {
                if (e.triple.equals(triple)) {
                    log.error((Object)e.getMessage(), (Throwable)((Object)e));
                    if (this.isUnresolveableProxyCacheable(triple)) {
                        unresolveableProxies.add(uriFragment);
                    }
                    this.createAndAddDiagnostic(triple);
                    EObject eObject = null;
                    return eObject;
                }
                try {
                    throw e;
                }
                catch (IllegalNodeException ex) {
                    this.createAndAddDiagnostic(triple, ex);
                    EObject eObject = null;
                    return eObject;
                }
            }
            if (!EcoreUtil2.isAssignableFrom(reference.getEReferenceType(), result.eClass())) {
                log.error((Object)("An element of type " + result.getClass().getName() + " is not assignable to the reference " + reference.getEContainingClass().getName() + "." + reference.getName()));
                if (this.isUnresolveableProxyCacheable(triple)) {
                    unresolveableProxies.add(uriFragment);
                }
                this.createAndAddDiagnostic(triple);
                EObject eObject = null;
                return eObject;
            }
            unresolveableProxies.remove(uriFragment);
            this.removeDiagnostic(triple);
            EObject eObject = result;
            return eObject;
        }
        finally {
            if (this.cyclicLinkingDetectionCounter > this.cyclicLinkingDectectionCounterLimit) {
                this.resolving.remove(triple);
            }
            --this.cyclicLinkingDetectionCounter;
        }
    }

    protected boolean isUnresolveableProxyCacheable(Triple<EObject, EReference, INode> triple) {
        return true;
    }

    protected EObject handleCyclicResolution(Triple<EObject, EReference, INode> triple) throws AssertionError {
        throw new CyclicLinkingException("Cyclic resolution of lazy links : " + this.getReferences(triple, this.resolving) + " in resource '" + this.getURI() + "'.", triple);
    }

    protected String getReferences(Triple<EObject, EReference, INode> triple, LinkedHashSet<Triple<EObject, EReference, INode>> resolving2) {
        StringBuffer buffer = new StringBuffer();
        boolean found = false;
        for (Triple triple2 : resolving2) {
            if (!(found = found || triple2.equals(triple))) continue;
            buffer.append(this.getQualifiedName((EReference)triple2.getSecond())).append("->");
        }
        buffer.append(this.getQualifiedName((EReference)triple.getSecond()));
        return buffer.toString();
    }

    private String getQualifiedName(EReference eReference) {
        return eReference.getEContainingClass().getName() + "." + eReference.getName();
    }

    protected void createAndAddDiagnostic(Triple<EObject, EReference, INode> triple) {
        Resource.Diagnostic diagnostic;
        List<Resource.Diagnostic> list;
        if (this.isValidationDisabled()) {
            return;
        }
        DiagnosticMessage message = this.createDiagnosticMessage(triple);
        if (message != null && !(list = this.getDiagnosticList(message)).contains(diagnostic = this.createDiagnostic(triple, message))) {
            list.add(diagnostic);
        }
    }

    protected void createAndAddDiagnostic(Triple<EObject, EReference, INode> triple, IllegalNodeException ex) {
        Resource.Diagnostic diagnostic;
        List<Resource.Diagnostic> list;
        if (this.isValidationDisabled()) {
            return;
        }
        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticMessageContext(triple);
        DiagnosticMessage message = this.linkingDiagnosticMessageProvider.getIllegalNodeMessage(context, ex);
        if (message != null && !(list = this.getDiagnosticList(message)).contains(diagnostic = this.createDiagnostic(triple, message))) {
            list.add(diagnostic);
        }
    }

    protected void removeDiagnostic(Triple<EObject, EReference, INode> triple) {
        if (this.getErrors().isEmpty() && this.getWarnings().isEmpty()) {
            return;
        }
        DiagnosticMessage message = this.createDiagnosticMessage(triple);
        List<Resource.Diagnostic> list = this.getDiagnosticList(message);
        if (!list.isEmpty()) {
            Resource.Diagnostic diagnostic = this.createDiagnostic(triple, message);
            list.remove(diagnostic);
        }
    }

    protected Resource.Diagnostic createDiagnostic(Triple<EObject, EReference, INode> triple, DiagnosticMessage message) {
        XtextLinkingDiagnostic diagnostic = new XtextLinkingDiagnostic((INode)triple.getThird(), message.getMessage(), message.getIssueCode(), message.getIssueData());
        return diagnostic;
    }

    protected List<Resource.Diagnostic> getDiagnosticList(DiagnosticMessage message) throws AssertionError {
        if (message != null) {
            switch (message.getSeverity()) {
                case ERROR: {
                    return this.getErrors();
                }
                case WARNING: {
                    return this.getWarnings();
                }
            }
            throw new AssertionError((Object)("Unexpected severity: " + (Object)((Object)message.getSeverity())));
        }
        return Collections.emptyList();
    }

    protected DiagnosticMessage createDiagnosticMessage(Triple<EObject, EReference, INode> triple) {
        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticMessageContext(triple);
        DiagnosticMessage message = this.diagnosticMessageProvider.getUnresolvedProxyMessage(context);
        return message;
    }

    protected ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext createDiagnosticMessageContext(Triple<EObject, EReference, INode> triple) {
        return new DiagnosticMessageContext(triple, this.linkingHelper);
    }

    public void setLinkingService(ILinkingService linkingService) {
        this.linkingService = linkingService;
    }

    public ILinkingService getLinkingService() {
        return this.linkingService;
    }

    public void setEncoder(LazyURIEncoder encoder) {
        this.encoder = encoder;
    }

    public LazyURIEncoder getEncoder() {
        return this.encoder;
    }

    public void setEagerLinking(boolean eagerLinking) {
        this.eagerLinking = eagerLinking;
    }

    public boolean isEagerLinking() {
        return this.eagerLinking;
    }

    public ILinkingDiagnosticMessageProvider getDiagnosticMessageProvider() {
        return this.diagnosticMessageProvider;
    }

    public void setDiagnosticMessageProvider(ILinkingDiagnosticMessageProvider diagnosticMessageProvider) {
        this.diagnosticMessageProvider = diagnosticMessageProvider;
    }

    public LinkingHelper getLinkingHelper() {
        return this.linkingHelper;
    }

    public void setLinkingHelper(LinkingHelper linkingHelper) {
        this.linkingHelper = linkingHelper;
    }

    public void markUnresolvable(EObject referenced) {
        if (!referenced.eIsProxy()) {
            throw new IllegalArgumentException("Cannot mark an instance as unresolvable if it is already resolved");
        }
        URI proxyURI = ((InternalEObject)referenced).eProxyURI();
        this.getUnresolvableURIFragments().add(proxyURI.fragment());
    }

    protected Set<String> getUnresolvableURIFragments() {
        Set unresolveableProxies = (Set)this.getCache().get((Object)UNRESOLVEABLE_PROXIES_KEY, (Resource)this, (Provider)new Provider<Set<String>>(){

            public Set<String> get() {
                return Sets.newHashSet();
            }
        });
        return unresolveableProxies;
    }

    public int addLazyProxyInformation(EObject obj, EReference ref, INode node) {
        int index = this.proxyInformation.size();
        this.proxyInformation.add((Triple<EObject, EReference, INode>)Tuples.create((Object)obj, (Object)ref, (Object)node));
        return index;
    }

    public boolean hasLazyProxyInformation(int idx) {
        return this.proxyInformation.get(idx) != null;
    }

    public Triple<EObject, EReference, INode> getLazyProxyInformation(int idx) {
        if (!this.hasLazyProxyInformation(idx)) {
            throw new IllegalArgumentException("No proxy information for index '" + idx + "' available.");
        }
        return this.proxyInformation.get(idx);
    }

    public Triple<EObject, EReference, INode> removeLazyProxyInformation(int idx) {
        return this.proxyInformation.set(idx, null);
    }

    public void clearLazyProxyInformation() {
        this.proxyInformation = Lists.newArrayListWithCapacity((int)this.proxyInformation.size());
    }

    protected static class DiagnosticMessageContext
    implements ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext {
        private final Triple<EObject, EReference, INode> triple;
        private final LinkingHelper linkingHelper;

        protected DiagnosticMessageContext(Triple<EObject, EReference, INode> triple, LinkingHelper helper) {
            this.triple = triple;
            this.linkingHelper = helper;
        }

        @Override
        public EObject getContext() {
            return (EObject)this.triple.getFirst();
        }

        @Override
        public EReference getReference() {
            return (EReference)this.triple.getSecond();
        }

        @Override
        public String getLinkText() {
            return this.linkingHelper.getCrossRefNodeAsString((INode)this.triple.getThird(), true);
        }
    }

    public static final class CyclicLinkingException
    extends AssertionError {
        private Triple<EObject, EReference, INode> triple;

        private CyclicLinkingException(Object detailMessage, Triple<EObject, EReference, INode> triple) {
            super(detailMessage);
            this.triple = triple;
        }
    }
}

