/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.refactoring;

import com.google.inject.Inject;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.scoping.N4JSScopeProvider;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.util.TypeModelUtils;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;

public class N4JSRenameElementProcessor
extends RenameElementProcessor {
    @Inject
    private N4JSScopeProvider scopeProvider;
    @Inject
    private ContainerTypesHelper containerTypesHelper;

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.getTargetElement() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)"Rename an element of external library is not allowed.");
        }
        return super.checkInitialConditions(pm);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(super.checkFinalConditions(monitor, context));
        if (status.hasFatalError()) {
            return status;
        }
        String newName = this.getNewName();
        EObject targetElement = this.getTargetElement();
        List realTargetElements = TypeModelUtils.getRealElements((EObject)targetElement);
        realTargetElements.stream().forEach(realTargetElement -> status.merge(this.checkDuplicateName((EObject)realTargetElement, newName)));
        return status;
    }

    private RefactoringStatus checkDuplicateName(EObject context, String newName) {
        RefactoringStatus status = new RefactoringStatus();
        if (context instanceof TMember) {
            TMember member = (TMember)context;
            status.merge(this.checkDuplicateMember(member, newName));
        }
        if (status.hasError()) {
            return status;
        }
        if (context instanceof TEnumLiteral) {
            TEnumLiteral enumLit = (TEnumLiteral)context;
            status.merge(this.checkDuplicateEnum((TEnum)enumLit.eContainer(), newName));
        }
        if (status.hasError()) {
            return status;
        }
        if (context instanceof FormalParameter) {
            FormalParameter fpar = (FormalParameter)context;
            FunctionDefinition method = (FunctionDefinition)fpar.eContainer();
            status.merge(this.checkDuplicateFormalParam(fpar, (List<FormalParameter>)method.getFpars(), newName));
        }
        if (status.hasError()) {
            return status;
        }
        EObject astContext = null;
        astContext = context instanceof SyntaxRelatedTElement ? ((SyntaxRelatedTElement)context).getAstElement() : context;
        IScope scope = this.scopeProvider.getScopeForContentAssist(astContext, N4JSPackage.Literals.IDENTIFIER_REF__ID);
        for (IEObjectDescription desc : scope.getAllElements()) {
            if (!desc.getName().toString().equals(newName)) continue;
            status.merge(RefactoringStatus.createFatalErrorStatus((String)("Problem in " + this.trimPlatformPart(desc.getEObjectURI().trimFragment().toString()) + ": Another element in the same scope with name '" + newName + "' already exists")));
            if (!status.hasError()) continue;
            return status;
        }
        return status;
    }

    private RefactoringStatus checkDuplicateEnum(TEnum enumeration, String newName) {
        boolean duplicateFound;
        boolean bl = duplicateFound = enumeration.getLiterals().stream().filter(literal -> literal.getName().equals(newName)).collect(Collectors.toList()).size() > 0;
        if (duplicateFound) {
            return RefactoringStatus.createFatalErrorStatus((String)("Problem in " + this.trimPlatformPart(enumeration.eResource().getURI().toString()) + ": Another enum literal with name '" + newName + "' already exists."));
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkDuplicateFormalParam(FormalParameter fpar, List<FormalParameter> fpars, String newName) {
        List fparsWithName = fpars.stream().filter(fp -> fp != fpar && fp.getName().equals(newName)).collect(Collectors.toList());
        if (fparsWithName.size() > 0) {
            return RefactoringStatus.createFatalErrorStatus((String)("Problem in " + this.trimPlatformPart(fpar.eResource().getURI().toString()) + ": Another formal parameter with name '" + newName + "' already exists."));
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkDuplicateMember(TMember member, String newName) {
        ContainerTypesHelper.MemberCollector memberCollector;
        List membersWithName;
        ContainerType container = member.getContainingType();
        if (container != null && (membersWithName = (memberCollector = this.containerTypesHelper.fromContext((EObject)container)).members(container).stream().filter(m -> m != member && m.getName().equals(newName)).collect(Collectors.toList())).size() > 0) {
            return RefactoringStatus.createFatalErrorStatus((String)("Problem in " + this.trimPlatformPart(member.eResource().getURI().toString()) + ": Another member with name '" + newName + "' already exists"));
        }
        return new RefactoringStatus();
    }

    private String trimPlatformPart(String URI2) {
        String result = URI2.replaceFirst(Pattern.quote("platform:/resource/"), "");
        return result;
    }
}

