/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.packagejson;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonContentProvider;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class PackageJsonBuilder {
    private String projectName;
    private ProjectType type = ProjectType.VALIDATION;
    private String version;
    private SortedMap<String, String> dependencies;
    private String vendorId;
    private String vendorName;
    private String output;
    private Collection<String> providedRLs = CollectionLiterals.newArrayList();
    private Collection<String> requiredRLs = CollectionLiterals.newArrayList();
    private Collection<String> testedProjects;
    private String extendedRE;
    private Collection<String> implementedProjects;
    private String implementationId;
    private Map<SourceContainerType, String> sourceContainers;

    public static PackageJsonBuilder newBuilder() {
        return new PackageJsonBuilder();
    }

    private PackageJsonBuilder() {
        TreeMap<String, String> _treeMap = new TreeMap<String, String>();
        this.dependencies = _treeMap;
        this.implementedProjects = CollectionLiterals.newArrayList();
        this.testedProjects = CollectionLiterals.newArrayList();
        this.sourceContainers = CollectionLiterals.newHashMap();
    }

    public String build() {
        JSONDocument document = this.buildModel();
        return JSONModelUtils.serializeJSON((JSONDocument)document);
    }

    public JSONDocument buildModel() {
        return PackageJsonContentProvider.getModel((String)Preconditions.checkNotNull((Object)this.projectName), (Optional<String>)Optional.fromNullable((Object)this.version), (ProjectType)Preconditions.checkNotNull((Object)this.type), (Optional<String>)Optional.fromNullable((Object)this.vendorId), (Optional<String>)Optional.fromNullable((Object)this.vendorName), (Optional<String>)Optional.fromNullable((Object)this.output), (Optional<String>)Optional.fromNullable((Object)this.extendedRE), this.dependencies, this.providedRLs, this.requiredRLs, (Optional<String>)Optional.fromNullable((Object)this.implementationId), this.implementedProjects, this.testedProjects, this.sourceContainers);
    }

    public PackageJsonBuilder withName(String name) {
        this.projectName = (String)Preconditions.checkNotNull((Object)name);
        return this;
    }

    public PackageJsonBuilder withVersion(String version) {
        this.version = (String)Preconditions.checkNotNull((Object)version);
        return this;
    }

    public PackageJsonBuilder withType(ProjectType type) {
        this.type = (ProjectType)Preconditions.checkNotNull((Object)type);
        return this;
    }

    public PackageJsonBuilder withVendorId(String vendorId) {
        this.vendorId = vendorId;
        return this;
    }

    public PackageJsonBuilder withVendorName(String vendorName) {
        this.vendorName = vendorName;
        return this;
    }

    public PackageJsonBuilder withOutput(String output) {
        this.output = output;
        return this;
    }

    public PackageJsonBuilder withSourceContainer(SourceContainerType type, String path) {
        this.sourceContainers.put((SourceContainerType)Preconditions.checkNotNull((Object)type), (String)Preconditions.checkNotNull((Object)path));
        return this;
    }

    public PackageJsonBuilder withExtendedRE(String extendedRE) {
        this.extendedRE = extendedRE;
        return this;
    }

    public PackageJsonBuilder withProvidedRL(String providedRL) {
        this.providedRLs.add((String)Preconditions.checkNotNull((Object)providedRL));
        return this;
    }

    public PackageJsonBuilder withRequiredRL(String requiredRL) {
        this.requiredRLs.add((String)Preconditions.checkNotNull((Object)requiredRL));
        this.dependencies.put(requiredRL, "*");
        return this;
    }

    public PackageJsonBuilder withRequiredRL(String requiredRL, String versionConstraint) {
        this.requiredRLs.add((String)Preconditions.checkNotNull((Object)requiredRL));
        this.dependencies.put(requiredRL, versionConstraint);
        return this;
    }

    public PackageJsonBuilder withDependency(String projectDependency) {
        this.dependencies.put((String)Preconditions.checkNotNull((Object)projectDependency), "*");
        return this;
    }

    public PackageJsonBuilder withDependency(String projectDependency, String versionConstraint) {
        this.dependencies.put((String)Preconditions.checkNotNull((Object)projectDependency), (String)Preconditions.checkNotNull((Object)versionConstraint));
        return this;
    }

    public PackageJsonBuilder withTestedProject(String testedProject) {
        this.dependencies.put((String)Preconditions.checkNotNull((Object)testedProject), "*");
        this.testedProjects.add((String)Preconditions.checkNotNull((Object)testedProject));
        return this;
    }

    public PackageJsonBuilder withTestedProject(String testedProject, String version) {
        this.dependencies.put((String)Preconditions.checkNotNull((Object)testedProject), "*");
        this.testedProjects.add((String)Preconditions.checkNotNull((Object)testedProject));
        return this;
    }

    public PackageJsonBuilder withImplementationId(String implementationId) {
        this.implementationId = (String)Preconditions.checkNotNull((Object)implementationId);
        return this;
    }

    public PackageJsonBuilder withImplementedProject(String implementationAPI) {
        this.implementedProjects.add((String)Preconditions.checkNotNull((Object)implementationAPI));
        return this;
    }

    public String toString() {
        String _build = this.build();
        return "!!! This is just a preview of the N4JS package.json file !!!\n" + _build;
    }
}

