/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.tests.util.EclipseGracefulUIShutdownEnabler;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilder;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilderHelper;
import org.eclipse.n4js.xpect.ui.methods.contentassist.RegionWithCursor;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class HyperlinkXpectMethod {
    @Inject
    private IHyperlinkDetector hyperlinkDetector;
    @Inject
    private N4ContentAssistProcessorTestBuilderHelper n4ContentAssistProcessorTestBuilderHelper;

    static {
        EclipseGracefulUIShutdownEnabler.enableOnce();
    }

    @ParameterParser(syntax="('at' arg2=STRING)?")
    @Xpect
    public void hyperlinks(@CommaSeparatedValuesExpectation ICommaSeparatedValuesExpectation expectation, @ThisResource XtextResource resource, RegionWithCursor region) throws Exception {
        N4ContentAssistProcessorTestBuilder fixture = this.n4ContentAssistProcessorTestBuilderHelper.createTestBuilderForResource(resource);
        String currentModelToParse = resource.getParseResult().getRootNode().getText();
        IXtextDocument xtextDocument = fixture.getDocument(resource, currentModelToParse);
        ResourceSet resSet = resource.getResourceSet();
        for (Resource currRes : new ArrayList(resSet.getResources())) {
            N4JSResource.postProcess((Resource)currRes);
        }
        ITextViewer sourceViewer = fixture.getSourceViewer(currentModelToParse, xtextDocument);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(sourceViewer, (IRegion)new Region(region.getGlobalCursorOffset(), 0), true);
        ArrayList result = Lists.newArrayList();
        if (hyperlinks != null) {
            IHyperlink[] iHyperlinkArray = hyperlinks;
            int n = hyperlinks.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlink hyperlink = iHyperlinkArray[n2];
                result.add(this.getTargetDescription(resource, hyperlink));
                ++n2;
            }
        }
        expectation.assertEquals((Iterable)result);
    }

    private String getTargetDescription(XtextResource resource, IHyperlink hyperlink) {
        StringBuffer sb = new StringBuffer();
        String hyperlinkText = hyperlink.getHyperlinkText();
        hyperlinkText = hyperlinkText.substring(hyperlinkText.lastIndexOf(46) + 1);
        EObject target = this.getTarget(resource, hyperlink);
        if (target != null) {
            String fname;
            if (hyperlinkText != null) {
                sb.append(hyperlinkText);
            } else {
                sb.append("<no hyperlink text>");
            }
            sb.append(": ");
            int startLen = sb.length();
            EObject currTarget = target;
            while (currTarget != null) {
                if (currTarget instanceof NamedElement || currTarget instanceof IdentifiableElement) {
                    if (sb.length() > startLen) {
                        sb.append(" in ");
                    }
                    String name = currTarget instanceof NamedElement ? ((NamedElement)currTarget).getName() : ((IdentifiableElement)currTarget).getName();
                    name = name == null || name.trim().length() == 0 ? "<unnamed>" : "\"" + name + "\"";
                    sb.append(String.valueOf(name) + "(" + currTarget.eClass().getName() + ")");
                }
                currTarget = currTarget.eContainer();
            }
            URI targetResURI = target.eResource() != null ? target.eResource().getURI() : null;
            String string = fname = targetResURI != null ? targetResURI.lastSegment() : null;
            if (fname != null && fname.trim().length() > 0) {
                sb.append(" in file ");
                sb.append(fname);
            }
        } else {
            URI uri = this.getURI(hyperlink);
            if (uri != null) {
                if (uri.isFile()) {
                    sb.append("file:/...");
                    int i = Math.max(0, uri.segmentCount() - 2);
                    while (i < uri.segmentCount()) {
                        sb.append("/");
                        sb.append(uri.segment(i));
                        ++i;
                    }
                } else {
                    sb.append(uri);
                }
            }
        }
        return sb.toString();
    }

    private EObject getTarget(XtextResource resource, IHyperlink hyperlink) {
        EObject target;
        ResourceSet resourceSet = resource != null ? resource.getResourceSet() : null;
        URI uri = this.getURI(hyperlink);
        EObject eObject = target = resourceSet != null && uri != null && uri.fragment() != null ? resourceSet.getEObject(uri, true) : null;
        if (target instanceof SyntaxRelatedTElement) {
            return ((SyntaxRelatedTElement)target).getAstElement();
        }
        return target;
    }

    private URI getURI(IHyperlink hyperlink) {
        URI uri = hyperlink instanceof XtextHyperlink ? ((XtextHyperlink)hyperlink).getURI() : null;
        return uri;
    }
}

