/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
parser grammar InternalN4JSParser;

options {
	tokenVocab=InternalN4JSLexer;
	superClass=AbstractInternalContentAssistParser;
	backtrack=true;
}

@header {
package org.eclipse.n4js.ui.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.n4js.services.N4JSGrammarAccess;

}
@members {
	private N4JSGrammarAccess grammarAccess;
	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
	
	{
		tokenNameToValue.put("ExclamationMark", "'!'");
		tokenNameToValue.put("PercentSign", "'\%'");
		tokenNameToValue.put("Ampersand", "'&'");
		tokenNameToValue.put("LeftParenthesis", "'('");
		tokenNameToValue.put("RightParenthesis", "')'");
		tokenNameToValue.put("Asterisk", "'*'");
		tokenNameToValue.put("PlusSign", "'+'");
		tokenNameToValue.put("Comma", "','");
		tokenNameToValue.put("HyphenMinus", "'-'");
		tokenNameToValue.put("FullStop", "'.'");
		tokenNameToValue.put("Solidus", "'/'");
		tokenNameToValue.put("Colon", "':'");
		tokenNameToValue.put("Semicolon", "';'");
		tokenNameToValue.put("LessThanSign", "'<'");
		tokenNameToValue.put("EqualsSign", "'='");
		tokenNameToValue.put("GreaterThanSign", "'>'");
		tokenNameToValue.put("QuestionMark", "'?'");
		tokenNameToValue.put("CommercialAt", "'@'");
		tokenNameToValue.put("LeftSquareBracket", "'['");
		tokenNameToValue.put("RightSquareBracket", "']'");
		tokenNameToValue.put("CircumflexAccent", "'^'");
		tokenNameToValue.put("LeftCurlyBracket", "'{'");
		tokenNameToValue.put("VerticalLine", "'|'");
		tokenNameToValue.put("RightCurlyBracket", "'}'");
		tokenNameToValue.put("Tilde", "'~'");
		tokenNameToValue.put("ExclamationMarkEqualsSign", "'!='");
		tokenNameToValue.put("PercentSignEqualsSign", "'\%='");
		tokenNameToValue.put("AmpersandAmpersand", "'&&'");
		tokenNameToValue.put("AmpersandEqualsSign", "'&='");
		tokenNameToValue.put("AsteriskEqualsSign", "'*='");
		tokenNameToValue.put("PlusSignPlusSign", "'++'");
		tokenNameToValue.put("PlusSignEqualsSign", "'+='");
		tokenNameToValue.put("HyphenMinusHyphenMinus", "'--'");
		tokenNameToValue.put("HyphenMinusEqualsSign", "'-='");
		tokenNameToValue.put("SolidusEqualsSign", "'/='");
		tokenNameToValue.put("LessThanSignLessThanSign", "'<<'");
		tokenNameToValue.put("LessThanSignEqualsSign", "'<='");
		tokenNameToValue.put("EqualsSignEqualsSign", "'=='");
		tokenNameToValue.put("EqualsSignGreaterThanSign", "'=>'");
		tokenNameToValue.put("CommercialAtCommercialAt", "'@@'");
		tokenNameToValue.put("CircumflexAccentEqualsSign", "'^='");
		tokenNameToValue.put("As", "'as'");
		tokenNameToValue.put("Do", "'do'");
		tokenNameToValue.put("If", "'if'");
		tokenNameToValue.put("In", "'in'");
		tokenNameToValue.put("Of", "'of'");
		tokenNameToValue.put("VerticalLineEqualsSign", "'|='");
		tokenNameToValue.put("VerticalLineVerticalLine", "'||'");
		tokenNameToValue.put("ExclamationMarkEqualsSignEqualsSign", "'!=='");
		tokenNameToValue.put("FullStopFullStopFullStop", "'...'");
		tokenNameToValue.put("LessThanSignLessThanSignEqualsSign", "'<<='");
		tokenNameToValue.put("EqualsSignEqualsSignEqualsSign", "'==='");
		tokenNameToValue.put("For", "'for'");
		tokenNameToValue.put("Get", "'get'");
		tokenNameToValue.put("Let", "'let'");
		tokenNameToValue.put("New", "'new'");
		tokenNameToValue.put("Out", "'out'");
		tokenNameToValue.put("Set", "'set'");
		tokenNameToValue.put("Try", "'try'");
		tokenNameToValue.put("Var", "'var'");
		tokenNameToValue.put("This", "'This'");
		tokenNameToValue.put("Case", "'case'");
		tokenNameToValue.put("Else", "'else'");
		tokenNameToValue.put("Enum", "'enum'");
		tokenNameToValue.put("From", "'from'");
		tokenNameToValue.put("Null", "'null'");
		tokenNameToValue.put("This_1", "'this'");
		tokenNameToValue.put("True", "'true'");
		tokenNameToValue.put("Type", "'type'");
		tokenNameToValue.put("Void", "'void'");
		tokenNameToValue.put("With", "'with'");
		tokenNameToValue.put("Async", "'async'");
		tokenNameToValue.put("Await", "'await'");
		tokenNameToValue.put("Break", "'break'");
		tokenNameToValue.put("Catch", "'catch'");
		tokenNameToValue.put("Class", "'class'");
		tokenNameToValue.put("Const", "'const'");
		tokenNameToValue.put("False", "'false'");
		tokenNameToValue.put("Super", "'super'");
		tokenNameToValue.put("Throw", "'throw'");
		tokenNameToValue.put("Union", "'union'");
		tokenNameToValue.put("While", "'while'");
		tokenNameToValue.put("Yield", "'yield'");
		tokenNameToValue.put("Delete", "'delete'");
		tokenNameToValue.put("Export", "'export'");
		tokenNameToValue.put("Import", "'import'");
		tokenNameToValue.put("Public", "'public'");
		tokenNameToValue.put("Return", "'return'");
		tokenNameToValue.put("Static", "'static'");
		tokenNameToValue.put("Switch", "'switch'");
		tokenNameToValue.put("Target", "'target'");
		tokenNameToValue.put("Typeof", "'typeof'");
		tokenNameToValue.put("Default", "'default'");
		tokenNameToValue.put("Extends", "'extends'");
		tokenNameToValue.put("Finally", "'finally'");
		tokenNameToValue.put("Private", "'private'");
		tokenNameToValue.put("Project", "'project'");
		tokenNameToValue.put("Abstract", "'abstract'");
		tokenNameToValue.put("Continue", "'continue'");
		tokenNameToValue.put("Debugger", "'debugger'");
		tokenNameToValue.put("External", "'external'");
		tokenNameToValue.put("Function", "'function'");
		tokenNameToValue.put("Promisify", "'Promisify'");
		tokenNameToValue.put("Interface", "'interface'");
		tokenNameToValue.put("Protected", "'protected'");
		tokenNameToValue.put("Implements", "'implements'");
		tokenNameToValue.put("Instanceof", "'instanceof'");
		tokenNameToValue.put("Constructor", "'constructor'");
		tokenNameToValue.put("Intersection", "'intersection'");
	}

	public void setGrammarAccess(N4JSGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		String result = tokenNameToValue.get(tokenName);
		if (result == null)
			result = tokenName;
		return result;
	}
}

// Entry rule entryRuleScript
entryRuleScript
:
{ before(grammarAccess.getScriptRule()); }
	 ruleScript
{ after(grammarAccess.getScriptRule()); } 
	 EOF 
;

// Rule Script
ruleScript 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getScriptAccess().getGroup()); }
		(rule__Script__Group__0)
		{ after(grammarAccess.getScriptAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleScriptElement
entryRuleScriptElement
:
{ before(grammarAccess.getScriptElementRule()); }
	 ruleScriptElement
{ after(grammarAccess.getScriptElementRule()); } 
	 EOF 
;

// Rule ScriptElement
ruleScriptElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getScriptElementAccess().getAlternatives()); }
		(rule__ScriptElement__Alternatives)
		{ after(grammarAccess.getScriptElementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotatedScriptElement
entryRuleAnnotatedScriptElement
:
{ before(grammarAccess.getAnnotatedScriptElementRule()); }
	 ruleAnnotatedScriptElement
{ after(grammarAccess.getAnnotatedScriptElementRule()); } 
	 EOF 
;

// Rule AnnotatedScriptElement
ruleAnnotatedScriptElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup()); }
		(rule__AnnotatedScriptElement__Group__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExportDeclaration
entryRuleExportDeclaration
:
{ before(grammarAccess.getExportDeclarationRule()); }
	 ruleExportDeclaration
{ after(grammarAccess.getExportDeclarationRule()); } 
	 EOF 
;

// Rule ExportDeclaration
ruleExportDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportDeclarationAccess().getGroup()); }
		(rule__ExportDeclaration__Group__0)
		{ after(grammarAccess.getExportDeclarationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExportDeclarationImpl
ruleExportDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportDeclarationImplAccess().getGroup()); }
		(rule__ExportDeclarationImpl__Group__0)
		{ after(grammarAccess.getExportDeclarationImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExportFromClause
ruleExportFromClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportFromClauseAccess().getGroup()); }
		(rule__ExportFromClause__Group__0)
		{ after(grammarAccess.getExportFromClauseAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExportClause
ruleExportClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportClauseAccess().getGroup()); }
		(rule__ExportClause__Group__0)
		{ after(grammarAccess.getExportClauseAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExportSpecifier
entryRuleExportSpecifier
:
{ before(grammarAccess.getExportSpecifierRule()); }
	 ruleExportSpecifier
{ after(grammarAccess.getExportSpecifierRule()); } 
	 EOF 
;

// Rule ExportSpecifier
ruleExportSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportSpecifierAccess().getGroup()); }
		(rule__ExportSpecifier__Group__0)
		{ after(grammarAccess.getExportSpecifierAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExportableElement
entryRuleExportableElement
:
{ before(grammarAccess.getExportableElementRule()); }
	 ruleExportableElement
{ after(grammarAccess.getExportableElementRule()); } 
	 EOF 
;

// Rule ExportableElement
ruleExportableElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportableElementAccess().getAlternatives()); }
		(rule__ExportableElement__Alternatives)
		{ after(grammarAccess.getExportableElementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotatedExportableElement
entryRuleAnnotatedExportableElement
:
{ before(grammarAccess.getAnnotatedExportableElementRule()); }
	 ruleAnnotatedExportableElement
{ after(grammarAccess.getAnnotatedExportableElementRule()); } 
	 EOF 
;

// Rule AnnotatedExportableElement
ruleAnnotatedExportableElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup(), 0
		); }
		(rule__AnnotatedExportableElement__Group__0)
		{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleImportDeclaration
entryRuleImportDeclaration
:
{ before(grammarAccess.getImportDeclarationRule()); }
	 ruleImportDeclaration
{ after(grammarAccess.getImportDeclarationRule()); } 
	 EOF 
;

// Rule ImportDeclaration
ruleImportDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getImportDeclarationAccess().getGroup()); }
		(rule__ImportDeclaration__Group__0)
		{ after(grammarAccess.getImportDeclarationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ImportDeclarationImpl
ruleImportDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getImportDeclarationImplAccess().getGroup()); }
		(rule__ImportDeclarationImpl__Group__0)
		{ after(grammarAccess.getImportDeclarationImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ImportClause
ruleImportClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getImportClauseAccess().getAlternatives()); }
		(rule__ImportClause__Alternatives)
		{ after(grammarAccess.getImportClauseAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ImportSpecifiersExceptDefault
ruleImportSpecifiersExceptDefault 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getAlternatives()); }
		(rule__ImportSpecifiersExceptDefault__Alternatives)
		{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNamedImportSpecifier
entryRuleNamedImportSpecifier
:
{ before(grammarAccess.getNamedImportSpecifierRule()); }
	 ruleNamedImportSpecifier
{ after(grammarAccess.getNamedImportSpecifierRule()); } 
	 EOF 
;

// Rule NamedImportSpecifier
ruleNamedImportSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNamedImportSpecifierAccess().getAlternatives()); }
		(rule__NamedImportSpecifier__Alternatives)
		{ after(grammarAccess.getNamedImportSpecifierAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDefaultImportSpecifier
entryRuleDefaultImportSpecifier
:
{ before(grammarAccess.getDefaultImportSpecifierRule()); }
	 ruleDefaultImportSpecifier
{ after(grammarAccess.getDefaultImportSpecifierRule()); } 
	 EOF 
;

// Rule DefaultImportSpecifier
ruleDefaultImportSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDefaultImportSpecifierAccess().getImportedElementAssignment()); }
		(rule__DefaultImportSpecifier__ImportedElementAssignment)
		{ after(grammarAccess.getDefaultImportSpecifierAccess().getImportedElementAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNamespaceImportSpecifier
entryRuleNamespaceImportSpecifier
:
{ before(grammarAccess.getNamespaceImportSpecifierRule()); }
	 ruleNamespaceImportSpecifier
{ after(grammarAccess.getNamespaceImportSpecifierRule()); } 
	 EOF 
;

// Rule NamespaceImportSpecifier
ruleNamespaceImportSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNamespaceImportSpecifierAccess().getGroup()); }
		(rule__NamespaceImportSpecifier__Group__0)
		{ after(grammarAccess.getNamespaceImportSpecifierAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleModuleSpecifier
entryRuleModuleSpecifier
:
{ before(grammarAccess.getModuleSpecifierRule()); }
	 ruleModuleSpecifier
{ after(grammarAccess.getModuleSpecifierRule()); } 
	 EOF 
;

// Rule ModuleSpecifier
ruleModuleSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getModuleSpecifierAccess().getSTRINGTerminalRuleCall()); }
		RULE_STRING
		{ after(grammarAccess.getModuleSpecifierAccess().getSTRINGTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFunctionDeclaration
entryRuleFunctionDeclaration
:
{ before(grammarAccess.getFunctionDeclarationRule()); }
	 ruleFunctionDeclaration
{ after(grammarAccess.getFunctionDeclarationRule()); } 
	 EOF 
;

// Rule FunctionDeclaration
ruleFunctionDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionDeclarationAccess().getGroup(), 0
		); }
		(rule__FunctionDeclaration__Group__0)
		{ after(grammarAccess.getFunctionDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionDeclaration
norm1_FunctionDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionDeclarationAccess().getGroup(), 1
		); }
		(norm1_FunctionDeclaration__Group__0)
		{ after(grammarAccess.getFunctionDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AsyncNoTrailingLineBreak
ruleAsyncNoTrailingLineBreak 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAsyncNoTrailingLineBreakAccess().getGroup()); }
		(rule__AsyncNoTrailingLineBreak__Group__0)?
		{ after(grammarAccess.getAsyncNoTrailingLineBreakAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionImpl
ruleFunctionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup(), 0
		); }
		(rule__FunctionImpl__Group__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionImpl
norm3_FunctionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup(), 3
		); }
		(norm3_FunctionImpl__Group__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionImpl
norm6_FunctionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup(), 6
		); }
		(norm6_FunctionImpl__Group__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup(), 6
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionHeader
ruleFunctionHeader 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionHeaderAccess().getGroup(), 0
		); }
		(rule__FunctionHeader__Group__0)
		{ after(grammarAccess.getFunctionHeaderAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionHeader
norm1_FunctionHeader 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionHeaderAccess().getGroup(), 1
		); }
		(norm1_FunctionHeader__Group__0)
		{ after(grammarAccess.getFunctionHeaderAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionHeader
norm2_FunctionHeader 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionHeaderAccess().getGroup(), 2
		); }
		(norm2_FunctionHeader__Group__0)
		{ after(grammarAccess.getFunctionHeaderAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionHeader
norm3_FunctionHeader 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionHeaderAccess().getGroup(), 3
		); }
		(norm3_FunctionHeader__Group__0)
		{ after(grammarAccess.getFunctionHeaderAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionBody
ruleFunctionBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 0
		); }
		(rule__FunctionBody__BodyAssignment_1_0)?
		{ after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionBody
norm1_FunctionBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 1
		); }
		(norm1_FunctionBody__BodyAssignment_1_0)?
		{ after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionBody
norm2_FunctionBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 2
		); }
		(norm2_FunctionBody__BodyAssignment_0_0)
		{ after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FunctionBody
norm3_FunctionBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 3
		); }
		(norm3_FunctionBody__BodyAssignment_0_0)
		{ after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotatedFunctionDeclaration
entryRuleAnnotatedFunctionDeclaration
:
{ before(grammarAccess.getAnnotatedFunctionDeclarationRule()); }
	 ruleAnnotatedFunctionDeclaration
{ after(grammarAccess.getAnnotatedFunctionDeclarationRule()); } 
	 EOF 
;

// Rule AnnotatedFunctionDeclaration
ruleAnnotatedFunctionDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 0
		); }
		(rule__AnnotatedFunctionDeclaration__Group__0)
		{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AnnotatedFunctionDeclaration
norm1_AnnotatedFunctionDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 1
		); }
		(norm1_AnnotatedFunctionDeclaration__Group__0)
		{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFunctionExpression
entryRuleFunctionExpression
:
{ before(grammarAccess.getFunctionExpressionRule()); }
	 ruleFunctionExpression
{ after(grammarAccess.getFunctionExpressionRule()); } 
	 EOF 
;

// Rule FunctionExpression
ruleFunctionExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionExpressionAccess().getGroup()); }
		(rule__FunctionExpression__Group__0)
		{ after(grammarAccess.getFunctionExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAsyncFunctionExpression
entryRuleAsyncFunctionExpression
:
{ before(grammarAccess.getAsyncFunctionExpressionRule()); }
	 ruleAsyncFunctionExpression
{ after(grammarAccess.getAsyncFunctionExpressionRule()); } 
	 EOF 
;

// Rule AsyncFunctionExpression
ruleAsyncFunctionExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAsyncFunctionExpressionAccess().getGroup()); }
		(rule__AsyncFunctionExpression__Group__0)
		{ after(grammarAccess.getAsyncFunctionExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArrowExpression
entryRuleArrowExpression
:
{ before(grammarAccess.getArrowExpressionRule()); }
	 ruleArrowExpression
{ after(grammarAccess.getArrowExpressionRule()); } 
	 EOF 
;

// Rule ArrowExpression
ruleArrowExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup(), 0
		); }
		(rule__ArrowExpression__Group__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArrowExpression
norm1_ArrowExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup(), 1
		); }
		(norm1_ArrowExpression__Group__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArrowExpression
norm2_ArrowExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup(), 2
		); }
		(norm2_ArrowExpression__Group__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArrowExpression
norm3_ArrowExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup(), 3
		); }
		(norm3_ArrowExpression__Group__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule StrictFormalParameters
ruleStrictFormalParameters 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStrictFormalParametersAccess().getGroup(), 0
		); }
		(rule__StrictFormalParameters__Group__0)
		{ after(grammarAccess.getStrictFormalParametersAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule StrictFormalParameters
norm1_StrictFormalParameters 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStrictFormalParametersAccess().getGroup(), 1
		); }
		(norm1_StrictFormalParameters__Group__0)
		{ after(grammarAccess.getStrictFormalParametersAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBindingIdentifierAsFormalParameter
entryRuleBindingIdentifierAsFormalParameter
:
{ before(grammarAccess.getBindingIdentifierAsFormalParameterRule()); }
	 ruleBindingIdentifierAsFormalParameter
{ after(grammarAccess.getBindingIdentifierAsFormalParameterRule()); } 
	 EOF 
;

// Rule BindingIdentifierAsFormalParameter
ruleBindingIdentifierAsFormalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 0
		); }
		(rule__BindingIdentifierAsFormalParameter__NameAssignment)
		{ after(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingIdentifierAsFormalParameter
norm1_BindingIdentifierAsFormalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 1
		); }
		(norm1_BindingIdentifierAsFormalParameter__NameAssignment)
		{ after(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBlockMinusBraces
entryRuleBlockMinusBraces
:
{ before(grammarAccess.getBlockMinusBracesRule()); }
	 ruleBlockMinusBraces
{ after(grammarAccess.getBlockMinusBracesRule()); } 
	 EOF 
;

// Rule BlockMinusBraces
ruleBlockMinusBraces 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBlockMinusBracesAccess().getGroup(), 0
		); }
		(rule__BlockMinusBraces__Group__0)
		{ after(grammarAccess.getBlockMinusBracesAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BlockMinusBraces
norm1_BlockMinusBraces 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBlockMinusBracesAccess().getGroup(), 1
		); }
		(norm1_BlockMinusBraces__Group__0)
		{ after(grammarAccess.getBlockMinusBracesAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpressionDisguisedAsBlock
entryRuleExpressionDisguisedAsBlock
:
{ before(grammarAccess.getExpressionDisguisedAsBlockRule()); }
	 ruleExpressionDisguisedAsBlock
{ after(grammarAccess.getExpressionDisguisedAsBlockRule()); } 
	 EOF 
;

// Rule ExpressionDisguisedAsBlock
ruleExpressionDisguisedAsBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 0
		); }
		(rule__ExpressionDisguisedAsBlock__Group__0)
		{ after(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExpressionDisguisedAsBlock
norm1_ExpressionDisguisedAsBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 1
		); }
		(norm1_ExpressionDisguisedAsBlock__Group__0)
		{ after(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssignmentExpressionStatement
entryRuleAssignmentExpressionStatement
:
{ before(grammarAccess.getAssignmentExpressionStatementRule()); }
	 ruleAssignmentExpressionStatement
{ after(grammarAccess.getAssignmentExpressionStatementRule()); } 
	 EOF 
;

// Rule AssignmentExpressionStatement
ruleAssignmentExpressionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 0
		); }
		(rule__AssignmentExpressionStatement__ExpressionAssignment)
		{ after(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AssignmentExpressionStatement
norm1_AssignmentExpressionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 1
		); }
		(norm1_AssignmentExpressionStatement__ExpressionAssignment)
		{ after(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotatedExpression
entryRuleAnnotatedExpression
:
{ before(grammarAccess.getAnnotatedExpressionRule()); }
	 ruleAnnotatedExpression
{ after(grammarAccess.getAnnotatedExpressionRule()); } 
	 EOF 
;

// Rule AnnotatedExpression
ruleAnnotatedExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 0
		); }
		(rule__AnnotatedExpression__Group__0)
		{ after(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AnnotatedExpression
norm1_AnnotatedExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 1
		); }
		(norm1_AnnotatedExpression__Group__0)
		{ after(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeVariable
entryRuleTypeVariable
:
{ before(grammarAccess.getTypeVariableRule()); }
	 ruleTypeVariable
{ after(grammarAccess.getTypeVariableRule()); } 
	 EOF 
;

// Rule TypeVariable
ruleTypeVariable 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeVariableAccess().getGroup()); }
		(rule__TypeVariable__Group__0)
		{ after(grammarAccess.getTypeVariableAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFormalParameter
entryRuleFormalParameter
:
{ before(grammarAccess.getFormalParameterRule()); }
	 ruleFormalParameter
{ after(grammarAccess.getFormalParameterRule()); } 
	 EOF 
;

// Rule FormalParameter
ruleFormalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFormalParameterAccess().getGroup(), 0
		); }
		(rule__FormalParameter__Group__0)
		{ after(grammarAccess.getFormalParameterAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FormalParameter
norm1_FormalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFormalParameterAccess().getGroup(), 1
		); }
		(norm1_FormalParameter__Group__0)
		{ after(grammarAccess.getFormalParameterAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingElementFragment
ruleBindingElementFragment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingElementFragmentAccess().getGroup(), 0
		); }
		(rule__BindingElementFragment__Group__0)
		{ after(grammarAccess.getBindingElementFragmentAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingElementFragment
norm1_BindingElementFragment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingElementFragmentAccess().getGroup(), 1
		); }
		(norm1_BindingElementFragment__Group__0)
		{ after(grammarAccess.getBindingElementFragmentAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BogusTypeRefFragment
ruleBogusTypeRefFragment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBogusTypeRefFragmentAccess().getBogusTypeRefAssignment()); }
		(rule__BogusTypeRefFragment__BogusTypeRefAssignment)
		{ after(grammarAccess.getBogusTypeRefFragmentAccess().getBogusTypeRefAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBlock
entryRuleBlock
:
{ before(grammarAccess.getBlockRule()); }
	 ruleBlock
{ after(grammarAccess.getBlockRule()); } 
	 EOF 
;

// Rule Block
ruleBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBlockAccess().getGroup(), 0
		); }
		(rule__Block__Group__0)
		{ after(grammarAccess.getBlockAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Block
norm1_Block 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBlockAccess().getGroup(), 1
		); }
		(norm1_Block__Group__0)
		{ after(grammarAccess.getBlockAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRootStatement
entryRuleRootStatement
:
{ before(grammarAccess.getRootStatementRule()); }
	 ruleRootStatement
{ after(grammarAccess.getRootStatementRule()); } 
	 EOF 
;

// Rule RootStatement
ruleRootStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRootStatementAccess().getAlternatives(), 0
		); }
		(rule__RootStatement__Alternatives)
		{ after(grammarAccess.getRootStatementAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule RootStatement
norm1_RootStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRootStatementAccess().getAlternatives(), 1
		); }
		(norm1_RootStatement__Alternatives)
		{ after(grammarAccess.getRootStatementAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatement
entryRuleStatement
:
{ before(grammarAccess.getStatementRule()); }
	 ruleStatement
{ after(grammarAccess.getStatementRule()); } 
	 EOF 
;

// Rule Statement
ruleStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatementAccess().getAlternatives(), 0
		); }
		(rule__Statement__Alternatives)
		{ after(grammarAccess.getStatementAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Statement
norm1_Statement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatementAccess().getAlternatives(), 1
		); }
		(norm1_Statement__Alternatives)
		{ after(grammarAccess.getStatementAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableStatement
norm1_VariableStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableStatementAccess().getGroup(), 1
		); }
		(norm1_VariableStatement__Group__0)
		{ after(grammarAccess.getVariableStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableStatement
norm3_VariableStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableStatementAccess().getGroup(), 3
		); }
		(norm3_VariableStatement__Group__0)
		{ after(grammarAccess.getVariableStatementAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExportedVariableStatement
entryRuleExportedVariableStatement
:
{ before(grammarAccess.getExportedVariableStatementRule()); }
	 ruleExportedVariableStatement
{ after(grammarAccess.getExportedVariableStatementRule()); } 
	 EOF 
;

// Rule ExportedVariableStatement
ruleExportedVariableStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportedVariableStatementAccess().getGroup()); }
		(rule__ExportedVariableStatement__Group__0)
		{ after(grammarAccess.getExportedVariableStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariableDeclarationOrBinding
entryRuleVariableDeclarationOrBinding
:
{ before(grammarAccess.getVariableDeclarationOrBindingRule()); }
	 ruleVariableDeclarationOrBinding
{ after(grammarAccess.getVariableDeclarationOrBindingRule()); } 
	 EOF 
;

// Rule VariableDeclarationOrBinding
ruleVariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 0
		); }
		(rule__VariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationOrBinding
norm1_VariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 1
		); }
		(norm1_VariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationOrBinding
norm2_VariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 2
		); }
		(norm2_VariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationOrBinding
norm3_VariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 3
		); }
		(norm3_VariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationOrBinding
norm4_VariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 4
		); }
		(norm4_VariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 4
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationOrBinding
norm6_VariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 6
		); }
		(norm6_VariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 6
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariableBinding
entryRuleVariableBinding
:
{ before(grammarAccess.getVariableBindingRule()); }
	 ruleVariableBinding
{ after(grammarAccess.getVariableBindingRule()); } 
	 EOF 
;

// Rule VariableBinding
ruleVariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 0
		); }
		(rule__VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableBinding
norm1_VariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 1
		); }
		(norm1_VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableBinding
norm2_VariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 2
		); }
		(norm2_VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableBinding
norm3_VariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 3
		); }
		(norm3_VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableBinding
norm4_VariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 4
		); }
		(norm4_VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 4
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableBinding
norm5_VariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 5
		); }
		(norm5_VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 5
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableBinding
norm6_VariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 6
		); }
		(norm6_VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 6
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableBinding
norm7_VariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableBindingAccess().getGroup(), 7
		); }
		(norm7_VariableBinding__Group__0)
		{ after(grammarAccess.getVariableBindingAccess().getGroup(), 7
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclaration
norm1_VariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationAccess().getGroup(), 1
		); }
		(norm1_VariableDeclaration__Group__0)
		{ after(grammarAccess.getVariableDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclaration
norm3_VariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationAccess().getGroup(), 3
		); }
		(norm3_VariableDeclaration__Group__0)
		{ after(grammarAccess.getVariableDeclarationAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclaration
norm4_VariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationAccess().getGroup(), 4
		); }
		(norm4_VariableDeclaration__Group__0)
		{ after(grammarAccess.getVariableDeclarationAccess().getGroup(), 4
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclaration
norm5_VariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationAccess().getGroup(), 5
		); }
		(norm5_VariableDeclaration__Group__0)
		{ after(grammarAccess.getVariableDeclarationAccess().getGroup(), 5
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclaration
norm6_VariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationAccess().getGroup(), 6
		); }
		(norm6_VariableDeclaration__Group__0)
		{ after(grammarAccess.getVariableDeclarationAccess().getGroup(), 6
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclaration
norm7_VariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationAccess().getGroup(), 7
		); }
		(norm7_VariableDeclaration__Group__0)
		{ after(grammarAccess.getVariableDeclarationAccess().getGroup(), 7
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
ruleVariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 0
		); }
		(rule__VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
norm1_VariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 1
		); }
		(norm1_VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
norm2_VariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 2
		); }
		(norm2_VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
norm3_VariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 3
		); }
		(norm3_VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
norm4_VariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 4
		); }
		(norm4_VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 4
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
norm5_VariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 5
		); }
		(norm5_VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 5
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
norm6_VariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 6
		); }
		(norm6_VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 6
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VariableDeclarationImpl
norm7_VariableDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 7
		); }
		(norm7_VariableDeclarationImpl__Group__0)
		{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 7
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExportedVariableDeclarationOrBinding
entryRuleExportedVariableDeclarationOrBinding
:
{ before(grammarAccess.getExportedVariableDeclarationOrBindingRule()); }
	 ruleExportedVariableDeclarationOrBinding
{ after(grammarAccess.getExportedVariableDeclarationOrBindingRule()); } 
	 EOF 
;

// Rule ExportedVariableDeclarationOrBinding
ruleExportedVariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 0
		); }
		(rule__ExportedVariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExportedVariableDeclarationOrBinding
norm1_ExportedVariableDeclarationOrBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 1
		); }
		(norm1_ExportedVariableDeclarationOrBinding__Alternatives)
		{ after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExportedVariableBinding
entryRuleExportedVariableBinding
:
{ before(grammarAccess.getExportedVariableBindingRule()); }
	 ruleExportedVariableBinding
{ after(grammarAccess.getExportedVariableBindingRule()); } 
	 EOF 
;

// Rule ExportedVariableBinding
ruleExportedVariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportedVariableBindingAccess().getGroup(), 0
		); }
		(rule__ExportedVariableBinding__Group__0)
		{ after(grammarAccess.getExportedVariableBindingAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExportedVariableBinding
norm1_ExportedVariableBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportedVariableBindingAccess().getGroup(), 1
		); }
		(norm1_ExportedVariableBinding__Group__0)
		{ after(grammarAccess.getExportedVariableBindingAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExportedVariableDeclaration
entryRuleExportedVariableDeclaration
:
{ before(grammarAccess.getExportedVariableDeclarationRule()); }
	 ruleExportedVariableDeclaration
{ after(grammarAccess.getExportedVariableDeclarationRule()); } 
	 EOF 
;

// Rule ExportedVariableDeclaration
ruleExportedVariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 0
		); }
		(rule__ExportedVariableDeclaration__Group__0)
		{ after(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExportedVariableDeclaration
norm1_ExportedVariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 1
		); }
		(norm1_ExportedVariableDeclaration__Group__0)
		{ after(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEmptyStatement
entryRuleEmptyStatement
:
{ before(grammarAccess.getEmptyStatementRule()); }
	 ruleEmptyStatement
{ after(grammarAccess.getEmptyStatementRule()); } 
	 EOF 
;

// Rule EmptyStatement
ruleEmptyStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEmptyStatementAccess().getGroup()); }
		(rule__EmptyStatement__Group__0)
		{ after(grammarAccess.getEmptyStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpressionStatement
entryRuleExpressionStatement
:
{ before(grammarAccess.getExpressionStatementRule()); }
	 ruleExpressionStatement
{ after(grammarAccess.getExpressionStatementRule()); } 
	 EOF 
;

// Rule ExpressionStatement
ruleExpressionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionStatementAccess().getGroup(), 0
		); }
		(rule__ExpressionStatement__Group__0)
		{ after(grammarAccess.getExpressionStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ExpressionStatement
norm1_ExpressionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionStatementAccess().getGroup(), 1
		); }
		(norm1_ExpressionStatement__Group__0)
		{ after(grammarAccess.getExpressionStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIfStatement
entryRuleIfStatement
:
{ before(grammarAccess.getIfStatementRule()); }
	 ruleIfStatement
{ after(grammarAccess.getIfStatementRule()); } 
	 EOF 
;

// Rule IfStatement
ruleIfStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIfStatementAccess().getGroup(), 0
		); }
		(rule__IfStatement__Group__0)
		{ after(grammarAccess.getIfStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule IfStatement
norm1_IfStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIfStatementAccess().getGroup(), 1
		); }
		(norm1_IfStatement__Group__0)
		{ after(grammarAccess.getIfStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIterationStatement
entryRuleIterationStatement
:
{ before(grammarAccess.getIterationStatementRule()); }
	 ruleIterationStatement
{ after(grammarAccess.getIterationStatementRule()); } 
	 EOF 
;

// Rule IterationStatement
ruleIterationStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIterationStatementAccess().getAlternatives(), 0
		); }
		(rule__IterationStatement__Alternatives)
		{ after(grammarAccess.getIterationStatementAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule IterationStatement
norm1_IterationStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIterationStatementAccess().getAlternatives(), 1
		); }
		(norm1_IterationStatement__Alternatives)
		{ after(grammarAccess.getIterationStatementAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDoStatement
entryRuleDoStatement
:
{ before(grammarAccess.getDoStatementRule()); }
	 ruleDoStatement
{ after(grammarAccess.getDoStatementRule()); } 
	 EOF 
;

// Rule DoStatement
ruleDoStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDoStatementAccess().getGroup(), 0
		); }
		(rule__DoStatement__Group__0)
		{ after(grammarAccess.getDoStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule DoStatement
norm1_DoStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDoStatementAccess().getGroup(), 1
		); }
		(norm1_DoStatement__Group__0)
		{ after(grammarAccess.getDoStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleWhileStatement
entryRuleWhileStatement
:
{ before(grammarAccess.getWhileStatementRule()); }
	 ruleWhileStatement
{ after(grammarAccess.getWhileStatementRule()); } 
	 EOF 
;

// Rule WhileStatement
ruleWhileStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getWhileStatementAccess().getGroup(), 0
		); }
		(rule__WhileStatement__Group__0)
		{ after(grammarAccess.getWhileStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule WhileStatement
norm1_WhileStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getWhileStatementAccess().getGroup(), 1
		); }
		(norm1_WhileStatement__Group__0)
		{ after(grammarAccess.getWhileStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleForStatement
entryRuleForStatement
:
{ before(grammarAccess.getForStatementRule()); }
	 ruleForStatement
{ after(grammarAccess.getForStatementRule()); } 
	 EOF 
;

// Rule ForStatement
ruleForStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup(), 0
		); }
		(rule__ForStatement__Group__0)
		{ after(grammarAccess.getForStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ForStatement
norm1_ForStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup(), 1
		); }
		(norm1_ForStatement__Group__0)
		{ after(grammarAccess.getForStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLetIdentifierRef
entryRuleLetIdentifierRef
:
{ before(grammarAccess.getLetIdentifierRefRule()); }
	 ruleLetIdentifierRef
{ after(grammarAccess.getLetIdentifierRefRule()); } 
	 EOF 
;

// Rule LetIdentifierRef
ruleLetIdentifierRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLetIdentifierRefAccess().getIdAssignment()); }
		(rule__LetIdentifierRef__IdAssignment)
		{ after(grammarAccess.getLetIdentifierRefAccess().getIdAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLetAsIdentifier
entryRuleLetAsIdentifier
:
{ before(grammarAccess.getLetAsIdentifierRule()); }
	 ruleLetAsIdentifier
{ after(grammarAccess.getLetAsIdentifierRule()); } 
	 EOF 
;

// Rule LetAsIdentifier
ruleLetAsIdentifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLetAsIdentifierAccess().getLetKeyword()); }
		Let
		{ after(grammarAccess.getLetAsIdentifierAccess().getLetKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBindingIdentifierAsVariableDeclaration
entryRuleBindingIdentifierAsVariableDeclaration
:
{ before(grammarAccess.getBindingIdentifierAsVariableDeclarationRule()); }
	 ruleBindingIdentifierAsVariableDeclaration
{ after(grammarAccess.getBindingIdentifierAsVariableDeclarationRule()); } 
	 EOF 
;

// Rule BindingIdentifierAsVariableDeclaration
ruleBindingIdentifierAsVariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 0
		); }
		(rule__BindingIdentifierAsVariableDeclaration__NameAssignment)
		{ after(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingIdentifierAsVariableDeclaration
norm2_BindingIdentifierAsVariableDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 2
		); }
		(norm2_BindingIdentifierAsVariableDeclaration__NameAssignment)
		{ after(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleContinueStatement
entryRuleContinueStatement
:
{ before(grammarAccess.getContinueStatementRule()); }
	 ruleContinueStatement
{ after(grammarAccess.getContinueStatementRule()); } 
	 EOF 
;

// Rule ContinueStatement
ruleContinueStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getContinueStatementAccess().getGroup(), 0
		); }
		(rule__ContinueStatement__Group__0)
		{ after(grammarAccess.getContinueStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ContinueStatement
norm1_ContinueStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getContinueStatementAccess().getGroup(), 1
		); }
		(norm1_ContinueStatement__Group__0)
		{ after(grammarAccess.getContinueStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBreakStatement
entryRuleBreakStatement
:
{ before(grammarAccess.getBreakStatementRule()); }
	 ruleBreakStatement
{ after(grammarAccess.getBreakStatementRule()); } 
	 EOF 
;

// Rule BreakStatement
ruleBreakStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBreakStatementAccess().getGroup(), 0
		); }
		(rule__BreakStatement__Group__0)
		{ after(grammarAccess.getBreakStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BreakStatement
norm1_BreakStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBreakStatementAccess().getGroup(), 1
		); }
		(norm1_BreakStatement__Group__0)
		{ after(grammarAccess.getBreakStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReturnStatement
entryRuleReturnStatement
:
{ before(grammarAccess.getReturnStatementRule()); }
	 ruleReturnStatement
{ after(grammarAccess.getReturnStatementRule()); } 
	 EOF 
;

// Rule ReturnStatement
ruleReturnStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnStatementAccess().getGroup(), 0
		); }
		(rule__ReturnStatement__Group__0)
		{ after(grammarAccess.getReturnStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ReturnStatement
norm1_ReturnStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnStatementAccess().getGroup(), 1
		); }
		(norm1_ReturnStatement__Group__0)
		{ after(grammarAccess.getReturnStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleWithStatement
entryRuleWithStatement
:
{ before(grammarAccess.getWithStatementRule()); }
	 ruleWithStatement
{ after(grammarAccess.getWithStatementRule()); } 
	 EOF 
;

// Rule WithStatement
ruleWithStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getWithStatementAccess().getGroup(), 0
		); }
		(rule__WithStatement__Group__0)
		{ after(grammarAccess.getWithStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule WithStatement
norm1_WithStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getWithStatementAccess().getGroup(), 1
		); }
		(norm1_WithStatement__Group__0)
		{ after(grammarAccess.getWithStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSwitchStatement
entryRuleSwitchStatement
:
{ before(grammarAccess.getSwitchStatementRule()); }
	 ruleSwitchStatement
{ after(grammarAccess.getSwitchStatementRule()); } 
	 EOF 
;

// Rule SwitchStatement
ruleSwitchStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSwitchStatementAccess().getGroup(), 0
		); }
		(rule__SwitchStatement__Group__0)
		{ after(grammarAccess.getSwitchStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule SwitchStatement
norm1_SwitchStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSwitchStatementAccess().getGroup(), 1
		); }
		(norm1_SwitchStatement__Group__0)
		{ after(grammarAccess.getSwitchStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCaseClause
entryRuleCaseClause
:
{ before(grammarAccess.getCaseClauseRule()); }
	 ruleCaseClause
{ after(grammarAccess.getCaseClauseRule()); } 
	 EOF 
;

// Rule CaseClause
ruleCaseClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCaseClauseAccess().getGroup(), 0
		); }
		(rule__CaseClause__Group__0)
		{ after(grammarAccess.getCaseClauseAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule CaseClause
norm1_CaseClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCaseClauseAccess().getGroup(), 1
		); }
		(norm1_CaseClause__Group__0)
		{ after(grammarAccess.getCaseClauseAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDefaultClause
entryRuleDefaultClause
:
{ before(grammarAccess.getDefaultClauseRule()); }
	 ruleDefaultClause
{ after(grammarAccess.getDefaultClauseRule()); } 
	 EOF 
;

// Rule DefaultClause
ruleDefaultClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDefaultClauseAccess().getGroup(), 0
		); }
		(rule__DefaultClause__Group__0)
		{ after(grammarAccess.getDefaultClauseAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule DefaultClause
norm1_DefaultClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDefaultClauseAccess().getGroup(), 1
		); }
		(norm1_DefaultClause__Group__0)
		{ after(grammarAccess.getDefaultClauseAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLabelledStatement
entryRuleLabelledStatement
:
{ before(grammarAccess.getLabelledStatementRule()); }
	 ruleLabelledStatement
{ after(grammarAccess.getLabelledStatementRule()); } 
	 EOF 
;

// Rule LabelledStatement
ruleLabelledStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLabelledStatementAccess().getGroup(), 0
		); }
		(rule__LabelledStatement__Group__0)
		{ after(grammarAccess.getLabelledStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LabelledStatement
norm1_LabelledStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLabelledStatementAccess().getGroup(), 1
		); }
		(norm1_LabelledStatement__Group__0)
		{ after(grammarAccess.getLabelledStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleThrowStatement
entryRuleThrowStatement
:
{ before(grammarAccess.getThrowStatementRule()); }
	 ruleThrowStatement
{ after(grammarAccess.getThrowStatementRule()); } 
	 EOF 
;

// Rule ThrowStatement
ruleThrowStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getThrowStatementAccess().getGroup(), 0
		); }
		(rule__ThrowStatement__Group__0)
		{ after(grammarAccess.getThrowStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ThrowStatement
norm1_ThrowStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getThrowStatementAccess().getGroup(), 1
		); }
		(norm1_ThrowStatement__Group__0)
		{ after(grammarAccess.getThrowStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTryStatement
entryRuleTryStatement
:
{ before(grammarAccess.getTryStatementRule()); }
	 ruleTryStatement
{ after(grammarAccess.getTryStatementRule()); } 
	 EOF 
;

// Rule TryStatement
ruleTryStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTryStatementAccess().getGroup(), 0
		); }
		(rule__TryStatement__Group__0)
		{ after(grammarAccess.getTryStatementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule TryStatement
norm1_TryStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTryStatementAccess().getGroup(), 1
		); }
		(norm1_TryStatement__Group__0)
		{ after(grammarAccess.getTryStatementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCatchBlock
entryRuleCatchBlock
:
{ before(grammarAccess.getCatchBlockRule()); }
	 ruleCatchBlock
{ after(grammarAccess.getCatchBlockRule()); } 
	 EOF 
;

// Rule CatchBlock
ruleCatchBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCatchBlockAccess().getGroup(), 0
		); }
		(rule__CatchBlock__Group__0)
		{ after(grammarAccess.getCatchBlockAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule CatchBlock
norm1_CatchBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCatchBlockAccess().getGroup(), 1
		); }
		(norm1_CatchBlock__Group__0)
		{ after(grammarAccess.getCatchBlockAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCatchVariable
entryRuleCatchVariable
:
{ before(grammarAccess.getCatchVariableRule()); }
	 ruleCatchVariable
{ after(grammarAccess.getCatchVariableRule()); } 
	 EOF 
;

// Rule CatchVariable
ruleCatchVariable 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCatchVariableAccess().getAlternatives(), 0
		); }
		(rule__CatchVariable__Alternatives)
		{ after(grammarAccess.getCatchVariableAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule CatchVariable
norm1_CatchVariable 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCatchVariableAccess().getAlternatives(), 1
		); }
		(norm1_CatchVariable__Alternatives)
		{ after(grammarAccess.getCatchVariableAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFinallyBlock
entryRuleFinallyBlock
:
{ before(grammarAccess.getFinallyBlockRule()); }
	 ruleFinallyBlock
{ after(grammarAccess.getFinallyBlockRule()); } 
	 EOF 
;

// Rule FinallyBlock
ruleFinallyBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFinallyBlockAccess().getGroup(), 0
		); }
		(rule__FinallyBlock__Group__0)
		{ after(grammarAccess.getFinallyBlockAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FinallyBlock
norm1_FinallyBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFinallyBlockAccess().getGroup(), 1
		); }
		(norm1_FinallyBlock__Group__0)
		{ after(grammarAccess.getFinallyBlockAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDebuggerStatement
entryRuleDebuggerStatement
:
{ before(grammarAccess.getDebuggerStatementRule()); }
	 ruleDebuggerStatement
{ after(grammarAccess.getDebuggerStatementRule()); } 
	 EOF 
;

// Rule DebuggerStatement
ruleDebuggerStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDebuggerStatementAccess().getGroup()); }
		(rule__DebuggerStatement__Group__0)
		{ after(grammarAccess.getDebuggerStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimaryExpression
entryRulePrimaryExpression
:
{ before(grammarAccess.getPrimaryExpressionRule()); }
	 rulePrimaryExpression
{ after(grammarAccess.getPrimaryExpressionRule()); } 
	 EOF 
;

// Rule PrimaryExpression
rulePrimaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 0
		); }
		(rule__PrimaryExpression__Alternatives)
		{ after(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PrimaryExpression
norm1_PrimaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 1
		); }
		(norm1_PrimaryExpression__Alternatives)
		{ after(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParenExpression
entryRuleParenExpression
:
{ before(grammarAccess.getParenExpressionRule()); }
	 ruleParenExpression
{ after(grammarAccess.getParenExpressionRule()); } 
	 EOF 
;

// Rule ParenExpression
ruleParenExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParenExpressionAccess().getGroup(), 0
		); }
		(rule__ParenExpression__Group__0)
		{ after(grammarAccess.getParenExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ParenExpression
norm1_ParenExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParenExpressionAccess().getGroup(), 1
		); }
		(norm1_ParenExpression__Group__0)
		{ after(grammarAccess.getParenExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIdentifierRef
entryRuleIdentifierRef
:
{ before(grammarAccess.getIdentifierRefRule()); }
	 ruleIdentifierRef
{ after(grammarAccess.getIdentifierRefRule()); } 
	 EOF 
;

// Rule IdentifierRef
ruleIdentifierRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIdentifierRefAccess().getAlternatives(), 0
		); }
		(rule__IdentifierRef__Alternatives)
		{ after(grammarAccess.getIdentifierRefAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule IdentifierRef
norm1_IdentifierRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIdentifierRefAccess().getAlternatives(), 1
		); }
		(norm1_IdentifierRef__Alternatives)
		{ after(grammarAccess.getIdentifierRefAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSuperLiteral
entryRuleSuperLiteral
:
{ before(grammarAccess.getSuperLiteralRule()); }
	 ruleSuperLiteral
{ after(grammarAccess.getSuperLiteralRule()); } 
	 EOF 
;

// Rule SuperLiteral
ruleSuperLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSuperLiteralAccess().getGroup()); }
		(rule__SuperLiteral__Group__0)
		{ after(grammarAccess.getSuperLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleThisLiteral
entryRuleThisLiteral
:
{ before(grammarAccess.getThisLiteralRule()); }
	 ruleThisLiteral
{ after(grammarAccess.getThisLiteralRule()); } 
	 EOF 
;

// Rule ThisLiteral
ruleThisLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getThisLiteralAccess().getGroup()); }
		(rule__ThisLiteral__Group__0)
		{ after(grammarAccess.getThisLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArrayLiteral
entryRuleArrayLiteral
:
{ before(grammarAccess.getArrayLiteralRule()); }
	 ruleArrayLiteral
{ after(grammarAccess.getArrayLiteralRule()); } 
	 EOF 
;

// Rule ArrayLiteral
ruleArrayLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayLiteralAccess().getGroup(), 0
		); }
		(rule__ArrayLiteral__Group__0)
		{ after(grammarAccess.getArrayLiteralAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArrayLiteral
norm1_ArrayLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayLiteralAccess().getGroup(), 1
		); }
		(norm1_ArrayLiteral__Group__0)
		{ after(grammarAccess.getArrayLiteralAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArrayPadding
entryRuleArrayPadding
:
{ before(grammarAccess.getArrayPaddingRule()); }
	 ruleArrayPadding
{ after(grammarAccess.getArrayPaddingRule()); } 
	 EOF 
;

// Rule ArrayPadding
ruleArrayPadding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayPaddingAccess().getGroup()); }
		(rule__ArrayPadding__Group__0)
		{ after(grammarAccess.getArrayPaddingAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArrayElement
entryRuleArrayElement
:
{ before(grammarAccess.getArrayElementRule()); }
	 ruleArrayElement
{ after(grammarAccess.getArrayElementRule()); } 
	 EOF 
;

// Rule ArrayElement
ruleArrayElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayElementAccess().getGroup(), 0
		); }
		(rule__ArrayElement__Group__0)
		{ after(grammarAccess.getArrayElementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArrayElement
norm1_ArrayElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayElementAccess().getGroup(), 1
		); }
		(norm1_ArrayElement__Group__0)
		{ after(grammarAccess.getArrayElementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleObjectLiteral
entryRuleObjectLiteral
:
{ before(grammarAccess.getObjectLiteralRule()); }
	 ruleObjectLiteral
{ after(grammarAccess.getObjectLiteralRule()); } 
	 EOF 
;

// Rule ObjectLiteral
ruleObjectLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getObjectLiteralAccess().getGroup(), 0
		); }
		(rule__ObjectLiteral__Group__0)
		{ after(grammarAccess.getObjectLiteralAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ObjectLiteral
norm1_ObjectLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getObjectLiteralAccess().getGroup(), 1
		); }
		(norm1_ObjectLiteral__Group__0)
		{ after(grammarAccess.getObjectLiteralAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyAssignment
entryRulePropertyAssignment
:
{ before(grammarAccess.getPropertyAssignmentRule()); }
	 rulePropertyAssignment
{ after(grammarAccess.getPropertyAssignmentRule()); } 
	 EOF 
;

// Rule PropertyAssignment
rulePropertyAssignment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 0
		); }
		(rule__PropertyAssignment__Alternatives)
		{ after(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PropertyAssignment
norm1_PropertyAssignment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 1
		); }
		(norm1_PropertyAssignment__Alternatives)
		{ after(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotatedPropertyAssignment
entryRuleAnnotatedPropertyAssignment
:
{ before(grammarAccess.getAnnotatedPropertyAssignmentRule()); }
	 ruleAnnotatedPropertyAssignment
{ after(grammarAccess.getAnnotatedPropertyAssignmentRule()); } 
	 EOF 
;

// Rule AnnotatedPropertyAssignment
ruleAnnotatedPropertyAssignment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 0
		); }
		(rule__AnnotatedPropertyAssignment__Group__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AnnotatedPropertyAssignment
norm1_AnnotatedPropertyAssignment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 1
		); }
		(norm1_AnnotatedPropertyAssignment__Group__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyMethodDeclaration
entryRulePropertyMethodDeclaration
:
{ before(grammarAccess.getPropertyMethodDeclarationRule()); }
	 rulePropertyMethodDeclaration
{ after(grammarAccess.getPropertyMethodDeclarationRule()); } 
	 EOF 
;

// Rule PropertyMethodDeclaration
rulePropertyMethodDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 0
		); }
		(rule__PropertyMethodDeclaration__Group__0)
		{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PropertyMethodDeclaration
norm1_PropertyMethodDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 1
		); }
		(norm1_PropertyMethodDeclaration__Group__0)
		{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyNameValuePair
entryRulePropertyNameValuePair
:
{ before(grammarAccess.getPropertyNameValuePairRule()); }
	 rulePropertyNameValuePair
{ after(grammarAccess.getPropertyNameValuePairRule()); } 
	 EOF 
;

// Rule PropertyNameValuePair
rulePropertyNameValuePair 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 0
		); }
		(rule__PropertyNameValuePair__Group__0)
		{ after(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PropertyNameValuePair
norm1_PropertyNameValuePair 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 1
		); }
		(norm1_PropertyNameValuePair__Group__0)
		{ after(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyNameValuePairSingleName
entryRulePropertyNameValuePairSingleName
:
{ before(grammarAccess.getPropertyNameValuePairSingleNameRule()); }
	 rulePropertyNameValuePairSingleName
{ after(grammarAccess.getPropertyNameValuePairSingleNameRule()); } 
	 EOF 
;

// Rule PropertyNameValuePairSingleName
rulePropertyNameValuePairSingleName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 0
		); }
		(rule__PropertyNameValuePairSingleName__Group__0)
		{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PropertyNameValuePairSingleName
norm1_PropertyNameValuePairSingleName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 1
		); }
		(norm1_PropertyNameValuePairSingleName__Group__0)
		{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyGetterDeclaration
entryRulePropertyGetterDeclaration
:
{ before(grammarAccess.getPropertyGetterDeclarationRule()); }
	 rulePropertyGetterDeclaration
{ after(grammarAccess.getPropertyGetterDeclarationRule()); } 
	 EOF 
;

// Rule PropertyGetterDeclaration
rulePropertyGetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 0
		); }
		(rule__PropertyGetterDeclaration__Group__0)
		{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PropertyGetterDeclaration
norm1_PropertyGetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 1
		); }
		(norm1_PropertyGetterDeclaration__Group__0)
		{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertySetterDeclaration
entryRulePropertySetterDeclaration
:
{ before(grammarAccess.getPropertySetterDeclarationRule()); }
	 rulePropertySetterDeclaration
{ after(grammarAccess.getPropertySetterDeclarationRule()); } 
	 EOF 
;

// Rule PropertySetterDeclaration
rulePropertySetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 0
		); }
		(rule__PropertySetterDeclaration__Group__0)
		{ after(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PropertySetterDeclaration
norm1_PropertySetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 1
		); }
		(norm1_PropertySetterDeclaration__Group__0)
		{ after(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterizedCallExpression
entryRuleParameterizedCallExpression
:
{ before(grammarAccess.getParameterizedCallExpressionRule()); }
	 ruleParameterizedCallExpression
{ after(grammarAccess.getParameterizedCallExpressionRule()); } 
	 EOF 
;

// Rule ParameterizedCallExpression
ruleParameterizedCallExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 0
		); }
		(rule__ParameterizedCallExpression__Group__0)
		{ after(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ParameterizedCallExpression
norm1_ParameterizedCallExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 1
		); }
		(norm1_ParameterizedCallExpression__Group__0)
		{ after(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ConcreteTypeArguments
ruleConcreteTypeArguments 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConcreteTypeArgumentsAccess().getGroup()); }
		(rule__ConcreteTypeArguments__Group__0)
		{ after(grammarAccess.getConcreteTypeArgumentsAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLeftHandSideExpression
entryRuleLeftHandSideExpression
:
{ before(grammarAccess.getLeftHandSideExpressionRule()); }
	 ruleLeftHandSideExpression
{ after(grammarAccess.getLeftHandSideExpressionRule()); } 
	 EOF 
;

// Rule LeftHandSideExpression
ruleLeftHandSideExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 0
		); }
		(rule__LeftHandSideExpression__Group__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LeftHandSideExpression
norm1_LeftHandSideExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 1
		); }
		(norm1_LeftHandSideExpression__Group__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArgumentsWithParentheses
ruleArgumentsWithParentheses 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 0
		); }
		(rule__ArgumentsWithParentheses__Group__0)
		{ after(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArgumentsWithParentheses
norm1_ArgumentsWithParentheses 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 1
		); }
		(norm1_ArgumentsWithParentheses__Group__0)
		{ after(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Arguments
ruleArguments 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentsAccess().getGroup(), 0
		); }
		(rule__Arguments__Group__0)
		{ after(grammarAccess.getArgumentsAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Arguments
norm1_Arguments 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentsAccess().getGroup(), 1
		); }
		(norm1_Arguments__Group__0)
		{ after(grammarAccess.getArgumentsAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArgument
entryRuleArgument
:
{ before(grammarAccess.getArgumentRule()); }
	 ruleArgument
{ after(grammarAccess.getArgumentRule()); } 
	 EOF 
;

// Rule Argument
ruleArgument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentAccess().getGroup(), 0
		); }
		(rule__Argument__Group__0)
		{ after(grammarAccess.getArgumentAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Argument
norm1_Argument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentAccess().getGroup(), 1
		); }
		(norm1_Argument__Group__0)
		{ after(grammarAccess.getArgumentAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMemberExpression
entryRuleMemberExpression
:
{ before(grammarAccess.getMemberExpressionRule()); }
	 ruleMemberExpression
{ after(grammarAccess.getMemberExpressionRule()); } 
	 EOF 
;

// Rule MemberExpression
ruleMemberExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getAlternatives(), 0
		); }
		(rule__MemberExpression__Alternatives)
		{ after(grammarAccess.getMemberExpressionAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule MemberExpression
norm1_MemberExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getAlternatives(), 1
		); }
		(norm1_MemberExpression__Alternatives)
		{ after(grammarAccess.getMemberExpressionAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule IndexedAccessExpressionTail
ruleIndexedAccessExpressionTail 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 0
		); }
		(rule__IndexedAccessExpressionTail__Group__0)
		{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule IndexedAccessExpressionTail
norm1_IndexedAccessExpressionTail 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 1
		); }
		(norm1_IndexedAccessExpressionTail__Group__0)
		{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ParameterizedPropertyAccessExpressionTail
ruleParameterizedPropertyAccessExpressionTail 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 0
		); }
		(rule__ParameterizedPropertyAccessExpressionTail__Group__0)
		{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ParameterizedPropertyAccessExpressionTail
norm1_ParameterizedPropertyAccessExpressionTail 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 1
		); }
		(norm1_ParameterizedPropertyAccessExpressionTail__Group__0)
		{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePostfixExpression
entryRulePostfixExpression
:
{ before(grammarAccess.getPostfixExpressionRule()); }
	 rulePostfixExpression
{ after(grammarAccess.getPostfixExpressionRule()); } 
	 EOF 
;

// Rule PostfixExpression
rulePostfixExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPostfixExpressionAccess().getGroup(), 0
		); }
		(rule__PostfixExpression__Group__0)
		{ after(grammarAccess.getPostfixExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PostfixExpression
norm1_PostfixExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPostfixExpressionAccess().getGroup(), 1
		); }
		(norm1_PostfixExpression__Group__0)
		{ after(grammarAccess.getPostfixExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCastExpression
entryRuleCastExpression
:
{ before(grammarAccess.getCastExpressionRule()); }
	 ruleCastExpression
{ after(grammarAccess.getCastExpressionRule()); } 
	 EOF 
;

// Rule CastExpression
ruleCastExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCastExpressionAccess().getGroup(), 0
		); }
		(rule__CastExpression__Group__0)
		{ after(grammarAccess.getCastExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule CastExpression
norm1_CastExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCastExpressionAccess().getGroup(), 1
		); }
		(norm1_CastExpression__Group__0)
		{ after(grammarAccess.getCastExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnaryExpression
entryRuleUnaryExpression
:
{ before(grammarAccess.getUnaryExpressionRule()); }
	 ruleUnaryExpression
{ after(grammarAccess.getUnaryExpressionRule()); } 
	 EOF 
;

// Rule UnaryExpression
ruleUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 0
		); }
		(rule__UnaryExpression__Alternatives)
		{ after(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule UnaryExpression
norm1_UnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 1
		); }
		(norm1_UnaryExpression__Alternatives)
		{ after(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMultiplicativeExpression
entryRuleMultiplicativeExpression
:
{ before(grammarAccess.getMultiplicativeExpressionRule()); }
	 ruleMultiplicativeExpression
{ after(grammarAccess.getMultiplicativeExpressionRule()); } 
	 EOF 
;

// Rule MultiplicativeExpression
ruleMultiplicativeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 0
		); }
		(rule__MultiplicativeExpression__Group__0)
		{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule MultiplicativeExpression
norm1_MultiplicativeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 1
		); }
		(norm1_MultiplicativeExpression__Group__0)
		{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAdditiveExpression
entryRuleAdditiveExpression
:
{ before(grammarAccess.getAdditiveExpressionRule()); }
	 ruleAdditiveExpression
{ after(grammarAccess.getAdditiveExpressionRule()); } 
	 EOF 
;

// Rule AdditiveExpression
ruleAdditiveExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAdditiveExpressionAccess().getGroup(), 0
		); }
		(rule__AdditiveExpression__Group__0)
		{ after(grammarAccess.getAdditiveExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AdditiveExpression
norm1_AdditiveExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAdditiveExpressionAccess().getGroup(), 1
		); }
		(norm1_AdditiveExpression__Group__0)
		{ after(grammarAccess.getAdditiveExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleShiftExpression
entryRuleShiftExpression
:
{ before(grammarAccess.getShiftExpressionRule()); }
	 ruleShiftExpression
{ after(grammarAccess.getShiftExpressionRule()); } 
	 EOF 
;

// Rule ShiftExpression
ruleShiftExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getGroup(), 0
		); }
		(rule__ShiftExpression__Group__0)
		{ after(grammarAccess.getShiftExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ShiftExpression
norm1_ShiftExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getGroup(), 1
		); }
		(norm1_ShiftExpression__Group__0)
		{ after(grammarAccess.getShiftExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleShiftOperator
entryRuleShiftOperator
:
{ before(grammarAccess.getShiftOperatorRule()); }
	 ruleShiftOperator
{ after(grammarAccess.getShiftOperatorRule()); } 
	 EOF 
;

// Rule ShiftOperator
ruleShiftOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getShiftOperatorAccess().getAlternatives()); }
		(rule__ShiftOperator__Alternatives)
		{ after(grammarAccess.getShiftOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRelationalExpression
entryRuleRelationalExpression
:
{ before(grammarAccess.getRelationalExpressionRule()); }
	 ruleRelationalExpression
{ after(grammarAccess.getRelationalExpressionRule()); } 
	 EOF 
;

// Rule RelationalExpression
ruleRelationalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalExpressionAccess().getGroup(), 0
		); }
		(rule__RelationalExpression__Group__0)
		{ after(grammarAccess.getRelationalExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule RelationalExpression
norm1_RelationalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalExpressionAccess().getGroup(), 1
		); }
		(norm1_RelationalExpression__Group__0)
		{ after(grammarAccess.getRelationalExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule RelationalExpression
norm2_RelationalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalExpressionAccess().getGroup(), 2
		); }
		(norm2_RelationalExpression__Group__0)
		{ after(grammarAccess.getRelationalExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule RelationalExpression
norm3_RelationalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalExpressionAccess().getGroup(), 3
		); }
		(norm3_RelationalExpression__Group__0)
		{ after(grammarAccess.getRelationalExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRelationalOperator
entryRuleRelationalOperator
:
{ before(grammarAccess.getRelationalOperatorRule()); }
	 ruleRelationalOperator
{ after(grammarAccess.getRelationalOperatorRule()); } 
	 EOF 
;

// Rule RelationalOperator
ruleRelationalOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 0
		); }
		(rule__RelationalOperator__Alternatives)
		{ after(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule RelationalOperator
norm1_RelationalOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 1
		); }
		(norm1_RelationalOperator__Alternatives)
		{ after(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEqualityExpression
entryRuleEqualityExpression
:
{ before(grammarAccess.getEqualityExpressionRule()); }
	 ruleEqualityExpression
{ after(grammarAccess.getEqualityExpressionRule()); } 
	 EOF 
;

// Rule EqualityExpression
ruleEqualityExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEqualityExpressionAccess().getGroup(), 0
		); }
		(rule__EqualityExpression__Group__0)
		{ after(grammarAccess.getEqualityExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule EqualityExpression
norm1_EqualityExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEqualityExpressionAccess().getGroup(), 1
		); }
		(norm1_EqualityExpression__Group__0)
		{ after(grammarAccess.getEqualityExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule EqualityExpression
norm2_EqualityExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEqualityExpressionAccess().getGroup(), 2
		); }
		(norm2_EqualityExpression__Group__0)
		{ after(grammarAccess.getEqualityExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule EqualityExpression
norm3_EqualityExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEqualityExpressionAccess().getGroup(), 3
		); }
		(norm3_EqualityExpression__Group__0)
		{ after(grammarAccess.getEqualityExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseANDExpression
entryRuleBitwiseANDExpression
:
{ before(grammarAccess.getBitwiseANDExpressionRule()); }
	 ruleBitwiseANDExpression
{ after(grammarAccess.getBitwiseANDExpressionRule()); } 
	 EOF 
;

// Rule BitwiseANDExpression
ruleBitwiseANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 0
		); }
		(rule__BitwiseANDExpression__Group__0)
		{ after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseANDExpression
norm1_BitwiseANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 1
		); }
		(norm1_BitwiseANDExpression__Group__0)
		{ after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseANDExpression
norm2_BitwiseANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 2
		); }
		(norm2_BitwiseANDExpression__Group__0)
		{ after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseANDExpression
norm3_BitwiseANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 3
		); }
		(norm3_BitwiseANDExpression__Group__0)
		{ after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseANDOperator
entryRuleBitwiseANDOperator
:
{ before(grammarAccess.getBitwiseANDOperatorRule()); }
	 ruleBitwiseANDOperator
{ after(grammarAccess.getBitwiseANDOperatorRule()); } 
	 EOF 
;

// Rule BitwiseANDOperator
ruleBitwiseANDOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseANDOperatorAccess().getAmpersandKeyword()); }
		Ampersand
		{ after(grammarAccess.getBitwiseANDOperatorAccess().getAmpersandKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseXORExpression
entryRuleBitwiseXORExpression
:
{ before(grammarAccess.getBitwiseXORExpressionRule()); }
	 ruleBitwiseXORExpression
{ after(grammarAccess.getBitwiseXORExpressionRule()); } 
	 EOF 
;

// Rule BitwiseXORExpression
ruleBitwiseXORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 0
		); }
		(rule__BitwiseXORExpression__Group__0)
		{ after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseXORExpression
norm1_BitwiseXORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 1
		); }
		(norm1_BitwiseXORExpression__Group__0)
		{ after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseXORExpression
norm2_BitwiseXORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 2
		); }
		(norm2_BitwiseXORExpression__Group__0)
		{ after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseXORExpression
norm3_BitwiseXORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 3
		); }
		(norm3_BitwiseXORExpression__Group__0)
		{ after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseXOROperator
entryRuleBitwiseXOROperator
:
{ before(grammarAccess.getBitwiseXOROperatorRule()); }
	 ruleBitwiseXOROperator
{ after(grammarAccess.getBitwiseXOROperatorRule()); } 
	 EOF 
;

// Rule BitwiseXOROperator
ruleBitwiseXOROperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXOROperatorAccess().getCircumflexAccentKeyword()); }
		CircumflexAccent
		{ after(grammarAccess.getBitwiseXOROperatorAccess().getCircumflexAccentKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseORExpression
entryRuleBitwiseORExpression
:
{ before(grammarAccess.getBitwiseORExpressionRule()); }
	 ruleBitwiseORExpression
{ after(grammarAccess.getBitwiseORExpressionRule()); } 
	 EOF 
;

// Rule BitwiseORExpression
ruleBitwiseORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 0
		); }
		(rule__BitwiseORExpression__Group__0)
		{ after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseORExpression
norm1_BitwiseORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 1
		); }
		(norm1_BitwiseORExpression__Group__0)
		{ after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseORExpression
norm2_BitwiseORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 2
		); }
		(norm2_BitwiseORExpression__Group__0)
		{ after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BitwiseORExpression
norm3_BitwiseORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 3
		); }
		(norm3_BitwiseORExpression__Group__0)
		{ after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseOROperator
entryRuleBitwiseOROperator
:
{ before(grammarAccess.getBitwiseOROperatorRule()); }
	 ruleBitwiseOROperator
{ after(grammarAccess.getBitwiseOROperatorRule()); } 
	 EOF 
;

// Rule BitwiseOROperator
ruleBitwiseOROperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseOROperatorAccess().getVerticalLineKeyword()); }
		VerticalLine
		{ after(grammarAccess.getBitwiseOROperatorAccess().getVerticalLineKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalANDExpression
entryRuleLogicalANDExpression
:
{ before(grammarAccess.getLogicalANDExpressionRule()); }
	 ruleLogicalANDExpression
{ after(grammarAccess.getLogicalANDExpressionRule()); } 
	 EOF 
;

// Rule LogicalANDExpression
ruleLogicalANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 0
		); }
		(rule__LogicalANDExpression__Group__0)
		{ after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LogicalANDExpression
norm1_LogicalANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 1
		); }
		(norm1_LogicalANDExpression__Group__0)
		{ after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LogicalANDExpression
norm2_LogicalANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 2
		); }
		(norm2_LogicalANDExpression__Group__0)
		{ after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LogicalANDExpression
norm3_LogicalANDExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 3
		); }
		(norm3_LogicalANDExpression__Group__0)
		{ after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalANDOperator
entryRuleLogicalANDOperator
:
{ before(grammarAccess.getLogicalANDOperatorRule()); }
	 ruleLogicalANDOperator
{ after(grammarAccess.getLogicalANDOperatorRule()); } 
	 EOF 
;

// Rule LogicalANDOperator
ruleLogicalANDOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalANDOperatorAccess().getAmpersandAmpersandKeyword()); }
		AmpersandAmpersand
		{ after(grammarAccess.getLogicalANDOperatorAccess().getAmpersandAmpersandKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalORExpression
entryRuleLogicalORExpression
:
{ before(grammarAccess.getLogicalORExpressionRule()); }
	 ruleLogicalORExpression
{ after(grammarAccess.getLogicalORExpressionRule()); } 
	 EOF 
;

// Rule LogicalORExpression
ruleLogicalORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 0
		); }
		(rule__LogicalORExpression__Group__0)
		{ after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LogicalORExpression
norm1_LogicalORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 1
		); }
		(norm1_LogicalORExpression__Group__0)
		{ after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LogicalORExpression
norm2_LogicalORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 2
		); }
		(norm2_LogicalORExpression__Group__0)
		{ after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LogicalORExpression
norm3_LogicalORExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 3
		); }
		(norm3_LogicalORExpression__Group__0)
		{ after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalOROperator
entryRuleLogicalOROperator
:
{ before(grammarAccess.getLogicalOROperatorRule()); }
	 ruleLogicalOROperator
{ after(grammarAccess.getLogicalOROperatorRule()); } 
	 EOF 
;

// Rule LogicalOROperator
ruleLogicalOROperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalOROperatorAccess().getVerticalLineVerticalLineKeyword()); }
		VerticalLineVerticalLine
		{ after(grammarAccess.getLogicalOROperatorAccess().getVerticalLineVerticalLineKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConditionalExpression
entryRuleConditionalExpression
:
{ before(grammarAccess.getConditionalExpressionRule()); }
	 ruleConditionalExpression
{ after(grammarAccess.getConditionalExpressionRule()); } 
	 EOF 
;

// Rule ConditionalExpression
ruleConditionalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getGroup(), 0
		); }
		(rule__ConditionalExpression__Group__0)
		{ after(grammarAccess.getConditionalExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ConditionalExpression
norm1_ConditionalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getGroup(), 1
		); }
		(norm1_ConditionalExpression__Group__0)
		{ after(grammarAccess.getConditionalExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ConditionalExpression
norm2_ConditionalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getGroup(), 2
		); }
		(norm2_ConditionalExpression__Group__0)
		{ after(grammarAccess.getConditionalExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ConditionalExpression
norm3_ConditionalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getGroup(), 3
		); }
		(norm3_ConditionalExpression__Group__0)
		{ after(grammarAccess.getConditionalExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssignmentExpression
entryRuleAssignmentExpression
:
{ before(grammarAccess.getAssignmentExpressionRule()); }
	 ruleAssignmentExpression
{ after(grammarAccess.getAssignmentExpressionRule()); } 
	 EOF 
;

// Rule AssignmentExpression
ruleAssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 0
		); }
		(rule__AssignmentExpression__Alternatives)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AssignmentExpression
norm1_AssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 1
		); }
		(norm1_AssignmentExpression__Alternatives)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AssignmentExpression
norm2_AssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 2
		); }
		(norm2_AssignmentExpression__Alternatives)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AssignmentExpression
norm3_AssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 3
		); }
		(norm3_AssignmentExpression__Alternatives)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleYieldExpression
entryRuleYieldExpression
:
{ before(grammarAccess.getYieldExpressionRule()); }
	 ruleYieldExpression
{ after(grammarAccess.getYieldExpressionRule()); } 
	 EOF 
;

// Rule YieldExpression
ruleYieldExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getYieldExpressionAccess().getGroup(), 0
		); }
		(rule__YieldExpression__Group__0)
		{ after(grammarAccess.getYieldExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule YieldExpression
norm1_YieldExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getYieldExpressionAccess().getGroup(), 1
		); }
		(norm1_YieldExpression__Group__0)
		{ after(grammarAccess.getYieldExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssignmentOperator
entryRuleAssignmentOperator
:
{ before(grammarAccess.getAssignmentOperatorRule()); }
	 ruleAssignmentOperator
{ after(grammarAccess.getAssignmentOperatorRule()); } 
	 EOF 
;

// Rule AssignmentOperator
ruleAssignmentOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
		(rule__AssignmentOperator__Alternatives)
		{ after(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAwaitExpression
entryRuleAwaitExpression
:
{ before(grammarAccess.getAwaitExpressionRule()); }
	 ruleAwaitExpression
{ after(grammarAccess.getAwaitExpressionRule()); } 
	 EOF 
;

// Rule AwaitExpression
ruleAwaitExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAwaitExpressionAccess().getGroup(), 0
		); }
		(rule__AwaitExpression__Group__0)
		{ after(grammarAccess.getAwaitExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AwaitExpression
norm1_AwaitExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAwaitExpressionAccess().getGroup(), 1
		); }
		(norm1_AwaitExpression__Group__0)
		{ after(grammarAccess.getAwaitExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AwaitExpression
norm2_AwaitExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAwaitExpressionAccess().getGroup(), 2
		); }
		(norm2_AwaitExpression__Group__0)
		{ after(grammarAccess.getAwaitExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AwaitExpression
norm3_AwaitExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAwaitExpressionAccess().getGroup(), 3
		); }
		(norm3_AwaitExpression__Group__0)
		{ after(grammarAccess.getAwaitExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePromisifyExpression
entryRulePromisifyExpression
:
{ before(grammarAccess.getPromisifyExpressionRule()); }
	 rulePromisifyExpression
{ after(grammarAccess.getPromisifyExpressionRule()); } 
	 EOF 
;

// Rule PromisifyExpression
rulePromisifyExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 0
		); }
		(rule__PromisifyExpression__Group__0)
		{ after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PromisifyExpression
norm1_PromisifyExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 1
		); }
		(norm1_PromisifyExpression__Group__0)
		{ after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PromisifyExpression
norm2_PromisifyExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 2
		); }
		(norm2_PromisifyExpression__Group__0)
		{ after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule PromisifyExpression
norm3_PromisifyExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 3
		); }
		(norm3_PromisifyExpression__Group__0)
		{ after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpression
entryRuleExpression
:
{ before(grammarAccess.getExpressionRule()); }
	 ruleExpression
{ after(grammarAccess.getExpressionRule()); } 
	 EOF 
;

// Rule Expression
ruleExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAccess().getGroup(), 0
		); }
		(rule__Expression__Group__0)
		{ after(grammarAccess.getExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Expression
norm1_Expression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAccess().getGroup(), 1
		); }
		(norm1_Expression__Group__0)
		{ after(grammarAccess.getExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Expression
norm2_Expression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAccess().getGroup(), 2
		); }
		(norm2_Expression__Group__0)
		{ after(grammarAccess.getExpressionAccess().getGroup(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Expression
norm3_Expression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAccess().getGroup(), 3
		); }
		(norm3_Expression__Group__0)
		{ after(grammarAccess.getExpressionAccess().getGroup(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTemplateLiteral
entryRuleTemplateLiteral
:
{ before(grammarAccess.getTemplateLiteralRule()); }
	 ruleTemplateLiteral
{ after(grammarAccess.getTemplateLiteralRule()); } 
	 EOF 
;

// Rule TemplateLiteral
ruleTemplateLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateLiteralAccess().getGroup(), 0
		); }
		(rule__TemplateLiteral__Group__0)
		{ after(grammarAccess.getTemplateLiteralAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule TemplateLiteral
norm1_TemplateLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateLiteralAccess().getGroup(), 1
		); }
		(norm1_TemplateLiteral__Group__0)
		{ after(grammarAccess.getTemplateLiteralAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTemplateExpressionEnd
entryRuleTemplateExpressionEnd
:
{ before(grammarAccess.getTemplateExpressionEndRule()); }
	 ruleTemplateExpressionEnd
{ after(grammarAccess.getTemplateExpressionEndRule()); } 
	 EOF 
;

// Rule TemplateExpressionEnd
ruleTemplateExpressionEnd 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateExpressionEndAccess().getRightCurlyBracketKeyword()); }
		RightCurlyBracket
		{ after(grammarAccess.getTemplateExpressionEndAccess().getRightCurlyBracketKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNoSubstitutionTemplate
entryRuleNoSubstitutionTemplate
:
{ before(grammarAccess.getNoSubstitutionTemplateRule()); }
	 ruleNoSubstitutionTemplate
{ after(grammarAccess.getNoSubstitutionTemplateRule()); } 
	 EOF 
;

// Rule NoSubstitutionTemplate
ruleNoSubstitutionTemplate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNoSubstitutionTemplateAccess().getGroup()); }
		(rule__NoSubstitutionTemplate__Group__0)
		{ after(grammarAccess.getNoSubstitutionTemplateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTemplateHead
entryRuleTemplateHead
:
{ before(grammarAccess.getTemplateHeadRule()); }
	 ruleTemplateHead
{ after(grammarAccess.getTemplateHeadRule()); } 
	 EOF 
;

// Rule TemplateHead
ruleTemplateHead 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateHeadAccess().getGroup()); }
		(rule__TemplateHead__Group__0)
		{ after(grammarAccess.getTemplateHeadAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTemplateTail
entryRuleTemplateTail
:
{ before(grammarAccess.getTemplateTailRule()); }
	 ruleTemplateTail
{ after(grammarAccess.getTemplateTailRule()); } 
	 EOF 
;

// Rule TemplateTail
ruleTemplateTail 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateTailAccess().getGroup()); }
		(rule__TemplateTail__Group__0)
		{ after(grammarAccess.getTemplateTailAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTemplateMiddle
entryRuleTemplateMiddle
:
{ before(grammarAccess.getTemplateMiddleRule()); }
	 ruleTemplateMiddle
{ after(grammarAccess.getTemplateMiddleRule()); } 
	 EOF 
;

// Rule TemplateMiddle
ruleTemplateMiddle 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateMiddleAccess().getGroup()); }
		(rule__TemplateMiddle__Group__0)
		{ after(grammarAccess.getTemplateMiddleAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteral
entryRuleLiteral
:
{ before(grammarAccess.getLiteralRule()); }
	 ruleLiteral
{ after(grammarAccess.getLiteralRule()); } 
	 EOF 
;

// Rule Literal
ruleLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralAccess().getAlternatives()); }
		(rule__Literal__Alternatives)
		{ after(grammarAccess.getLiteralAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNullLiteral
entryRuleNullLiteral
:
{ before(grammarAccess.getNullLiteralRule()); }
	 ruleNullLiteral
{ after(grammarAccess.getNullLiteralRule()); } 
	 EOF 
;

// Rule NullLiteral
ruleNullLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNullLiteralAccess().getGroup()); }
		(rule__NullLiteral__Group__0)
		{ after(grammarAccess.getNullLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBooleanLiteral
entryRuleBooleanLiteral
:
{ before(grammarAccess.getBooleanLiteralRule()); }
	 ruleBooleanLiteral
{ after(grammarAccess.getBooleanLiteralRule()); } 
	 EOF 
;

// Rule BooleanLiteral
ruleBooleanLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBooleanLiteralAccess().getGroup()); }
		(rule__BooleanLiteral__Group__0)
		{ after(grammarAccess.getBooleanLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStringLiteral
entryRuleStringLiteral
:
{ before(grammarAccess.getStringLiteralRule()); }
	 ruleStringLiteral
{ after(grammarAccess.getStringLiteralRule()); } 
	 EOF 
;

// Rule StringLiteral
ruleStringLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStringLiteralAccess().getValueAssignment()); }
		(rule__StringLiteral__ValueAssignment)
		{ after(grammarAccess.getStringLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericLiteral
entryRuleNumericLiteral
:
{ before(grammarAccess.getNumericLiteralRule()); }
	 ruleNumericLiteral
{ after(grammarAccess.getNumericLiteralRule()); } 
	 EOF 
;

// Rule NumericLiteral
ruleNumericLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericLiteralAccess().getAlternatives()); }
		(rule__NumericLiteral__Alternatives)
		{ after(grammarAccess.getNumericLiteralAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDoubleLiteral
entryRuleDoubleLiteral
:
{ before(grammarAccess.getDoubleLiteralRule()); }
	 ruleDoubleLiteral
{ after(grammarAccess.getDoubleLiteralRule()); } 
	 EOF 
;

// Rule DoubleLiteral
ruleDoubleLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDoubleLiteralAccess().getValueAssignment()); }
		(rule__DoubleLiteral__ValueAssignment)
		{ after(grammarAccess.getDoubleLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntLiteral
entryRuleIntLiteral
:
{ before(grammarAccess.getIntLiteralRule()); }
	 ruleIntLiteral
{ after(grammarAccess.getIntLiteralRule()); } 
	 EOF 
;

// Rule IntLiteral
ruleIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntLiteralAccess().getValueAssignment()); }
		(rule__IntLiteral__ValueAssignment)
		{ after(grammarAccess.getIntLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOctalIntLiteral
entryRuleOctalIntLiteral
:
{ before(grammarAccess.getOctalIntLiteralRule()); }
	 ruleOctalIntLiteral
{ after(grammarAccess.getOctalIntLiteralRule()); } 
	 EOF 
;

// Rule OctalIntLiteral
ruleOctalIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOctalIntLiteralAccess().getValueAssignment()); }
		(rule__OctalIntLiteral__ValueAssignment)
		{ after(grammarAccess.getOctalIntLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLegacyOctalIntLiteral
entryRuleLegacyOctalIntLiteral
:
{ before(grammarAccess.getLegacyOctalIntLiteralRule()); }
	 ruleLegacyOctalIntLiteral
{ after(grammarAccess.getLegacyOctalIntLiteralRule()); } 
	 EOF 
;

// Rule LegacyOctalIntLiteral
ruleLegacyOctalIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLegacyOctalIntLiteralAccess().getValueAssignment()); }
		(rule__LegacyOctalIntLiteral__ValueAssignment)
		{ after(grammarAccess.getLegacyOctalIntLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleHexIntLiteral
entryRuleHexIntLiteral
:
{ before(grammarAccess.getHexIntLiteralRule()); }
	 ruleHexIntLiteral
{ after(grammarAccess.getHexIntLiteralRule()); } 
	 EOF 
;

// Rule HexIntLiteral
ruleHexIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getHexIntLiteralAccess().getValueAssignment()); }
		(rule__HexIntLiteral__ValueAssignment)
		{ after(grammarAccess.getHexIntLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBinaryIntLiteral
entryRuleBinaryIntLiteral
:
{ before(grammarAccess.getBinaryIntLiteralRule()); }
	 ruleBinaryIntLiteral
{ after(grammarAccess.getBinaryIntLiteralRule()); } 
	 EOF 
;

// Rule BinaryIntLiteral
ruleBinaryIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBinaryIntLiteralAccess().getValueAssignment()); }
		(rule__BinaryIntLiteral__ValueAssignment)
		{ after(grammarAccess.getBinaryIntLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleScientificIntLiteral
entryRuleScientificIntLiteral
:
{ before(grammarAccess.getScientificIntLiteralRule()); }
	 ruleScientificIntLiteral
{ after(grammarAccess.getScientificIntLiteralRule()); } 
	 EOF 
;

// Rule ScientificIntLiteral
ruleScientificIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getScientificIntLiteralAccess().getValueAssignment()); }
		(rule__ScientificIntLiteral__ValueAssignment)
		{ after(grammarAccess.getScientificIntLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRegularExpressionLiteral
entryRuleRegularExpressionLiteral
:
{ before(grammarAccess.getRegularExpressionLiteralRule()); }
	 ruleRegularExpressionLiteral
{ after(grammarAccess.getRegularExpressionLiteralRule()); } 
	 EOF 
;

// Rule RegularExpressionLiteral
ruleRegularExpressionLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRegularExpressionLiteralAccess().getValueAssignment()); }
		(rule__RegularExpressionLiteral__ValueAssignment)
		{ after(grammarAccess.getRegularExpressionLiteralAccess().getValueAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericLiteralAsString
entryRuleNumericLiteralAsString
:
{ before(grammarAccess.getNumericLiteralAsStringRule()); }
	 ruleNumericLiteralAsString
{ after(grammarAccess.getNumericLiteralAsStringRule()); } 
	 EOF 
;

// Rule NumericLiteralAsString
ruleNumericLiteralAsString 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericLiteralAsStringAccess().getAlternatives()); }
		(rule__NumericLiteralAsString__Alternatives)
		{ after(grammarAccess.getNumericLiteralAsStringAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIdentifierOrThis
entryRuleIdentifierOrThis
:
{ before(grammarAccess.getIdentifierOrThisRule()); }
	 ruleIdentifierOrThis
{ after(grammarAccess.getIdentifierOrThisRule()); } 
	 EOF 
;

// Rule IdentifierOrThis
ruleIdentifierOrThis 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIdentifierOrThisAccess().getAlternatives()); }
		(rule__IdentifierOrThis__Alternatives)
		{ after(grammarAccess.getIdentifierOrThisAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotationName
entryRuleAnnotationName
:
{ before(grammarAccess.getAnnotationNameRule()); }
	 ruleAnnotationName
{ after(grammarAccess.getAnnotationNameRule()); } 
	 EOF 
;

// Rule AnnotationName
ruleAnnotationName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotationNameAccess().getAlternatives()); }
		(rule__AnnotationName__Alternatives)
		{ after(grammarAccess.getAnnotationNameAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleREGEX_LITERAL
entryRuleREGEX_LITERAL
:
{ before(grammarAccess.getREGEX_LITERALRule()); }
	 ruleREGEX_LITERAL
{ after(grammarAccess.getREGEX_LITERALRule()); } 
	 EOF 
;

// Rule REGEX_LITERAL
ruleREGEX_LITERAL 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getREGEX_LITERALAccess().getGroup()); }
		(rule__REGEX_LITERAL__Group__0)
		{ after(grammarAccess.getREGEX_LITERALAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTemplateTailLiteral
entryRuleTemplateTailLiteral
:
{ before(grammarAccess.getTemplateTailLiteralRule()); }
	 ruleTemplateTailLiteral
{ after(grammarAccess.getTemplateTailLiteralRule()); } 
	 EOF 
;

// Rule TemplateTailLiteral
ruleTemplateTailLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateTailLiteralAccess().getTEMPLATE_ENDTerminalRuleCall()); }
		(RULE_TEMPLATE_END)?
		{ after(grammarAccess.getTemplateTailLiteralAccess().getTEMPLATE_ENDTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTemplateMiddleLiteral
entryRuleTemplateMiddleLiteral
:
{ before(grammarAccess.getTemplateMiddleLiteralRule()); }
	 ruleTemplateMiddleLiteral
{ after(grammarAccess.getTemplateMiddleLiteralRule()); } 
	 EOF 
;

// Rule TemplateMiddleLiteral
ruleTemplateMiddleLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTemplateMiddleLiteralAccess().getTEMPLATE_MIDDLETerminalRuleCall()); }
		RULE_TEMPLATE_MIDDLE
		{ after(grammarAccess.getTemplateMiddleLiteralAccess().getTEMPLATE_MIDDLETerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSemi
entryRuleSemi
:
{ before(grammarAccess.getSemiRule()); }
	 ruleSemi
{ after(grammarAccess.getSemiRule()); } 
	 EOF 
;

// Rule Semi
ruleSemi 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSemiAccess().getSemicolonKeyword()); }
		Semicolon
		{ after(grammarAccess.getSemiAccess().getSemicolonKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule NoLineTerminator
ruleNoLineTerminator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNoLineTerminatorAccess().getNO_LINE_TERMINATORTerminalRuleCall()); }
		(RULE_NO_LINE_TERMINATOR)?
		{ after(grammarAccess.getNoLineTerminatorAccess().getNO_LINE_TERMINATORTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotation
entryRuleAnnotation
:
{ before(grammarAccess.getAnnotationRule()); }
	 ruleAnnotation
{ after(grammarAccess.getAnnotationRule()); } 
	 EOF 
;

// Rule Annotation
ruleAnnotation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotationAccess().getGroup()); }
		(rule__Annotation__Group__0)
		{ after(grammarAccess.getAnnotationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleScriptAnnotation
entryRuleScriptAnnotation
:
{ before(grammarAccess.getScriptAnnotationRule()); }
	 ruleScriptAnnotation
{ after(grammarAccess.getScriptAnnotationRule()); } 
	 EOF 
;

// Rule ScriptAnnotation
ruleScriptAnnotation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getScriptAnnotationAccess().getGroup()); }
		(rule__ScriptAnnotation__Group__0)
		{ after(grammarAccess.getScriptAnnotationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotationNoAtSign
entryRuleAnnotationNoAtSign
:
{ before(grammarAccess.getAnnotationNoAtSignRule()); }
	 ruleAnnotationNoAtSign
{ after(grammarAccess.getAnnotationNoAtSignRule()); } 
	 EOF 
;

// Rule AnnotationNoAtSign
ruleAnnotationNoAtSign 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotationNoAtSignAccess().getGroup()); }
		(rule__AnnotationNoAtSign__Group__0)
		{ after(grammarAccess.getAnnotationNoAtSignAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotationArgument
entryRuleAnnotationArgument
:
{ before(grammarAccess.getAnnotationArgumentRule()); }
	 ruleAnnotationArgument
{ after(grammarAccess.getAnnotationArgumentRule()); } 
	 EOF 
;

// Rule AnnotationArgument
ruleAnnotationArgument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotationArgumentAccess().getAlternatives()); }
		(rule__AnnotationArgument__Alternatives)
		{ after(grammarAccess.getAnnotationArgumentAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralAnnotationArgument
entryRuleLiteralAnnotationArgument
:
{ before(grammarAccess.getLiteralAnnotationArgumentRule()); }
	 ruleLiteralAnnotationArgument
{ after(grammarAccess.getLiteralAnnotationArgumentRule()); } 
	 EOF 
;

// Rule LiteralAnnotationArgument
ruleLiteralAnnotationArgument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralAnnotationArgumentAccess().getLiteralAssignment()); }
		(rule__LiteralAnnotationArgument__LiteralAssignment)
		{ after(grammarAccess.getLiteralAnnotationArgumentAccess().getLiteralAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeRefAnnotationArgument
entryRuleTypeRefAnnotationArgument
:
{ before(grammarAccess.getTypeRefAnnotationArgumentRule()); }
	 ruleTypeRefAnnotationArgument
{ after(grammarAccess.getTypeRefAnnotationArgumentRule()); } 
	 EOF 
;

// Rule TypeRefAnnotationArgument
ruleTypeRefAnnotationArgument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeRefAnnotationArgumentAccess().getTypeRefAssignment()); }
		(rule__TypeRefAnnotationArgument__TypeRefAssignment)
		{ after(grammarAccess.getTypeRefAnnotationArgumentAccess().getTypeRefAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeRefForCast
entryRuleTypeRefForCast
:
{ before(grammarAccess.getTypeRefForCastRule()); }
	 ruleTypeRefForCast
{ after(grammarAccess.getTypeRefForCastRule()); } 
	 EOF 
;

// Rule TypeRefForCast
ruleTypeRefForCast 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getAlternatives()); }
		(rule__TypeRefForCast__Alternatives)
		{ after(grammarAccess.getTypeRefForCastAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotationList
entryRuleAnnotationList
:
{ before(grammarAccess.getAnnotationListRule()); }
	 ruleAnnotationList
{ after(grammarAccess.getAnnotationListRule()); } 
	 EOF 
;

// Rule AnnotationList
ruleAnnotationList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotationListAccess().getGroup()); }
		(rule__AnnotationList__Group__0)
		{ after(grammarAccess.getAnnotationListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpressionAnnotationList
entryRuleExpressionAnnotationList
:
{ before(grammarAccess.getExpressionAnnotationListRule()); }
	 ruleExpressionAnnotationList
{ after(grammarAccess.getExpressionAnnotationListRule()); } 
	 EOF 
;

// Rule ExpressionAnnotationList
ruleExpressionAnnotationList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAnnotationListAccess().getGroup()); }
		(rule__ExpressionAnnotationList__Group__0)
		{ after(grammarAccess.getExpressionAnnotationListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePropertyAssignmentAnnotationList
entryRulePropertyAssignmentAnnotationList
:
{ before(grammarAccess.getPropertyAssignmentAnnotationListRule()); }
	 rulePropertyAssignmentAnnotationList
{ after(grammarAccess.getPropertyAssignmentAnnotationListRule()); } 
	 EOF 
;

// Rule PropertyAssignmentAnnotationList
rulePropertyAssignmentAnnotationList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPropertyAssignmentAnnotationListAccess().getGroup()); }
		(rule__PropertyAssignmentAnnotationList__Group__0)
		{ after(grammarAccess.getPropertyAssignmentAnnotationListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4MemberAnnotationList
entryRuleN4MemberAnnotationList
:
{ before(grammarAccess.getN4MemberAnnotationListRule()); }
	 ruleN4MemberAnnotationList
{ after(grammarAccess.getN4MemberAnnotationListRule()); } 
	 EOF 
;

// Rule N4MemberAnnotationList
ruleN4MemberAnnotationList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4MemberAnnotationListAccess().getGroup()); }
		(rule__N4MemberAnnotationList__Group__0)
		{ after(grammarAccess.getN4MemberAnnotationListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule TypeReference
ruleTypeReference 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeReferenceAccess().getGroup()); }
		(rule__TypeReference__Group__0)
		{ after(grammarAccess.getTypeReferenceAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeReferenceName
entryRuleTypeReferenceName
:
{ before(grammarAccess.getTypeReferenceNameRule()); }
	 ruleTypeReferenceName
{ after(grammarAccess.getTypeReferenceNameRule()); } 
	 EOF 
;

// Rule TypeReferenceName
ruleTypeReferenceName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getAlternatives()); }
		(rule__TypeReferenceName__Alternatives)
		{ after(grammarAccess.getTypeReferenceNameAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4ClassDeclaration
entryRuleN4ClassDeclaration
:
{ before(grammarAccess.getN4ClassDeclarationRule()); }
	 ruleN4ClassDeclaration
{ after(grammarAccess.getN4ClassDeclarationRule()); } 
	 EOF 
;

// Rule N4ClassDeclaration
ruleN4ClassDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4ClassDeclarationAccess().getGroup(), 0
		); }
		(rule__N4ClassDeclaration__Group__0)
		{ after(grammarAccess.getN4ClassDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Members
ruleMembers 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMembersAccess().getGroup(), 0
		); }
		(rule__Members__Group__0)
		{ after(grammarAccess.getMembersAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule Members
norm1_Members 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMembersAccess().getGroup(), 1
		); }
		(norm1_Members__Group__0)
		{ after(grammarAccess.getMembersAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ClassExtendsImplements
ruleClassExtendsImplements 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 0
		); }
		(rule__ClassExtendsImplements__Alternatives)
		{ after(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ClassExtendsImplements
norm1_ClassExtendsImplements 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 1
		); }
		(norm1_ClassExtendsImplements__Alternatives)
		{ after(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ClassExtendsClause
ruleClassExtendsClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getClassExtendsClauseAccess().getGroup(), 0
		); }
		(rule__ClassExtendsClause__Group__0)
		{ after(grammarAccess.getClassExtendsClauseAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ClassExtendsClause
norm1_ClassExtendsClause 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getClassExtendsClauseAccess().getGroup(), 1
		); }
		(norm1_ClassExtendsClause__Group__0)
		{ after(grammarAccess.getClassExtendsClauseAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ClassImplementsList
ruleClassImplementsList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getClassImplementsListAccess().getGroup()); }
		(rule__ClassImplementsList__Group__0)
		{ after(grammarAccess.getClassImplementsListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4ClassExpression
entryRuleN4ClassExpression
:
{ before(grammarAccess.getN4ClassExpressionRule()); }
	 ruleN4ClassExpression
{ after(grammarAccess.getN4ClassExpressionRule()); } 
	 EOF 
;

// Rule N4ClassExpression
ruleN4ClassExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4ClassExpressionAccess().getGroup(), 0
		); }
		(rule__N4ClassExpression__Group__0)
		{ after(grammarAccess.getN4ClassExpressionAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule N4ClassExpression
norm1_N4ClassExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4ClassExpressionAccess().getGroup(), 1
		); }
		(norm1_N4ClassExpression__Group__0)
		{ after(grammarAccess.getN4ClassExpressionAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4InterfaceDeclaration
entryRuleN4InterfaceDeclaration
:
{ before(grammarAccess.getN4InterfaceDeclarationRule()); }
	 ruleN4InterfaceDeclaration
{ after(grammarAccess.getN4InterfaceDeclarationRule()); } 
	 EOF 
;

// Rule N4InterfaceDeclaration
ruleN4InterfaceDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4InterfaceDeclarationAccess().getGroup(), 0
		); }
		(rule__N4InterfaceDeclaration__Group__0)
		{ after(grammarAccess.getN4InterfaceDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule InterfaceExtendsList
ruleInterfaceExtendsList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInterfaceExtendsListAccess().getGroup()); }
		(rule__InterfaceExtendsList__Group__0)
		{ after(grammarAccess.getInterfaceExtendsListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4EnumDeclaration
entryRuleN4EnumDeclaration
:
{ before(grammarAccess.getN4EnumDeclarationRule()); }
	 ruleN4EnumDeclaration
{ after(grammarAccess.getN4EnumDeclarationRule()); } 
	 EOF 
;

// Rule N4EnumDeclaration
ruleN4EnumDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4EnumDeclarationAccess().getGroup(), 0
		); }
		(rule__N4EnumDeclaration__Group__0)
		{ after(grammarAccess.getN4EnumDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4EnumLiteral
entryRuleN4EnumLiteral
:
{ before(grammarAccess.getN4EnumLiteralRule()); }
	 ruleN4EnumLiteral
{ after(grammarAccess.getN4EnumLiteralRule()); } 
	 EOF 
;

// Rule N4EnumLiteral
ruleN4EnumLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4EnumLiteralAccess().getGroup()); }
		(rule__N4EnumLiteral__Group__0)
		{ after(grammarAccess.getN4EnumLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4MemberDeclaration
entryRuleN4MemberDeclaration
:
{ before(grammarAccess.getN4MemberDeclarationRule()); }
	 ruleN4MemberDeclaration
{ after(grammarAccess.getN4MemberDeclarationRule()); } 
	 EOF 
;

// Rule N4MemberDeclaration
ruleN4MemberDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 0
		); }
		(rule__N4MemberDeclaration__Alternatives)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule N4MemberDeclaration
norm1_N4MemberDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 1
		); }
		(norm1_N4MemberDeclaration__Alternatives)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotatedN4MemberDeclaration
entryRuleAnnotatedN4MemberDeclaration
:
{ before(grammarAccess.getAnnotatedN4MemberDeclarationRule()); }
	 ruleAnnotatedN4MemberDeclaration
{ after(grammarAccess.getAnnotatedN4MemberDeclarationRule()); } 
	 EOF 
;

// Rule AnnotatedN4MemberDeclaration
ruleAnnotatedN4MemberDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 0
		); }
		(rule__AnnotatedN4MemberDeclaration__Group__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule AnnotatedN4MemberDeclaration
norm1_AnnotatedN4MemberDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 1
		); }
		(norm1_AnnotatedN4MemberDeclaration__Group__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FieldDeclarationImpl
ruleFieldDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 0
		); }
		(rule__FieldDeclarationImpl__Group__0)
		{ after(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule FieldDeclarationImpl
norm1_FieldDeclarationImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 1
		); }
		(norm1_FieldDeclarationImpl__Group__0)
		{ after(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4FieldDeclaration
entryRuleN4FieldDeclaration
:
{ before(grammarAccess.getN4FieldDeclarationRule()); }
	 ruleN4FieldDeclaration
{ after(grammarAccess.getN4FieldDeclarationRule()); } 
	 EOF 
;

// Rule N4FieldDeclaration
ruleN4FieldDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 0
		); }
		(rule__N4FieldDeclaration__Group__0)
		{ after(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule N4FieldDeclaration
norm1_N4FieldDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 1
		); }
		(norm1_N4FieldDeclaration__Group__0)
		{ after(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4MethodDeclaration
entryRuleN4MethodDeclaration
:
{ before(grammarAccess.getN4MethodDeclarationRule()); }
	 ruleN4MethodDeclaration
{ after(grammarAccess.getN4MethodDeclarationRule()); } 
	 EOF 
;

// Rule N4MethodDeclaration
ruleN4MethodDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 0
		); }
		(rule__N4MethodDeclaration__Group__0)
		{ after(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule N4MethodDeclaration
norm1_N4MethodDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 1
		); }
		(norm1_N4MethodDeclaration__Group__0)
		{ after(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4CallableConstructorDeclaration
entryRuleN4CallableConstructorDeclaration
:
{ before(grammarAccess.getN4CallableConstructorDeclarationRule()); }
	 ruleN4CallableConstructorDeclaration
{ after(grammarAccess.getN4CallableConstructorDeclarationRule()); } 
	 EOF 
;

// Rule N4CallableConstructorDeclaration
ruleN4CallableConstructorDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 0
		); }
		(rule__N4CallableConstructorDeclaration__Group__0)
		{ after(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule N4CallableConstructorDeclaration
norm1_N4CallableConstructorDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 1
		); }
		(norm1_N4CallableConstructorDeclaration__Group__0)
		{ after(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule MethodParamsAndBody
ruleMethodParamsAndBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 0
		); }
		(rule__MethodParamsAndBody__Group__0)
		{ after(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule MethodParamsAndBody
norm1_MethodParamsAndBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 1
		); }
		(norm1_MethodParamsAndBody__Group__0)
		{ after(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule MethodParamsReturnAndBody
ruleMethodParamsReturnAndBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 0
		); }
		(rule__MethodParamsReturnAndBody__Group__0)
		{ after(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule MethodParamsReturnAndBody
norm1_MethodParamsReturnAndBody 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 1
		); }
		(norm1_MethodParamsReturnAndBody__Group__0)
		{ after(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4GetterDeclaration
entryRuleN4GetterDeclaration
:
{ before(grammarAccess.getN4GetterDeclarationRule()); }
	 ruleN4GetterDeclaration
{ after(grammarAccess.getN4GetterDeclarationRule()); } 
	 EOF 
;

// Rule N4GetterDeclaration
ruleN4GetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 0
		); }
		(rule__N4GetterDeclaration__Group__0)
		{ after(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule N4GetterDeclaration
norm1_N4GetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 1
		); }
		(norm1_N4GetterDeclaration__Group__0)
		{ after(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule GetterHeader
ruleGetterHeader 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getGetterHeaderAccess().getGroup(), 0
		); }
		(rule__GetterHeader__Group__0)
		{ after(grammarAccess.getGetterHeaderAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule GetterHeader
norm1_GetterHeader 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getGetterHeaderAccess().getGroup(), 1
		); }
		(norm1_GetterHeader__Group__0)
		{ after(grammarAccess.getGetterHeaderAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4SetterDeclaration
entryRuleN4SetterDeclaration
:
{ before(grammarAccess.getN4SetterDeclarationRule()); }
	 ruleN4SetterDeclaration
{ after(grammarAccess.getN4SetterDeclarationRule()); } 
	 EOF 
;

// Rule N4SetterDeclaration
ruleN4SetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 0
		); }
		(rule__N4SetterDeclaration__Group__0)
		{ after(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule N4SetterDeclaration
norm1_N4SetterDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 1
		); }
		(norm1_N4SetterDeclaration__Group__0)
		{ after(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBindingPattern
entryRuleBindingPattern
:
{ before(grammarAccess.getBindingPatternRule()); }
	 ruleBindingPattern
{ after(grammarAccess.getBindingPatternRule()); } 
	 EOF 
;

// Rule BindingPattern
ruleBindingPattern 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingPatternAccess().getAlternatives(), 0
		); }
		(rule__BindingPattern__Alternatives)
		{ after(grammarAccess.getBindingPatternAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingPattern
norm1_BindingPattern 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingPatternAccess().getAlternatives(), 1
		); }
		(norm1_BindingPattern__Alternatives)
		{ after(grammarAccess.getBindingPatternAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleObjectBindingPattern
entryRuleObjectBindingPattern
:
{ before(grammarAccess.getObjectBindingPatternRule()); }
	 ruleObjectBindingPattern
{ after(grammarAccess.getObjectBindingPatternRule()); } 
	 EOF 
;

// Rule ObjectBindingPattern
ruleObjectBindingPattern 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getObjectBindingPatternAccess().getGroup(), 0
		); }
		(rule__ObjectBindingPattern__Group__0)
		{ after(grammarAccess.getObjectBindingPatternAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ObjectBindingPattern
norm1_ObjectBindingPattern 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getObjectBindingPatternAccess().getGroup(), 1
		); }
		(norm1_ObjectBindingPattern__Group__0)
		{ after(grammarAccess.getObjectBindingPatternAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArrayBindingPattern
entryRuleArrayBindingPattern
:
{ before(grammarAccess.getArrayBindingPatternRule()); }
	 ruleArrayBindingPattern
{ after(grammarAccess.getArrayBindingPatternRule()); } 
	 EOF 
;

// Rule ArrayBindingPattern
ruleArrayBindingPattern 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayBindingPatternAccess().getGroup(), 0
		); }
		(rule__ArrayBindingPattern__Group__0)
		{ after(grammarAccess.getArrayBindingPatternAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ArrayBindingPattern
norm1_ArrayBindingPattern 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayBindingPatternAccess().getGroup(), 1
		); }
		(norm1_ArrayBindingPattern__Group__0)
		{ after(grammarAccess.getArrayBindingPatternAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBindingProperty
entryRuleBindingProperty
:
{ before(grammarAccess.getBindingPropertyRule()); }
	 ruleBindingProperty
{ after(grammarAccess.getBindingPropertyRule()); } 
	 EOF 
;

// Rule BindingProperty
ruleBindingProperty 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingPropertyAccess().getAlternatives(), 0
		); }
		(rule__BindingProperty__Alternatives)
		{ after(grammarAccess.getBindingPropertyAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingProperty
norm1_BindingProperty 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingPropertyAccess().getAlternatives(), 1
		); }
		(norm1_BindingProperty__Alternatives)
		{ after(grammarAccess.getBindingPropertyAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSingleNameBinding
entryRuleSingleNameBinding
:
{ before(grammarAccess.getSingleNameBindingRule()); }
	 ruleSingleNameBinding
{ after(grammarAccess.getSingleNameBindingRule()); } 
	 EOF 
;

// Rule SingleNameBinding
ruleSingleNameBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 0
		); }
		(rule__SingleNameBinding__VarDeclAssignment)
		{ after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule SingleNameBinding
norm1_SingleNameBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 1
		); }
		(norm1_SingleNameBinding__VarDeclAssignment)
		{ after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule SingleNameBinding
norm2_SingleNameBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 2
		); }
		(norm2_SingleNameBinding__VarDeclAssignment)
		{ after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 2
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule SingleNameBinding
norm3_SingleNameBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 3
		); }
		(norm3_SingleNameBinding__VarDeclAssignment)
		{ after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 3
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBindingElement
entryRuleBindingElement
:
{ before(grammarAccess.getBindingElementRule()); }
	 ruleBindingElement
{ after(grammarAccess.getBindingElementRule()); } 
	 EOF 
;

// Rule BindingElement
ruleBindingElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 0
		); }
		ruleBindingElementImpl
		{ after(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingElement
norm1_BindingElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 1
		); }
		norm1_BindingElementImpl
		{ after(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBindingRestElement
entryRuleBindingRestElement
:
{ before(grammarAccess.getBindingRestElementRule()); }
	 ruleBindingRestElement
{ after(grammarAccess.getBindingRestElementRule()); } 
	 EOF 
;

// Rule BindingRestElement
ruleBindingRestElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingRestElementAccess().getGroup(), 0
		); }
		(rule__BindingRestElement__Group__0)
		{ after(grammarAccess.getBindingRestElementAccess().getGroup(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingRestElement
norm1_BindingRestElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingRestElementAccess().getGroup(), 1
		); }
		(norm1_BindingRestElement__Group__0)
		{ after(grammarAccess.getBindingRestElementAccess().getGroup(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingElementImpl
ruleBindingElementImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingElementImplAccess().getAlternatives(), 0
		); }
		(rule__BindingElementImpl__Alternatives)
		{ after(grammarAccess.getBindingElementImplAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingElementImpl
norm1_BindingElementImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingElementImplAccess().getAlternatives(), 1
		); }
		(norm1_BindingElementImpl__Alternatives)
		{ after(grammarAccess.getBindingElementImplAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleElision
entryRuleElision
:
{ before(grammarAccess.getElisionRule()); }
	 ruleElision
{ after(grammarAccess.getElisionRule()); } 
	 EOF 
;

// Rule Elision
ruleElision 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getElisionAccess().getGroup()); }
		(rule__Elision__Group__0)
		{ after(grammarAccess.getElisionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralOrComputedPropertyName
entryRuleLiteralOrComputedPropertyName
:
{ before(grammarAccess.getLiteralOrComputedPropertyNameRule()); }
	 ruleLiteralOrComputedPropertyName
{ after(grammarAccess.getLiteralOrComputedPropertyNameRule()); } 
	 EOF 
;

// Rule LiteralOrComputedPropertyName
ruleLiteralOrComputedPropertyName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 0
		); }
		(rule__LiteralOrComputedPropertyName__Alternatives)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule LiteralOrComputedPropertyName
norm1_LiteralOrComputedPropertyName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 1
		); }
		(norm1_LiteralOrComputedPropertyName__Alternatives)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXElement
entryRuleJSXElement
:
{ before(grammarAccess.getJSXElementRule()); }
	 ruleJSXElement
{ after(grammarAccess.getJSXElementRule()); } 
	 EOF 
;

// Rule JSXElement
ruleJSXElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXElementAccess().getGroup()); }
		(rule__JSXElement__Group__0)
		{ after(grammarAccess.getJSXElementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule JSXClosingElement
ruleJSXClosingElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXClosingElementAccess().getGroup()); }
		(rule__JSXClosingElement__Group__0)
		{ after(grammarAccess.getJSXClosingElementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXChild
entryRuleJSXChild
:
{ before(grammarAccess.getJSXChildRule()); }
	 ruleJSXChild
{ after(grammarAccess.getJSXChildRule()); } 
	 EOF 
;

// Rule JSXChild
ruleJSXChild 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXChildAccess().getAlternatives()); }
		(rule__JSXChild__Alternatives)
		{ after(grammarAccess.getJSXChildAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXExpression
entryRuleJSXExpression
:
{ before(grammarAccess.getJSXExpressionRule()); }
	 ruleJSXExpression
{ after(grammarAccess.getJSXExpressionRule()); } 
	 EOF 
;

// Rule JSXExpression
ruleJSXExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXExpressionAccess().getGroup()); }
		(rule__JSXExpression__Group__0)
		{ after(grammarAccess.getJSXExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXElementName
entryRuleJSXElementName
:
{ before(grammarAccess.getJSXElementNameRule()); }
	 ruleJSXElementName
{ after(grammarAccess.getJSXElementNameRule()); } 
	 EOF 
;

// Rule JSXElementName
ruleJSXElementName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXElementNameAccess().getExpressionAssignment()); }
		(rule__JSXElementName__ExpressionAssignment)
		{ after(grammarAccess.getJSXElementNameAccess().getExpressionAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXElementNameExpression
entryRuleJSXElementNameExpression
:
{ before(grammarAccess.getJSXElementNameExpressionRule()); }
	 ruleJSXElementNameExpression
{ after(grammarAccess.getJSXElementNameExpressionRule()); } 
	 EOF 
;

// Rule JSXElementNameExpression
ruleJSXElementNameExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXElementNameExpressionAccess().getGroup()); }
		(rule__JSXElementNameExpression__Group__0)
		{ after(grammarAccess.getJSXElementNameExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule JSXAttributes
ruleJSXAttributes 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXAttributesAccess().getJsxAttributesAssignment()); }
		(rule__JSXAttributes__JsxAttributesAssignment)*
		{ after(grammarAccess.getJSXAttributesAccess().getJsxAttributesAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXAttribute
entryRuleJSXAttribute
:
{ before(grammarAccess.getJSXAttributeRule()); }
	 ruleJSXAttribute
{ after(grammarAccess.getJSXAttributeRule()); } 
	 EOF 
;

// Rule JSXAttribute
ruleJSXAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXAttributeAccess().getAlternatives()); }
		(rule__JSXAttribute__Alternatives)
		{ after(grammarAccess.getJSXAttributeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXSpreadAttribute
entryRuleJSXSpreadAttribute
:
{ before(grammarAccess.getJSXSpreadAttributeRule()); }
	 ruleJSXSpreadAttribute
{ after(grammarAccess.getJSXSpreadAttributeRule()); } 
	 EOF 
;

// Rule JSXSpreadAttribute
ruleJSXSpreadAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXSpreadAttributeAccess().getGroup()); }
		(rule__JSXSpreadAttribute__Group__0)
		{ after(grammarAccess.getJSXSpreadAttributeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleJSXPropertyAttribute
entryRuleJSXPropertyAttribute
:
{ before(grammarAccess.getJSXPropertyAttributeRule()); }
	 ruleJSXPropertyAttribute
{ after(grammarAccess.getJSXPropertyAttributeRule()); } 
	 EOF 
;

// Rule JSXPropertyAttribute
ruleJSXPropertyAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getJSXPropertyAttributeAccess().getGroup()); }
		(rule__JSXPropertyAttribute__Group__0)
		{ after(grammarAccess.getJSXPropertyAttributeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VersionDeclaration
ruleVersionDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVersionDeclarationAccess().getDeclaredVersionAssignment()); }
		(rule__VersionDeclaration__DeclaredVersionAssignment)
		{ after(grammarAccess.getVersionDeclarationAccess().getDeclaredVersionAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeRef
entryRuleTypeRef
:
{ before(grammarAccess.getTypeRefRule()); }
	 ruleTypeRef
{ after(grammarAccess.getTypeRefRule()); } 
	 EOF 
;

// Rule TypeRef
ruleTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeRefAccess().getGroup()); }
		(rule__TypeRef__Group__0)
		{ after(grammarAccess.getTypeRefAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntersectionTypeExpression
entryRuleIntersectionTypeExpression
:
{ before(grammarAccess.getIntersectionTypeExpressionRule()); }
	 ruleIntersectionTypeExpression
{ after(grammarAccess.getIntersectionTypeExpressionRule()); } 
	 EOF 
;

// Rule IntersectionTypeExpression
ruleIntersectionTypeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntersectionTypeExpressionAccess().getGroup()); }
		(rule__IntersectionTypeExpression__Group__0)
		{ after(grammarAccess.getIntersectionTypeExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimaryTypeExpression
entryRulePrimaryTypeExpression
:
{ before(grammarAccess.getPrimaryTypeExpressionRule()); }
	 rulePrimaryTypeExpression
{ after(grammarAccess.getPrimaryTypeExpressionRule()); } 
	 EOF 
;

// Rule PrimaryTypeExpression
rulePrimaryTypeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimaryTypeExpressionAccess().getAlternatives()); }
		(rule__PrimaryTypeExpression__Alternatives)
		{ after(grammarAccess.getPrimaryTypeExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeRefWithModifiers
entryRuleTypeRefWithModifiers
:
{ before(grammarAccess.getTypeRefWithModifiersRule()); }
	 ruleTypeRefWithModifiers
{ after(grammarAccess.getTypeRefWithModifiersRule()); } 
	 EOF 
;

// Rule TypeRefWithModifiers
ruleTypeRefWithModifiers 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeRefWithModifiersAccess().getGroup()); }
		(rule__TypeRefWithModifiers__Group__0)
		{ after(grammarAccess.getTypeRefWithModifiersAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeRefWithoutModifiers
entryRuleTypeRefWithoutModifiers
:
{ before(grammarAccess.getTypeRefWithoutModifiersRule()); }
	 ruleTypeRefWithoutModifiers
{ after(grammarAccess.getTypeRefWithoutModifiersRule()); } 
	 EOF 
;

// Rule TypeRefWithoutModifiers
ruleTypeRefWithoutModifiers 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getAlternatives()); }
		(rule__TypeRefWithoutModifiers__Alternatives)
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeRefFunctionTypeExpression
entryRuleTypeRefFunctionTypeExpression
:
{ before(grammarAccess.getTypeRefFunctionTypeExpressionRule()); }
	 ruleTypeRefFunctionTypeExpression
{ after(grammarAccess.getTypeRefFunctionTypeExpressionRule()); } 
	 EOF 
;

// Rule TypeRefFunctionTypeExpression
ruleTypeRefFunctionTypeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getAlternatives()); }
		(rule__TypeRefFunctionTypeExpression__Alternatives)
		{ after(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeArgInTypeTypeRef
entryRuleTypeArgInTypeTypeRef
:
{ before(grammarAccess.getTypeArgInTypeTypeRefRule()); }
	 ruleTypeArgInTypeTypeRef
{ after(grammarAccess.getTypeArgInTypeTypeRefRule()); } 
	 EOF 
;

// Rule TypeArgInTypeTypeRef
ruleTypeArgInTypeTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeArgInTypeTypeRefAccess().getAlternatives()); }
		(rule__TypeArgInTypeTypeRef__Alternatives)
		{ after(grammarAccess.getTypeArgInTypeTypeRefAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleThisTypeRef
entryRuleThisTypeRef
:
{ before(grammarAccess.getThisTypeRefRule()); }
	 ruleThisTypeRef
{ after(grammarAccess.getThisTypeRefRule()); } 
	 EOF 
;

// Rule ThisTypeRef
ruleThisTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getThisTypeRefAccess().getAlternatives()); }
		(rule__ThisTypeRef__Alternatives)
		{ after(grammarAccess.getThisTypeRefAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleThisTypeRefNominal
entryRuleThisTypeRefNominal
:
{ before(grammarAccess.getThisTypeRefNominalRule()); }
	 ruleThisTypeRefNominal
{ after(grammarAccess.getThisTypeRefNominalRule()); } 
	 EOF 
;

// Rule ThisTypeRefNominal
ruleThisTypeRefNominal 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getThisTypeRefNominalAccess().getGroup()); }
		(rule__ThisTypeRefNominal__Group__0)
		{ after(grammarAccess.getThisTypeRefNominalAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleThisTypeRefStructural
entryRuleThisTypeRefStructural
:
{ before(grammarAccess.getThisTypeRefStructuralRule()); }
	 ruleThisTypeRefStructural
{ after(grammarAccess.getThisTypeRefStructuralRule()); } 
	 EOF 
;

// Rule ThisTypeRefStructural
ruleThisTypeRefStructural 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getThisTypeRefStructuralAccess().getGroup()); }
		(rule__ThisTypeRefStructural__Group__0)
		{ after(grammarAccess.getThisTypeRefStructuralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFunctionTypeExpressionOLD
entryRuleFunctionTypeExpressionOLD
:
{ before(grammarAccess.getFunctionTypeExpressionOLDRule()); }
	 ruleFunctionTypeExpressionOLD
{ after(grammarAccess.getFunctionTypeExpressionOLDRule()); } 
	 EOF 
;

// Rule FunctionTypeExpressionOLD
ruleFunctionTypeExpressionOLD 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup()); }
		(rule__FunctionTypeExpressionOLD__Group__0)
		{ after(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArrowFunctionTypeExpression
entryRuleArrowFunctionTypeExpression
:
{ before(grammarAccess.getArrowFunctionTypeExpressionRule()); }
	 ruleArrowFunctionTypeExpression
{ after(grammarAccess.getArrowFunctionTypeExpressionRule()); } 
	 EOF 
;

// Rule ArrowFunctionTypeExpression
ruleArrowFunctionTypeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrowFunctionTypeExpressionAccess().getGroup()); }
		(rule__ArrowFunctionTypeExpression__Group__0)
		{ after(grammarAccess.getArrowFunctionTypeExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule TAnonymousFormalParameterList
ruleTAnonymousFormalParameterList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTAnonymousFormalParameterListAccess().getGroup()); }
		(rule__TAnonymousFormalParameterList__Group__0)?
		{ after(grammarAccess.getTAnonymousFormalParameterListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTAnonymousFormalParameter
entryRuleTAnonymousFormalParameter
:
{ before(grammarAccess.getTAnonymousFormalParameterRule()); }
	 ruleTAnonymousFormalParameter
{ after(grammarAccess.getTAnonymousFormalParameterRule()); } 
	 EOF 
;

// Rule TAnonymousFormalParameter
ruleTAnonymousFormalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTAnonymousFormalParameterAccess().getGroup()); }
		(rule__TAnonymousFormalParameter__Group__0)
		{ after(grammarAccess.getTAnonymousFormalParameterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule DefaultFormalParameter
ruleDefaultFormalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDefaultFormalParameterAccess().getGroup()); }
		(rule__DefaultFormalParameter__Group__0)?
		{ after(grammarAccess.getDefaultFormalParameterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnionTypeExpressionOLD
entryRuleUnionTypeExpressionOLD
:
{ before(grammarAccess.getUnionTypeExpressionOLDRule()); }
	 ruleUnionTypeExpressionOLD
{ after(grammarAccess.getUnionTypeExpressionOLDRule()); } 
	 EOF 
;

// Rule UnionTypeExpressionOLD
ruleUnionTypeExpressionOLD 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnionTypeExpressionOLDAccess().getGroup()); }
		(rule__UnionTypeExpressionOLD__Group__0)
		{ after(grammarAccess.getUnionTypeExpressionOLDAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntersectionTypeExpressionOLD
entryRuleIntersectionTypeExpressionOLD
:
{ before(grammarAccess.getIntersectionTypeExpressionOLDRule()); }
	 ruleIntersectionTypeExpressionOLD
{ after(grammarAccess.getIntersectionTypeExpressionOLDRule()); } 
	 EOF 
;

// Rule IntersectionTypeExpressionOLD
ruleIntersectionTypeExpressionOLD 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntersectionTypeExpressionOLDAccess().getGroup()); }
		(rule__IntersectionTypeExpressionOLD__Group__0)
		{ after(grammarAccess.getIntersectionTypeExpressionOLDAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterizedTypeRef
entryRuleParameterizedTypeRef
:
{ before(grammarAccess.getParameterizedTypeRefRule()); }
	 ruleParameterizedTypeRef
{ after(grammarAccess.getParameterizedTypeRefRule()); } 
	 EOF 
;

// Rule ParameterizedTypeRef
ruleParameterizedTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterizedTypeRefAccess().getAlternatives()); }
		(rule__ParameterizedTypeRef__Alternatives)
		{ after(grammarAccess.getParameterizedTypeRefAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterizedTypeRefNominal
entryRuleParameterizedTypeRefNominal
:
{ before(grammarAccess.getParameterizedTypeRefNominalRule()); }
	 ruleParameterizedTypeRefNominal
{ after(grammarAccess.getParameterizedTypeRefNominalRule()); } 
	 EOF 
;

// Rule ParameterizedTypeRefNominal
ruleParameterizedTypeRefNominal 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup()); }
		(rule__ParameterizedTypeRefNominal__Group__0)
		{ after(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterizedTypeRefStructural
entryRuleParameterizedTypeRefStructural
:
{ before(grammarAccess.getParameterizedTypeRefStructuralRule()); }
	 ruleParameterizedTypeRefStructural
{ after(grammarAccess.getParameterizedTypeRefStructuralRule()); } 
	 EOF 
;

// Rule ParameterizedTypeRefStructural
ruleParameterizedTypeRefStructural 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup()); }
		(rule__ParameterizedTypeRefStructural__Group__0)
		{ after(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArrayTypeRef
entryRuleArrayTypeRef
:
{ before(grammarAccess.getArrayTypeRefRule()); }
	 ruleArrayTypeRef
{ after(grammarAccess.getArrayTypeRefRule()); } 
	 EOF 
;

// Rule ArrayTypeRef
ruleArrayTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArrayTypeRefAccess().getGroup()); }
		(rule__ArrayTypeRef__Group__0)
		{ after(grammarAccess.getArrayTypeRefAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule VersionRequest
ruleVersionRequest 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVersionRequestAccess().getRequestedVersionAssignment()); }
		(rule__VersionRequest__RequestedVersionAssignment)
		{ after(grammarAccess.getVersionRequestAccess().getRequestedVersionAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule TypeArguments
ruleTypeArguments 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeArgumentsAccess().getGroup()); }
		(rule__TypeArguments__Group__0)
		{ after(grammarAccess.getTypeArgumentsAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule TStructMemberList
ruleTStructMemberList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTStructMemberListAccess().getGroup()); }
		(rule__TStructMemberList__Group__0)
		{ after(grammarAccess.getTStructMemberListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTStructMember
entryRuleTStructMember
:
{ before(grammarAccess.getTStructMemberRule()); }
	 ruleTStructMember
{ after(grammarAccess.getTStructMemberRule()); } 
	 EOF 
;

// Rule TStructMember
ruleTStructMember 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTStructMemberAccess().getAlternatives()); }
		(rule__TStructMember__Alternatives)
		{ after(grammarAccess.getTStructMemberAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTStructMethod
entryRuleTStructMethod
:
{ before(grammarAccess.getTStructMethodRule()); }
	 ruleTStructMethod
{ after(grammarAccess.getTStructMethodRule()); } 
	 EOF 
;

// Rule TStructMethod
ruleTStructMethod 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTStructMethodAccess().getGroup()); }
		(rule__TStructMethod__Group__0)
		{ after(grammarAccess.getTStructMethodAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule TypeVariables
ruleTypeVariables 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeVariablesAccess().getGroup()); }
		(rule__TypeVariables__Group__0)
		{ after(grammarAccess.getTypeVariablesAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ColonSepDeclaredTypeRef
ruleColonSepDeclaredTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getColonSepDeclaredTypeRefAccess().getGroup()); }
		(rule__ColonSepDeclaredTypeRef__Group__0)
		{ after(grammarAccess.getColonSepDeclaredTypeRefAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ColonSepTypeRef
ruleColonSepTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getColonSepTypeRefAccess().getGroup()); }
		(rule__ColonSepTypeRef__Group__0)
		{ after(grammarAccess.getColonSepTypeRefAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule ColonSepReturnTypeRef
ruleColonSepReturnTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getColonSepReturnTypeRefAccess().getGroup()); }
		(rule__ColonSepReturnTypeRef__Group__0)
		{ after(grammarAccess.getColonSepReturnTypeRefAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTStructField
entryRuleTStructField
:
{ before(grammarAccess.getTStructFieldRule()); }
	 ruleTStructField
{ after(grammarAccess.getTStructFieldRule()); } 
	 EOF 
;

// Rule TStructField
ruleTStructField 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTStructFieldAccess().getGroup()); }
		(rule__TStructField__Group__0)
		{ after(grammarAccess.getTStructFieldAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTStructGetter
entryRuleTStructGetter
:
{ before(grammarAccess.getTStructGetterRule()); }
	 ruleTStructGetter
{ after(grammarAccess.getTStructGetterRule()); } 
	 EOF 
;

// Rule TStructGetter
ruleTStructGetter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTStructGetterAccess().getGroup()); }
		(rule__TStructGetter__Group__0)
		{ after(grammarAccess.getTStructGetterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTStructSetter
entryRuleTStructSetter
:
{ before(grammarAccess.getTStructSetterRule()); }
	 ruleTStructSetter
{ after(grammarAccess.getTStructSetterRule()); } 
	 EOF 
;

// Rule TStructSetter
ruleTStructSetter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTStructSetterAccess().getGroup()); }
		(rule__TStructSetter__Group__0)
		{ after(grammarAccess.getTStructSetterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypingStrategyUseSiteOperator
entryRuleTypingStrategyUseSiteOperator
:
{ before(grammarAccess.getTypingStrategyUseSiteOperatorRule()); }
	 ruleTypingStrategyUseSiteOperator
{ after(grammarAccess.getTypingStrategyUseSiteOperatorRule()); } 
	 EOF 
;

// Rule TypingStrategyUseSiteOperator
ruleTypingStrategyUseSiteOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getGroup()); }
		(rule__TypingStrategyUseSiteOperator__Group__0)
		{ after(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypingStrategyDefSiteOperator
entryRuleTypingStrategyDefSiteOperator
:
{ before(grammarAccess.getTypingStrategyDefSiteOperatorRule()); }
	 ruleTypingStrategyDefSiteOperator
{ after(grammarAccess.getTypingStrategyDefSiteOperatorRule()); } 
	 EOF 
;

// Rule TypingStrategyDefSiteOperator
ruleTypingStrategyDefSiteOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypingStrategyDefSiteOperatorAccess().getTildeKeyword()); }
		Tilde
		{ after(grammarAccess.getTypingStrategyDefSiteOperatorAccess().getTildeKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeTypeRef
entryRuleTypeTypeRef
:
{ before(grammarAccess.getTypeTypeRefRule()); }
	 ruleTypeTypeRef
{ after(grammarAccess.getTypeTypeRefRule()); } 
	 EOF 
;

// Rule TypeTypeRef
ruleTypeTypeRef 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeTypeRefAccess().getGroup()); }
		(rule__TypeTypeRef__Group__0)
		{ after(grammarAccess.getTypeTypeRefAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeArgument
entryRuleTypeArgument
:
{ before(grammarAccess.getTypeArgumentRule()); }
	 ruleTypeArgument
{ after(grammarAccess.getTypeArgumentRule()); } 
	 EOF 
;

// Rule TypeArgument
ruleTypeArgument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeArgumentAccess().getAlternatives()); }
		(rule__TypeArgument__Alternatives)
		{ after(grammarAccess.getTypeArgumentAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleWildcard
entryRuleWildcard
:
{ before(grammarAccess.getWildcardRule()); }
	 ruleWildcard
{ after(grammarAccess.getWildcardRule()); } 
	 EOF 
;

// Rule Wildcard
ruleWildcard 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getWildcardAccess().getGroup()); }
		(rule__Wildcard__Group__0)
		{ after(grammarAccess.getWildcardAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleWildcardNewNotation
entryRuleWildcardNewNotation
:
{ before(grammarAccess.getWildcardNewNotationRule()); }
	 ruleWildcardNewNotation
{ after(grammarAccess.getWildcardNewNotationRule()); } 
	 EOF 
;

// Rule WildcardNewNotation
ruleWildcardNewNotation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getWildcardNewNotationAccess().getAlternatives()); }
		(rule__WildcardNewNotation__Alternatives)
		{ after(grammarAccess.getWildcardNewNotationAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBindingIdentifier
entryRuleBindingIdentifier
:
{ before(grammarAccess.getBindingIdentifierRule()); }
	 ruleBindingIdentifier
{ after(grammarAccess.getBindingIdentifierRule()); } 
	 EOF 
;

// Rule BindingIdentifier
ruleBindingIdentifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 0
		); }
		(rule__BindingIdentifier__Alternatives)
		{ after(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 0
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}


// Rule BindingIdentifier
norm1_BindingIdentifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 1
		); }
		(norm1_BindingIdentifier__Alternatives)
		{ after(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 1
		); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIdentifierName
entryRuleIdentifierName
:
{ before(grammarAccess.getIdentifierNameRule()); }
	 ruleIdentifierName
{ after(grammarAccess.getIdentifierNameRule()); } 
	 EOF 
;

// Rule IdentifierName
ruleIdentifierName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIdentifierNameAccess().getAlternatives()); }
		(rule__IdentifierName__Alternatives)
		{ after(grammarAccess.getIdentifierNameAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReservedWord
entryRuleReservedWord
:
{ before(grammarAccess.getReservedWordRule()); }
	 ruleReservedWord
{ after(grammarAccess.getReservedWordRule()); } 
	 EOF 
;

// Rule ReservedWord
ruleReservedWord 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReservedWordAccess().getAlternatives()); }
		(rule__ReservedWord__Alternatives)
		{ after(grammarAccess.getReservedWordAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleN4Keyword
entryRuleN4Keyword
:
{ before(grammarAccess.getN4KeywordRule()); }
	 ruleN4Keyword
{ after(grammarAccess.getN4KeywordRule()); } 
	 EOF 
;

// Rule N4Keyword
ruleN4Keyword 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getN4KeywordAccess().getAlternatives()); }
		(rule__N4Keyword__Alternatives)
		{ after(grammarAccess.getN4KeywordAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule VariableStatementKeyword
ruleVariableStatementKeyword
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableStatementKeywordAccess().getAlternatives()); }
		(rule__VariableStatementKeyword__Alternatives)
		{ after(grammarAccess.getVariableStatementKeywordAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PostfixOperator
rulePostfixOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostfixOperatorAccess().getAlternatives()); }
		(rule__PostfixOperator__Alternatives)
		{ after(grammarAccess.getPostfixOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule UnaryOperator
ruleUnaryOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getAlternatives()); }
		(rule__UnaryOperator__Alternatives)
		{ after(grammarAccess.getUnaryOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule MultiplicativeOperator
ruleMultiplicativeOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); }
		(rule__MultiplicativeOperator__Alternatives)
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule AdditiveOperator
ruleAdditiveOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); }
		(rule__AdditiveOperator__Alternatives)
		{ after(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule EqualityOperator
ruleEqualityOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getAlternatives()); }
		(rule__EqualityOperator__Alternatives)
		{ after(grammarAccess.getEqualityOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule N4Modifier
ruleN4Modifier
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getN4ModifierAccess().getAlternatives()); }
		(rule__N4Modifier__Alternatives)
		{ after(grammarAccess.getN4ModifierAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Script__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getScriptAccess().getAnnotationsAssignment_1_0()); }
		(rule__Script__AnnotationsAssignment_1_0)
		{ after(grammarAccess.getScriptAccess().getAnnotationsAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getScriptAccess().getScriptElementsAssignment_1_1()); }
		(rule__Script__ScriptElementsAssignment_1_1)
		{ after(grammarAccess.getScriptAccess().getScriptElementsAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ScriptElement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getScriptElementAccess().getAnnotatedScriptElementParserRuleCall_0()); }
		(ruleAnnotatedScriptElement)
		{ after(grammarAccess.getScriptElementAccess().getAnnotatedScriptElementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getScriptElementAccess().getN4ClassDeclarationParserRuleCall_1()); }
		(ruleN4ClassDeclaration)
		{ after(grammarAccess.getScriptElementAccess().getN4ClassDeclarationParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getScriptElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); }
		(ruleN4InterfaceDeclaration)
		{ after(grammarAccess.getScriptElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getScriptElementAccess().getN4EnumDeclarationParserRuleCall_3()); }
		(ruleN4EnumDeclaration)
		{ after(grammarAccess.getScriptElementAccess().getN4EnumDeclarationParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getScriptElementAccess().getImportDeclarationParserRuleCall_4()); }
		ruleImportDeclaration
		{ after(grammarAccess.getScriptElementAccess().getImportDeclarationParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getScriptElementAccess().getExportDeclarationParserRuleCall_5()); }
		ruleExportDeclaration
		{ after(grammarAccess.getScriptElementAccess().getExportDeclarationParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getScriptElementAccess().getRootStatementParserRuleCall_6()); }
		ruleRootStatement
		{ after(grammarAccess.getScriptElementAccess().getRootStatementParserRuleCall_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_0()); }
		(rule__AnnotatedScriptElement__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_1()); }
		(rule__AnnotatedScriptElement__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2()); }
		(rule__AnnotatedScriptElement__Group_1_2__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3()); }
		(rule__AnnotatedScriptElement__Group_1_3__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4()); }
		(rule__AnnotatedScriptElement__Group_1_4__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Alternatives_1_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_0()); }
		(rule__AnnotatedScriptElement__Group_1_3_0_0__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_1()); }
		(rule__AnnotatedScriptElement__Group_1_3_0_1__0)
		{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_0()); }
		(rule__ExportDeclarationImpl__Group_1_0__0)
		{ after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_1()); }
		(rule__ExportDeclarationImpl__Group_1_1__0)
		{ after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_2()); }
		(rule__ExportDeclarationImpl__ExportedElementAssignment_1_2)
		{ after(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3()); }
		(rule__ExportDeclarationImpl__Group_1_3__0)
		{ after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Alternatives_1_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_3_1_0()); }
		(rule__ExportDeclarationImpl__ExportedElementAssignment_1_3_1_0)
		{ after(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3_1_1()); }
		(rule__ExportDeclarationImpl__Group_1_3_1_1__0)
		{ after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportableElement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExportableElementAccess().getAnnotatedExportableElementParserRuleCall_0()); }
		(ruleAnnotatedExportableElement)
		{ after(grammarAccess.getExportableElementAccess().getAnnotatedExportableElementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getExportableElementAccess().getN4ClassDeclarationParserRuleCall_1()); }
		(ruleN4ClassDeclaration)
		{ after(grammarAccess.getExportableElementAccess().getN4ClassDeclarationParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getExportableElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); }
		(ruleN4InterfaceDeclaration)
		{ after(grammarAccess.getExportableElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getExportableElementAccess().getN4EnumDeclarationParserRuleCall_3()); }
		(ruleN4EnumDeclaration)
		{ after(grammarAccess.getExportableElementAccess().getN4EnumDeclarationParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getExportableElementAccess().getFunctionDeclarationParserRuleCall_4()); }
		(ruleFunctionDeclaration)
		{ after(grammarAccess.getExportableElementAccess().getFunctionDeclarationParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getExportableElementAccess().getExportedVariableStatementParserRuleCall_5()); }
		ruleExportedVariableStatement
		{ after(grammarAccess.getExportableElementAccess().getExportedVariableStatementParserRuleCall_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_0()); }
		(rule__AnnotatedExportableElement__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1()); }
		(rule__AnnotatedExportableElement__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2()); }
		(rule__AnnotatedExportableElement__Group_1_2__0)
		{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3()); }
		(rule__AnnotatedExportableElement__Group_1_3__0)
		{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Alternatives_1_2_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_0()); }
		(rule__AnnotatedExportableElement__Group_1_2_0_0__0)
		{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_1()); }
		(rule__AnnotatedExportableElement__Group_1_2_0_1__0)
		{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportClause__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getImportClauseAccess().getGroup_0()); }
		(rule__ImportClause__Group_0__0)
		{ after(grammarAccess.getImportClauseAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_1()); }
		ruleImportSpecifiersExceptDefault
		{ after(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_0()); }
		(rule__ImportSpecifiersExceptDefault__ImportSpecifiersAssignment_0)
		{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1()); }
		(rule__ImportSpecifiersExceptDefault__Group_1__0)
		{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamedImportSpecifier__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_0()); }
		(rule__NamedImportSpecifier__ImportedElementAssignment_0)
		{ after(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getNamedImportSpecifierAccess().getGroup_1()); }
		(rule__NamedImportSpecifier__Group_1__0)
		{ after(grammarAccess.getNamedImportSpecifierAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup_1_0()); }
		(rule__FunctionImpl__Group_1_0__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup_1_1()); }
		(rule__FunctionImpl__Group_1_1__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup_1_0()); }
		(norm3_FunctionImpl__Group_1_0__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup_1_1()); }
		(norm3_FunctionImpl__Group_1_1__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup_1_0()); }
		(norm6_FunctionImpl__Group_1_0__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getFunctionImplAccess().getGroup_1_1()); }
		(norm6_FunctionImpl__Group_1_1__0)
		{ after(grammarAccess.getFunctionImplAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Alternatives_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
		(rule__ArrowExpression__Group_0_0_0_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
		(rule__ArrowExpression__Group_0_0_0_1__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
		(rule__ArrowExpression__FparsAssignment_0_0_0_2)
		{ after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
		(rule__ArrowExpression__Group_1_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
		(rule__ArrowExpression__BodyAssignment_1_1)
		{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Alternatives_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
		(norm1_ArrowExpression__Group_0_0_0_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
		(norm1_ArrowExpression__Group_0_0_0_1__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
		(norm1_ArrowExpression__FparsAssignment_0_0_0_2)
		{ after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
		(norm1_ArrowExpression__Group_1_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
		(norm1_ArrowExpression__BodyAssignment_1_1)
		{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Alternatives_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
		(norm2_ArrowExpression__Group_0_0_0_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
		(norm2_ArrowExpression__Group_0_0_0_1__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
		(norm2_ArrowExpression__FparsAssignment_0_0_0_2)
		{ after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
		(norm2_ArrowExpression__Group_1_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
		(norm2_ArrowExpression__BodyAssignment_1_1)
		{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Alternatives_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
		(norm3_ArrowExpression__Group_0_0_0_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
		(norm3_ArrowExpression__Group_0_0_0_1__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
		(norm3_ArrowExpression__FparsAssignment_0_0_0_2)
		{ after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
		(norm3_ArrowExpression__Group_1_0__0)
		{ after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
		(norm3_ArrowExpression__BodyAssignment_1_1)
		{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); }
		(rule__AnnotatedExpression__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); }
		(rule__AnnotatedExpression__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); }
		(norm1_AnnotatedExpression__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); }
		(norm1_AnnotatedExpression__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeVariableAccess().getDeclaredCovariantAssignment_0_0()); }
		(rule__TypeVariable__DeclaredCovariantAssignment_0_0)
		{ after(grammarAccess.getTypeVariableAccess().getDeclaredCovariantAssignment_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeVariableAccess().getDeclaredContravariantAssignment_0_1()); }
		(rule__TypeVariable__DeclaredContravariantAssignment_0_1)
		{ after(grammarAccess.getTypeVariableAccess().getDeclaredContravariantAssignment_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); }
		(rule__BindingElementFragment__BindingPatternAssignment_0_0)
		{ after(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); }
		(rule__BindingElementFragment__Group_0_1__0)
		{ after(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); }
		(norm1_BindingElementFragment__BindingPatternAssignment_0_0)
		{ after(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); }
		(norm1_BindingElementFragment__Group_0_1__0)
		{ after(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RootStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); }
		(ruleBlock)
		{ after(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); }
		(ruleFunctionDeclaration)
		{ after(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); }
		(norm1_VariableStatement)
		{ after(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); }
		ruleEmptyStatement
		{ after(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); }
		(ruleLabelledStatement)
		{ after(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); }
		ruleExpressionStatement
		{ after(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); }
		ruleIfStatement
		{ after(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); }
		ruleIterationStatement
		{ after(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); }
		ruleContinueStatement
		{ after(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); }
		ruleBreakStatement
		{ after(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); }
		ruleReturnStatement
		{ after(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); }
		ruleWithStatement
		{ after(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); }
		ruleSwitchStatement
		{ after(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); }
		ruleThrowStatement
		{ after(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); }
		ruleTryStatement
		{ after(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); }
		ruleDebuggerStatement
		{ after(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_RootStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); }
		(norm1_Block)
		{ after(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); }
		(norm1_FunctionDeclaration)
		{ after(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); }
		(norm3_VariableStatement)
		{ after(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); }
		ruleEmptyStatement
		{ after(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); }
		(norm1_LabelledStatement)
		{ after(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); }
		norm1_ExpressionStatement
		{ after(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); }
		norm1_IfStatement
		{ after(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); }
		norm1_IterationStatement
		{ after(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); }
		norm1_ContinueStatement
		{ after(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); }
		norm1_BreakStatement
		{ after(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); }
		norm1_ReturnStatement
		{ after(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); }
		norm1_WithStatement
		{ after(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); }
		norm1_SwitchStatement
		{ after(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); }
		norm1_ThrowStatement
		{ after(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); }
		norm1_TryStatement
		{ after(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); }
	)
	|
	(
		{ before(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); }
		ruleDebuggerStatement
		{ after(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); }
		(ruleAnnotatedFunctionDeclaration)
		{ after(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); }
		ruleRootStatement
		{ after(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_Statement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); }
		(norm1_AnnotatedFunctionDeclaration)
		{ after(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); }
		norm1_RootStatement
		{ after(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
		(ruleVariableBinding)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
		norm4_VariableDeclaration
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
		(norm1_VariableBinding)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
		norm5_VariableDeclaration
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
		(norm2_VariableBinding)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
		norm6_VariableDeclaration
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
		(norm3_VariableBinding)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
		norm7_VariableDeclaration
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
		(norm4_VariableBinding)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
		norm4_VariableDeclaration
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
		(norm6_VariableBinding)
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
		norm6_VariableDeclaration
		{ after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); }
		(ruleExportedVariableBinding)
		{ after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); }
		ruleExportedVariableDeclaration
		{ after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableDeclarationOrBinding__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); }
		(norm1_ExportedVariableBinding)
		{ after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); }
		norm1_ExportedVariableDeclaration
		{ after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IterationStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); }
		ruleDoStatement
		{ after(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); }
		ruleWhileStatement
		{ after(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); }
		ruleForStatement
		{ after(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IterationStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); }
		norm1_DoStatement
		{ after(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); }
		norm1_WhileStatement
		{ after(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); }
		norm1_ForStatement
		{ after(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_0()); }
		(rule__ForStatement__Group_3_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1()); }
		(rule__ForStatement__Group_3_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Alternatives_3_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); }
		(rule__ForStatement__Group_3_1_0_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); }
		(rule__ForStatement__Group_3_1_0_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); }
		(rule__ForStatement__Group_3_1_0_2__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Alternatives_3_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); }
		(rule__ForStatement__Group_3_1_0_0_1_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); }
		(rule__ForStatement__Group_3_1_0_0_1_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Alternatives_3_1_0_0_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); }
		(rule__ForStatement__ForInAssignment_3_1_0_0_1_0_0_1_0)
		{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); }
		(rule__ForStatement__ForOfAssignment_3_1_0_0_1_0_0_1_1)
		{ after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Alternatives_3_1_0_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); }
		(rule__ForStatement__Group_3_1_0_0_1_1_1_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); }
		(rule__ForStatement__Group_3_1_0_0_1_1_1_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); }
		(rule__ForStatement__Group_3_1_0_0_1_1_1_2__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Alternatives_3_1_0_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); }
		(rule__ForStatement__Group_3_1_0_1_1_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); }
		(rule__ForStatement__Group_3_1_0_1_1_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); }
		(rule__ForStatement__Group_3_1_0_1_1_2__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_0()); }
		(norm1_ForStatement__Group_3_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1()); }
		(norm1_ForStatement__Group_3_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Alternatives_3_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); }
		(norm1_ForStatement__Group_3_1_0_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); }
		(norm1_ForStatement__Group_3_1_0_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); }
		(norm1_ForStatement__Group_3_1_0_2__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Alternatives_3_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); }
		(norm1_ForStatement__Group_3_1_0_0_1_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); }
		(norm1_ForStatement__Group_3_1_0_0_1_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Alternatives_3_1_0_0_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); }
		(norm1_ForStatement__ForInAssignment_3_1_0_0_1_0_0_1_0)
		{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); }
		(norm1_ForStatement__ForOfAssignment_3_1_0_0_1_0_0_1_1)
		{ after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Alternatives_3_1_0_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); }
		(norm1_ForStatement__Group_3_1_0_0_1_1_1_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); }
		(norm1_ForStatement__Group_3_1_0_0_1_1_1_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); }
		(norm1_ForStatement__Group_3_1_0_0_1_1_1_2__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Alternatives_3_1_0_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); }
		(norm1_ForStatement__Group_3_1_0_1_1_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); }
		(norm1_ForStatement__Group_3_1_0_1_1_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); }
		(norm1_ForStatement__Group_3_1_0_1_1_2__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTryStatementAccess().getGroup_2_0()); }
		(rule__TryStatement__Group_2_0__0)
		{ after(grammarAccess.getTryStatementAccess().getGroup_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); }
		(rule__TryStatement__FinallyAssignment_2_1)
		{ after(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTryStatementAccess().getGroup_2_0()); }
		(norm1_TryStatement__Group_2_0__0)
		{ after(grammarAccess.getTryStatementAccess().getGroup_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); }
		(norm1_TryStatement__FinallyAssignment_2_1)
		{ after(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); }
		(rule__CatchVariable__BindingPatternAssignment_0)
		{ after(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getCatchVariableAccess().getGroup_1()); }
		(rule__CatchVariable__Group_1__0)
		{ after(grammarAccess.getCatchVariableAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getCatchVariableAccess().getGroup_2()); }
		(rule__CatchVariable__Group_2__0)
		{ after(grammarAccess.getCatchVariableAccess().getGroup_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); }
		(norm1_CatchVariable__BindingPatternAssignment_0)
		{ after(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getCatchVariableAccess().getGroup_1()); }
		(norm1_CatchVariable__Group_1__0)
		{ after(grammarAccess.getCatchVariableAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getCatchVariableAccess().getGroup_2()); }
		(norm1_CatchVariable__Group_2__0)
		{ after(grammarAccess.getCatchVariableAccess().getGroup_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); }
		ruleThisLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); }
		ruleSuperLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); }
		ruleIdentifierRef
		{ after(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_3()); }
		ruleJSXElement
		{ after(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_4()); }
		ruleParameterizedCallExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_5()); }
		ruleLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_6()); }
		ruleArrayLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_7()); }
		ruleObjectLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_8()); }
		ruleParenExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_9()); }
		ruleAnnotatedExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_9()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_10()); }
		ruleFunctionExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_10()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_11()); }
		(ruleAsyncFunctionExpression)
		{ after(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_11()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_12()); }
		ruleN4ClassExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_12()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_13()); }
		ruleTemplateLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_13()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PrimaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); }
		ruleThisLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); }
		ruleSuperLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); }
		norm1_IdentifierRef
		{ after(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_3()); }
		ruleJSXElement
		{ after(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_4()); }
		norm1_ParameterizedCallExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_5()); }
		ruleLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_6()); }
		norm1_ArrayLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_7()); }
		norm1_ObjectLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_8()); }
		norm1_ParenExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_9()); }
		norm1_AnnotatedExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_9()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_10()); }
		ruleFunctionExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_10()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_11()); }
		(ruleAsyncFunctionExpression)
		{ after(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_11()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_12()); }
		norm1_N4ClassExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_12()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_13()); }
		norm1_TemplateLiteral
		{ after(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_13()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierRef__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); }
		(rule__IdentifierRef__IdAssignment_0)
		{ after(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getIdentifierRefAccess().getGroup_1()); }
		(rule__IdentifierRef__Group_1__0)
		{ after(grammarAccess.getIdentifierRefAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IdentifierRef__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); }
		(norm1_IdentifierRef__IdAssignment_0)
		{ after(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getIdentifierRefAccess().getGroup_1()); }
		(norm1_IdentifierRef__Group_1__0)
		{ after(grammarAccess.getIdentifierRefAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyAssignment__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); }
		ruleAnnotatedPropertyAssignment
		{ after(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); }
		(rulePropertyNameValuePair)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); }
		(rulePropertyGetterDeclaration)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); }
		(rulePropertySetterDeclaration)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); }
		(rulePropertyMethodDeclaration)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); }
		rulePropertyNameValuePairSingleName
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyAssignment__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); }
		norm1_AnnotatedPropertyAssignment
		{ after(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); }
		(norm1_PropertyNameValuePair)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); }
		(norm1_PropertyGetterDeclaration)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); }
		(norm1_PropertySetterDeclaration)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); }
		(norm1_PropertyMethodDeclaration)
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); }
		norm1_PropertyNameValuePairSingleName
		{ after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); }
		(rule__AnnotatedPropertyAssignment__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); }
		(rule__AnnotatedPropertyAssignment__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); }
		(rule__AnnotatedPropertyAssignment__Group_1_2__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); }
		(rule__AnnotatedPropertyAssignment__Group_1_3__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); }
		(rule__AnnotatedPropertyAssignment__Group_1_4__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Alternatives_1_3_0_0_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); }
		(rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); }
		(rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); }
		(norm1_AnnotatedPropertyAssignment__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); }
		(norm1_AnnotatedPropertyAssignment__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); }
		(norm1_AnnotatedPropertyAssignment__Group_1_2__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); }
		(norm1_AnnotatedPropertyAssignment__Group_1_3__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); }
		(norm1_AnnotatedPropertyAssignment__Group_1_4__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Alternatives_1_3_0_0_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); }
		(norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); }
		(norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0)
		{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Alternatives_0_0_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); }
		(rule__PropertyMethodDeclaration__Group_0_0_3_0__0)
		{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); }
		(rule__PropertyMethodDeclaration__Group_0_0_3_1__0)
		{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Alternatives_0_0_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); }
		(norm1_PropertyMethodDeclaration__Group_0_0_3_0__0)
		{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); }
		(norm1_PropertyMethodDeclaration__Group_0_0_3_1__0)
		{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Alternatives_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); }
		(rule__LeftHandSideExpression__Group_1_2_0__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); }
		(rule__LeftHandSideExpression__Group_1_2_1__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); }
	)
	|
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); }
		(rule__LeftHandSideExpression__Group_1_2_2__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); }
	)
	|
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); }
		(rule__LeftHandSideExpression__Group_1_2_3__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Alternatives_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); }
		(norm1_LeftHandSideExpression__Group_1_2_0__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); }
		(norm1_LeftHandSideExpression__Group_1_2_1__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); }
	)
	|
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); }
		(norm1_LeftHandSideExpression__Group_1_2_2__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); }
	)
	|
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); }
		(norm1_LeftHandSideExpression__Group_1_2_3__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_0()); }
		(rule__MemberExpression__Group_0__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1()); }
		(rule__MemberExpression__Group_1__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2()); }
		(rule__MemberExpression__Group_2__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Alternatives_1_3_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); }
		(rule__MemberExpression__Group_1_3_3_0__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); }
		(rule__MemberExpression__Group_1_3_3_1__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); }
		(rule__MemberExpression__Group_1_3_3_2__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Alternatives_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); }
		(rule__MemberExpression__Group_2_1_0__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); }
		(rule__MemberExpression__Group_2_1_1__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); }
		(rule__MemberExpression__Group_2_1_2__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_0()); }
		(norm1_MemberExpression__Group_0__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1()); }
		(norm1_MemberExpression__Group_1__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2()); }
		(norm1_MemberExpression__Group_2__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Alternatives_1_3_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); }
		(norm1_MemberExpression__Group_1_3_3_0__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); }
		(norm1_MemberExpression__Group_1_3_3_1__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); }
		(norm1_MemberExpression__Group_1_3_3_2__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Alternatives_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); }
		(norm1_MemberExpression__Group_2_1_0__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); }
		(norm1_MemberExpression__Group_2_1_1__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); }
		(norm1_MemberExpression__Group_2_1_2__0)
		{ after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); }
		ruleCastExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getGroup_1()); }
		(rule__UnaryExpression__Group_1__0)
		{ after(grammarAccess.getUnaryExpressionAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_UnaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); }
		norm1_CastExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getGroup_1()); }
		(norm1_UnaryExpression__Group_1__0)
		{ after(grammarAccess.getUnaryExpressionAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftOperatorAccess().getGroup_0()); }
		(rule__ShiftOperator__Group_0__0)
		{ after(grammarAccess.getShiftOperatorAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getShiftOperatorAccess().getLessThanSignLessThanSignKeyword_1()); }
		LessThanSignLessThanSign
		{ after(grammarAccess.getShiftOperatorAccess().getLessThanSignLessThanSignKeyword_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RelationalOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); }
		LessThanSign
		{ after(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGroup_1()); }
		(rule__RelationalOperator__Group_1__0)
		{ after(grammarAccess.getRelationalOperatorAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); }
		LessThanSignEqualsSign
		{ after(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); }
		Instanceof
		{ after(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_RelationalOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); }
		LessThanSign
		{ after(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGroup_1()); }
		(norm1_RelationalOperator__Group_1__0)
		{ after(grammarAccess.getRelationalOperatorAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); }
		LessThanSignEqualsSign
		{ after(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); }
		Instanceof
		{ after(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getInKeyword_4_0()); }
		In
		{ after(grammarAccess.getRelationalOperatorAccess().getInKeyword_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
		(ruleAwaitExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
		(rulePromisifyExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
		(ruleArrowExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
		(rule__AssignmentExpression__Group_4__0)
		{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AssignmentExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
		(norm1_AwaitExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
		(norm1_PromisifyExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
		(norm1_ArrowExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
		(norm1_AssignmentExpression__Group_4__0)
		{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm2_AssignmentExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
		(norm2_AwaitExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
		(norm2_PromisifyExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
		(norm2_ArrowExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); }
		ruleYieldExpression
		{ after(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
		(norm2_AssignmentExpression__Group_4__0)
		{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm3_AssignmentExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
		(norm3_AwaitExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
		(norm3_PromisifyExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
		(norm3_ArrowExpression)
		{ after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); }
		norm1_YieldExpression
		{ after(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
		(norm3_AssignmentExpression__Group_4__0)
		{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getEqualsSignKeyword_0()); }
		EqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getEqualsSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAsteriskEqualsSignKeyword_1()); }
		AsteriskEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getAsteriskEqualsSignKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getSolidusEqualsSignKeyword_2()); }
		SolidusEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getSolidusEqualsSignKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getPercentSignEqualsSignKeyword_3()); }
		PercentSignEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getPercentSignEqualsSignKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getPlusSignEqualsSignKeyword_4()); }
		PlusSignEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getPlusSignEqualsSignKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getHyphenMinusEqualsSignKeyword_5()); }
		HyphenMinusEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getHyphenMinusEqualsSignKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getLessThanSignLessThanSignEqualsSignKeyword_6()); }
		LessThanSignLessThanSignEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getLessThanSignLessThanSignEqualsSignKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getGroup_7()); }
		(rule__AssignmentOperator__Group_7__0)
		{ after(grammarAccess.getAssignmentOperatorAccess().getGroup_7()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAmpersandEqualsSignKeyword_8()); }
		AmpersandEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getAmpersandEqualsSignKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignKeyword_9()); }
		CircumflexAccentEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getVerticalLineEqualsSignKeyword_10()); }
		VerticalLineEqualsSign
		{ after(grammarAccess.getAssignmentOperatorAccess().getVerticalLineEqualsSignKeyword_10()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TemplateLiteral__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); }
		(rule__TemplateLiteral__SegmentsAssignment_1_0)
		{ after(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); }
		(rule__TemplateLiteral__Group_1_1__0)
		{ after(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_TemplateLiteral__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); }
		(norm1_TemplateLiteral__SegmentsAssignment_1_0)
		{ after(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); }
		(norm1_TemplateLiteral__Group_1_1__0)
		{ after(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Literal__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralAccess().getNumericLiteralParserRuleCall_0()); }
		ruleNumericLiteral
		{ after(grammarAccess.getLiteralAccess().getNumericLiteralParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getBooleanLiteralParserRuleCall_1()); }
		ruleBooleanLiteral
		{ after(grammarAccess.getLiteralAccess().getBooleanLiteralParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_2()); }
		ruleStringLiteral
		{ after(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_3()); }
		ruleNullLiteral
		{ after(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getRegularExpressionLiteralParserRuleCall_4()); }
		ruleRegularExpressionLiteral
		{ after(grammarAccess.getLiteralAccess().getRegularExpressionLiteralParserRuleCall_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BooleanLiteral__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBooleanLiteralAccess().getTrueAssignment_1_0()); }
		(rule__BooleanLiteral__TrueAssignment_1_0)
		{ after(grammarAccess.getBooleanLiteralAccess().getTrueAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getBooleanLiteralAccess().getFalseKeyword_1_1()); }
		False
		{ after(grammarAccess.getBooleanLiteralAccess().getFalseKeyword_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericLiteral__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericLiteralAccess().getDoubleLiteralParserRuleCall_0()); }
		ruleDoubleLiteral
		{ after(grammarAccess.getNumericLiteralAccess().getDoubleLiteralParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAccess().getIntLiteralParserRuleCall_1()); }
		ruleIntLiteral
		{ after(grammarAccess.getNumericLiteralAccess().getIntLiteralParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAccess().getBinaryIntLiteralParserRuleCall_2()); }
		ruleBinaryIntLiteral
		{ after(grammarAccess.getNumericLiteralAccess().getBinaryIntLiteralParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAccess().getOctalIntLiteralParserRuleCall_3()); }
		ruleOctalIntLiteral
		{ after(grammarAccess.getNumericLiteralAccess().getOctalIntLiteralParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAccess().getLegacyOctalIntLiteralParserRuleCall_4()); }
		ruleLegacyOctalIntLiteral
		{ after(grammarAccess.getNumericLiteralAccess().getLegacyOctalIntLiteralParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAccess().getHexIntLiteralParserRuleCall_5()); }
		ruleHexIntLiteral
		{ after(grammarAccess.getNumericLiteralAccess().getHexIntLiteralParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAccess().getScientificIntLiteralParserRuleCall_6()); }
		ruleScientificIntLiteral
		{ after(grammarAccess.getNumericLiteralAccess().getScientificIntLiteralParserRuleCall_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericLiteralAsString__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericLiteralAsStringAccess().getDOUBLETerminalRuleCall_0()); }
		RULE_DOUBLE
		{ after(grammarAccess.getNumericLiteralAsStringAccess().getDOUBLETerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAsStringAccess().getINTTerminalRuleCall_1()); }
		RULE_INT
		{ after(grammarAccess.getNumericLiteralAsStringAccess().getINTTerminalRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAsStringAccess().getOCTAL_INTTerminalRuleCall_2()); }
		RULE_OCTAL_INT
		{ after(grammarAccess.getNumericLiteralAsStringAccess().getOCTAL_INTTerminalRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAsStringAccess().getHEX_INTTerminalRuleCall_3()); }
		RULE_HEX_INT
		{ after(grammarAccess.getNumericLiteralAsStringAccess().getHEX_INTTerminalRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getNumericLiteralAsStringAccess().getSCIENTIFIC_INTTerminalRuleCall_4()); }
		RULE_SCIENTIFIC_INT
		{ after(grammarAccess.getNumericLiteralAsStringAccess().getSCIENTIFIC_INTTerminalRuleCall_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierOrThis__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdentifierOrThisAccess().getIDENTIFIERTerminalRuleCall_0()); }
		RULE_IDENTIFIER
		{ after(grammarAccess.getIdentifierOrThisAccess().getIDENTIFIERTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getIdentifierOrThisAccess().getThisKeyword_1()); }
		This
		{ after(grammarAccess.getIdentifierOrThisAccess().getThisKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getIdentifierOrThisAccess().getPromisifyKeyword_2()); }
		Promisify
		{ after(grammarAccess.getIdentifierOrThisAccess().getPromisifyKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getIdentifierOrThisAccess().getTargetKeyword_3()); }
		Target
		{ after(grammarAccess.getIdentifierOrThisAccess().getTargetKeyword_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotationName__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotationNameAccess().getIDENTIFIERTerminalRuleCall_0()); }
		RULE_IDENTIFIER
		{ after(grammarAccess.getAnnotationNameAccess().getIDENTIFIERTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotationNameAccess().getThisKeyword_1()); }
		This
		{ after(grammarAccess.getAnnotationNameAccess().getThisKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotationNameAccess().getTargetKeyword_2()); }
		Target
		{ after(grammarAccess.getAnnotationNameAccess().getTargetKeyword_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__REGEX_LITERAL__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getREGEX_LITERALAccess().getSolidusKeyword_0_0()); }
		Solidus
		{ after(grammarAccess.getREGEX_LITERALAccess().getSolidusKeyword_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getREGEX_LITERALAccess().getSolidusEqualsSignKeyword_0_1()); }
		SolidusEqualsSign
		{ after(grammarAccess.getREGEX_LITERALAccess().getSolidusEqualsSignKeyword_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotationArgument__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotationArgumentAccess().getLiteralAnnotationArgumentParserRuleCall_0()); }
		ruleLiteralAnnotationArgument
		{ after(grammarAccess.getAnnotationArgumentAccess().getLiteralAnnotationArgumentParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotationArgumentAccess().getTypeRefAnnotationArgumentParserRuleCall_1()); }
		ruleTypeRefAnnotationArgument
		{ after(grammarAccess.getAnnotationArgumentAccess().getTypeRefAnnotationArgumentParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeRefForCast__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getParameterizedTypeRefParserRuleCall_0()); }
		ruleParameterizedTypeRef
		{ after(grammarAccess.getTypeRefForCastAccess().getParameterizedTypeRefParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getArrayTypeRefParserRuleCall_1()); }
		ruleArrayTypeRef
		{ after(grammarAccess.getTypeRefForCastAccess().getArrayTypeRefParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getThisTypeRefParserRuleCall_2()); }
		ruleThisTypeRef
		{ after(grammarAccess.getTypeRefForCastAccess().getThisTypeRefParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getTypeTypeRefParserRuleCall_3()); }
		ruleTypeTypeRef
		{ after(grammarAccess.getTypeRefForCastAccess().getTypeTypeRefParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getArrowFunctionTypeExpressionParserRuleCall_4()); }
		(ruleArrowFunctionTypeExpression)
		{ after(grammarAccess.getTypeRefForCastAccess().getArrowFunctionTypeExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getFunctionTypeExpressionOLDParserRuleCall_5()); }
		ruleFunctionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefForCastAccess().getFunctionTypeExpressionOLDParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getUnionTypeExpressionOLDParserRuleCall_6()); }
		ruleUnionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefForCastAccess().getUnionTypeExpressionOLDParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefForCastAccess().getIntersectionTypeExpressionOLDParserRuleCall_7()); }
		ruleIntersectionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefForCastAccess().getIntersectionTypeExpressionOLDParserRuleCall_7()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeReferenceName__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getVoidKeyword_0()); }
		Void
		{ after(grammarAccess.getTypeReferenceNameAccess().getVoidKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getThisKeyword_1()); }
		This
		{ after(grammarAccess.getTypeReferenceNameAccess().getThisKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getAwaitKeyword_2()); }
		Await
		{ after(grammarAccess.getTypeReferenceNameAccess().getAwaitKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getPromisifyKeyword_3()); }
		Promisify
		{ after(grammarAccess.getTypeReferenceNameAccess().getPromisifyKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getTargetKeyword_4()); }
		Target
		{ after(grammarAccess.getTypeReferenceNameAccess().getTargetKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getDefaultKeyword_5()); }
		Default
		{ after(grammarAccess.getTypeReferenceNameAccess().getDefaultKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getTypeReferenceNameAccess().getIDENTIFIERTerminalRuleCall_6()); }
		RULE_IDENTIFIER
		{ after(grammarAccess.getTypeReferenceNameAccess().getIDENTIFIERTerminalRuleCall_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ClassExtendsImplements__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); }
		(rule__ClassExtendsImplements__Group_0__0)
		{ after(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); }
		(rule__ClassExtendsImplements__Group_1__0)
		{ after(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ClassExtendsImplements__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); }
		(norm1_ClassExtendsImplements__Group_0__0)
		{ after(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); }
		(norm1_ClassExtendsImplements__Group_1__0)
		{ after(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ClassExtendsClause__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); }
		(rule__ClassExtendsClause__SuperClassRefAssignment_1_0)
		{ after(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); }
		(rule__ClassExtendsClause__SuperClassExpressionAssignment_1_1)
		{ after(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ClassExtendsClause__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); }
		(norm1_ClassExtendsClause__SuperClassRefAssignment_1_0)
		{ after(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); }
		(norm1_ClassExtendsClause__SuperClassExpressionAssignment_1_1)
		{ after(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InterfaceExtendsList__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInterfaceExtendsListAccess().getExtendsKeyword_0_0()); }
		Extends
		{ after(grammarAccess.getInterfaceExtendsListAccess().getExtendsKeyword_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getInterfaceExtendsListAccess().getImplementsKeyword_0_1()); }
		Implements
		{ after(grammarAccess.getInterfaceExtendsListAccess().getImplementsKeyword_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__N4MemberDeclaration__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); }
		ruleAnnotatedN4MemberDeclaration
		{ after(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); }
		(ruleN4GetterDeclaration)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); }
		(ruleN4SetterDeclaration)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); }
		(ruleN4MethodDeclaration)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); }
		ruleN4FieldDeclaration
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); }
		ruleN4CallableConstructorDeclaration
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_N4MemberDeclaration__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); }
		norm1_AnnotatedN4MemberDeclaration
		{ after(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); }
		(norm1_N4GetterDeclaration)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); }
		(norm1_N4SetterDeclaration)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); }
		(norm1_N4MethodDeclaration)
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); }
		norm1_N4FieldDeclaration
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); }
		norm1_N4CallableConstructorDeclaration
		{ after(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedN4MemberDeclaration__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); }
		(rule__AnnotatedN4MemberDeclaration__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); }
		(rule__AnnotatedN4MemberDeclaration__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); }
		(rule__AnnotatedN4MemberDeclaration__Group_1_2__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); }
		(rule__AnnotatedN4MemberDeclaration__Group_1_3__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedN4MemberDeclaration__Alternatives_1_2_0_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); }
		(rule__AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_0__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); }
		(rule__AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_1__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedN4MemberDeclaration__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); }
		(norm1_AnnotatedN4MemberDeclaration__Group_1_0__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); }
		(norm1_AnnotatedN4MemberDeclaration__Group_1_1__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); }
		(norm1_AnnotatedN4MemberDeclaration__Group_1_2__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); }
		(norm1_AnnotatedN4MemberDeclaration__Group_1_3__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedN4MemberDeclaration__Alternatives_1_2_0_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); }
		(norm1_AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_0__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); }
		(norm1_AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_1__0)
		{ after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__N4MethodDeclaration__Alternatives_0_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); }
		(rule__N4MethodDeclaration__Group_0_0_4_0__0)
		{ after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); }
		(rule__N4MethodDeclaration__Group_0_0_4_1__0)
		{ after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_N4MethodDeclaration__Alternatives_0_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); }
		(norm1_N4MethodDeclaration__Group_0_0_4_0__0)
		{ after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); }
		(norm1_N4MethodDeclaration__Group_0_0_4_1__0)
		{ after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingPattern__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); }
		ruleObjectBindingPattern
		{ after(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); }
		ruleArrayBindingPattern
		{ after(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingPattern__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); }
		norm1_ObjectBindingPattern
		{ after(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); }
		norm1_ArrayBindingPattern
		{ after(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingProperty__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingPropertyAccess().getGroup_0()); }
		(rule__BindingProperty__Group_0__0)
		{ after(grammarAccess.getBindingPropertyAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); }
		(rule__BindingProperty__ValueAssignment_1)
		{ after(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingProperty__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingPropertyAccess().getGroup_0()); }
		(norm1_BindingProperty__Group_0__0)
		{ after(grammarAccess.getBindingPropertyAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); }
		(norm1_BindingProperty__ValueAssignment_1)
		{ after(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementImpl__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingElementImplAccess().getGroup_0()); }
		(rule__BindingElementImpl__Group_0__0)
		{ after(grammarAccess.getBindingElementImplAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); }
		(rule__BindingElementImpl__VarDeclAssignment_1)
		{ after(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementImpl__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingElementImplAccess().getGroup_0()); }
		(norm1_BindingElementImpl__Group_0__0)
		{ after(grammarAccess.getBindingElementImplAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); }
		(norm1_BindingElementImpl__VarDeclAssignment_1)
		{ after(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralOrComputedPropertyName__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); }
		(rule__LiteralOrComputedPropertyName__LiteralNameAssignment_0)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); }
		(rule__LiteralOrComputedPropertyName__LiteralNameAssignment_1)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); }
		(rule__LiteralOrComputedPropertyName__LiteralNameAssignment_2)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); }
		(rule__LiteralOrComputedPropertyName__Group_3__0)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LiteralOrComputedPropertyName__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); }
		(norm1_LiteralOrComputedPropertyName__LiteralNameAssignment_0)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); }
		(norm1_LiteralOrComputedPropertyName__LiteralNameAssignment_1)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); }
		(norm1_LiteralOrComputedPropertyName__LiteralNameAssignment_2)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); }
		(norm1_LiteralOrComputedPropertyName__Group_3__0)
		{ after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__JSXElement__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getJSXElementAccess().getGroup_3_0()); }
		(rule__JSXElement__Group_3_0__0)
		{ after(grammarAccess.getJSXElementAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getJSXElementAccess().getGroup_3_1()); }
		(rule__JSXElement__Group_3_1__0)
		{ after(grammarAccess.getJSXElementAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__JSXChild__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getJSXChildAccess().getJSXElementParserRuleCall_0()); }
		ruleJSXElement
		{ after(grammarAccess.getJSXChildAccess().getJSXElementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getJSXChildAccess().getJSXExpressionParserRuleCall_1()); }
		ruleJSXExpression
		{ after(grammarAccess.getJSXChildAccess().getJSXExpressionParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__JSXAttribute__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getJSXAttributeAccess().getJSXSpreadAttributeParserRuleCall_0()); }
		ruleJSXSpreadAttribute
		{ after(grammarAccess.getJSXAttributeAccess().getJSXSpreadAttributeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getJSXAttributeAccess().getJSXPropertyAttributeParserRuleCall_1()); }
		ruleJSXPropertyAttribute
		{ after(grammarAccess.getJSXAttributeAccess().getJSXPropertyAttributeParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__JSXPropertyAttribute__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getJSXPropertyAttributeAccess().getJsxAttributeValueAssignment_1_1_0()); }
		(rule__JSXPropertyAttribute__JsxAttributeValueAssignment_1_1_0)
		{ after(grammarAccess.getJSXPropertyAttributeAccess().getJsxAttributeValueAssignment_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getJSXPropertyAttributeAccess().getGroup_1_1_1()); }
		(rule__JSXPropertyAttribute__Group_1_1_1__0)
		{ after(grammarAccess.getJSXPropertyAttributeAccess().getGroup_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimaryTypeExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryTypeExpressionAccess().getArrowFunctionTypeExpressionParserRuleCall_0()); }
		(ruleArrowFunctionTypeExpression)
		{ after(grammarAccess.getPrimaryTypeExpressionAccess().getArrowFunctionTypeExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryTypeExpressionAccess().getArrayTypeRefParserRuleCall_1()); }
		ruleArrayTypeRef
		{ after(grammarAccess.getPrimaryTypeExpressionAccess().getArrayTypeRefParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryTypeExpressionAccess().getTypeRefWithModifiersParserRuleCall_2()); }
		ruleTypeRefWithModifiers
		{ after(grammarAccess.getPrimaryTypeExpressionAccess().getTypeRefWithModifiersParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryTypeExpressionAccess().getGroup_3()); }
		(rule__PrimaryTypeExpression__Group_3__0)
		{ after(grammarAccess.getPrimaryTypeExpressionAccess().getGroup_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeRefWithoutModifiers__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getGroup_0()); }
		(rule__TypeRefWithoutModifiers__Group_0__0)
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getTypeTypeRefParserRuleCall_1()); }
		ruleTypeTypeRef
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getTypeTypeRefParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getFunctionTypeExpressionOLDParserRuleCall_2()); }
		ruleFunctionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getFunctionTypeExpressionOLDParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getUnionTypeExpressionOLDParserRuleCall_3()); }
		ruleUnionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getUnionTypeExpressionOLDParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getIntersectionTypeExpressionOLDParserRuleCall_4()); }
		ruleIntersectionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getIntersectionTypeExpressionOLDParserRuleCall_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeRefWithoutModifiers__Alternatives_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getParameterizedTypeRefParserRuleCall_0_0_0()); }
		ruleParameterizedTypeRef
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getParameterizedTypeRefParserRuleCall_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefWithoutModifiersAccess().getThisTypeRefParserRuleCall_0_0_1()); }
		ruleThisTypeRef
		{ after(grammarAccess.getTypeRefWithoutModifiersAccess().getThisTypeRefParserRuleCall_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeRefFunctionTypeExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getParameterizedTypeRefParserRuleCall_0()); }
		ruleParameterizedTypeRef
		{ after(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getParameterizedTypeRefParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getArrayTypeRefParserRuleCall_1()); }
		ruleArrayTypeRef
		{ after(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getArrayTypeRefParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getTypeTypeRefParserRuleCall_2()); }
		ruleTypeTypeRef
		{ after(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getTypeTypeRefParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getUnionTypeExpressionOLDParserRuleCall_3()); }
		ruleUnionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getUnionTypeExpressionOLDParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getIntersectionTypeExpressionOLDParserRuleCall_4()); }
		ruleIntersectionTypeExpressionOLD
		{ after(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getIntersectionTypeExpressionOLDParserRuleCall_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeArgInTypeTypeRef__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeArgInTypeTypeRefAccess().getParameterizedTypeRefNominalParserRuleCall_0()); }
		ruleParameterizedTypeRefNominal
		{ after(grammarAccess.getTypeArgInTypeTypeRefAccess().getParameterizedTypeRefNominalParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeArgInTypeTypeRefAccess().getThisTypeRefNominalParserRuleCall_1()); }
		ruleThisTypeRefNominal
		{ after(grammarAccess.getTypeArgInTypeTypeRefAccess().getThisTypeRefNominalParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTypeArgInTypeTypeRefAccess().getWildcardParserRuleCall_2()); }
		(ruleWildcard)
		{ after(grammarAccess.getTypeArgInTypeTypeRefAccess().getWildcardParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ThisTypeRef__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getThisTypeRefAccess().getThisTypeRefNominalParserRuleCall_0()); }
		ruleThisTypeRefNominal
		{ after(grammarAccess.getThisTypeRefAccess().getThisTypeRefNominalParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getThisTypeRefAccess().getThisTypeRefStructuralParserRuleCall_1()); }
		ruleThisTypeRefStructural
		{ after(grammarAccess.getThisTypeRefAccess().getThisTypeRefStructuralParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TAnonymousFormalParameter__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTAnonymousFormalParameterAccess().getGroup_1_0()); }
		(rule__TAnonymousFormalParameter__Group_1_0__0)
		{ after(grammarAccess.getTAnonymousFormalParameterAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTAnonymousFormalParameterAccess().getTypeRefAssignment_1_1()); }
		(rule__TAnonymousFormalParameter__TypeRefAssignment_1_1)
		{ after(grammarAccess.getTAnonymousFormalParameterAccess().getTypeRefAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedTypeRef__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterizedTypeRefAccess().getParameterizedTypeRefNominalParserRuleCall_0()); }
		ruleParameterizedTypeRefNominal
		{ after(grammarAccess.getParameterizedTypeRefAccess().getParameterizedTypeRefNominalParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getParameterizedTypeRefAccess().getParameterizedTypeRefStructuralParserRuleCall_1()); }
		ruleParameterizedTypeRefStructural
		{ after(grammarAccess.getParameterizedTypeRefAccess().getParameterizedTypeRefStructuralParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedTypeRefNominal__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterizedTypeRefNominalAccess().getTypeReferenceParserRuleCall_0_0()); }
		ruleTypeReference
		{ after(grammarAccess.getParameterizedTypeRefNominalAccess().getTypeReferenceParserRuleCall_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup_0_1()); }
		(rule__ParameterizedTypeRefNominal__Group_0_1__0)
		{ after(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedTypeRefStructural__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup_0_0()); }
		(rule__ParameterizedTypeRefStructural__Group_0_0__0)
		{ after(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup_0_1()); }
		(rule__ParameterizedTypeRefStructural__Group_0_1__0)
		{ after(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TStructMemberList__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTStructMemberListAccess().getSemicolonKeyword_1_1_0()); }
		Semicolon
		{ after(grammarAccess.getTStructMemberListAccess().getSemicolonKeyword_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTStructMemberListAccess().getCommaKeyword_1_1_1()); }
		Comma
		{ after(grammarAccess.getTStructMemberListAccess().getCommaKeyword_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TStructMember__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTStructMemberAccess().getTStructGetterParserRuleCall_0()); }
		(ruleTStructGetter)
		{ after(grammarAccess.getTStructMemberAccess().getTStructGetterParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTStructMemberAccess().getTStructSetterParserRuleCall_1()); }
		(ruleTStructSetter)
		{ after(grammarAccess.getTStructMemberAccess().getTStructSetterParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTStructMemberAccess().getTStructMethodParserRuleCall_2()); }
		(ruleTStructMethod)
		{ after(grammarAccess.getTStructMemberAccess().getTStructMethodParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTStructMemberAccess().getTStructFieldParserRuleCall_3()); }
		ruleTStructField
		{ after(grammarAccess.getTStructMemberAccess().getTStructFieldParserRuleCall_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypingStrategyUseSiteOperator__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getTildeKeyword_1_0()); }
		Tilde
		{ after(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getTildeKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getSTRUCTMODSUFFIXTerminalRuleCall_1_1()); }
		RULE_STRUCTMODSUFFIX
		{ after(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getSTRUCTMODSUFFIXTerminalRuleCall_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeTypeRef__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeTypeRefAccess().getTypeKeyword_1_0()); }
		Type
		{ after(grammarAccess.getTypeTypeRefAccess().getTypeKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeTypeRefAccess().getConstructorRefAssignment_1_1()); }
		(rule__TypeTypeRef__ConstructorRefAssignment_1_1)
		{ after(grammarAccess.getTypeTypeRefAccess().getConstructorRefAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeArgument__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeArgumentAccess().getWildcardParserRuleCall_0()); }
		(ruleWildcard)
		{ after(grammarAccess.getTypeArgumentAccess().getWildcardParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeArgumentAccess().getWildcardNewNotationParserRuleCall_1()); }
		ruleWildcardNewNotation
		{ after(grammarAccess.getTypeArgumentAccess().getWildcardNewNotationParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTypeArgumentAccess().getTypeRefParserRuleCall_2()); }
		ruleTypeRef
		{ after(grammarAccess.getTypeArgumentAccess().getTypeRefParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Wildcard__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getWildcardAccess().getGroup_1_0()); }
		(rule__Wildcard__Group_1_0__0)
		{ after(grammarAccess.getWildcardAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getWildcardAccess().getGroup_1_1()); }
		(rule__Wildcard__Group_1_1__0)
		{ after(grammarAccess.getWildcardAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__WildcardNewNotation__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getWildcardNewNotationAccess().getGroup_0()); }
		(rule__WildcardNewNotation__Group_0__0)
		{ after(grammarAccess.getWildcardNewNotationAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getWildcardNewNotationAccess().getGroup_1()); }
		(rule__WildcardNewNotation__Group_1__0)
		{ after(grammarAccess.getWildcardNewNotationAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingIdentifier__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingIdentifierAccess().getIDENTIFIERTerminalRuleCall_0()); }
		RULE_IDENTIFIER
		{ after(grammarAccess.getBindingIdentifierAccess().getIDENTIFIERTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingIdentifierAccess().getYieldKeyword_1_0()); }
		Yield
		{ after(grammarAccess.getBindingIdentifierAccess().getYieldKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingIdentifierAccess().getN4KeywordParserRuleCall_2()); }
		ruleN4Keyword
		{ after(grammarAccess.getBindingIdentifierAccess().getN4KeywordParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingIdentifier__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBindingIdentifierAccess().getIDENTIFIERTerminalRuleCall_0()); }
		RULE_IDENTIFIER
		{ after(grammarAccess.getBindingIdentifierAccess().getIDENTIFIERTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getBindingIdentifierAccess().getN4KeywordParserRuleCall_2()); }
		ruleN4Keyword
		{ after(grammarAccess.getBindingIdentifierAccess().getN4KeywordParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierName__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIdentifierNameAccess().getIDENTIFIERTerminalRuleCall_0()); }
		RULE_IDENTIFIER
		{ after(grammarAccess.getIdentifierNameAccess().getIDENTIFIERTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getIdentifierNameAccess().getReservedWordParserRuleCall_1()); }
		ruleReservedWord
		{ after(grammarAccess.getIdentifierNameAccess().getReservedWordParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getIdentifierNameAccess().getN4KeywordParserRuleCall_2()); }
		ruleN4Keyword
		{ after(grammarAccess.getIdentifierNameAccess().getN4KeywordParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReservedWord__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReservedWordAccess().getBreakKeyword_0()); }
		Break
		{ after(grammarAccess.getReservedWordAccess().getBreakKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getCaseKeyword_1()); }
		Case
		{ after(grammarAccess.getReservedWordAccess().getCaseKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getCatchKeyword_2()); }
		Catch
		{ after(grammarAccess.getReservedWordAccess().getCatchKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getClassKeyword_3()); }
		Class
		{ after(grammarAccess.getReservedWordAccess().getClassKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getConstKeyword_4()); }
		Const
		{ after(grammarAccess.getReservedWordAccess().getConstKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getContinueKeyword_5()); }
		Continue
		{ after(grammarAccess.getReservedWordAccess().getContinueKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getDebuggerKeyword_6()); }
		Debugger
		{ after(grammarAccess.getReservedWordAccess().getDebuggerKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getDefaultKeyword_7()); }
		Default
		{ after(grammarAccess.getReservedWordAccess().getDefaultKeyword_7()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getDeleteKeyword_8()); }
		Delete
		{ after(grammarAccess.getReservedWordAccess().getDeleteKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getDoKeyword_9()); }
		Do
		{ after(grammarAccess.getReservedWordAccess().getDoKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getElseKeyword_10()); }
		Else
		{ after(grammarAccess.getReservedWordAccess().getElseKeyword_10()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getExportKeyword_11()); }
		Export
		{ after(grammarAccess.getReservedWordAccess().getExportKeyword_11()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getExtendsKeyword_12()); }
		Extends
		{ after(grammarAccess.getReservedWordAccess().getExtendsKeyword_12()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getFinallyKeyword_13()); }
		Finally
		{ after(grammarAccess.getReservedWordAccess().getFinallyKeyword_13()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getForKeyword_14()); }
		For
		{ after(grammarAccess.getReservedWordAccess().getForKeyword_14()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getFunctionKeyword_15()); }
		Function
		{ after(grammarAccess.getReservedWordAccess().getFunctionKeyword_15()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getIfKeyword_16()); }
		If
		{ after(grammarAccess.getReservedWordAccess().getIfKeyword_16()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getImportKeyword_17()); }
		Import
		{ after(grammarAccess.getReservedWordAccess().getImportKeyword_17()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getInKeyword_18()); }
		In
		{ after(grammarAccess.getReservedWordAccess().getInKeyword_18()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getInstanceofKeyword_19()); }
		Instanceof
		{ after(grammarAccess.getReservedWordAccess().getInstanceofKeyword_19()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getNewKeyword_20()); }
		New
		{ after(grammarAccess.getReservedWordAccess().getNewKeyword_20()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getReturnKeyword_21()); }
		Return
		{ after(grammarAccess.getReservedWordAccess().getReturnKeyword_21()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getSuperKeyword_22()); }
		Super
		{ after(grammarAccess.getReservedWordAccess().getSuperKeyword_22()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getSwitchKeyword_23()); }
		Switch
		{ after(grammarAccess.getReservedWordAccess().getSwitchKeyword_23()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getThisKeyword_24()); }
		This_1
		{ after(grammarAccess.getReservedWordAccess().getThisKeyword_24()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getThrowKeyword_25()); }
		Throw
		{ after(grammarAccess.getReservedWordAccess().getThrowKeyword_25()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getTryKeyword_26()); }
		Try
		{ after(grammarAccess.getReservedWordAccess().getTryKeyword_26()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getTypeofKeyword_27()); }
		Typeof
		{ after(grammarAccess.getReservedWordAccess().getTypeofKeyword_27()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getVarKeyword_28()); }
		Var
		{ after(grammarAccess.getReservedWordAccess().getVarKeyword_28()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getVoidKeyword_29()); }
		Void
		{ after(grammarAccess.getReservedWordAccess().getVoidKeyword_29()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getWhileKeyword_30()); }
		While
		{ after(grammarAccess.getReservedWordAccess().getWhileKeyword_30()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getWithKeyword_31()); }
		With
		{ after(grammarAccess.getReservedWordAccess().getWithKeyword_31()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getYieldKeyword_32()); }
		Yield
		{ after(grammarAccess.getReservedWordAccess().getYieldKeyword_32()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getNullKeyword_33()); }
		Null
		{ after(grammarAccess.getReservedWordAccess().getNullKeyword_33()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getTrueKeyword_34()); }
		True
		{ after(grammarAccess.getReservedWordAccess().getTrueKeyword_34()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getFalseKeyword_35()); }
		False
		{ after(grammarAccess.getReservedWordAccess().getFalseKeyword_35()); }
	)
	|
	(
		{ before(grammarAccess.getReservedWordAccess().getEnumKeyword_36()); }
		Enum
		{ after(grammarAccess.getReservedWordAccess().getEnumKeyword_36()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__N4Keyword__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getN4KeywordAccess().getGetKeyword_0()); }
		Get
		{ after(grammarAccess.getN4KeywordAccess().getGetKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getSetKeyword_1()); }
		Set
		{ after(grammarAccess.getN4KeywordAccess().getSetKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getLetKeyword_2()); }
		Let
		{ after(grammarAccess.getN4KeywordAccess().getLetKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getProjectKeyword_3()); }
		Project
		{ after(grammarAccess.getN4KeywordAccess().getProjectKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getExternalKeyword_4()); }
		External
		{ after(grammarAccess.getN4KeywordAccess().getExternalKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getAbstractKeyword_5()); }
		Abstract
		{ after(grammarAccess.getN4KeywordAccess().getAbstractKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getStaticKeyword_6()); }
		Static
		{ after(grammarAccess.getN4KeywordAccess().getStaticKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getAsKeyword_7()); }
		As
		{ after(grammarAccess.getN4KeywordAccess().getAsKeyword_7()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getFromKeyword_8()); }
		From
		{ after(grammarAccess.getN4KeywordAccess().getFromKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getConstructorKeyword_9()); }
		Constructor
		{ after(grammarAccess.getN4KeywordAccess().getConstructorKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getOfKeyword_10()); }
		Of
		{ after(grammarAccess.getN4KeywordAccess().getOfKeyword_10()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getTargetKeyword_11()); }
		Target
		{ after(grammarAccess.getN4KeywordAccess().getTargetKeyword_11()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getTypeKeyword_12()); }
		Type
		{ after(grammarAccess.getN4KeywordAccess().getTypeKeyword_12()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getUnionKeyword_13()); }
		Union
		{ after(grammarAccess.getN4KeywordAccess().getUnionKeyword_13()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getIntersectionKeyword_14()); }
		Intersection
		{ after(grammarAccess.getN4KeywordAccess().getIntersectionKeyword_14()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getThisKeyword_15()); }
		This
		{ after(grammarAccess.getN4KeywordAccess().getThisKeyword_15()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getPromisifyKeyword_16()); }
		Promisify
		{ after(grammarAccess.getN4KeywordAccess().getPromisifyKeyword_16()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getAwaitKeyword_17()); }
		Await
		{ after(grammarAccess.getN4KeywordAccess().getAwaitKeyword_17()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getAsyncKeyword_18()); }
		Async
		{ after(grammarAccess.getN4KeywordAccess().getAsyncKeyword_18()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getImplementsKeyword_19()); }
		Implements
		{ after(grammarAccess.getN4KeywordAccess().getImplementsKeyword_19()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getInterfaceKeyword_20()); }
		Interface
		{ after(grammarAccess.getN4KeywordAccess().getInterfaceKeyword_20()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getPrivateKeyword_21()); }
		Private
		{ after(grammarAccess.getN4KeywordAccess().getPrivateKeyword_21()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getProtectedKeyword_22()); }
		Protected
		{ after(grammarAccess.getN4KeywordAccess().getProtectedKeyword_22()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getPublicKeyword_23()); }
		Public
		{ after(grammarAccess.getN4KeywordAccess().getPublicKeyword_23()); }
	)
	|
	(
		{ before(grammarAccess.getN4KeywordAccess().getOutKeyword_24()); }
		Out
		{ after(grammarAccess.getN4KeywordAccess().getOutKeyword_24()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableStatementKeyword__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableStatementKeywordAccess().getVarEnumLiteralDeclaration_0()); }
		(Var)
		{ after(grammarAccess.getVariableStatementKeywordAccess().getVarEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableStatementKeywordAccess().getConstEnumLiteralDeclaration_1()); }
		(Const)
		{ after(grammarAccess.getVariableStatementKeywordAccess().getConstEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getVariableStatementKeywordAccess().getLetEnumLiteralDeclaration_2()); }
		(Let)
		{ after(grammarAccess.getVariableStatementKeywordAccess().getLetEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostfixOperatorAccess().getIncEnumLiteralDeclaration_0()); }
		(PlusSignPlusSign)
		{ after(grammarAccess.getPostfixOperatorAccess().getIncEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getPostfixOperatorAccess().getDecEnumLiteralDeclaration_1()); }
		(HyphenMinusHyphenMinus)
		{ after(grammarAccess.getPostfixOperatorAccess().getDecEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getDeleteEnumLiteralDeclaration_0()); }
		(Delete)
		{ after(grammarAccess.getUnaryOperatorAccess().getDeleteEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getVoidEnumLiteralDeclaration_1()); }
		(Void)
		{ after(grammarAccess.getUnaryOperatorAccess().getVoidEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getTypeofEnumLiteralDeclaration_2()); }
		(Typeof)
		{ after(grammarAccess.getUnaryOperatorAccess().getTypeofEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getIncEnumLiteralDeclaration_3()); }
		(PlusSignPlusSign)
		{ after(grammarAccess.getUnaryOperatorAccess().getIncEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getDecEnumLiteralDeclaration_4()); }
		(HyphenMinusHyphenMinus)
		{ after(grammarAccess.getUnaryOperatorAccess().getDecEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getPosEnumLiteralDeclaration_5()); }
		(PlusSign)
		{ after(grammarAccess.getUnaryOperatorAccess().getPosEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getNegEnumLiteralDeclaration_6()); }
		(HyphenMinus)
		{ after(grammarAccess.getUnaryOperatorAccess().getNegEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getInvEnumLiteralDeclaration_7()); }
		(Tilde)
		{ after(grammarAccess.getUnaryOperatorAccess().getInvEnumLiteralDeclaration_7()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getNotEnumLiteralDeclaration_8()); }
		(ExclamationMark)
		{ after(grammarAccess.getUnaryOperatorAccess().getNotEnumLiteralDeclaration_8()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getTimesEnumLiteralDeclaration_0()); }
		(Asterisk)
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getTimesEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1()); }
		(Solidus)
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2()); }
		(PercentSign)
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getAddEnumLiteralDeclaration_0()); }
		(PlusSign)
		{ after(grammarAccess.getAdditiveOperatorAccess().getAddEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getSubEnumLiteralDeclaration_1()); }
		(HyphenMinus)
		{ after(grammarAccess.getAdditiveOperatorAccess().getSubEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EqualityOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getSameEnumLiteralDeclaration_0()); }
		(EqualsSignEqualsSignEqualsSign)
		{ after(grammarAccess.getEqualityOperatorAccess().getSameEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getNsameEnumLiteralDeclaration_1()); }
		(ExclamationMarkEqualsSignEqualsSign)
		{ after(grammarAccess.getEqualityOperatorAccess().getNsameEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getEqEnumLiteralDeclaration_2()); }
		(EqualsSignEqualsSign)
		{ after(grammarAccess.getEqualityOperatorAccess().getEqEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getNeqEnumLiteralDeclaration_3()); }
		(ExclamationMarkEqualsSign)
		{ after(grammarAccess.getEqualityOperatorAccess().getNeqEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__N4Modifier__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getN4ModifierAccess().getPrivateEnumLiteralDeclaration_0()); }
		(Private)
		{ after(grammarAccess.getN4ModifierAccess().getPrivateEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getN4ModifierAccess().getProjectEnumLiteralDeclaration_1()); }
		(Project)
		{ after(grammarAccess.getN4ModifierAccess().getProjectEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getN4ModifierAccess().getProtectedEnumLiteralDeclaration_2()); }
		(Protected)
		{ after(grammarAccess.getN4ModifierAccess().getProtectedEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getN4ModifierAccess().getPublicEnumLiteralDeclaration_3()); }
		(Public)
		{ after(grammarAccess.getN4ModifierAccess().getPublicEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getN4ModifierAccess().getExternalEnumLiteralDeclaration_4()); }
		(External)
		{ after(grammarAccess.getN4ModifierAccess().getExternalEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getN4ModifierAccess().getAbstractEnumLiteralDeclaration_5()); }
		(Abstract)
		{ after(grammarAccess.getN4ModifierAccess().getAbstractEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getN4ModifierAccess().getStaticEnumLiteralDeclaration_6()); }
		(Static)
		{ after(grammarAccess.getN4ModifierAccess().getStaticEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getN4ModifierAccess().getConstEnumLiteralDeclaration_7()); }
		(Const)
		{ after(grammarAccess.getN4ModifierAccess().getConstEnumLiteralDeclaration_7()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Script__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Script__Group__0__Impl
	rule__Script__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Script__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getScriptAccess().getScriptAction_0()); }
	()
	{ after(grammarAccess.getScriptAccess().getScriptAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Script__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Script__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Script__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getScriptAccess().getAlternatives_1()); }
	(rule__Script__Alternatives_1)*
	{ after(grammarAccess.getScriptAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group__0__Impl
	rule__AnnotatedScriptElement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getAnnotationListParserRuleCall_0()); }
	(ruleAnnotationList)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getAnnotationListParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getAlternatives_1()); }
	(rule__AnnotatedScriptElement__Alternatives_1)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_0__0__Impl
	rule__AnnotatedScriptElement__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getExportDeclarationAnnotationListAction_1_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getExportDeclarationAnnotationListAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getExportDeclarationImplParserRuleCall_1_0_1()); }
	ruleExportDeclarationImpl
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getExportDeclarationImplParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_1__0__Impl
	rule__AnnotatedScriptElement__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getImportDeclarationAnnotationListAction_1_1_0()); }
	()
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getImportDeclarationAnnotationListAction_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getImportDeclarationImplParserRuleCall_1_1_1()); }
	ruleImportDeclarationImpl
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getImportDeclarationImplParserRuleCall_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_2__0__Impl
	rule__AnnotatedScriptElement__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getFunctionDeclarationAnnotationListAction_1_2_0()); }
	()
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getFunctionDeclarationAnnotationListAction_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2_1()); }
	(rule__AnnotatedScriptElement__Group_1_2_1__0)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_2_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2_1_0()); }
	(rule__AnnotatedScriptElement__Group_1_2_1_0__0)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_2_1_0__0__Impl
	rule__AnnotatedScriptElement__Group_1_2_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_2_1_0_0()); }
	(rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_2_1_0_0)*
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_2_1_0__1__Impl
	rule__AnnotatedScriptElement__Group_1_2_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_2_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_2_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getFunctionImplParserRuleCall_1_2_1_0_2()); }
	(ruleFunctionImpl)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getFunctionImplParserRuleCall_1_2_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3__0__Impl
	rule__AnnotatedScriptElement__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getAlternatives_1_3_0()); }
	(rule__AnnotatedScriptElement__Alternatives_1_3_0)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getAlternatives_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getMembersParserRuleCall_1_3_1()); }
	ruleMembers
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getMembersParserRuleCall_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_3_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__0__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getN4ClassDeclarationAnnotationListAction_1_3_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getN4ClassDeclarationAnnotationListAction_1_3_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__1__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_3_0_0_1()); }
	(rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_3_0_0_1)*
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_3_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__2__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getClassKeyword_1_3_0_0_2()); }
	Class
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getClassKeyword_1_3_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__3__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_0_3()); }
	(rule__AnnotatedScriptElement__TypingStrategyAssignment_1_3_0_0_3)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__4__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_0__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_0_4()); }
	(rule__AnnotatedScriptElement__NameAssignment_1_3_0_0_4)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__5__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_0__6
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_0_5()); }
	(ruleVersionDeclaration)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_0_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__6__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_0__7
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_0_6()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_0_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_0__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_0__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getClassExtendsImplementsParserRuleCall_1_3_0_0_7()); }
	(ruleClassExtendsImplements)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getClassExtendsImplementsParserRuleCall_1_3_0_0_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_3_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__0__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getN4InterfaceDeclarationAnnotationListAction_1_3_0_1_0()); }
	()
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getN4InterfaceDeclarationAnnotationListAction_1_3_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__1__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_3_0_1_1()); }
	(rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_3_0_1_1)*
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_3_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__2__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getInterfaceKeyword_1_3_0_1_2()); }
	Interface
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getInterfaceKeyword_1_3_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__3__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_1_3()); }
	(rule__AnnotatedScriptElement__TypingStrategyAssignment_1_3_0_1_3)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__4__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_1__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_1_4()); }
	(rule__AnnotatedScriptElement__NameAssignment_1_3_0_1_4)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__5__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_1__6
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_1_5()); }
	(ruleVersionDeclaration)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_1_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__6__Impl
	rule__AnnotatedScriptElement__Group_1_3_0_1__7
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_1_6()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_1_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_3_0_1__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_3_0_1__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getInterfaceExtendsListParserRuleCall_1_3_0_1_7()); }
	(ruleInterfaceExtendsList)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getInterfaceExtendsListParserRuleCall_1_3_0_1_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__0__Impl
	rule__AnnotatedScriptElement__Group_1_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getN4EnumDeclarationAnnotationListAction_1_4_0()); }
	()
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getN4EnumDeclarationAnnotationListAction_1_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__1__Impl
	rule__AnnotatedScriptElement__Group_1_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_4_1()); }
	(rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_4_1)*
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__2__Impl
	rule__AnnotatedScriptElement__Group_1_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getEnumKeyword_1_4_2()); }
	Enum
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getEnumKeyword_1_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__3__Impl
	rule__AnnotatedScriptElement__Group_1_4__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_4_3()); }
	(rule__AnnotatedScriptElement__NameAssignment_1_4_3)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__4__Impl
	rule__AnnotatedScriptElement__Group_1_4__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_4_4()); }
	(ruleVersionDeclaration)?
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_4_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__5__Impl
	rule__AnnotatedScriptElement__Group_1_4__6
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getLeftCurlyBracketKeyword_1_4_5()); }
	LeftCurlyBracket
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getLeftCurlyBracketKeyword_1_4_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__6__Impl
	rule__AnnotatedScriptElement__Group_1_4__7
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_6()); }
	(rule__AnnotatedScriptElement__LiteralsAssignment_1_4_6)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__7__Impl
	rule__AnnotatedScriptElement__Group_1_4__8
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4_7()); }
	(rule__AnnotatedScriptElement__Group_1_4_7__0)*
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getRightCurlyBracketKeyword_1_4_8()); }
	RightCurlyBracket
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getRightCurlyBracketKeyword_1_4_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedScriptElement__Group_1_4_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4_7__0__Impl
	rule__AnnotatedScriptElement__Group_1_4_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getCommaKeyword_1_4_7_0()); }
	Comma
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getCommaKeyword_1_4_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedScriptElement__Group_1_4_7__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedScriptElement__Group_1_4_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_7_1()); }
	(rule__AnnotatedScriptElement__LiteralsAssignment_1_4_7_1)
	{ after(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclaration__Group__0__Impl
	rule__ExportDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationAccess().getExportDeclarationAction_0()); }
	()
	{ after(grammarAccess.getExportDeclarationAccess().getExportDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationAccess().getExportDeclarationImplParserRuleCall_1()); }
	ruleExportDeclarationImpl
	{ after(grammarAccess.getExportDeclarationAccess().getExportDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group__0__Impl
	rule__ExportDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getExportKeyword_0()); }
	Export
	{ after(grammarAccess.getExportDeclarationImplAccess().getExportKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getAlternatives_1()); }
	(rule__ExportDeclarationImpl__Alternatives_1)
	{ after(grammarAccess.getExportDeclarationImplAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportDeclarationImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_0__0__Impl
	rule__ExportDeclarationImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getWildcardExportAssignment_1_0_0()); }
	(rule__ExportDeclarationImpl__WildcardExportAssignment_1_0_0)
	{ after(grammarAccess.getExportDeclarationImplAccess().getWildcardExportAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_0__1__Impl
	rule__ExportDeclarationImpl__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_0_1()); }
	ruleExportFromClause
	{ after(grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_0_2()); }
	ruleSemi
	{ after(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportDeclarationImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_1__0__Impl
	rule__ExportDeclarationImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getExportClauseParserRuleCall_1_1_0()); }
	ruleExportClause
	{ after(grammarAccess.getExportDeclarationImplAccess().getExportClauseParserRuleCall_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_1__1__Impl
	rule__ExportDeclarationImpl__Group_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_1_1()); }
	(ruleExportFromClause)?
	{ after(grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_1_2()); }
	ruleSemi
	{ after(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportDeclarationImpl__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_3__0__Impl
	rule__ExportDeclarationImpl__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getDefaultExportAssignment_1_3_0()); }
	(rule__ExportDeclarationImpl__DefaultExportAssignment_1_3_0)
	{ after(grammarAccess.getExportDeclarationImplAccess().getDefaultExportAssignment_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getAlternatives_1_3_1()); }
	(rule__ExportDeclarationImpl__Alternatives_1_3_1)
	{ after(grammarAccess.getExportDeclarationImplAccess().getAlternatives_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportDeclarationImpl__Group_1_3_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_3_1_1__0__Impl
	rule__ExportDeclarationImpl__Group_1_3_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_3_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getDefaultExportedExpressionAssignment_1_3_1_1_0()); }
	(rule__ExportDeclarationImpl__DefaultExportedExpressionAssignment_1_3_1_1_0)
	{ after(grammarAccess.getExportDeclarationImplAccess().getDefaultExportedExpressionAssignment_1_3_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_3_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportDeclarationImpl__Group_1_3_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportDeclarationImpl__Group_1_3_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_3_1_1_1()); }
	ruleSemi
	{ after(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_3_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportFromClause__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportFromClause__Group__0__Impl
	rule__ExportFromClause__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportFromClause__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportFromClauseAccess().getFromKeyword_0()); }
	From
	{ after(grammarAccess.getExportFromClauseAccess().getFromKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportFromClause__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportFromClause__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportFromClause__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportFromClauseAccess().getReexportedFromAssignment_1()); }
	(rule__ExportFromClause__ReexportedFromAssignment_1)
	{ after(grammarAccess.getExportFromClauseAccess().getReexportedFromAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportClause__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group__0__Impl
	rule__ExportClause__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getLeftCurlyBracketKeyword_0()); }
	LeftCurlyBracket
	{ after(grammarAccess.getExportClauseAccess().getLeftCurlyBracketKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group__1__Impl
	rule__ExportClause__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getGroup_1()); }
	(rule__ExportClause__Group_1__0)?
	{ after(grammarAccess.getExportClauseAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getRightCurlyBracketKeyword_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getExportClauseAccess().getRightCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportClause__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group_1__0__Impl
	rule__ExportClause__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_0()); }
	(rule__ExportClause__NamedExportsAssignment_1_0)
	{ after(grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group_1__1__Impl
	rule__ExportClause__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getGroup_1_1()); }
	(rule__ExportClause__Group_1_1__0)*
	{ after(grammarAccess.getExportClauseAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getCommaKeyword_1_2()); }
	(Comma)?
	{ after(grammarAccess.getExportClauseAccess().getCommaKeyword_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportClause__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group_1_1__0__Impl
	rule__ExportClause__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getCommaKeyword_1_1_0()); }
	Comma
	{ after(grammarAccess.getExportClauseAccess().getCommaKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportClause__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportClause__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_1_1()); }
	(rule__ExportClause__NamedExportsAssignment_1_1_1)
	{ after(grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportSpecifier__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportSpecifier__Group__0__Impl
	rule__ExportSpecifier__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportSpecifier__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportSpecifierAccess().getElementAssignment_0()); }
	(rule__ExportSpecifier__ElementAssignment_0)
	{ after(grammarAccess.getExportSpecifierAccess().getElementAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportSpecifier__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportSpecifier__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportSpecifier__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportSpecifierAccess().getGroup_1()); }
	(rule__ExportSpecifier__Group_1__0)?
	{ after(grammarAccess.getExportSpecifierAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportSpecifier__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportSpecifier__Group_1__0__Impl
	rule__ExportSpecifier__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportSpecifier__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportSpecifierAccess().getAsKeyword_1_0()); }
	As
	{ after(grammarAccess.getExportSpecifierAccess().getAsKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportSpecifier__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportSpecifier__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportSpecifier__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportSpecifierAccess().getAliasAssignment_1_1()); }
	(rule__ExportSpecifier__AliasAssignment_1_1)
	{ after(grammarAccess.getExportSpecifierAccess().getAliasAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group__0__Impl
	rule__AnnotatedExportableElement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getAnnotationListParserRuleCall_0()); }
	(ruleAnnotationList)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getAnnotationListParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getAlternatives_1()); }
	(rule__AnnotatedExportableElement__Alternatives_1)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_0__0__Impl
	rule__AnnotatedExportableElement__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getFunctionDeclarationAnnotationListAction_1_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getFunctionDeclarationAnnotationListAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_0__1__Impl
	rule__AnnotatedExportableElement__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_0_1()); }
	(rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_0_1)*
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_0__2__Impl
	rule__AnnotatedExportableElement__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_0_2()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getFunctionImplParserRuleCall_1_0_3()); }
	ruleFunctionImpl
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getFunctionImplParserRuleCall_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1__0__Impl
	rule__AnnotatedExportableElement__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getExportedVariableStatementAnnotationListAction_1_1_0()); }
	()
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getExportedVariableStatementAnnotationListAction_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1__1__Impl
	rule__AnnotatedExportableElement__Group_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_1_1()); }
	(rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_1_1)*
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1__2__Impl
	rule__AnnotatedExportableElement__Group_1_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getVarStmtKeywordAssignment_1_1_2()); }
	(rule__AnnotatedExportableElement__VarStmtKeywordAssignment_1_1_2)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getVarStmtKeywordAssignment_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1__3__Impl
	rule__AnnotatedExportableElement__Group_1_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_3()); }
	(rule__AnnotatedExportableElement__VarDeclsOrBindingsAssignment_1_1_3)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1__4__Impl
	rule__AnnotatedExportableElement__Group_1_1__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1_4()); }
	(rule__AnnotatedExportableElement__Group_1_1_4__0)*
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getSemiParserRuleCall_1_1_5()); }
	ruleSemi
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getSemiParserRuleCall_1_1_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_1_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1_4__0__Impl
	rule__AnnotatedExportableElement__Group_1_1_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_1_4_0()); }
	Comma
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_1_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_1_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_1_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_4_1()); }
	(rule__AnnotatedExportableElement__VarDeclsOrBindingsAssignment_1_1_4_1)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2__0__Impl
	rule__AnnotatedExportableElement__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getAlternatives_1_2_0()); }
	(rule__AnnotatedExportableElement__Alternatives_1_2_0)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getAlternatives_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getMembersParserRuleCall_1_2_1()); }
	ruleMembers
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getMembersParserRuleCall_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_2_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_0__0__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getN4ClassDeclarationAnnotationListAction_1_2_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getN4ClassDeclarationAnnotationListAction_1_2_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_0__1__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_2_0_0_1()); }
	(rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_2_0_0_1)*
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_2_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_0__2__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getClassKeyword_1_2_0_0_2()); }
	Class
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getClassKeyword_1_2_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_0__3__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_0_3()); }
	(rule__AnnotatedExportableElement__TypingStrategyAssignment_1_2_0_0_3)?
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_0__4__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_0__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_0_4()); }
	(rule__AnnotatedExportableElement__NameAssignment_1_2_0_0_4)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_0__5__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_0__6
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_0_5()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_0_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_0__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_0__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getClassExtendsImplementsParserRuleCall_1_2_0_0_6()); }
	(ruleClassExtendsImplements)?
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getClassExtendsImplementsParserRuleCall_1_2_0_0_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_2_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_1__0__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getN4InterfaceDeclarationAnnotationListAction_1_2_0_1_0()); }
	()
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getN4InterfaceDeclarationAnnotationListAction_1_2_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_1__1__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_2_0_1_1()); }
	(rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_2_0_1_1)*
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_2_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_1__2__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getInterfaceKeyword_1_2_0_1_2()); }
	Interface
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getInterfaceKeyword_1_2_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_1__3__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_1_3()); }
	(rule__AnnotatedExportableElement__TypingStrategyAssignment_1_2_0_1_3)?
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_1__4__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_1__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_1_4()); }
	(rule__AnnotatedExportableElement__NameAssignment_1_2_0_1_4)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_1__5__Impl
	rule__AnnotatedExportableElement__Group_1_2_0_1__6
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_1_5()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_1_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_2_0_1__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_2_0_1__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getInterfaceExtendsListParserRuleCall_1_2_0_1_6()); }
	(ruleInterfaceExtendsList)?
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getInterfaceExtendsListParserRuleCall_1_2_0_1_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__0__Impl
	rule__AnnotatedExportableElement__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getN4EnumDeclarationAnnotationListAction_1_3_0()); }
	()
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getN4EnumDeclarationAnnotationListAction_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__1__Impl
	rule__AnnotatedExportableElement__Group_1_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_3_1()); }
	(rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_3_1)*
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__2__Impl
	rule__AnnotatedExportableElement__Group_1_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getEnumKeyword_1_3_2()); }
	Enum
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getEnumKeyword_1_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__3__Impl
	rule__AnnotatedExportableElement__Group_1_3__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_3_3()); }
	(rule__AnnotatedExportableElement__NameAssignment_1_3_3)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__4__Impl
	rule__AnnotatedExportableElement__Group_1_3__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getLeftCurlyBracketKeyword_1_3_4()); }
	LeftCurlyBracket
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getLeftCurlyBracketKeyword_1_3_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__5__Impl
	rule__AnnotatedExportableElement__Group_1_3__6
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_5()); }
	(rule__AnnotatedExportableElement__LiteralsAssignment_1_3_5)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__6__Impl
	rule__AnnotatedExportableElement__Group_1_3__7
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3_6()); }
	(rule__AnnotatedExportableElement__Group_1_3_6__0)*
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getRightCurlyBracketKeyword_1_3_7()); }
	RightCurlyBracket
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getRightCurlyBracketKeyword_1_3_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExportableElement__Group_1_3_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3_6__0__Impl
	rule__AnnotatedExportableElement__Group_1_3_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_3_6_0()); }
	Comma
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_3_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExportableElement__Group_1_3_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExportableElement__Group_1_3_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_6_1()); }
	(rule__AnnotatedExportableElement__LiteralsAssignment_1_3_6_1)
	{ after(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclaration__Group__0__Impl
	rule__ImportDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationAccess().getImportDeclarationAction_0()); }
	()
	{ after(grammarAccess.getImportDeclarationAccess().getImportDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationAccess().getImportDeclarationImplParserRuleCall_1()); }
	ruleImportDeclarationImpl
	{ after(grammarAccess.getImportDeclarationAccess().getImportDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclarationImpl__Group__0__Impl
	rule__ImportDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationImplAccess().getImportKeyword_0()); }
	Import
	{ after(grammarAccess.getImportDeclarationImplAccess().getImportKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclarationImpl__Group__1__Impl
	rule__ImportDeclarationImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationImplAccess().getGroup_1()); }
	(rule__ImportDeclarationImpl__Group_1__0)?
	{ after(grammarAccess.getImportDeclarationImplAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclarationImpl__Group__2__Impl
	rule__ImportDeclarationImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationImplAccess().getModuleAssignment_2()); }
	(rule__ImportDeclarationImpl__ModuleAssignment_2)
	{ after(grammarAccess.getImportDeclarationImplAccess().getModuleAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclarationImpl__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationImplAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getImportDeclarationImplAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportDeclarationImpl__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclarationImpl__Group_1__0__Impl
	rule__ImportDeclarationImpl__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationImplAccess().getImportClauseParserRuleCall_1_0()); }
	ruleImportClause
	{ after(grammarAccess.getImportDeclarationImplAccess().getImportClauseParserRuleCall_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportDeclarationImpl__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportDeclarationImpl__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportDeclarationImplAccess().getImportFromAssignment_1_1()); }
	(rule__ImportDeclarationImpl__ImportFromAssignment_1_1)
	{ after(grammarAccess.getImportDeclarationImplAccess().getImportFromAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportClause__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportClause__Group_0__0__Impl
	rule__ImportClause__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportClause__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportClauseAccess().getImportSpecifiersAssignment_0_0()); }
	(rule__ImportClause__ImportSpecifiersAssignment_0_0)
	{ after(grammarAccess.getImportClauseAccess().getImportSpecifiersAssignment_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportClause__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportClause__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportClause__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportClauseAccess().getGroup_0_1()); }
	(rule__ImportClause__Group_0_1__0)?
	{ after(grammarAccess.getImportClauseAccess().getGroup_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportClause__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportClause__Group_0_1__0__Impl
	rule__ImportClause__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportClause__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportClauseAccess().getCommaKeyword_0_1_0()); }
	Comma
	{ after(grammarAccess.getImportClauseAccess().getCommaKeyword_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportClause__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportClause__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportClause__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_0_1_1()); }
	ruleImportSpecifiersExceptDefault
	{ after(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportSpecifiersExceptDefault__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1__0__Impl
	rule__ImportSpecifiersExceptDefault__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getLeftCurlyBracketKeyword_1_0()); }
	LeftCurlyBracket
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getLeftCurlyBracketKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1__1__Impl
	rule__ImportSpecifiersExceptDefault__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1_1()); }
	(rule__ImportSpecifiersExceptDefault__Group_1_1__0)?
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getRightCurlyBracketKeyword_1_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getRightCurlyBracketKeyword_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportSpecifiersExceptDefault__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1_1__0__Impl
	rule__ImportSpecifiersExceptDefault__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_0()); }
	(rule__ImportSpecifiersExceptDefault__ImportSpecifiersAssignment_1_1_0)
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1_1__1__Impl
	rule__ImportSpecifiersExceptDefault__Group_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1_1_1()); }
	(rule__ImportSpecifiersExceptDefault__Group_1_1_1__0)*
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_2()); }
	(Comma)?
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ImportSpecifiersExceptDefault__Group_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1_1_1__0__Impl
	rule__ImportSpecifiersExceptDefault__Group_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_1_0()); }
	Comma
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ImportSpecifiersExceptDefault__Group_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ImportSpecifiersExceptDefault__Group_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_1_1()); }
	(rule__ImportSpecifiersExceptDefault__ImportSpecifiersAssignment_1_1_1_1)
	{ after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NamedImportSpecifier__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamedImportSpecifier__Group_1__0__Impl
	rule__NamedImportSpecifier__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NamedImportSpecifier__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_1_0()); }
	(rule__NamedImportSpecifier__ImportedElementAssignment_1_0)
	{ after(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamedImportSpecifier__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamedImportSpecifier__Group_1__1__Impl
	rule__NamedImportSpecifier__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NamedImportSpecifier__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamedImportSpecifierAccess().getAsKeyword_1_1()); }
	As
	{ after(grammarAccess.getNamedImportSpecifierAccess().getAsKeyword_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamedImportSpecifier__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamedImportSpecifier__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NamedImportSpecifier__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamedImportSpecifierAccess().getAliasAssignment_1_2()); }
	(rule__NamedImportSpecifier__AliasAssignment_1_2)
	{ after(grammarAccess.getNamedImportSpecifierAccess().getAliasAssignment_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NamespaceImportSpecifier__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamespaceImportSpecifier__Group__0__Impl
	rule__NamespaceImportSpecifier__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamespaceImportSpecifierAccess().getNamespaceImportSpecifierAction_0()); }
	()
	{ after(grammarAccess.getNamespaceImportSpecifierAccess().getNamespaceImportSpecifierAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamespaceImportSpecifier__Group__1__Impl
	rule__NamespaceImportSpecifier__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamespaceImportSpecifierAccess().getAsteriskKeyword_1()); }
	Asterisk
	{ after(grammarAccess.getNamespaceImportSpecifierAccess().getAsteriskKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamespaceImportSpecifier__Group__2__Impl
	rule__NamespaceImportSpecifier__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamespaceImportSpecifierAccess().getAsKeyword_2()); }
	As
	{ after(grammarAccess.getNamespaceImportSpecifierAccess().getAsKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamespaceImportSpecifier__Group__3__Impl
	rule__NamespaceImportSpecifier__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamespaceImportSpecifierAccess().getAliasAssignment_3()); }
	(rule__NamespaceImportSpecifier__AliasAssignment_3)
	{ after(grammarAccess.getNamespaceImportSpecifierAccess().getAliasAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NamespaceImportSpecifier__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NamespaceImportSpecifier__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNamespaceImportSpecifierAccess().getDeclaredDynamicAssignment_4()); }
	(rule__NamespaceImportSpecifier__DeclaredDynamicAssignment_4)?
	{ after(grammarAccess.getNamespaceImportSpecifierAccess().getDeclaredDynamicAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionDeclaration__Group__0__Impl
	rule__FunctionDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getGroup_0()); }
	(rule__FunctionDeclaration__Group_0__0)
	{ after(grammarAccess.getFunctionDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1()); }
	(ruleSemi)?
	{ after(grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getGroup_0_0()); }
	(rule__FunctionDeclaration__Group_0_0__0)
	{ after(grammarAccess.getFunctionDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionDeclaration__Group_0_0__0__Impl
	rule__FunctionDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getFunctionDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getFunctionDeclarationAccess().getFunctionDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionDeclaration__Group_0_0__1__Impl
	rule__FunctionDeclaration__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getDeclaredModifiersAssignment_0_0_1()); }
	(rule__FunctionDeclaration__DeclaredModifiersAssignment_0_0_1)*
	{ after(grammarAccess.getFunctionDeclarationAccess().getDeclaredModifiersAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionDeclaration__Group_0_0__2__Impl
	rule__FunctionDeclaration__Group_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionDeclaration__Group_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionDeclaration__Group_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3()); }
	(ruleFunctionImpl)
	{ after(grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_FunctionDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionDeclaration__Group__0__Impl
	norm1_FunctionDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getGroup_0()); }
	(norm1_FunctionDeclaration__Group_0__0)
	{ after(grammarAccess.getFunctionDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1()); }
	(ruleSemi)?
	{ after(grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_FunctionDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getGroup_0_0()); }
	(norm1_FunctionDeclaration__Group_0_0__0)
	{ after(grammarAccess.getFunctionDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_FunctionDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionDeclaration__Group_0_0__0__Impl
	norm1_FunctionDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getFunctionDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getFunctionDeclarationAccess().getFunctionDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionDeclaration__Group_0_0__1__Impl
	norm1_FunctionDeclaration__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getDeclaredModifiersAssignment_0_0_1()); }
	(norm1_FunctionDeclaration__DeclaredModifiersAssignment_0_0_1)*
	{ after(grammarAccess.getFunctionDeclarationAccess().getDeclaredModifiersAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionDeclaration__Group_0_0__2__Impl
	norm1_FunctionDeclaration__Group_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionDeclaration__Group_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionDeclaration__Group_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3()); }
	(norm3_FunctionImpl)
	{ after(grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AsyncNoTrailingLineBreak__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncNoTrailingLineBreak__Group__0__Impl
	rule__AsyncNoTrailingLineBreak__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncNoTrailingLineBreak__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncNoTrailingLineBreakAccess().getDeclaredAsyncAssignment_0()); }
	(rule__AsyncNoTrailingLineBreak__DeclaredAsyncAssignment_0)
	{ after(grammarAccess.getAsyncNoTrailingLineBreakAccess().getDeclaredAsyncAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncNoTrailingLineBreak__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncNoTrailingLineBreak__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncNoTrailingLineBreak__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncNoTrailingLineBreakAccess().getNoLineTerminatorParserRuleCall_1()); }
	ruleNoLineTerminator
	{ after(grammarAccess.getAsyncNoTrailingLineBreakAccess().getNoLineTerminatorParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionImpl__Group__0__Impl
	rule__FunctionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionKeyword_0()); }
	Function
	{ after(grammarAccess.getFunctionImplAccess().getFunctionKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getAlternatives_1()); }
	(rule__FunctionImpl__Alternatives_1)
	{ after(grammarAccess.getFunctionImplAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionImpl__Group_1_0__0__Impl
	rule__FunctionImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getGeneratorAssignment_1_0_0()); }
	(rule__FunctionImpl__GeneratorAssignment_1_0_0)
	{ after(grammarAccess.getFunctionImplAccess().getGeneratorAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionImpl__Group_1_0__1__Impl
	rule__FunctionImpl__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); }
	norm2_FunctionHeader
	{ after(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionImpl__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); }
	norm1_FunctionBody
	{ after(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionImpl__Group_1_1__0__Impl
	rule__FunctionImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); }
	ruleFunctionHeader
	{ after(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionImpl__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); }
	ruleFunctionBody
	{ after(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_FunctionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionImpl__Group__0__Impl
	norm3_FunctionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionKeyword_0()); }
	Function
	{ after(grammarAccess.getFunctionImplAccess().getFunctionKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getAlternatives_1()); }
	(norm3_FunctionImpl__Alternatives_1)
	{ after(grammarAccess.getFunctionImplAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_FunctionImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionImpl__Group_1_0__0__Impl
	norm3_FunctionImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getGeneratorAssignment_1_0_0()); }
	(norm3_FunctionImpl__GeneratorAssignment_1_0_0)
	{ after(grammarAccess.getFunctionImplAccess().getGeneratorAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionImpl__Group_1_0__1__Impl
	norm3_FunctionImpl__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); }
	norm3_FunctionHeader
	{ after(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionImpl__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); }
	norm1_FunctionBody
	{ after(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_FunctionImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionImpl__Group_1_1__0__Impl
	norm3_FunctionImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); }
	norm1_FunctionHeader
	{ after(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionImpl__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); }
	ruleFunctionBody
	{ after(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_FunctionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_FunctionImpl__Group__0__Impl
	norm6_FunctionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionKeyword_0()); }
	Function
	{ after(grammarAccess.getFunctionImplAccess().getFunctionKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_FunctionImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getAlternatives_1()); }
	(norm6_FunctionImpl__Alternatives_1)
	{ after(grammarAccess.getFunctionImplAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_FunctionImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_FunctionImpl__Group_1_0__0__Impl
	norm6_FunctionImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getGeneratorAssignment_1_0_0()); }
	(norm6_FunctionImpl__GeneratorAssignment_1_0_0)
	{ after(grammarAccess.getFunctionImplAccess().getGeneratorAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_FunctionImpl__Group_1_0__1__Impl
	norm6_FunctionImpl__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); }
	norm3_FunctionHeader
	{ after(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_FunctionImpl__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); }
	norm3_FunctionBody
	{ after(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_FunctionImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_FunctionImpl__Group_1_1__0__Impl
	norm6_FunctionImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); }
	ruleFunctionHeader
	{ after(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_FunctionImpl__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_FunctionImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); }
	norm2_FunctionBody
	{ after(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionHeader__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionHeader__Group__0__Impl
	rule__FunctionHeader__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionHeader__Group__1__Impl
	rule__FunctionHeader__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
	(rule__FunctionHeader__NameAssignment_1)?
	{ after(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionHeader__Group__2__Impl
	rule__FunctionHeader__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
	(ruleVersionDeclaration)?
	{ after(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionHeader__Group__3__Impl
	rule__FunctionHeader__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
	ruleStrictFormalParameters
	{ after(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionHeader__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionHeader__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_FunctionHeader__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionHeader__Group__0__Impl
	norm1_FunctionHeader__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionHeader__Group__1__Impl
	norm1_FunctionHeader__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
	(norm1_FunctionHeader__NameAssignment_1)?
	{ after(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionHeader__Group__2__Impl
	norm1_FunctionHeader__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
	(ruleVersionDeclaration)?
	{ after(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionHeader__Group__3__Impl
	norm1_FunctionHeader__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
	ruleStrictFormalParameters
	{ after(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FunctionHeader__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_FunctionHeader__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_FunctionHeader__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_FunctionHeader__Group__0__Impl
	norm2_FunctionHeader__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_FunctionHeader__Group__1__Impl
	norm2_FunctionHeader__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
	(norm2_FunctionHeader__NameAssignment_1)?
	{ after(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_FunctionHeader__Group__2__Impl
	norm2_FunctionHeader__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
	(ruleVersionDeclaration)?
	{ after(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_FunctionHeader__Group__3__Impl
	norm2_FunctionHeader__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
	norm1_StrictFormalParameters
	{ after(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_FunctionHeader__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_FunctionHeader__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_FunctionHeader__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionHeader__Group__0__Impl
	norm3_FunctionHeader__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionHeader__Group__1__Impl
	norm3_FunctionHeader__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
	(norm3_FunctionHeader__NameAssignment_1)?
	{ after(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionHeader__Group__2__Impl
	norm3_FunctionHeader__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
	(ruleVersionDeclaration)?
	{ after(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionHeader__Group__3__Impl
	norm3_FunctionHeader__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
	norm1_StrictFormalParameters
	{ after(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_FunctionHeader__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_FunctionHeader__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedFunctionDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedFunctionDeclaration__Group__0__Impl
	rule__AnnotatedFunctionDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedFunctionDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAssignment_0()); }
	(rule__AnnotatedFunctionDeclaration__AnnotationListAssignment_0)
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedFunctionDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedFunctionDeclaration__Group__1__Impl
	rule__AnnotatedFunctionDeclaration__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedFunctionDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getDeclaredModifiersAssignment_1()); }
	(rule__AnnotatedFunctionDeclaration__DeclaredModifiersAssignment_1)*
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getDeclaredModifiersAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedFunctionDeclaration__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedFunctionDeclaration__Group__2__Impl
	rule__AnnotatedFunctionDeclaration__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedFunctionDeclaration__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedFunctionDeclaration__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedFunctionDeclaration__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedFunctionDeclaration__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3()); }
	ruleFunctionImpl
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedFunctionDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedFunctionDeclaration__Group__0__Impl
	norm1_AnnotatedFunctionDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedFunctionDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAssignment_0()); }
	(norm1_AnnotatedFunctionDeclaration__AnnotationListAssignment_0)
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedFunctionDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedFunctionDeclaration__Group__1__Impl
	norm1_AnnotatedFunctionDeclaration__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedFunctionDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getDeclaredModifiersAssignment_1()); }
	(norm1_AnnotatedFunctionDeclaration__DeclaredModifiersAssignment_1)*
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getDeclaredModifiersAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedFunctionDeclaration__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedFunctionDeclaration__Group__2__Impl
	norm1_AnnotatedFunctionDeclaration__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedFunctionDeclaration__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedFunctionDeclaration__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedFunctionDeclaration__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedFunctionDeclaration__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3()); }
	norm3_FunctionImpl
	{ after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionExpression__Group__0__Impl
	rule__FunctionExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionExpressionAccess().getFunctionExpressionAction_0()); }
	()
	{ after(grammarAccess.getFunctionExpressionAccess().getFunctionExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionExpressionAccess().getFunctionImplParserRuleCall_1()); }
	norm6_FunctionImpl
	{ after(grammarAccess.getFunctionExpressionAccess().getFunctionImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AsyncFunctionExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncFunctionExpression__Group__0__Impl
	rule__AsyncFunctionExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncFunctionExpressionAccess().getGroup_0()); }
	(rule__AsyncFunctionExpression__Group_0__0)
	{ after(grammarAccess.getAsyncFunctionExpressionAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncFunctionExpression__Group__1__Impl
	rule__AsyncFunctionExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionHeaderParserRuleCall_1()); }
	ruleFunctionHeader
	{ after(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionHeaderParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncFunctionExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionBodyParserRuleCall_2()); }
	norm2_FunctionBody
	{ after(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionBodyParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AsyncFunctionExpression__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncFunctionExpression__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncFunctionExpressionAccess().getGroup_0_0()); }
	(rule__AsyncFunctionExpression__Group_0_0__0)
	{ after(grammarAccess.getAsyncFunctionExpressionAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AsyncFunctionExpression__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncFunctionExpression__Group_0_0__0__Impl
	rule__AsyncFunctionExpression__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncFunctionExpressionAccess().getDeclaredAsyncAssignment_0_0_0()); }
	(rule__AsyncFunctionExpression__DeclaredAsyncAssignment_0_0_0)
	{ after(grammarAccess.getAsyncFunctionExpressionAccess().getDeclaredAsyncAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncFunctionExpression__Group_0_0__1__Impl
	rule__AsyncFunctionExpression__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncFunctionExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_1()); }
	ruleNoLineTerminator
	{ after(grammarAccess.getAsyncFunctionExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AsyncFunctionExpression__Group_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AsyncFunctionExpression__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionKeyword_0_0_2()); }
	Function
	{ after(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionKeyword_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group__0__Impl
	rule__ArrowExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
	(rule__ArrowExpression__Group_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
	(rule__ArrowExpression__Alternatives_1)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
	(rule__ArrowExpression__Group_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0__0__Impl
	rule__ArrowExpression__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
	(rule__ArrowExpression__Alternatives_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
	EqualsSignGreaterThanSign
	{ after(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group_0_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_0__0__Impl
	rule__ArrowExpression__Group_0_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
	ruleStrictFormalParameters
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group_0_0_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_1__0__Impl
	rule__ArrowExpression__Group_0_0_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
	(rule__ArrowExpression__Group_0_0_0_1_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group_0_0_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
	(rule__ArrowExpression__Group_0_0_0_1_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group_0_0_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	rule__ArrowExpression__Group_0_0_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
	(rule__ArrowExpression__DeclaredAsyncAssignment_0_0_0_1_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	rule__ArrowExpression__Group_0_0_0_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
	ruleNoLineTerminator
	{ after(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_0_0_0_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_0_0_0_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
	(ruleStrictFormalParameters)
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrowExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_1_0__0__Impl
	rule__ArrowExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
	(rule__ArrowExpression__HasBracesAroundBodyAssignment_1_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_1_0__1__Impl
	rule__ArrowExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
	(rule__ArrowExpression__BodyAssignment_1_0_1)
	{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrowExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrowExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group__0__Impl
	norm1_ArrowExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
	(norm1_ArrowExpression__Group_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
	(norm1_ArrowExpression__Alternatives_1)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
	(norm1_ArrowExpression__Group_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0__0__Impl
	norm1_ArrowExpression__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
	(norm1_ArrowExpression__Alternatives_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
	EqualsSignGreaterThanSign
	{ after(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group_0_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_0__0__Impl
	norm1_ArrowExpression__Group_0_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
	ruleStrictFormalParameters
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group_0_0_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_1__0__Impl
	norm1_ArrowExpression__Group_0_0_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
	(norm1_ArrowExpression__Group_0_0_0_1_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group_0_0_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
	(norm1_ArrowExpression__Group_0_0_0_1_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group_0_0_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	norm1_ArrowExpression__Group_0_0_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
	(norm1_ArrowExpression__DeclaredAsyncAssignment_0_0_0_1_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	norm1_ArrowExpression__Group_0_0_0_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
	ruleNoLineTerminator
	{ after(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_0_0_0_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_0_0_0_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
	(ruleStrictFormalParameters)
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrowExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_1_0__0__Impl
	norm1_ArrowExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
	(norm1_ArrowExpression__HasBracesAroundBodyAssignment_1_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_1_0__1__Impl
	norm1_ArrowExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
	(norm1_ArrowExpression__BodyAssignment_1_0_1)
	{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrowExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrowExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group__0__Impl
	norm2_ArrowExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
	(norm2_ArrowExpression__Group_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
	(norm2_ArrowExpression__Alternatives_1)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
	(norm2_ArrowExpression__Group_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0__0__Impl
	norm2_ArrowExpression__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
	(norm2_ArrowExpression__Alternatives_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
	EqualsSignGreaterThanSign
	{ after(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group_0_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_0__0__Impl
	norm2_ArrowExpression__Group_0_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
	norm1_StrictFormalParameters
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group_0_0_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_1__0__Impl
	norm2_ArrowExpression__Group_0_0_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
	(norm2_ArrowExpression__Group_0_0_0_1_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group_0_0_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
	(norm2_ArrowExpression__Group_0_0_0_1_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group_0_0_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	norm2_ArrowExpression__Group_0_0_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
	(norm2_ArrowExpression__DeclaredAsyncAssignment_0_0_0_1_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	norm2_ArrowExpression__Group_0_0_0_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
	ruleNoLineTerminator
	{ after(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_0_0_0_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_0_0_0_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
	(norm1_StrictFormalParameters)
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_ArrowExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_1_0__0__Impl
	norm2_ArrowExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
	(norm2_ArrowExpression__HasBracesAroundBodyAssignment_1_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_1_0__1__Impl
	norm2_ArrowExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
	(norm2_ArrowExpression__BodyAssignment_1_0_1)
	{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_ArrowExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_ArrowExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group__0__Impl
	norm3_ArrowExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
	(norm3_ArrowExpression__Group_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
	(norm3_ArrowExpression__Alternatives_1)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
	(norm3_ArrowExpression__Group_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0__0__Impl
	norm3_ArrowExpression__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
	(norm3_ArrowExpression__Alternatives_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
	EqualsSignGreaterThanSign
	{ after(grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group_0_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_0__0__Impl
	norm3_ArrowExpression__Group_0_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
	norm1_StrictFormalParameters
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group_0_0_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_1__0__Impl
	norm3_ArrowExpression__Group_0_0_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
	(norm3_ArrowExpression__Group_0_0_0_1_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
	(ruleColonSepReturnTypeRef)?
	{ after(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group_0_0_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
	(norm3_ArrowExpression__Group_0_0_0_1_0_0__0)
	{ after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group_0_0_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	norm3_ArrowExpression__Group_0_0_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
	(norm3_ArrowExpression__DeclaredAsyncAssignment_0_0_0_1_0_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	norm3_ArrowExpression__Group_0_0_0_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
	ruleNoLineTerminator
	{ after(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_0_0_0_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_0_0_0_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
	(norm1_StrictFormalParameters)
	{ after(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_ArrowExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_1_0__0__Impl
	norm3_ArrowExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
	(norm3_ArrowExpression__HasBracesAroundBodyAssignment_1_0_0)
	{ after(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_1_0__1__Impl
	norm3_ArrowExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
	(norm3_ArrowExpression__BodyAssignment_1_0_1)
	{ after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_ArrowExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_ArrowExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StrictFormalParameters__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StrictFormalParameters__Group__0__Impl
	rule__StrictFormalParameters__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0()); }
	LeftParenthesis
	{ after(grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StrictFormalParameters__Group__1__Impl
	rule__StrictFormalParameters__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getGroup_1()); }
	(rule__StrictFormalParameters__Group_1__0)?
	{ after(grammarAccess.getStrictFormalParametersAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StrictFormalParameters__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2()); }
	RightParenthesis
	{ after(grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StrictFormalParameters__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StrictFormalParameters__Group_1__0__Impl
	rule__StrictFormalParameters__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_0()); }
	(rule__StrictFormalParameters__FparsAssignment_1_0)
	{ after(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StrictFormalParameters__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getGroup_1_1()); }
	(rule__StrictFormalParameters__Group_1_1__0)*
	{ after(grammarAccess.getStrictFormalParametersAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StrictFormalParameters__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StrictFormalParameters__Group_1_1__0__Impl
	rule__StrictFormalParameters__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0()); }
	Comma
	{ after(grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StrictFormalParameters__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StrictFormalParameters__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_1_1()); }
	(rule__StrictFormalParameters__FparsAssignment_1_1_1)
	{ after(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_StrictFormalParameters__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_StrictFormalParameters__Group__0__Impl
	norm1_StrictFormalParameters__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0()); }
	LeftParenthesis
	{ after(grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_StrictFormalParameters__Group__1__Impl
	norm1_StrictFormalParameters__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getGroup_1()); }
	(norm1_StrictFormalParameters__Group_1__0)?
	{ after(grammarAccess.getStrictFormalParametersAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_StrictFormalParameters__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2()); }
	RightParenthesis
	{ after(grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_StrictFormalParameters__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_StrictFormalParameters__Group_1__0__Impl
	norm1_StrictFormalParameters__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_0()); }
	(norm1_StrictFormalParameters__FparsAssignment_1_0)
	{ after(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_StrictFormalParameters__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getGroup_1_1()); }
	(norm1_StrictFormalParameters__Group_1_1__0)*
	{ after(grammarAccess.getStrictFormalParametersAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_StrictFormalParameters__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_StrictFormalParameters__Group_1_1__0__Impl
	norm1_StrictFormalParameters__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0()); }
	Comma
	{ after(grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_StrictFormalParameters__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_StrictFormalParameters__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_1_1()); }
	(norm1_StrictFormalParameters__FparsAssignment_1_1_1)
	{ after(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BlockMinusBraces__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BlockMinusBraces__Group__0__Impl
	rule__BlockMinusBraces__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockMinusBraces__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockMinusBracesAccess().getBlockAction_0()); }
	()
	{ after(grammarAccess.getBlockMinusBracesAccess().getBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockMinusBraces__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BlockMinusBraces__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockMinusBraces__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockMinusBracesAccess().getStatementsAssignment_1()); }
	(rule__BlockMinusBraces__StatementsAssignment_1)*
	{ after(grammarAccess.getBlockMinusBracesAccess().getStatementsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_BlockMinusBraces__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BlockMinusBraces__Group__0__Impl
	norm1_BlockMinusBraces__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_BlockMinusBraces__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockMinusBracesAccess().getBlockAction_0()); }
	()
	{ after(grammarAccess.getBlockMinusBracesAccess().getBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BlockMinusBraces__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BlockMinusBraces__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_BlockMinusBraces__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockMinusBracesAccess().getStatementsAssignment_1()); }
	(norm1_BlockMinusBraces__StatementsAssignment_1)*
	{ after(grammarAccess.getBlockMinusBracesAccess().getStatementsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExpressionDisguisedAsBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExpressionDisguisedAsBlock__Group__0__Impl
	rule__ExpressionDisguisedAsBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionDisguisedAsBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionDisguisedAsBlockAccess().getBlockAction_0()); }
	()
	{ after(grammarAccess.getExpressionDisguisedAsBlockAccess().getBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionDisguisedAsBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExpressionDisguisedAsBlock__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionDisguisedAsBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignment_1()); }
	(rule__ExpressionDisguisedAsBlock__StatementsAssignment_1)
	{ after(grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ExpressionDisguisedAsBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExpressionDisguisedAsBlock__Group__0__Impl
	norm1_ExpressionDisguisedAsBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExpressionDisguisedAsBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionDisguisedAsBlockAccess().getBlockAction_0()); }
	()
	{ after(grammarAccess.getExpressionDisguisedAsBlockAccess().getBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExpressionDisguisedAsBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExpressionDisguisedAsBlock__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExpressionDisguisedAsBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignment_1()); }
	(norm1_ExpressionDisguisedAsBlock__StatementsAssignment_1)
	{ after(grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group__0__Impl
	rule__AnnotatedExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0()); }
	ruleExpressionAnnotationList
	{ after(grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getAlternatives_1()); }
	(rule__AnnotatedExpression__Alternatives_1)
	{ after(grammarAccess.getAnnotatedExpressionAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_0__0__Impl
	rule__AnnotatedExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getN4ClassExpressionAnnotationListAction_1_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedExpressionAccess().getN4ClassExpressionAnnotationListAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_0__1__Impl
	rule__AnnotatedExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1()); }
	Class
	{ after(grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_0__2__Impl
	rule__AnnotatedExpression__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getNameAssignment_1_0_2()); }
	(rule__AnnotatedExpression__NameAssignment_1_0_2)?
	{ after(grammarAccess.getAnnotatedExpressionAccess().getNameAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_0__3__Impl
	rule__AnnotatedExpression__Group_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3()); }
	(ruleClassExtendsImplements)?
	{ after(grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4()); }
	ruleMembers
	{ after(grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedExpression__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_1__0__Impl
	rule__AnnotatedExpression__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getFunctionExpressionAnnotationListAction_1_1_0()); }
	()
	{ after(grammarAccess.getAnnotatedExpressionAccess().getFunctionExpressionAnnotationListAction_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_1__1__Impl
	rule__AnnotatedExpression__Group_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedExpression__Group_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedExpression__Group_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2()); }
	norm6_FunctionImpl
	{ after(grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group__0__Impl
	norm1_AnnotatedExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0()); }
	ruleExpressionAnnotationList
	{ after(grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getAlternatives_1()); }
	(norm1_AnnotatedExpression__Alternatives_1)
	{ after(grammarAccess.getAnnotatedExpressionAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_0__0__Impl
	norm1_AnnotatedExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getN4ClassExpressionAnnotationListAction_1_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedExpressionAccess().getN4ClassExpressionAnnotationListAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_0__1__Impl
	norm1_AnnotatedExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1()); }
	Class
	{ after(grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_0__2__Impl
	norm1_AnnotatedExpression__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getNameAssignment_1_0_2()); }
	(norm1_AnnotatedExpression__NameAssignment_1_0_2)?
	{ after(grammarAccess.getAnnotatedExpressionAccess().getNameAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_0__3__Impl
	norm1_AnnotatedExpression__Group_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3()); }
	(norm1_ClassExtendsImplements)?
	{ after(grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4()); }
	norm1_Members
	{ after(grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedExpression__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_1__0__Impl
	norm1_AnnotatedExpression__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getFunctionExpressionAnnotationListAction_1_1_0()); }
	()
	{ after(grammarAccess.getAnnotatedExpressionAccess().getFunctionExpressionAnnotationListAction_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_1__1__Impl
	norm1_AnnotatedExpression__Group_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1()); }
	ruleAsyncNoTrailingLineBreak
	{ after(grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedExpression__Group_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedExpression__Group_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2()); }
	norm6_FunctionImpl
	{ after(grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeVariable__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeVariable__Group__0__Impl
	rule__TypeVariable__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeVariableAccess().getAlternatives_0()); }
	(rule__TypeVariable__Alternatives_0)?
	{ after(grammarAccess.getTypeVariableAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeVariable__Group__1__Impl
	rule__TypeVariable__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeVariableAccess().getNameAssignment_1()); }
	(rule__TypeVariable__NameAssignment_1)
	{ after(grammarAccess.getTypeVariableAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeVariable__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeVariableAccess().getGroup_2()); }
	(rule__TypeVariable__Group_2__0)?
	{ after(grammarAccess.getTypeVariableAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeVariable__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeVariable__Group_2__0__Impl
	rule__TypeVariable__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeVariableAccess().getExtendsKeyword_2_0()); }
	Extends
	{ after(grammarAccess.getTypeVariableAccess().getExtendsKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeVariable__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeVariable__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeVariableAccess().getDeclaredUpperBoundAssignment_2_1()); }
	(rule__TypeVariable__DeclaredUpperBoundAssignment_2_1)
	{ after(grammarAccess.getTypeVariableAccess().getDeclaredUpperBoundAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FormalParameter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group__0__Impl
	rule__FormalParameter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getFormalParameterAction_0()); }
	()
	{ after(grammarAccess.getFormalParameterAccess().getFormalParameterAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1()); }
	ruleBindingElementFragment
	{ after(grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_FormalParameter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FormalParameter__Group__0__Impl
	norm1_FormalParameter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_FormalParameter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getFormalParameterAction_0()); }
	()
	{ after(grammarAccess.getFormalParameterAccess().getFormalParameterAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FormalParameter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FormalParameter__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_FormalParameter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1()); }
	norm1_BindingElementFragment
	{ after(grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BindingElementFragment__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group__0__Impl
	rule__BindingElementFragment__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getAlternatives_0()); }
	(rule__BindingElementFragment__Alternatives_0)
	{ after(grammarAccess.getBindingElementFragmentAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getGroup_1()); }
	(rule__BindingElementFragment__Group_1__0)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BindingElementFragment__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group_0_1__0__Impl
	rule__BindingElementFragment__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getAnnotationsAssignment_0_1_0()); }
	(rule__BindingElementFragment__AnnotationsAssignment_0_1_0)*
	{ after(grammarAccess.getBindingElementFragmentAccess().getAnnotationsAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group_0_1__1__Impl
	rule__BindingElementFragment__Group_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1()); }
	(ruleBogusTypeRefFragment)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group_0_1__2__Impl
	rule__BindingElementFragment__Group_0_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getVariadicAssignment_0_1_2()); }
	(rule__BindingElementFragment__VariadicAssignment_0_1_2)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getVariadicAssignment_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group_0_1__3__Impl
	rule__BindingElementFragment__Group_0_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getNameAssignment_0_1_3()); }
	(rule__BindingElementFragment__NameAssignment_0_1_3)
	{ after(grammarAccess.getBindingElementFragmentAccess().getNameAssignment_0_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group_0_1__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_0_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4()); }
	(ruleColonSepDeclaredTypeRef)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BindingElementFragment__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group_1__0__Impl
	rule__BindingElementFragment__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentAssignment_1_0()); }
	(rule__BindingElementFragment__HasInitializerAssignmentAssignment_1_0)
	{ after(grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BindingElementFragment__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BindingElementFragment__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getInitializerAssignment_1_1()); }
	(rule__BindingElementFragment__InitializerAssignment_1_1)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getInitializerAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_BindingElementFragment__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group__0__Impl
	norm1_BindingElementFragment__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getAlternatives_0()); }
	(norm1_BindingElementFragment__Alternatives_0)
	{ after(grammarAccess.getBindingElementFragmentAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getGroup_1()); }
	(norm1_BindingElementFragment__Group_1__0)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_BindingElementFragment__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group_0_1__0__Impl
	norm1_BindingElementFragment__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getAnnotationsAssignment_0_1_0()); }
	(norm1_BindingElementFragment__AnnotationsAssignment_0_1_0)*
	{ after(grammarAccess.getBindingElementFragmentAccess().getAnnotationsAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group_0_1__1__Impl
	norm1_BindingElementFragment__Group_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1()); }
	(ruleBogusTypeRefFragment)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group_0_1__2__Impl
	norm1_BindingElementFragment__Group_0_1__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getVariadicAssignment_0_1_2()); }
	(norm1_BindingElementFragment__VariadicAssignment_0_1_2)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getVariadicAssignment_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group_0_1__3__Impl
	norm1_BindingElementFragment__Group_0_1__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getNameAssignment_0_1_3()); }
	(norm1_BindingElementFragment__NameAssignment_0_1_3)
	{ after(grammarAccess.getBindingElementFragmentAccess().getNameAssignment_0_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group_0_1__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_0_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4()); }
	(ruleColonSepDeclaredTypeRef)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_BindingElementFragment__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group_1__0__Impl
	norm1_BindingElementFragment__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentAssignment_1_0()); }
	(norm1_BindingElementFragment__HasInitializerAssignmentAssignment_1_0)
	{ after(grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BindingElementFragment__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_BindingElementFragment__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBindingElementFragmentAccess().getInitializerAssignment_1_1()); }
	(norm1_BindingElementFragment__InitializerAssignment_1_1)?
	{ after(grammarAccess.getBindingElementFragmentAccess().getInitializerAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Block__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Block__Group__0__Impl
	rule__Block__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getGroup_0()); }
	(rule__Block__Group_0__0)
	{ after(grammarAccess.getBlockAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Block__Group__1__Impl
	rule__Block__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getStatementsAssignment_1()); }
	(rule__Block__StatementsAssignment_1)*
	{ after(grammarAccess.getBlockAccess().getStatementsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Block__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Block__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Block__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getGroup_0_0()); }
	(rule__Block__Group_0_0__0)
	{ after(grammarAccess.getBlockAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Block__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Block__Group_0_0__0__Impl
	rule__Block__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getBlockAction_0_0_0()); }
	()
	{ after(grammarAccess.getBlockAccess().getBlockAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Block__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Block__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1()); }
	LeftCurlyBracket
	{ after(grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_Block__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Block__Group__0__Impl
	norm1_Block__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getGroup_0()); }
	(norm1_Block__Group_0__0)
	{ after(grammarAccess.getBlockAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Block__Group__1__Impl
	norm1_Block__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getStatementsAssignment_1()); }
	(norm1_Block__StatementsAssignment_1)*
	{ after(grammarAccess.getBlockAccess().getStatementsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Block__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2()); }
	RightCurlyBracket
	{ after(grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_Block__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Block__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getGroup_0_0()); }
	(norm1_Block__Group_0_0__0)
	{ after(grammarAccess.getBlockAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_Block__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Block__Group_0_0__0__Impl
	norm1_Block__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getBlockAction_0_0_0()); }
	()
	{ after(grammarAccess.getBlockAccess().getBlockAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Block__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_Block__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1()); }
	LeftCurlyBracket
	{ after(grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group__0__Impl
	norm1_VariableStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getGroup_0()); }
	(norm1_VariableStatement__Group_0__0)
	{ after(grammarAccess.getVariableStatementAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group__1__Impl
	norm1_VariableStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_1()); }
	(norm1_VariableStatement__VarDeclsOrBindingsAssignment_1)
	{ after(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group__2__Impl
	norm1_VariableStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getGroup_2()); }
	(norm1_VariableStatement__Group_2__0)*
	{ after(grammarAccess.getVariableStatementAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableStatement__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getGroup_0_0()); }
	(norm1_VariableStatement__Group_0_0__0)
	{ after(grammarAccess.getVariableStatementAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableStatement__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group_0_0__0__Impl
	norm1_VariableStatement__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVariableStatementAction_0_0_0()); }
	()
	{ after(grammarAccess.getVariableStatementAccess().getVariableStatementAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVarStmtKeywordAssignment_0_0_1()); }
	(norm1_VariableStatement__VarStmtKeywordAssignment_0_0_1)
	{ after(grammarAccess.getVariableStatementAccess().getVarStmtKeywordAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableStatement__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group_2__0__Impl
	norm1_VariableStatement__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0()); }
	Comma
	{ after(grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableStatement__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableStatement__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_2_1()); }
	(norm1_VariableStatement__VarDeclsOrBindingsAssignment_2_1)
	{ after(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group__0__Impl
	norm3_VariableStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getGroup_0()); }
	(norm3_VariableStatement__Group_0__0)
	{ after(grammarAccess.getVariableStatementAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group__1__Impl
	norm3_VariableStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_1()); }
	(norm3_VariableStatement__VarDeclsOrBindingsAssignment_1)
	{ after(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group__2__Impl
	norm3_VariableStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getGroup_2()); }
	(norm3_VariableStatement__Group_2__0)*
	{ after(grammarAccess.getVariableStatementAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableStatement__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getGroup_0_0()); }
	(norm3_VariableStatement__Group_0_0__0)
	{ after(grammarAccess.getVariableStatementAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableStatement__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group_0_0__0__Impl
	norm3_VariableStatement__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVariableStatementAction_0_0_0()); }
	()
	{ after(grammarAccess.getVariableStatementAccess().getVariableStatementAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVarStmtKeywordAssignment_0_0_1()); }
	(norm3_VariableStatement__VarStmtKeywordAssignment_0_0_1)
	{ after(grammarAccess.getVariableStatementAccess().getVarStmtKeywordAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableStatement__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group_2__0__Impl
	norm3_VariableStatement__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0()); }
	Comma
	{ after(grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableStatement__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableStatement__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_2_1()); }
	(norm3_VariableStatement__VarDeclsOrBindingsAssignment_2_1)
	{ after(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportedVariableStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group__0__Impl
	rule__ExportedVariableStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getExportedVariableStatementAction_0()); }
	()
	{ after(grammarAccess.getExportedVariableStatementAccess().getExportedVariableStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group__1__Impl
	rule__ExportedVariableStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getDeclaredModifiersAssignment_1()); }
	(rule__ExportedVariableStatement__DeclaredModifiersAssignment_1)*
	{ after(grammarAccess.getExportedVariableStatementAccess().getDeclaredModifiersAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group__2__Impl
	rule__ExportedVariableStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getVarStmtKeywordAssignment_2()); }
	(rule__ExportedVariableStatement__VarStmtKeywordAssignment_2)
	{ after(grammarAccess.getExportedVariableStatementAccess().getVarStmtKeywordAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group__3__Impl
	rule__ExportedVariableStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_3()); }
	(rule__ExportedVariableStatement__VarDeclsOrBindingsAssignment_3)
	{ after(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group__4__Impl
	rule__ExportedVariableStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getGroup_4()); }
	(rule__ExportedVariableStatement__Group_4__0)*
	{ after(grammarAccess.getExportedVariableStatementAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getSemiParserRuleCall_5()); }
	ruleSemi
	{ after(grammarAccess.getExportedVariableStatementAccess().getSemiParserRuleCall_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportedVariableStatement__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group_4__0__Impl
	rule__ExportedVariableStatement__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getCommaKeyword_4_0()); }
	Comma
	{ after(grammarAccess.getExportedVariableStatementAccess().getCommaKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableStatement__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableStatement__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_4_1()); }
	(rule__ExportedVariableStatement__VarDeclsOrBindingsAssignment_4_1)
	{ after(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableBinding__Group__0__Impl
	rule__VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(rule__VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
	(rule__VariableBinding__Group_1_1__0)
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableBinding__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableBinding__Group_1_1__0__Impl
	rule__VariableBinding__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableBinding__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableBinding__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableBinding__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableBinding__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
	(rule__VariableBinding__ExpressionAssignment_1_1_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableBinding__Group__0__Impl
	norm1_VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(norm1_VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
	(norm1_VariableBinding__Group_1_1__0)
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableBinding__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableBinding__Group_1_1__0__Impl
	norm1_VariableBinding__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableBinding__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableBinding__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableBinding__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableBinding__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
	(norm1_VariableBinding__ExpressionAssignment_1_1_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableBinding__Group__0__Impl
	norm2_VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(norm2_VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
	(norm2_VariableBinding__Group_1_1__0)
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_VariableBinding__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableBinding__Group_1_1__0__Impl
	norm2_VariableBinding__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableBinding__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableBinding__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableBinding__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableBinding__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
	(norm2_VariableBinding__ExpressionAssignment_1_1_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableBinding__Group__0__Impl
	norm3_VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(norm3_VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
	(norm3_VariableBinding__Group_1_1__0)
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableBinding__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableBinding__Group_1_1__0__Impl
	norm3_VariableBinding__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableBinding__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableBinding__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableBinding__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableBinding__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
	(norm3_VariableBinding__ExpressionAssignment_1_1_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableBinding__Group__0__Impl
	norm4_VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(norm4_VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
	(norm4_VariableBinding__Group_1_0_0__0)?
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableBinding__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableBinding__Group_1_0_0__0__Impl
	norm4_VariableBinding__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableBinding__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableBinding__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableBinding__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableBinding__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
	(norm4_VariableBinding__ExpressionAssignment_1_0_0_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableBinding__Group__0__Impl
	norm5_VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(norm5_VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
	(norm5_VariableBinding__Group_1_0_0__0)?
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableBinding__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableBinding__Group_1_0_0__0__Impl
	norm5_VariableBinding__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableBinding__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableBinding__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableBinding__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableBinding__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
	(norm5_VariableBinding__ExpressionAssignment_1_0_0_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableBinding__Group__0__Impl
	norm6_VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(norm6_VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
	(norm6_VariableBinding__Group_1_0_0__0)?
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableBinding__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableBinding__Group_1_0_0__0__Impl
	norm6_VariableBinding__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableBinding__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableBinding__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableBinding__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableBinding__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
	(norm6_VariableBinding__ExpressionAssignment_1_0_0_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableBinding__Group__0__Impl
	norm7_VariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
	(norm7_VariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableBinding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
	(norm7_VariableBinding__Group_1_0_0__0)?
	{ after(grammarAccess.getVariableBindingAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableBinding__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableBinding__Group_1_0_0__0__Impl
	norm7_VariableBinding__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableBinding__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableBinding__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableBinding__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableBinding__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
	(norm7_VariableBinding__ExpressionAssignment_1_0_0_1)
	{ after(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclaration__Group__0__Impl
	norm1_VariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm1_VariableDeclarationImpl
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclaration__Group__0__Impl
	norm3_VariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm3_VariableDeclarationImpl
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclaration__Group__0__Impl
	norm4_VariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm4_VariableDeclarationImpl
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclaration__Group__0__Impl
	norm5_VariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm5_VariableDeclarationImpl
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclaration__Group__0__Impl
	norm6_VariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm6_VariableDeclarationImpl
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclaration__Group__0__Impl
	norm7_VariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm7_VariableDeclarationImpl
	{ after(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDeclarationImpl__Group__0__Impl
	rule__VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(rule__VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
	(rule__VariableDeclarationImpl__Group_1_1__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDeclarationImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDeclarationImpl__Group_1_1__0__Impl
	rule__VariableDeclarationImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
	(rule__VariableDeclarationImpl__Group_1_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDeclarationImpl__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
	(rule__VariableDeclarationImpl__Group_1_1_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDeclarationImpl__Group_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDeclarationImpl__Group_1_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
	(rule__VariableDeclarationImpl__NameAssignment_1_1_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDeclarationImpl__Group_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDeclarationImpl__Group_1_1_1__0__Impl
	rule__VariableDeclarationImpl__Group_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDeclarationImpl__Group_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDeclarationImpl__Group_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
	(rule__VariableDeclarationImpl__ExpressionAssignment_1_1_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclarationImpl__Group__0__Impl
	norm1_VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(norm1_VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
	(norm1_VariableDeclarationImpl__Group_1_1__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableDeclarationImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclarationImpl__Group_1_1__0__Impl
	norm1_VariableDeclarationImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
	(norm1_VariableDeclarationImpl__Group_1_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclarationImpl__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
	(norm1_VariableDeclarationImpl__Group_1_1_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableDeclarationImpl__Group_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclarationImpl__Group_1_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
	(norm1_VariableDeclarationImpl__NameAssignment_1_1_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_VariableDeclarationImpl__Group_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclarationImpl__Group_1_1_1__0__Impl
	norm1_VariableDeclarationImpl__Group_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_VariableDeclarationImpl__Group_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_VariableDeclarationImpl__Group_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
	(norm1_VariableDeclarationImpl__ExpressionAssignment_1_1_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableDeclarationImpl__Group__0__Impl
	norm2_VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(norm2_VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
	(norm2_VariableDeclarationImpl__Group_1_1__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_VariableDeclarationImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableDeclarationImpl__Group_1_1__0__Impl
	norm2_VariableDeclarationImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
	(norm2_VariableDeclarationImpl__Group_1_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableDeclarationImpl__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
	(norm2_VariableDeclarationImpl__Group_1_1_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_VariableDeclarationImpl__Group_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableDeclarationImpl__Group_1_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
	(norm2_VariableDeclarationImpl__NameAssignment_1_1_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm2_VariableDeclarationImpl__Group_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableDeclarationImpl__Group_1_1_1__0__Impl
	norm2_VariableDeclarationImpl__Group_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm2_VariableDeclarationImpl__Group_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm2_VariableDeclarationImpl__Group_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
	(norm2_VariableDeclarationImpl__ExpressionAssignment_1_1_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclarationImpl__Group__0__Impl
	norm3_VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(norm3_VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
	(norm3_VariableDeclarationImpl__Group_1_1__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableDeclarationImpl__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclarationImpl__Group_1_1__0__Impl
	norm3_VariableDeclarationImpl__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
	(norm3_VariableDeclarationImpl__Group_1_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclarationImpl__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
	(norm3_VariableDeclarationImpl__Group_1_1_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableDeclarationImpl__Group_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclarationImpl__Group_1_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
	(norm3_VariableDeclarationImpl__NameAssignment_1_1_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm3_VariableDeclarationImpl__Group_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclarationImpl__Group_1_1_1__0__Impl
	norm3_VariableDeclarationImpl__Group_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm3_VariableDeclarationImpl__Group_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm3_VariableDeclarationImpl__Group_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
	(norm3_VariableDeclarationImpl__ExpressionAssignment_1_1_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group__0__Impl
	norm4_VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(norm4_VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
	(norm4_VariableDeclarationImpl__Group_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableDeclarationImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group_1_0__0__Impl
	norm4_VariableDeclarationImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
	(norm4_VariableDeclarationImpl__Group_1_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
	(norm4_VariableDeclarationImpl__Group_1_0_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableDeclarationImpl__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group_1_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
	(norm4_VariableDeclarationImpl__Group_1_0_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableDeclarationImpl__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	norm4_VariableDeclarationImpl__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
	(norm4_VariableDeclarationImpl__NameAssignment_1_0_0_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
	(ruleColonSepDeclaredTypeRef)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm4_VariableDeclarationImpl__Group_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group_1_0_1__0__Impl
	norm4_VariableDeclarationImpl__Group_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm4_VariableDeclarationImpl__Group_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm4_VariableDeclarationImpl__Group_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
	(norm4_VariableDeclarationImpl__ExpressionAssignment_1_0_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group__0__Impl
	norm5_VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(norm5_VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
	(norm5_VariableDeclarationImpl__Group_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableDeclarationImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group_1_0__0__Impl
	norm5_VariableDeclarationImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
	(norm5_VariableDeclarationImpl__Group_1_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
	(norm5_VariableDeclarationImpl__Group_1_0_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableDeclarationImpl__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group_1_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
	(norm5_VariableDeclarationImpl__Group_1_0_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableDeclarationImpl__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	norm5_VariableDeclarationImpl__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
	(norm5_VariableDeclarationImpl__NameAssignment_1_0_0_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
	(ruleColonSepDeclaredTypeRef)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm5_VariableDeclarationImpl__Group_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group_1_0_1__0__Impl
	norm5_VariableDeclarationImpl__Group_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm5_VariableDeclarationImpl__Group_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm5_VariableDeclarationImpl__Group_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
	(norm5_VariableDeclarationImpl__ExpressionAssignment_1_0_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group__0__Impl
	norm6_VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(norm6_VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
	(norm6_VariableDeclarationImpl__Group_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableDeclarationImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group_1_0__0__Impl
	norm6_VariableDeclarationImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
	(norm6_VariableDeclarationImpl__Group_1_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
	(norm6_VariableDeclarationImpl__Group_1_0_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableDeclarationImpl__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group_1_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
	(norm6_VariableDeclarationImpl__Group_1_0_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableDeclarationImpl__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	norm6_VariableDeclarationImpl__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
	(norm6_VariableDeclarationImpl__NameAssignment_1_0_0_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
	(ruleColonSepDeclaredTypeRef)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm6_VariableDeclarationImpl__Group_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group_1_0_1__0__Impl
	norm6_VariableDeclarationImpl__Group_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm6_VariableDeclarationImpl__Group_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm6_VariableDeclarationImpl__Group_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
	(norm6_VariableDeclarationImpl__ExpressionAssignment_1_0_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableDeclarationImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group__0__Impl
	norm7_VariableDeclarationImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
	(norm7_VariableDeclarationImpl__AnnotationsAssignment_0)*
	{ after(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
	(norm7_VariableDeclarationImpl__Group_1_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableDeclarationImpl__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group_1_0__0__Impl
	norm7_VariableDeclarationImpl__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
	(norm7_VariableDeclarationImpl__Group_1_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
	(norm7_VariableDeclarationImpl__Group_1_0_1__0)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableDeclarationImpl__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group_1_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
	(norm7_VariableDeclarationImpl__Group_1_0_0_0__0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableDeclarationImpl__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	norm7_VariableDeclarationImpl__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
	(norm7_VariableDeclarationImpl__NameAssignment_1_0_0_0_0)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
	(ruleColonSepDeclaredTypeRef)?
	{ after(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm7_VariableDeclarationImpl__Group_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group_1_0_1__0__Impl
	norm7_VariableDeclarationImpl__Group_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
	EqualsSign
	{ after(grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm7_VariableDeclarationImpl__Group_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm7_VariableDeclarationImpl__Group_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
	(norm7_VariableDeclarationImpl__ExpressionAssignment_1_0_1_1)
	{ after(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportedVariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableBinding__Group__0__Impl
	rule__ExportedVariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableBindingAccess().getPatternAssignment_0()); }
	(rule__ExportedVariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getExportedVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableBinding__Group__1__Impl
	rule__ExportedVariableBinding__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1()); }
	EqualsSign
	{ after(grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableBinding__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableBinding__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableBinding__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignment_2()); }
	(rule__ExportedVariableBinding__ExpressionAssignment_2)
	{ after(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ExportedVariableBinding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExportedVariableBinding__Group__0__Impl
	norm1_ExportedVariableBinding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableBinding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableBindingAccess().getPatternAssignment_0()); }
	(norm1_ExportedVariableBinding__PatternAssignment_0)
	{ after(grammarAccess.getExportedVariableBindingAccess().getPatternAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableBinding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExportedVariableBinding__Group__1__Impl
	norm1_ExportedVariableBinding__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableBinding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1()); }
	EqualsSign
	{ after(grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableBinding__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExportedVariableBinding__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableBinding__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignment_2()); }
	(norm1_ExportedVariableBinding__ExpressionAssignment_2)
	{ after(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExportedVariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableDeclaration__Group__0__Impl
	rule__ExportedVariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableDeclarationAccess().getExportedVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getExportedVariableDeclarationAccess().getExportedVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExportedVariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExportedVariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm5_VariableDeclarationImpl
	{ after(grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ExportedVariableDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExportedVariableDeclaration__Group__0__Impl
	norm1_ExportedVariableDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableDeclarationAccess().getExportedVariableDeclarationAction_0()); }
	()
	{ after(grammarAccess.getExportedVariableDeclarationAccess().getExportedVariableDeclarationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExportedVariableDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExportedVariableDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
	norm7_VariableDeclarationImpl
	{ after(grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EmptyStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EmptyStatement__Group__0__Impl
	rule__EmptyStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EmptyStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEmptyStatementAccess().getEmptyStatementAction_0()); }
	()
	{ after(grammarAccess.getEmptyStatementAccess().getEmptyStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EmptyStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EmptyStatement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EmptyStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEmptyStatementAccess().getSemicolonKeyword_1()); }
	Semicolon
	{ after(grammarAccess.getEmptyStatementAccess().getSemicolonKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExpressionStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExpressionStatement__Group__0__Impl
	rule__ExpressionStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionStatementAccess().getExpressionAssignment_0()); }
	(rule__ExpressionStatement__ExpressionAssignment_0)
	{ after(grammarAccess.getExpressionStatementAccess().getExpressionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExpressionStatement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1()); }
	ruleSemi
	{ after(grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ExpressionStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExpressionStatement__Group__0__Impl
	norm1_ExpressionStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExpressionStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionStatementAccess().getExpressionAssignment_0()); }
	(norm1_ExpressionStatement__ExpressionAssignment_0)
	{ after(grammarAccess.getExpressionStatementAccess().getExpressionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExpressionStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ExpressionStatement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ExpressionStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1()); }
	ruleSemi
	{ after(grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IfStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__0__Impl
	rule__IfStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getIfKeyword_0()); }
	If
	{ after(grammarAccess.getIfStatementAccess().getIfKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__1__Impl
	rule__IfStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__2__Impl
	rule__IfStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getExpressionAssignment_2()); }
	(rule__IfStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getIfStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__3__Impl
	rule__IfStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__4__Impl
	rule__IfStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getIfStmtAssignment_4()); }
	(rule__IfStatement__IfStmtAssignment_4)
	{ after(grammarAccess.getIfStatementAccess().getIfStmtAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getGroup_5()); }
	(rule__IfStatement__Group_5__0)?
	{ after(grammarAccess.getIfStatementAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IfStatement__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group_5__0__Impl
	rule__IfStatement__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getElseKeyword_5_0()); }
	(Else)
	{ after(grammarAccess.getIfStatementAccess().getElseKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getElseStmtAssignment_5_1()); }
	(rule__IfStatement__ElseStmtAssignment_5_1)
	{ after(grammarAccess.getIfStatementAccess().getElseStmtAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_IfStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group__0__Impl
	norm1_IfStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getIfKeyword_0()); }
	If
	{ after(grammarAccess.getIfStatementAccess().getIfKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group__1__Impl
	norm1_IfStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group__2__Impl
	norm1_IfStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getExpressionAssignment_2()); }
	(norm1_IfStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getIfStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group__3__Impl
	norm1_IfStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group__4__Impl
	norm1_IfStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getIfStmtAssignment_4()); }
	(norm1_IfStatement__IfStmtAssignment_4)
	{ after(grammarAccess.getIfStatementAccess().getIfStmtAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getGroup_5()); }
	(norm1_IfStatement__Group_5__0)?
	{ after(grammarAccess.getIfStatementAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_IfStatement__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group_5__0__Impl
	norm1_IfStatement__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getElseKeyword_5_0()); }
	(Else)
	{ after(grammarAccess.getIfStatementAccess().getElseKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IfStatement__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_IfStatement__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getElseStmtAssignment_5_1()); }
	(norm1_IfStatement__ElseStmtAssignment_5_1)
	{ after(grammarAccess.getIfStatementAccess().getElseStmtAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DoStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoStatement__Group__0__Impl
	rule__DoStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getDoKeyword_0()); }
	Do
	{ after(grammarAccess.getDoStatementAccess().getDoKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoStatement__Group__1__Impl
	rule__DoStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getStatementAssignment_1()); }
	(rule__DoStatement__StatementAssignment_1)
	{ after(grammarAccess.getDoStatementAccess().getStatementAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoStatement__Group__2__Impl
	rule__DoStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getWhileKeyword_2()); }
	While
	{ after(grammarAccess.getDoStatementAccess().getWhileKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoStatement__Group__3__Impl
	rule__DoStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3()); }
	LeftParenthesis
	{ after(grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoStatement__Group__4__Impl
	rule__DoStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getExpressionAssignment_4()); }
	(rule__DoStatement__ExpressionAssignment_4)
	{ after(grammarAccess.getDoStatementAccess().getExpressionAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoStatement__Group__5__Impl
	rule__DoStatement__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5()); }
	RightParenthesis
	{ after(grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoStatement__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DoStatement__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6()); }
	(ruleSemi)?
	{ after(grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_DoStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DoStatement__Group__0__Impl
	norm1_DoStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getDoKeyword_0()); }
	Do
	{ after(grammarAccess.getDoStatementAccess().getDoKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DoStatement__Group__1__Impl
	norm1_DoStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getStatementAssignment_1()); }
	(norm1_DoStatement__StatementAssignment_1)
	{ after(grammarAccess.getDoStatementAccess().getStatementAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DoStatement__Group__2__Impl
	norm1_DoStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getWhileKeyword_2()); }
	While
	{ after(grammarAccess.getDoStatementAccess().getWhileKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DoStatement__Group__3__Impl
	norm1_DoStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3()); }
	LeftParenthesis
	{ after(grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DoStatement__Group__4__Impl
	norm1_DoStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getExpressionAssignment_4()); }
	(norm1_DoStatement__ExpressionAssignment_4)
	{ after(grammarAccess.getDoStatementAccess().getExpressionAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DoStatement__Group__5__Impl
	norm1_DoStatement__Group__6
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5()); }
	RightParenthesis
	{ after(grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DoStatement__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_DoStatement__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6()); }
	(ruleSemi)?
	{ after(grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__WhileStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WhileStatement__Group__0__Impl
	rule__WhileStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getWhileKeyword_0()); }
	While
	{ after(grammarAccess.getWhileStatementAccess().getWhileKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WhileStatement__Group__1__Impl
	rule__WhileStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WhileStatement__Group__2__Impl
	rule__WhileStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getExpressionAssignment_2()); }
	(rule__WhileStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getWhileStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WhileStatement__Group__3__Impl
	rule__WhileStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WhileStatement__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__WhileStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getStatementAssignment_4()); }
	(rule__WhileStatement__StatementAssignment_4)
	{ after(grammarAccess.getWhileStatementAccess().getStatementAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_WhileStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WhileStatement__Group__0__Impl
	norm1_WhileStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getWhileKeyword_0()); }
	While
	{ after(grammarAccess.getWhileStatementAccess().getWhileKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WhileStatement__Group__1__Impl
	norm1_WhileStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WhileStatement__Group__2__Impl
	norm1_WhileStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getExpressionAssignment_2()); }
	(norm1_WhileStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getWhileStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WhileStatement__Group__3__Impl
	norm1_WhileStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WhileStatement__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_WhileStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWhileStatementAccess().getStatementAssignment_4()); }
	(norm1_WhileStatement__StatementAssignment_4)
	{ after(grammarAccess.getWhileStatementAccess().getStatementAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group__0__Impl
	rule__ForStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForStatementAction_0()); }
	()
	{ after(grammarAccess.getForStatementAccess().getForStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group__1__Impl
	rule__ForStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForKeyword_1()); }
	For
	{ after(grammarAccess.getForStatementAccess().getForKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group__2__Impl
	rule__ForStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2()); }
	LeftParenthesis
	{ after(grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group__3__Impl
	rule__ForStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3()); }
	(rule__ForStatement__Alternatives_3)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getStatementAssignment_4()); }
	(rule__ForStatement__StatementAssignment_4)
	{ after(grammarAccess.getForStatementAccess().getStatementAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getGroup_3_0_0()); }
	(rule__ForStatement__Group_3_0_0__0)
	{ after(grammarAccess.getForStatementAccess().getGroup_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_0_0__0__Impl
	rule__ForStatement__Group_3_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getInitExprAssignment_3_0_0_0()); }
	(rule__ForStatement__InitExprAssignment_3_0_0_0)
	{ after(grammarAccess.getForStatementAccess().getInitExprAssignment_3_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_0_0__1__Impl
	rule__ForStatement__Group_3_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_0_0_1()); }
	(rule__ForStatement__ForInAssignment_3_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_0_0__2__Impl
	rule__ForStatement__Group_3_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_0_0_2()); }
	(rule__ForStatement__ExpressionAssignment_3_0_0_2)
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3()); }
	RightParenthesis
	{ after(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1__0__Impl
	rule__ForStatement__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0()); }
	(rule__ForStatement__Alternatives_3_1_0)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1()); }
	RightParenthesis
	{ after(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0__0__Impl
	rule__ForStatement__Group_3_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarStmtKeywordAssignment_3_1_0_0_0()); }
	(rule__ForStatement__VarStmtKeywordAssignment_3_1_0_0_0)
	{ after(grammarAccess.getForStatementAccess().getVarStmtKeywordAssignment_3_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1()); }
	(rule__ForStatement__Alternatives_3_1_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0_0()); }
	(rule__ForStatement__Group_3_1_0_0_1_0_0__0)
	{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_0_0__0__Impl
	rule__ForStatement__Group_3_1_0_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0()); }
	(rule__ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0)
	{ after(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_0_0__1__Impl
	rule__ForStatement__Group_3_1_0_0_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_0_0_1()); }
	(rule__ForStatement__Alternatives_3_1_0_0_1_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_0_0_2()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_0_1_0_0_2)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1__0__Impl
	rule__ForStatement__Group_3_1_0_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_0()); }
	(rule__ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_1_0)
	{ after(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_1_1()); }
	(rule__ForStatement__Alternatives_3_1_0_0_1_1_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0_1_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__0__Impl
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0_0()); }
	(rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__0)*
	{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__1__Impl
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__2__Impl
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_0_2()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_0_2)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__3__Impl
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_0_1_1_1_0_4()); }
	(rule__ForStatement__UpdateExprAssignment_3_1_0_0_1_1_1_0_4)?
	{ after(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_0_1_1_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__0__Impl
	rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0()); }
	Comma
	{ after(grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1()); }
	(rule__ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0_1_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_1__0__Impl
	rule__ForStatement__Group_3_1_0_0_1_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_1_1_1_0()); }
	(rule__ForStatement__ForInAssignment_3_1_0_0_1_1_1_1_0)
	{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_1_1()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_1_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_0_1_1_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_2__0__Impl
	rule__ForStatement__Group_3_1_0_0_1_1_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_1_1_2_0()); }
	(rule__ForStatement__ForOfAssignment_3_1_0_0_1_1_1_2_0)
	{ after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_1_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_0_1_1_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_0_1_1_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_2_1()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_2_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1__0__Impl
	rule__ForStatement__Group_3_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getInitExprAssignment_3_1_0_1_0()); }
	(rule__ForStatement__InitExprAssignment_3_1_0_1_0)
	{ after(grammarAccess.getForStatementAccess().getInitExprAssignment_3_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_1_1()); }
	(rule__ForStatement__Alternatives_3_1_0_1_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_0__0__Impl
	rule__ForStatement__Group_3_1_0_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_0__1__Impl
	rule__ForStatement__Group_3_1_0_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_0_1()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_1_1_0_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_0__2__Impl
	rule__ForStatement__Group_3_1_0_1_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_1_1_0_3()); }
	(rule__ForStatement__UpdateExprAssignment_3_1_0_1_1_0_3)?
	{ after(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_1_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_1__0__Impl
	rule__ForStatement__Group_3_1_0_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_1_1_1_0()); }
	(rule__ForStatement__ForInAssignment_3_1_0_1_1_1_0)
	{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_1_1()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_1_1_1_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_1_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_2__0__Impl
	rule__ForStatement__Group_3_1_0_1_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_1_1_2_0()); }
	(rule__ForStatement__ForOfAssignment_3_1_0_1_1_2_0)
	{ after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_1_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_1_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_1_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_2_1()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_1_1_2_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ForStatement__Group_3_1_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_2__0__Impl
	rule__ForStatement__Group_3_1_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_2__1__Impl
	rule__ForStatement__Group_3_1_0_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_2_1()); }
	(rule__ForStatement__ExpressionAssignment_3_1_0_2_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_2__2__Impl
	rule__ForStatement__Group_3_1_0_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ForStatement__Group_3_1_0_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Group_3_1_0_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_2_3()); }
	(rule__ForStatement__UpdateExprAssignment_3_1_0_2_3)?
	{ after(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group__0__Impl
	norm1_ForStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForStatementAction_0()); }
	()
	{ after(grammarAccess.getForStatementAccess().getForStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group__1__Impl
	norm1_ForStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForKeyword_1()); }
	For
	{ after(grammarAccess.getForStatementAccess().getForKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group__2__Impl
	norm1_ForStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2()); }
	LeftParenthesis
	{ after(grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group__3__Impl
	norm1_ForStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3()); }
	(norm1_ForStatement__Alternatives_3)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getStatementAssignment_4()); }
	(norm1_ForStatement__StatementAssignment_4)
	{ after(grammarAccess.getForStatementAccess().getStatementAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getGroup_3_0_0()); }
	(norm1_ForStatement__Group_3_0_0__0)
	{ after(grammarAccess.getForStatementAccess().getGroup_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_0_0__0__Impl
	norm1_ForStatement__Group_3_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getInitExprAssignment_3_0_0_0()); }
	(norm1_ForStatement__InitExprAssignment_3_0_0_0)
	{ after(grammarAccess.getForStatementAccess().getInitExprAssignment_3_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_0_0__1__Impl
	norm1_ForStatement__Group_3_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_0_0_1()); }
	(norm1_ForStatement__ForInAssignment_3_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_0_0__2__Impl
	norm1_ForStatement__Group_3_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_0_0_2()); }
	(norm1_ForStatement__ExpressionAssignment_3_0_0_2)
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3()); }
	RightParenthesis
	{ after(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1__0__Impl
	norm1_ForStatement__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0()); }
	(norm1_ForStatement__Alternatives_3_1_0)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1()); }
	RightParenthesis
	{ after(grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0__0__Impl
	norm1_ForStatement__Group_3_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarStmtKeywordAssignment_3_1_0_0_0()); }
	(norm1_ForStatement__VarStmtKeywordAssignment_3_1_0_0_0)
	{ after(grammarAccess.getForStatementAccess().getVarStmtKeywordAssignment_3_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1()); }
	(norm1_ForStatement__Alternatives_3_1_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0_0()); }
	(norm1_ForStatement__Group_3_1_0_0_1_0_0__0)
	{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_0_0__0__Impl
	norm1_ForStatement__Group_3_1_0_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0()); }
	(norm1_ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0)
	{ after(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_0_0__1__Impl
	norm1_ForStatement__Group_3_1_0_0_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_0_0_1()); }
	(norm1_ForStatement__Alternatives_3_1_0_0_1_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_0_0_2()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_0_1_0_0_2)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1__0__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_0()); }
	(norm1_ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_1_0)
	{ after(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_1_1()); }
	(norm1_ForStatement__Alternatives_3_1_0_0_1_1_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0_1_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__0__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0_0()); }
	(norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__0)*
	{ after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__1__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__2__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_0_2()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_0_2)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__3__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_0_1_1_1_0_4()); }
	(norm1_ForStatement__UpdateExprAssignment_3_1_0_0_1_1_1_0_4)?
	{ after(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_0_1_1_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__0__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0()); }
	Comma
	{ after(grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1()); }
	(norm1_ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1)
	{ after(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0_1_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_1__0__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_1_1_1_0()); }
	(norm1_ForStatement__ForInAssignment_3_1_0_0_1_1_1_1_0)
	{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_1_1()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_1_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_0_1_1_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_2__0__Impl
	norm1_ForStatement__Group_3_1_0_0_1_1_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_1_1_2_0()); }
	(norm1_ForStatement__ForOfAssignment_3_1_0_0_1_1_1_2_0)
	{ after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_1_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_0_1_1_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_0_1_1_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_2_1()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_2_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1__0__Impl
	norm1_ForStatement__Group_3_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getInitExprAssignment_3_1_0_1_0()); }
	(norm1_ForStatement__InitExprAssignment_3_1_0_1_0)
	{ after(grammarAccess.getForStatementAccess().getInitExprAssignment_3_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_1_1()); }
	(norm1_ForStatement__Alternatives_3_1_0_1_1)
	{ after(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_0__0__Impl
	norm1_ForStatement__Group_3_1_0_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_0__1__Impl
	norm1_ForStatement__Group_3_1_0_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_0_1()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_1_1_0_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_0__2__Impl
	norm1_ForStatement__Group_3_1_0_1_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_1_1_0_3()); }
	(norm1_ForStatement__UpdateExprAssignment_3_1_0_1_1_0_3)?
	{ after(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_1_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_1__0__Impl
	norm1_ForStatement__Group_3_1_0_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_1_1_1_0()); }
	(norm1_ForStatement__ForInAssignment_3_1_0_1_1_1_0)
	{ after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_1_1()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_1_1_1_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_1_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_2__0__Impl
	norm1_ForStatement__Group_3_1_0_1_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_1_1_2_0()); }
	(norm1_ForStatement__ForOfAssignment_3_1_0_1_1_2_0)
	{ after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_1_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_1_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_1_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_2_1()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_1_1_2_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ForStatement__Group_3_1_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_2__0__Impl
	norm1_ForStatement__Group_3_1_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_2__1__Impl
	norm1_ForStatement__Group_3_1_0_2__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_2_1()); }
	(norm1_ForStatement__ExpressionAssignment_3_1_0_2_1)?
	{ after(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_2__2__Impl
	norm1_ForStatement__Group_3_1_0_2__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2()); }
	Semicolon
	{ after(grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ForStatement__Group_3_1_0_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ForStatement__Group_3_1_0_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_2_3()); }
	(norm1_ForStatement__UpdateExprAssignment_3_1_0_2_3)?
	{ after(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ContinueStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ContinueStatement__Group__0__Impl
	rule__ContinueStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ContinueStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getContinueStatementAction_0()); }
	()
	{ after(grammarAccess.getContinueStatementAccess().getContinueStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ContinueStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ContinueStatement__Group__1__Impl
	rule__ContinueStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ContinueStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getContinueKeyword_1()); }
	Continue
	{ after(grammarAccess.getContinueStatementAccess().getContinueKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ContinueStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ContinueStatement__Group__2__Impl
	rule__ContinueStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ContinueStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getLabelAssignment_2()); }
	(rule__ContinueStatement__LabelAssignment_2)?
	{ after(grammarAccess.getContinueStatementAccess().getLabelAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ContinueStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ContinueStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ContinueStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ContinueStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ContinueStatement__Group__0__Impl
	norm1_ContinueStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ContinueStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getContinueStatementAction_0()); }
	()
	{ after(grammarAccess.getContinueStatementAccess().getContinueStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ContinueStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ContinueStatement__Group__1__Impl
	norm1_ContinueStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ContinueStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getContinueKeyword_1()); }
	Continue
	{ after(grammarAccess.getContinueStatementAccess().getContinueKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ContinueStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ContinueStatement__Group__2__Impl
	norm1_ContinueStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ContinueStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getLabelAssignment_2()); }
	(norm1_ContinueStatement__LabelAssignment_2)?
	{ after(grammarAccess.getContinueStatementAccess().getLabelAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ContinueStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ContinueStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ContinueStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BreakStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BreakStatement__Group__0__Impl
	rule__BreakStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BreakStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getBreakStatementAction_0()); }
	()
	{ after(grammarAccess.getBreakStatementAccess().getBreakStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BreakStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BreakStatement__Group__1__Impl
	rule__BreakStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BreakStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getBreakKeyword_1()); }
	Break
	{ after(grammarAccess.getBreakStatementAccess().getBreakKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BreakStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BreakStatement__Group__2__Impl
	rule__BreakStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__BreakStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getLabelAssignment_2()); }
	(rule__BreakStatement__LabelAssignment_2)?
	{ after(grammarAccess.getBreakStatementAccess().getLabelAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BreakStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BreakStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BreakStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_BreakStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BreakStatement__Group__0__Impl
	norm1_BreakStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_BreakStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getBreakStatementAction_0()); }
	()
	{ after(grammarAccess.getBreakStatementAccess().getBreakStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BreakStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BreakStatement__Group__1__Impl
	norm1_BreakStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_BreakStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getBreakKeyword_1()); }
	Break
	{ after(grammarAccess.getBreakStatementAccess().getBreakKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BreakStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BreakStatement__Group__2__Impl
	norm1_BreakStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_BreakStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getLabelAssignment_2()); }
	(norm1_BreakStatement__LabelAssignment_2)?
	{ after(grammarAccess.getBreakStatementAccess().getLabelAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_BreakStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_BreakStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_BreakStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group__0__Impl
	rule__ReturnStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnStatementAction_0()); }
	()
	{ after(grammarAccess.getReturnStatementAccess().getReturnStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group__1__Impl
	rule__ReturnStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnKeyword_1()); }
	Return
	{ after(grammarAccess.getReturnStatementAccess().getReturnKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group__2__Impl
	rule__ReturnStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getExpressionAssignment_2()); }
	(rule__ReturnStatement__ExpressionAssignment_2)?
	{ after(grammarAccess.getReturnStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ReturnStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ReturnStatement__Group__0__Impl
	norm1_ReturnStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ReturnStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnStatementAction_0()); }
	()
	{ after(grammarAccess.getReturnStatementAccess().getReturnStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ReturnStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ReturnStatement__Group__1__Impl
	norm1_ReturnStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ReturnStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnKeyword_1()); }
	Return
	{ after(grammarAccess.getReturnStatementAccess().getReturnKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ReturnStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ReturnStatement__Group__2__Impl
	norm1_ReturnStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ReturnStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getExpressionAssignment_2()); }
	(norm1_ReturnStatement__ExpressionAssignment_2)?
	{ after(grammarAccess.getReturnStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ReturnStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ReturnStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ReturnStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3()); }
	ruleSemi
	{ after(grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__WithStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WithStatement__Group__0__Impl
	rule__WithStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getWithKeyword_0()); }
	With
	{ after(grammarAccess.getWithStatementAccess().getWithKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WithStatement__Group__1__Impl
	rule__WithStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WithStatement__Group__2__Impl
	rule__WithStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getExpressionAssignment_2()); }
	(rule__WithStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getWithStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WithStatement__Group__3__Impl
	rule__WithStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__WithStatement__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__WithStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getStatementAssignment_4()); }
	(rule__WithStatement__StatementAssignment_4)
	{ after(grammarAccess.getWithStatementAccess().getStatementAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_WithStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WithStatement__Group__0__Impl
	norm1_WithStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getWithKeyword_0()); }
	With
	{ after(grammarAccess.getWithStatementAccess().getWithKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WithStatement__Group__1__Impl
	norm1_WithStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WithStatement__Group__2__Impl
	norm1_WithStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getExpressionAssignment_2()); }
	(norm1_WithStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getWithStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WithStatement__Group__3__Impl
	norm1_WithStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_WithStatement__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_WithStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getWithStatementAccess().getStatementAssignment_4()); }
	(norm1_WithStatement__StatementAssignment_4)
	{ after(grammarAccess.getWithStatementAccess().getStatementAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SwitchStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__0__Impl
	rule__SwitchStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0()); }
	Switch
	{ after(grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__1__Impl
	rule__SwitchStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__2__Impl
	rule__SwitchStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getExpressionAssignment_2()); }
	(rule__SwitchStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getSwitchStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__3__Impl
	rule__SwitchStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__4__Impl
	rule__SwitchStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4()); }
	LeftCurlyBracket
	{ after(grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__5__Impl
	rule__SwitchStatement__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getCasesAssignment_5()); }
	(rule__SwitchStatement__CasesAssignment_5)*
	{ after(grammarAccess.getSwitchStatementAccess().getCasesAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__6__Impl
	rule__SwitchStatement__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getGroup_6()); }
	(rule__SwitchStatement__Group_6__0)?
	{ after(grammarAccess.getSwitchStatementAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7()); }
	RightCurlyBracket
	{ after(grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SwitchStatement__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group_6__0__Impl
	rule__SwitchStatement__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_0()); }
	(rule__SwitchStatement__CasesAssignment_6_0)
	{ after(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SwitchStatement__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SwitchStatement__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_1()); }
	(rule__SwitchStatement__CasesAssignment_6_1)*
	{ after(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_SwitchStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__0__Impl
	norm1_SwitchStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0()); }
	Switch
	{ after(grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__1__Impl
	norm1_SwitchStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1()); }
	LeftParenthesis
	{ after(grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__2__Impl
	norm1_SwitchStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getExpressionAssignment_2()); }
	(norm1_SwitchStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getSwitchStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__3__Impl
	norm1_SwitchStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3()); }
	RightParenthesis
	{ after(grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__4__Impl
	norm1_SwitchStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4()); }
	LeftCurlyBracket
	{ after(grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__5__Impl
	norm1_SwitchStatement__Group__6
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getCasesAssignment_5()); }
	(norm1_SwitchStatement__CasesAssignment_5)*
	{ after(grammarAccess.getSwitchStatementAccess().getCasesAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__6__Impl
	norm1_SwitchStatement__Group__7
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getGroup_6()); }
	(norm1_SwitchStatement__Group_6__0)?
	{ after(grammarAccess.getSwitchStatementAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7()); }
	RightCurlyBracket
	{ after(grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_SwitchStatement__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group_6__0__Impl
	norm1_SwitchStatement__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_0()); }
	(norm1_SwitchStatement__CasesAssignment_6_0)
	{ after(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_SwitchStatement__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_SwitchStatement__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_1()); }
	(norm1_SwitchStatement__CasesAssignment_6_1)*
	{ after(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CaseClause__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CaseClause__Group__0__Impl
	rule__CaseClause__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CaseClause__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getCaseKeyword_0()); }
	Case
	{ after(grammarAccess.getCaseClauseAccess().getCaseKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CaseClause__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CaseClause__Group__1__Impl
	rule__CaseClause__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CaseClause__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getExpressionAssignment_1()); }
	(rule__CaseClause__ExpressionAssignment_1)
	{ after(grammarAccess.getCaseClauseAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CaseClause__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CaseClause__Group__2__Impl
	rule__CaseClause__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__CaseClause__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getColonKeyword_2()); }
	Colon
	{ after(grammarAccess.getCaseClauseAccess().getColonKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CaseClause__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CaseClause__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CaseClause__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getStatementsAssignment_3()); }
	(rule__CaseClause__StatementsAssignment_3)*
	{ after(grammarAccess.getCaseClauseAccess().getStatementsAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CaseClause__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CaseClause__Group__0__Impl
	norm1_CaseClause__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_CaseClause__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getCaseKeyword_0()); }
	Case
	{ after(grammarAccess.getCaseClauseAccess().getCaseKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CaseClause__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CaseClause__Group__1__Impl
	norm1_CaseClause__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_CaseClause__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getExpressionAssignment_1()); }
	(norm1_CaseClause__ExpressionAssignment_1)
	{ after(grammarAccess.getCaseClauseAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CaseClause__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CaseClause__Group__2__Impl
	norm1_CaseClause__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_CaseClause__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getColonKeyword_2()); }
	Colon
	{ after(grammarAccess.getCaseClauseAccess().getColonKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CaseClause__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CaseClause__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CaseClause__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCaseClauseAccess().getStatementsAssignment_3()); }
	(norm1_CaseClause__StatementsAssignment_3)*
	{ after(grammarAccess.getCaseClauseAccess().getStatementsAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DefaultClause__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DefaultClause__Group__0__Impl
	rule__DefaultClause__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DefaultClause__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getDefaultClauseAction_0()); }
	()
	{ after(grammarAccess.getDefaultClauseAccess().getDefaultClauseAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DefaultClause__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DefaultClause__Group__1__Impl
	rule__DefaultClause__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DefaultClause__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1()); }
	Default
	{ after(grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DefaultClause__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DefaultClause__Group__2__Impl
	rule__DefaultClause__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__DefaultClause__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getColonKeyword_2()); }
	Colon
	{ after(grammarAccess.getDefaultClauseAccess().getColonKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DefaultClause__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DefaultClause__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DefaultClause__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getStatementsAssignment_3()); }
	(rule__DefaultClause__StatementsAssignment_3)*
	{ after(grammarAccess.getDefaultClauseAccess().getStatementsAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_DefaultClause__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DefaultClause__Group__0__Impl
	norm1_DefaultClause__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_DefaultClause__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getDefaultClauseAction_0()); }
	()
	{ after(grammarAccess.getDefaultClauseAccess().getDefaultClauseAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DefaultClause__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DefaultClause__Group__1__Impl
	norm1_DefaultClause__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_DefaultClause__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1()); }
	Default
	{ after(grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DefaultClause__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DefaultClause__Group__2__Impl
	norm1_DefaultClause__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_DefaultClause__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getColonKeyword_2()); }
	Colon
	{ after(grammarAccess.getDefaultClauseAccess().getColonKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_DefaultClause__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_DefaultClause__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_DefaultClause__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDefaultClauseAccess().getStatementsAssignment_3()); }
	(norm1_DefaultClause__StatementsAssignment_3)*
	{ after(grammarAccess.getDefaultClauseAccess().getStatementsAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LabelledStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LabelledStatement__Group__0__Impl
	rule__LabelledStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LabelledStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getGroup_0()); }
	(rule__LabelledStatement__Group_0__0)
	{ after(grammarAccess.getLabelledStatementAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LabelledStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LabelledStatement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LabelledStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getStatementAssignment_1()); }
	(rule__LabelledStatement__StatementAssignment_1)
	{ after(grammarAccess.getLabelledStatementAccess().getStatementAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LabelledStatement__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LabelledStatement__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LabelledStatement__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getGroup_0_0()); }
	(rule__LabelledStatement__Group_0_0__0)
	{ after(grammarAccess.getLabelledStatementAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LabelledStatement__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LabelledStatement__Group_0_0__0__Impl
	rule__LabelledStatement__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LabelledStatement__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getNameAssignment_0_0_0()); }
	(rule__LabelledStatement__NameAssignment_0_0_0)
	{ after(grammarAccess.getLabelledStatementAccess().getNameAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LabelledStatement__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LabelledStatement__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LabelledStatement__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1()); }
	Colon
	{ after(grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LabelledStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LabelledStatement__Group__0__Impl
	norm1_LabelledStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LabelledStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getGroup_0()); }
	(norm1_LabelledStatement__Group_0__0)
	{ after(grammarAccess.getLabelledStatementAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LabelledStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LabelledStatement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LabelledStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getStatementAssignment_1()); }
	(norm1_LabelledStatement__StatementAssignment_1)
	{ after(grammarAccess.getLabelledStatementAccess().getStatementAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LabelledStatement__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LabelledStatement__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LabelledStatement__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getGroup_0_0()); }
	(norm1_LabelledStatement__Group_0_0__0)
	{ after(grammarAccess.getLabelledStatementAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LabelledStatement__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LabelledStatement__Group_0_0__0__Impl
	norm1_LabelledStatement__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LabelledStatement__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getNameAssignment_0_0_0()); }
	(norm1_LabelledStatement__NameAssignment_0_0_0)
	{ after(grammarAccess.getLabelledStatementAccess().getNameAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LabelledStatement__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LabelledStatement__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LabelledStatement__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1()); }
	Colon
	{ after(grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ThrowStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ThrowStatement__Group__0__Impl
	rule__ThrowStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ThrowStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThrowStatementAccess().getThrowKeyword_0()); }
	Throw
	{ after(grammarAccess.getThrowStatementAccess().getThrowKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ThrowStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ThrowStatement__Group__1__Impl
	rule__ThrowStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ThrowStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThrowStatementAccess().getExpressionAssignment_1()); }
	(rule__ThrowStatement__ExpressionAssignment_1)
	{ after(grammarAccess.getThrowStatementAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ThrowStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ThrowStatement__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ThrowStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2()); }
	ruleSemi
	{ after(grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ThrowStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ThrowStatement__Group__0__Impl
	norm1_ThrowStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ThrowStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThrowStatementAccess().getThrowKeyword_0()); }
	Throw
	{ after(grammarAccess.getThrowStatementAccess().getThrowKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ThrowStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ThrowStatement__Group__1__Impl
	norm1_ThrowStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ThrowStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThrowStatementAccess().getExpressionAssignment_1()); }
	(norm1_ThrowStatement__ExpressionAssignment_1)
	{ after(grammarAccess.getThrowStatementAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ThrowStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ThrowStatement__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ThrowStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2()); }
	ruleSemi
	{ after(grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TryStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TryStatement__Group__0__Impl
	rule__TryStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getTryKeyword_0()); }
	Try
	{ after(grammarAccess.getTryStatementAccess().getTryKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TryStatement__Group__1__Impl
	rule__TryStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getBlockAssignment_1()); }
	(rule__TryStatement__BlockAssignment_1)
	{ after(grammarAccess.getTryStatementAccess().getBlockAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TryStatement__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getAlternatives_2()); }
	(rule__TryStatement__Alternatives_2)
	{ after(grammarAccess.getTryStatementAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TryStatement__Group_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TryStatement__Group_2_0__0__Impl
	rule__TryStatement__Group_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getCatchAssignment_2_0_0()); }
	(rule__TryStatement__CatchAssignment_2_0_0)
	{ after(grammarAccess.getTryStatementAccess().getCatchAssignment_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TryStatement__Group_2_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TryStatement__Group_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_0_1()); }
	(rule__TryStatement__FinallyAssignment_2_0_1)?
	{ after(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_TryStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_TryStatement__Group__0__Impl
	norm1_TryStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getTryKeyword_0()); }
	Try
	{ after(grammarAccess.getTryStatementAccess().getTryKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_TryStatement__Group__1__Impl
	norm1_TryStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getBlockAssignment_1()); }
	(norm1_TryStatement__BlockAssignment_1)
	{ after(grammarAccess.getTryStatementAccess().getBlockAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_TryStatement__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getAlternatives_2()); }
	(norm1_TryStatement__Alternatives_2)
	{ after(grammarAccess.getTryStatementAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_TryStatement__Group_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_TryStatement__Group_2_0__0__Impl
	norm1_TryStatement__Group_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getCatchAssignment_2_0_0()); }
	(norm1_TryStatement__CatchAssignment_2_0_0)
	{ after(grammarAccess.getTryStatementAccess().getCatchAssignment_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_TryStatement__Group_2_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_TryStatement__Group_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_0_1()); }
	(norm1_TryStatement__FinallyAssignment_2_0_1)?
	{ after(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CatchBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchBlock__Group__0__Impl
	rule__CatchBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getCatchBlockAction_0()); }
	()
	{ after(grammarAccess.getCatchBlockAccess().getCatchBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchBlock__Group__1__Impl
	rule__CatchBlock__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getCatchKeyword_1()); }
	Catch
	{ after(grammarAccess.getCatchBlockAccess().getCatchKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchBlock__Group__2__Impl
	rule__CatchBlock__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2()); }
	LeftParenthesis
	{ after(grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchBlock__Group__3__Impl
	rule__CatchBlock__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getCatchVariableAssignment_3()); }
	(rule__CatchBlock__CatchVariableAssignment_3)
	{ after(grammarAccess.getCatchBlockAccess().getCatchVariableAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchBlock__Group__4__Impl
	rule__CatchBlock__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4()); }
	RightParenthesis
	{ after(grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchBlock__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchBlock__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getBlockAssignment_5()); }
	(rule__CatchBlock__BlockAssignment_5)
	{ after(grammarAccess.getCatchBlockAccess().getBlockAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CatchBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchBlock__Group__0__Impl
	norm1_CatchBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getCatchBlockAction_0()); }
	()
	{ after(grammarAccess.getCatchBlockAccess().getCatchBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchBlock__Group__1__Impl
	norm1_CatchBlock__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getCatchKeyword_1()); }
	Catch
	{ after(grammarAccess.getCatchBlockAccess().getCatchKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchBlock__Group__2__Impl
	norm1_CatchBlock__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2()); }
	LeftParenthesis
	{ after(grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchBlock__Group__3__Impl
	norm1_CatchBlock__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getCatchVariableAssignment_3()); }
	(norm1_CatchBlock__CatchVariableAssignment_3)
	{ after(grammarAccess.getCatchBlockAccess().getCatchVariableAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchBlock__Group__4__Impl
	norm1_CatchBlock__Group__5
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4()); }
	RightParenthesis
	{ after(grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchBlock__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchBlock__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchBlockAccess().getBlockAssignment_5()); }
	(norm1_CatchBlock__BlockAssignment_5)
	{ after(grammarAccess.getCatchBlockAccess().getBlockAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CatchVariable__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchVariable__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getGroup_1_0()); }
	(rule__CatchVariable__Group_1_0__0)
	{ after(grammarAccess.getCatchVariableAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CatchVariable__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchVariable__Group_1_0__0__Impl
	rule__CatchVariable__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getNameAssignment_1_0_0()); }
	(rule__CatchVariable__NameAssignment_1_0_0)
	{ after(grammarAccess.getCatchVariableAccess().getNameAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchVariable__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1()); }
	(ruleColonSepDeclaredTypeRef)
	{ after(grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CatchVariable__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchVariable__Group_2__0__Impl
	rule__CatchVariable__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0()); }
	(ruleBogusTypeRefFragment)?
	{ after(grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CatchVariable__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CatchVariable__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getNameAssignment_2_1()); }
	(rule__CatchVariable__NameAssignment_2_1)
	{ after(grammarAccess.getCatchVariableAccess().getNameAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CatchVariable__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchVariable__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getGroup_1_0()); }
	(norm1_CatchVariable__Group_1_0__0)
	{ after(grammarAccess.getCatchVariableAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CatchVariable__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchVariable__Group_1_0__0__Impl
	norm1_CatchVariable__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getNameAssignment_1_0_0()); }
	(norm1_CatchVariable__NameAssignment_1_0_0)
	{ after(grammarAccess.getCatchVariableAccess().getNameAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchVariable__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1()); }
	(ruleColonSepDeclaredTypeRef)
	{ after(grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CatchVariable__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchVariable__Group_2__0__Impl
	norm1_CatchVariable__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0()); }
	(ruleBogusTypeRefFragment)?
	{ after(grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CatchVariable__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CatchVariable__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCatchVariableAccess().getNameAssignment_2_1()); }
	(norm1_CatchVariable__NameAssignment_2_1)
	{ after(grammarAccess.getCatchVariableAccess().getNameAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FinallyBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinallyBlock__Group__0__Impl
	rule__FinallyBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FinallyBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinallyBlockAccess().getFinallyBlockAction_0()); }
	()
	{ after(grammarAccess.getFinallyBlockAccess().getFinallyBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinallyBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinallyBlock__Group__1__Impl
	rule__FinallyBlock__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FinallyBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1()); }
	Finally
	{ after(grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinallyBlock__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinallyBlock__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FinallyBlock__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinallyBlockAccess().getBlockAssignment_2()); }
	(rule__FinallyBlock__BlockAssignment_2)
	{ after(grammarAccess.getFinallyBlockAccess().getBlockAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_FinallyBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FinallyBlock__Group__0__Impl
	norm1_FinallyBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_FinallyBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinallyBlockAccess().getFinallyBlockAction_0()); }
	()
	{ after(grammarAccess.getFinallyBlockAccess().getFinallyBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FinallyBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FinallyBlock__Group__1__Impl
	norm1_FinallyBlock__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_FinallyBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1()); }
	Finally
	{ after(grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_FinallyBlock__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_FinallyBlock__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_FinallyBlock__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinallyBlockAccess().getBlockAssignment_2()); }
	(norm1_FinallyBlock__BlockAssignment_2)
	{ after(grammarAccess.getFinallyBlockAccess().getBlockAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DebuggerStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DebuggerStatement__Group__0__Impl
	rule__DebuggerStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DebuggerStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDebuggerStatementAccess().getDebuggerStatementAction_0()); }
	()
	{ after(grammarAccess.getDebuggerStatementAccess().getDebuggerStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DebuggerStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DebuggerStatement__Group__1__Impl
	rule__DebuggerStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DebuggerStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDebuggerStatementAccess().getDebuggerKeyword_1()); }
	Debugger
	{ after(grammarAccess.getDebuggerStatementAccess().getDebuggerKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DebuggerStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DebuggerStatement__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DebuggerStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDebuggerStatementAccess().getSemiParserRuleCall_2()); }
	ruleSemi
	{ after(grammarAccess.getDebuggerStatementAccess().getSemiParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParenExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenExpression__Group__0__Impl
	rule__ParenExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0()); }
	LeftParenthesis
	{ after(grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenExpression__Group__1__Impl
	rule__ParenExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenExpressionAccess().getExpressionAssignment_1()); }
	(rule__ParenExpression__ExpressionAssignment_1)
	{ after(grammarAccess.getParenExpressionAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2()); }
	RightParenthesis
	{ after(grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ParenExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParenExpression__Group__0__Impl
	norm1_ParenExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParenExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0()); }
	LeftParenthesis
	{ after(grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParenExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParenExpression__Group__1__Impl
	norm1_ParenExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParenExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenExpressionAccess().getExpressionAssignment_1()); }
	(norm1_ParenExpression__ExpressionAssignment_1)
	{ after(grammarAccess.getParenExpressionAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParenExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParenExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParenExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2()); }
	RightParenthesis
	{ after(grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IdentifierRef__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdentifierRef__Group_1__0__Impl
	rule__IdentifierRef__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierRef__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdentifierRefAccess().getVersionedIdentifierRefAction_1_0()); }
	()
	{ after(grammarAccess.getIdentifierRefAccess().getVersionedIdentifierRefAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierRef__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdentifierRef__Group_1__1__Impl
	rule__IdentifierRef__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierRef__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdentifierRefAccess().getIdAssignment_1_1()); }
	(rule__IdentifierRef__IdAssignment_1_1)
	{ after(grammarAccess.getIdentifierRefAccess().getIdAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierRef__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IdentifierRef__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IdentifierRef__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2()); }
	ruleVersionRequest
	{ after(grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_IdentifierRef__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IdentifierRef__Group_1__0__Impl
	norm1_IdentifierRef__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_IdentifierRef__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdentifierRefAccess().getVersionedIdentifierRefAction_1_0()); }
	()
	{ after(grammarAccess.getIdentifierRefAccess().getVersionedIdentifierRefAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IdentifierRef__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IdentifierRef__Group_1__1__Impl
	norm1_IdentifierRef__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_IdentifierRef__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdentifierRefAccess().getIdAssignment_1_1()); }
	(norm1_IdentifierRef__IdAssignment_1_1)
	{ after(grammarAccess.getIdentifierRefAccess().getIdAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IdentifierRef__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IdentifierRef__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_IdentifierRef__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2()); }
	ruleVersionRequest
	{ after(grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SuperLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SuperLiteral__Group__0__Impl
	rule__SuperLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SuperLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSuperLiteralAccess().getSuperLiteralAction_0()); }
	()
	{ after(grammarAccess.getSuperLiteralAccess().getSuperLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SuperLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SuperLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SuperLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSuperLiteralAccess().getSuperKeyword_1()); }
	Super
	{ after(grammarAccess.getSuperLiteralAccess().getSuperKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ThisLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ThisLiteral__Group__0__Impl
	rule__ThisLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ThisLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThisLiteralAccess().getThisLiteralAction_0()); }
	()
	{ after(grammarAccess.getThisLiteralAccess().getThisLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ThisLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ThisLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ThisLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getThisLiteralAccess().getThisKeyword_1()); }
	This_1
	{ after(grammarAccess.getThisLiteralAccess().getThisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrayLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group__0__Impl
	rule__ArrayLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getArrayLiteralAction_0()); }
	()
	{ after(grammarAccess.getArrayLiteralAccess().getArrayLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group__1__Impl
	rule__ArrayLiteral__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1()); }
	LeftSquareBracket
	{ after(grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group__2__Impl
	rule__ArrayLiteral__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_2()); }
	(rule__ArrayLiteral__ElementsAssignment_2)*
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group__3__Impl
	rule__ArrayLiteral__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getGroup_3()); }
	(rule__ArrayLiteral__Group_3__0)?
	{ after(grammarAccess.getArrayLiteralAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4()); }
	RightSquareBracket
	{ after(grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrayLiteral__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3__0__Impl
	rule__ArrayLiteral__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_0()); }
	(rule__ArrayLiteral__ElementsAssignment_3_0)
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3__1__Impl
	rule__ArrayLiteral__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getGroup_3_1()); }
	(rule__ArrayLiteral__Group_3_1__0)*
	{ after(grammarAccess.getArrayLiteralAccess().getGroup_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getGroup_3_2()); }
	(rule__ArrayLiteral__Group_3_2__0)?
	{ after(grammarAccess.getArrayLiteralAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrayLiteral__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3_1__0__Impl
	rule__ArrayLiteral__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0()); }
	Comma
	{ after(grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3_1__1__Impl
	rule__ArrayLiteral__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_1()); }
	(rule__ArrayLiteral__ElementsAssignment_3_1_1)*
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_2()); }
	(rule__ArrayLiteral__ElementsAssignment_3_1_2)
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrayLiteral__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3_2__0__Impl
	rule__ArrayLiteral__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getTrailingCommaAssignment_3_2_0()); }
	(rule__ArrayLiteral__TrailingCommaAssignment_3_2_0)
	{ after(grammarAccess.getArrayLiteralAccess().getTrailingCommaAssignment_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayLiteral__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayLiteral__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_2_1()); }
	(rule__ArrayLiteral__ElementsAssignment_3_2_1)*
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrayLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group__0__Impl
	norm1_ArrayLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getArrayLiteralAction_0()); }
	()
	{ after(grammarAccess.getArrayLiteralAccess().getArrayLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group__1__Impl
	norm1_ArrayLiteral__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1()); }
	LeftSquareBracket
	{ after(grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group__2__Impl
	norm1_ArrayLiteral__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_2()); }
	(norm1_ArrayLiteral__ElementsAssignment_2)*
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group__3__Impl
	norm1_ArrayLiteral__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getGroup_3()); }
	(norm1_ArrayLiteral__Group_3__0)?
	{ after(grammarAccess.getArrayLiteralAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4()); }
	RightSquareBracket
	{ after(grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrayLiteral__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3__0__Impl
	norm1_ArrayLiteral__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_0()); }
	(norm1_ArrayLiteral__ElementsAssignment_3_0)
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3__1__Impl
	norm1_ArrayLiteral__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getGroup_3_1()); }
	(norm1_ArrayLiteral__Group_3_1__0)*
	{ after(grammarAccess.getArrayLiteralAccess().getGroup_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getGroup_3_2()); }
	(norm1_ArrayLiteral__Group_3_2__0)?
	{ after(grammarAccess.getArrayLiteralAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrayLiteral__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3_1__0__Impl
	norm1_ArrayLiteral__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0()); }
	Comma
	{ after(grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3_1__1__Impl
	norm1_ArrayLiteral__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_1()); }
	(norm1_ArrayLiteral__ElementsAssignment_3_1_1)*
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_2()); }
	(norm1_ArrayLiteral__ElementsAssignment_3_1_2)
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrayLiteral__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3_2__0__Impl
	norm1_ArrayLiteral__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getTrailingCommaAssignment_3_2_0()); }
	(norm1_ArrayLiteral__TrailingCommaAssignment_3_2_0)
	{ after(grammarAccess.getArrayLiteralAccess().getTrailingCommaAssignment_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayLiteral__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayLiteral__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_2_1()); }
	(norm1_ArrayLiteral__ElementsAssignment_3_2_1)*
	{ after(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrayPadding__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayPadding__Group__0__Impl
	rule__ArrayPadding__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayPadding__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayPaddingAccess().getArrayPaddingAction_0()); }
	()
	{ after(grammarAccess.getArrayPaddingAccess().getArrayPaddingAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayPadding__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayPadding__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayPadding__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayPaddingAccess().getCommaKeyword_1()); }
	Comma
	{ after(grammarAccess.getArrayPaddingAccess().getCommaKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArrayElement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayElement__Group__0__Impl
	rule__ArrayElement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayElement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayElementAccess().getArrayElementAction_0()); }
	()
	{ after(grammarAccess.getArrayElementAccess().getArrayElementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayElement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayElement__Group__1__Impl
	rule__ArrayElement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayElement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayElementAccess().getSpreadAssignment_1()); }
	(rule__ArrayElement__SpreadAssignment_1)?
	{ after(grammarAccess.getArrayElementAccess().getSpreadAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayElement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArrayElement__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArrayElement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayElementAccess().getExpressionAssignment_2()); }
	(rule__ArrayElement__ExpressionAssignment_2)
	{ after(grammarAccess.getArrayElementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArrayElement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayElement__Group__0__Impl
	norm1_ArrayElement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayElement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayElementAccess().getArrayElementAction_0()); }
	()
	{ after(grammarAccess.getArrayElementAccess().getArrayElementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayElement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayElement__Group__1__Impl
	norm1_ArrayElement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayElement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayElementAccess().getSpreadAssignment_1()); }
	(norm1_ArrayElement__SpreadAssignment_1)?
	{ after(grammarAccess.getArrayElementAccess().getSpreadAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayElement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArrayElement__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArrayElement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArrayElementAccess().getExpressionAssignment_2()); }
	(norm1_ArrayElement__ExpressionAssignment_2)
	{ after(grammarAccess.getArrayElementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ObjectLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group__0__Impl
	rule__ObjectLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getObjectLiteralAction_0()); }
	()
	{ after(grammarAccess.getObjectLiteralAccess().getObjectLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group__1__Impl
	rule__ObjectLiteral__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1()); }
	LeftCurlyBracket
	{ after(grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group__2__Impl
	rule__ObjectLiteral__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getGroup_2()); }
	(rule__ObjectLiteral__Group_2__0)?
	{ after(grammarAccess.getObjectLiteralAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3()); }
	RightCurlyBracket
	{ after(grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ObjectLiteral__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group_2__0__Impl
	rule__ObjectLiteral__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_0()); }
	(rule__ObjectLiteral__PropertyAssignmentsAssignment_2_0)
	{ after(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group_2__1__Impl
	rule__ObjectLiteral__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getGroup_2_1()); }
	(rule__ObjectLiteral__Group_2_1__0)*
	{ after(grammarAccess.getObjectLiteralAccess().getGroup_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2()); }
	(Comma)?
	{ after(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ObjectLiteral__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group_2_1__0__Impl
	rule__ObjectLiteral__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0()); }
	Comma
	{ after(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ObjectLiteral__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ObjectLiteral__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_1_1()); }
	(rule__ObjectLiteral__PropertyAssignmentsAssignment_2_1_1)
	{ after(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ObjectLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group__0__Impl
	norm1_ObjectLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getObjectLiteralAction_0()); }
	()
	{ after(grammarAccess.getObjectLiteralAccess().getObjectLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group__1__Impl
	norm1_ObjectLiteral__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1()); }
	LeftCurlyBracket
	{ after(grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group__2__Impl
	norm1_ObjectLiteral__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getGroup_2()); }
	(norm1_ObjectLiteral__Group_2__0)?
	{ after(grammarAccess.getObjectLiteralAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3()); }
	RightCurlyBracket
	{ after(grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ObjectLiteral__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group_2__0__Impl
	norm1_ObjectLiteral__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_0()); }
	(norm1_ObjectLiteral__PropertyAssignmentsAssignment_2_0)
	{ after(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group_2__1__Impl
	norm1_ObjectLiteral__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getGroup_2_1()); }
	(norm1_ObjectLiteral__Group_2_1__0)*
	{ after(grammarAccess.getObjectLiteralAccess().getGroup_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2()); }
	(Comma)?
	{ after(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ObjectLiteral__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group_2_1__0__Impl
	norm1_ObjectLiteral__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0()); }
	Comma
	{ after(grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ObjectLiteral__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ObjectLiteral__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_1_1()); }
	(norm1_ObjectLiteral__PropertyAssignmentsAssignment_2_1_1)
	{ after(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group__0__Impl
	rule__AnnotatedPropertyAssignment__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyAssignmentAnnotationListParserRuleCall_0()); }
	rulePropertyAssignmentAnnotationList
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyAssignmentAnnotationListParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1()); }
	(rule__AnnotatedPropertyAssignment__Alternatives_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_0__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_0_1()); }
	(rule__AnnotatedPropertyAssignment__ExpressionAssignment_1_0_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_0_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_0_0_0__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairAnnotationListAction_1_0_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairAnnotationListAction_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_0_0_0__1__Impl
	rule__AnnotatedPropertyAssignment__Group_1_0_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_0_0_0_1()); }
	(rule__AnnotatedPropertyAssignment__DeclaredTypeRefAssignment_1_0_0_0_1)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_0_0_0__2__Impl
	rule__AnnotatedPropertyAssignment__Group_1_0_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_0_0_0_2()); }
	(rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_0_0_0_2)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_0_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_0_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_0_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getColonKeyword_1_0_0_0_3()); }
	Colon
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getColonKeyword_1_0_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_1__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_1_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_1_1()); }
	(rule__AnnotatedPropertyAssignment__BodyAssignment_1_1_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_1_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_1_0_0__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyGetterDeclarationAnnotationListAction_1_1_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyGetterDeclarationAnnotationListAction_1_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGetterHeaderParserRuleCall_1_1_0_0_1()); }
	ruleGetterHeader
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGetterHeaderParserRuleCall_1_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_2_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2__1__Impl
	rule__AnnotatedPropertyAssignment__Group_1_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredOptionalAssignment_1_2_1()); }
	(rule__AnnotatedPropertyAssignment__DeclaredOptionalAssignment_1_2_1)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredOptionalAssignment_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2__2__Impl
	rule__AnnotatedPropertyAssignment__Group_1_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getLeftParenthesisKeyword_1_2_2()); }
	LeftParenthesis
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getLeftParenthesisKeyword_1_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2__3__Impl
	rule__AnnotatedPropertyAssignment__Group_1_2__4
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getFparAssignment_1_2_3()); }
	(rule__AnnotatedPropertyAssignment__FparAssignment_1_2_3)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getFparAssignment_1_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2__4__Impl
	rule__AnnotatedPropertyAssignment__Group_1_2__5
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getRightParenthesisKeyword_1_2_4()); }
	RightParenthesis
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getRightParenthesisKeyword_1_2_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_2_5()); }
	(rule__AnnotatedPropertyAssignment__BodyAssignment_1_2_5)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_2_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_2_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_2_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2_0_0__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_2_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertySetterDeclarationAnnotationListAction_1_2_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertySetterDeclarationAnnotationListAction_1_2_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2_0_0__1__Impl
	rule__AnnotatedPropertyAssignment__Group_1_2_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSetKeyword_1_2_0_0_1()); }
	Set
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSetKeyword_1_2_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_2_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_2_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_2_0_0_2()); }
	(rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_2_0_0_2)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_2_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_3_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSemicolonKeyword_1_3_1()); }
	(Semicolon)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSemicolonKeyword_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0()); }
	(rule__AnnotatedPropertyAssignment__Group_1_3_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_3_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyMethodDeclarationAnnotationListAction_1_3_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyMethodDeclarationAnnotationListAction_1_3_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0__1__Impl
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getTypeVariablesParserRuleCall_1_3_0_0_1()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getTypeVariablesParserRuleCall_1_3_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0__2__Impl
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getReturnTypeRefAssignment_1_3_0_0_2()); }
	(rule__AnnotatedPropertyAssignment__ReturnTypeRefAssignment_1_3_0_0_2)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getReturnTypeRefAssignment_1_3_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1_3_0_0_3()); }
	(rule__AnnotatedPropertyAssignment__Alternatives_1_3_0_0_3)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1_3_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGeneratorAssignment_1_3_0_0_3_0_0()); }
	(rule__AnnotatedPropertyAssignment__GeneratorAssignment_1_3_0_0_3_0_0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGeneratorAssignment_1_3_0_0_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1__Impl
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_0_1()); }
	(rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_3_0_0_3_0_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2()); }
	(norm1_MethodParamsAndBody)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_1_0()); }
	(rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_3_0_0_3_1_0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1()); }
	(ruleMethodParamsAndBody)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_4__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairSingleNameAnnotationListAction_1_4_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairSingleNameAnnotationListAction_1_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_4__1__Impl
	rule__AnnotatedPropertyAssignment__Group_1_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_4_1()); }
	(rule__AnnotatedPropertyAssignment__DeclaredTypeRefAssignment_1_4_1)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_4__2__Impl
	rule__AnnotatedPropertyAssignment__Group_1_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getIdentifierRefAssignment_1_4_2()); }
	(rule__AnnotatedPropertyAssignment__IdentifierRefAssignment_1_4_2)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getIdentifierRefAssignment_1_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_4__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4_3()); }
	(rule__AnnotatedPropertyAssignment__Group_1_4_3__0)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AnnotatedPropertyAssignment__Group_1_4_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_4_3__0__Impl
	rule__AnnotatedPropertyAssignment__Group_1_4_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getEqualsSignKeyword_1_4_3_0()); }
	EqualsSign
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getEqualsSignKeyword_1_4_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AnnotatedPropertyAssignment__Group_1_4_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AnnotatedPropertyAssignment__Group_1_4_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_4_3_1()); }
	(rule__AnnotatedPropertyAssignment__ExpressionAssignment_1_4_3_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_4_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group__0__Impl
	norm1_AnnotatedPropertyAssignment__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyAssignmentAnnotationListParserRuleCall_0()); }
	rulePropertyAssignmentAnnotationList
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyAssignmentAnnotationListParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1()); }
	(norm1_AnnotatedPropertyAssignment__Alternatives_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_0__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_0_1()); }
	(norm1_AnnotatedPropertyAssignment__ExpressionAssignment_1_0_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairAnnotationListAction_1_0_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairAnnotationListAction_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__1__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_0_0_0_1()); }
	(norm1_AnnotatedPropertyAssignment__DeclaredTypeRefAssignment_1_0_0_0_1)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__2__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_0_0_0_2()); }
	(norm1_AnnotatedPropertyAssignment__DeclaredNameAssignment_1_0_0_0_2)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_0_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_0_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getColonKeyword_1_0_0_0_3()); }
	Colon
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getColonKeyword_1_0_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_1__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_1_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_1_1()); }
	(norm1_AnnotatedPropertyAssignment__BodyAssignment_1_1_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyGetterDeclarationAnnotationListAction_1_1_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyGetterDeclarationAnnotationListAction_1_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGetterHeaderParserRuleCall_1_1_0_0_1()); }
	norm1_GetterHeader
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGetterHeaderParserRuleCall_1_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_2_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2__1__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_2__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredOptionalAssignment_1_2_1()); }
	(norm1_AnnotatedPropertyAssignment__DeclaredOptionalAssignment_1_2_1)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredOptionalAssignment_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2__2__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_2__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getLeftParenthesisKeyword_1_2_2()); }
	LeftParenthesis
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getLeftParenthesisKeyword_1_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2__3__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_2__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getFparAssignment_1_2_3()); }
	(norm1_AnnotatedPropertyAssignment__FparAssignment_1_2_3)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getFparAssignment_1_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2__4__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_2__5
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getRightParenthesisKeyword_1_2_4()); }
	RightParenthesis
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getRightParenthesisKeyword_1_2_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__5
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_2_5()); }
	(norm1_AnnotatedPropertyAssignment__BodyAssignment_1_2_5)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_2_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertySetterDeclarationAnnotationListAction_1_2_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertySetterDeclarationAnnotationListAction_1_2_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__1__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSetKeyword_1_2_0_0_1()); }
	Set
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSetKeyword_1_2_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_2_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_2_0_0_2()); }
	(norm1_AnnotatedPropertyAssignment__DeclaredNameAssignment_1_2_0_0_2)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_2_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_3_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSemicolonKeyword_1_3_1()); }
	(Semicolon)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getSemicolonKeyword_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyMethodDeclarationAnnotationListAction_1_3_0_0_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyMethodDeclarationAnnotationListAction_1_3_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__1__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getTypeVariablesParserRuleCall_1_3_0_0_1()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getTypeVariablesParserRuleCall_1_3_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__2__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getReturnTypeRefAssignment_1_3_0_0_2()); }
	(norm1_AnnotatedPropertyAssignment__ReturnTypeRefAssignment_1_3_0_0_2)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getReturnTypeRefAssignment_1_3_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1_3_0_0_3()); }
	(norm1_AnnotatedPropertyAssignment__Alternatives_1_3_0_0_3)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1_3_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGeneratorAssignment_1_3_0_0_3_0_0()); }
	(norm1_AnnotatedPropertyAssignment__GeneratorAssignment_1_3_0_0_3_0_0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGeneratorAssignment_1_3_0_0_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_0_1()); }
	(norm1_AnnotatedPropertyAssignment__DeclaredNameAssignment_1_3_0_0_3_0_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2()); }
	(norm1_MethodParamsAndBody)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_1_0()); }
	(norm1_AnnotatedPropertyAssignment__DeclaredNameAssignment_1_3_0_0_3_1_0)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1()); }
	(ruleMethodParamsAndBody)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_4__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_4__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairSingleNameAnnotationListAction_1_4_0()); }
	()
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyNameValuePairSingleNameAnnotationListAction_1_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_4__1__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_4__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_4_1()); }
	(norm1_AnnotatedPropertyAssignment__DeclaredTypeRefAssignment_1_4_1)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_4__2__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_4__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getIdentifierRefAssignment_1_4_2()); }
	(norm1_AnnotatedPropertyAssignment__IdentifierRefAssignment_1_4_2)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getIdentifierRefAssignment_1_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_4__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4_3()); }
	(norm1_AnnotatedPropertyAssignment__Group_1_4_3__0)?
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AnnotatedPropertyAssignment__Group_1_4_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_4_3__0__Impl
	norm1_AnnotatedPropertyAssignment__Group_1_4_3__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getEqualsSignKeyword_1_4_3_0()); }
	EqualsSign
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getEqualsSignKeyword_1_4_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AnnotatedPropertyAssignment__Group_1_4_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AnnotatedPropertyAssignment__Group_1_4_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_4_3_1()); }
	(norm1_AnnotatedPropertyAssignment__ExpressionAssignment_1_4_3_1)
	{ after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_4_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyMethodDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group__0__Impl
	rule__PropertyMethodDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0()); }
	(rule__PropertyMethodDeclaration__Group_0__0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getSemicolonKeyword_1()); }
	(Semicolon)?
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getSemicolonKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyMethodDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0()); }
	(rule__PropertyMethodDeclaration__Group_0_0__0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyMethodDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0__0__Impl
	rule__PropertyMethodDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getPropertyMethodDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getPropertyMethodDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0__1__Impl
	rule__PropertyMethodDeclaration__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getTypeVariablesParserRuleCall_0_0_1()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getTypeVariablesParserRuleCall_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0__2__Impl
	rule__PropertyMethodDeclaration__Group_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getReturnTypeRefAssignment_0_0_2()); }
	(rule__PropertyMethodDeclaration__ReturnTypeRefAssignment_0_0_2)?
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getReturnTypeRefAssignment_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getAlternatives_0_0_3()); }
	(rule__PropertyMethodDeclaration__Alternatives_0_0_3)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getAlternatives_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyMethodDeclaration__Group_0_0_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0_3_0__0__Impl
	rule__PropertyMethodDeclaration__Group_0_0_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGeneratorAssignment_0_0_3_0_0()); }
	(rule__PropertyMethodDeclaration__GeneratorAssignment_0_0_3_0_0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGeneratorAssignment_0_0_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0_3_0__1__Impl
	rule__PropertyMethodDeclaration__Group_0_0_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_0_1()); }
	(rule__PropertyMethodDeclaration__DeclaredNameAssignment_0_0_3_0_1)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_0_2()); }
	(norm1_MethodParamsAndBody)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyMethodDeclaration__Group_0_0_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0_3_1__0__Impl
	rule__PropertyMethodDeclaration__Group_0_0_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_1_0()); }
	(rule__PropertyMethodDeclaration__DeclaredNameAssignment_0_0_3_1_0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyMethodDeclaration__Group_0_0_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyMethodDeclaration__Group_0_0_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_1_1()); }
	(ruleMethodParamsAndBody)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyMethodDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group__0__Impl
	norm1_PropertyMethodDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0()); }
	(norm1_PropertyMethodDeclaration__Group_0__0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getSemicolonKeyword_1()); }
	(Semicolon)?
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getSemicolonKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyMethodDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0()); }
	(norm1_PropertyMethodDeclaration__Group_0_0__0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyMethodDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0__0__Impl
	norm1_PropertyMethodDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getPropertyMethodDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getPropertyMethodDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0__1__Impl
	norm1_PropertyMethodDeclaration__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getTypeVariablesParserRuleCall_0_0_1()); }
	(ruleTypeVariables)?
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getTypeVariablesParserRuleCall_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0__2__Impl
	norm1_PropertyMethodDeclaration__Group_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getReturnTypeRefAssignment_0_0_2()); }
	(norm1_PropertyMethodDeclaration__ReturnTypeRefAssignment_0_0_2)?
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getReturnTypeRefAssignment_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getAlternatives_0_0_3()); }
	(norm1_PropertyMethodDeclaration__Alternatives_0_0_3)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getAlternatives_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyMethodDeclaration__Group_0_0_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0_3_0__0__Impl
	norm1_PropertyMethodDeclaration__Group_0_0_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getGeneratorAssignment_0_0_3_0_0()); }
	(norm1_PropertyMethodDeclaration__GeneratorAssignment_0_0_3_0_0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getGeneratorAssignment_0_0_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0_3_0__1__Impl
	norm1_PropertyMethodDeclaration__Group_0_0_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_0_1()); }
	(norm1_PropertyMethodDeclaration__DeclaredNameAssignment_0_0_3_0_1)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_0_2()); }
	(norm1_MethodParamsAndBody)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyMethodDeclaration__Group_0_0_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0_3_1__0__Impl
	norm1_PropertyMethodDeclaration__Group_0_0_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_1_0()); }
	(norm1_PropertyMethodDeclaration__DeclaredNameAssignment_0_0_3_1_0)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyMethodDeclaration__Group_0_0_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyMethodDeclaration__Group_0_0_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_1_1()); }
	(ruleMethodParamsAndBody)
	{ after(grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyNameValuePair__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group__0__Impl
	rule__PropertyNameValuePair__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getGroup_0()); }
	(rule__PropertyNameValuePair__Group_0__0)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getExpressionAssignment_1()); }
	(rule__PropertyNameValuePair__ExpressionAssignment_1)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyNameValuePair__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getGroup_0_0()); }
	(rule__PropertyNameValuePair__Group_0_0__0)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyNameValuePair__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group_0_0__0__Impl
	rule__PropertyNameValuePair__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getPropertyNameValuePairAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertyNameValuePairAccess().getPropertyNameValuePairAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group_0_0__1__Impl
	rule__PropertyNameValuePair__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getDeclaredTypeRefAssignment_0_0_1()); }
	(rule__PropertyNameValuePair__DeclaredTypeRefAssignment_0_0_1)?
	{ after(grammarAccess.getPropertyNameValuePairAccess().getDeclaredTypeRefAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group_0_0__2__Impl
	rule__PropertyNameValuePair__Group_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getDeclaredNameAssignment_0_0_2()); }
	(rule__PropertyNameValuePair__DeclaredNameAssignment_0_0_2)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getDeclaredNameAssignment_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group_0_0__3__Impl
	rule__PropertyNameValuePair__Group_0_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getDeclaredOptionalAssignment_0_0_3()); }
	(rule__PropertyNameValuePair__DeclaredOptionalAssignment_0_0_3)?
	{ after(grammarAccess.getPropertyNameValuePairAccess().getDeclaredOptionalAssignment_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePair__Group_0_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePair__Group_0_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getColonKeyword_0_0_4()); }
	Colon
	{ after(grammarAccess.getPropertyNameValuePairAccess().getColonKeyword_0_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyNameValuePair__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group__0__Impl
	norm1_PropertyNameValuePair__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getGroup_0()); }
	(norm1_PropertyNameValuePair__Group_0__0)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getExpressionAssignment_1()); }
	(norm1_PropertyNameValuePair__ExpressionAssignment_1)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyNameValuePair__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getGroup_0_0()); }
	(norm1_PropertyNameValuePair__Group_0_0__0)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyNameValuePair__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group_0_0__0__Impl
	norm1_PropertyNameValuePair__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getPropertyNameValuePairAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertyNameValuePairAccess().getPropertyNameValuePairAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group_0_0__1__Impl
	norm1_PropertyNameValuePair__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getDeclaredTypeRefAssignment_0_0_1()); }
	(norm1_PropertyNameValuePair__DeclaredTypeRefAssignment_0_0_1)?
	{ after(grammarAccess.getPropertyNameValuePairAccess().getDeclaredTypeRefAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group_0_0__2__Impl
	norm1_PropertyNameValuePair__Group_0_0__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getDeclaredNameAssignment_0_0_2()); }
	(norm1_PropertyNameValuePair__DeclaredNameAssignment_0_0_2)
	{ after(grammarAccess.getPropertyNameValuePairAccess().getDeclaredNameAssignment_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group_0_0__3__Impl
	norm1_PropertyNameValuePair__Group_0_0__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getDeclaredOptionalAssignment_0_0_3()); }
	(norm1_PropertyNameValuePair__DeclaredOptionalAssignment_0_0_3)?
	{ after(grammarAccess.getPropertyNameValuePairAccess().getDeclaredOptionalAssignment_0_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePair__Group_0_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePair__Group_0_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairAccess().getColonKeyword_0_0_4()); }
	Colon
	{ after(grammarAccess.getPropertyNameValuePairAccess().getColonKeyword_0_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyNameValuePairSingleName__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePairSingleName__Group__0__Impl
	rule__PropertyNameValuePairSingleName__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getDeclaredTypeRefAssignment_0()); }
	(rule__PropertyNameValuePairSingleName__DeclaredTypeRefAssignment_0)?
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getDeclaredTypeRefAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePairSingleName__Group__1__Impl
	rule__PropertyNameValuePairSingleName__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getIdentifierRefAssignment_1()); }
	(rule__PropertyNameValuePairSingleName__IdentifierRefAssignment_1)
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getIdentifierRefAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePairSingleName__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup_2()); }
	(rule__PropertyNameValuePairSingleName__Group_2__0)?
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyNameValuePairSingleName__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePairSingleName__Group_2__0__Impl
	rule__PropertyNameValuePairSingleName__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getEqualsSignKeyword_2_0()); }
	EqualsSign
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getEqualsSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyNameValuePairSingleName__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyNameValuePairSingleName__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getExpressionAssignment_2_1()); }
	(rule__PropertyNameValuePairSingleName__ExpressionAssignment_2_1)
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getExpressionAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyNameValuePairSingleName__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePairSingleName__Group__0__Impl
	norm1_PropertyNameValuePairSingleName__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getDeclaredTypeRefAssignment_0()); }
	(norm1_PropertyNameValuePairSingleName__DeclaredTypeRefAssignment_0)?
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getDeclaredTypeRefAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePairSingleName__Group__1__Impl
	norm1_PropertyNameValuePairSingleName__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getIdentifierRefAssignment_1()); }
	(norm1_PropertyNameValuePairSingleName__IdentifierRefAssignment_1)
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getIdentifierRefAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePairSingleName__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup_2()); }
	(norm1_PropertyNameValuePairSingleName__Group_2__0)?
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyNameValuePairSingleName__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePairSingleName__Group_2__0__Impl
	norm1_PropertyNameValuePairSingleName__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getEqualsSignKeyword_2_0()); }
	EqualsSign
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getEqualsSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyNameValuePairSingleName__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyNameValuePairSingleName__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getExpressionAssignment_2_1()); }
	(norm1_PropertyNameValuePairSingleName__ExpressionAssignment_2_1)
	{ after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getExpressionAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyGetterDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyGetterDeclaration__Group__0__Impl
	rule__PropertyGetterDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyGetterDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0()); }
	(rule__PropertyGetterDeclaration__Group_0__0)
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyGetterDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyGetterDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyGetterDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getBodyAssignment_1()); }
	(rule__PropertyGetterDeclaration__BodyAssignment_1)
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getBodyAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyGetterDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyGetterDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyGetterDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0_0()); }
	(rule__PropertyGetterDeclaration__Group_0_0__0)
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertyGetterDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyGetterDeclaration__Group_0_0__0__Impl
	rule__PropertyGetterDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyGetterDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getPropertyGetterDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getPropertyGetterDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyGetterDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertyGetterDeclaration__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertyGetterDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGetterHeaderParserRuleCall_0_0_1()); }
	ruleGetterHeader
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGetterHeaderParserRuleCall_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyGetterDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyGetterDeclaration__Group__0__Impl
	norm1_PropertyGetterDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyGetterDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0()); }
	(norm1_PropertyGetterDeclaration__Group_0__0)
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyGetterDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyGetterDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyGetterDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getBodyAssignment_1()); }
	(norm1_PropertyGetterDeclaration__BodyAssignment_1)
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getBodyAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyGetterDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyGetterDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyGetterDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0_0()); }
	(norm1_PropertyGetterDeclaration__Group_0_0__0)
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertyGetterDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyGetterDeclaration__Group_0_0__0__Impl
	norm1_PropertyGetterDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyGetterDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getPropertyGetterDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getPropertyGetterDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyGetterDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertyGetterDeclaration__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertyGetterDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertyGetterDeclarationAccess().getGetterHeaderParserRuleCall_0_0_1()); }
	norm1_GetterHeader
	{ after(grammarAccess.getPropertyGetterDeclarationAccess().getGetterHeaderParserRuleCall_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertySetterDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group__0__Impl
	rule__PropertySetterDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0()); }
	(rule__PropertySetterDeclaration__Group_0__0)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group__1__Impl
	rule__PropertySetterDeclaration__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredOptionalAssignment_1()); }
	(rule__PropertySetterDeclaration__DeclaredOptionalAssignment_1)?
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredOptionalAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group__2__Impl
	rule__PropertySetterDeclaration__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getLeftParenthesisKeyword_2()); }
	LeftParenthesis
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group__3__Impl
	rule__PropertySetterDeclaration__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getFparAssignment_3()); }
	(rule__PropertySetterDeclaration__FparAssignment_3)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getFparAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group__4__Impl
	rule__PropertySetterDeclaration__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getRightParenthesisKeyword_4()); }
	RightParenthesis
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getBodyAssignment_5()); }
	(rule__PropertySetterDeclaration__BodyAssignment_5)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getBodyAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertySetterDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0_0()); }
	(rule__PropertySetterDeclaration__Group_0_0__0)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PropertySetterDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group_0_0__0__Impl
	rule__PropertySetterDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getPropertySetterDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getPropertySetterDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group_0_0__1__Impl
	rule__PropertySetterDeclaration__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getSetKeyword_0_0_1()); }
	Set
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getSetKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PropertySetterDeclaration__Group_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PropertySetterDeclaration__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredNameAssignment_0_0_2()); }
	(rule__PropertySetterDeclaration__DeclaredNameAssignment_0_0_2)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredNameAssignment_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertySetterDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group__0__Impl
	norm1_PropertySetterDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0()); }
	(norm1_PropertySetterDeclaration__Group_0__0)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group__1__Impl
	norm1_PropertySetterDeclaration__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredOptionalAssignment_1()); }
	(norm1_PropertySetterDeclaration__DeclaredOptionalAssignment_1)?
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredOptionalAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group__2__Impl
	norm1_PropertySetterDeclaration__Group__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getLeftParenthesisKeyword_2()); }
	LeftParenthesis
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group__3__Impl
	norm1_PropertySetterDeclaration__Group__4
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getFparAssignment_3()); }
	(norm1_PropertySetterDeclaration__FparAssignment_3)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getFparAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group__4__Impl
	norm1_PropertySetterDeclaration__Group__5
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getRightParenthesisKeyword_4()); }
	RightParenthesis
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getBodyAssignment_5()); }
	(norm1_PropertySetterDeclaration__BodyAssignment_5)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getBodyAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertySetterDeclaration__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0_0()); }
	(norm1_PropertySetterDeclaration__Group_0_0__0)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PropertySetterDeclaration__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group_0_0__0__Impl
	norm1_PropertySetterDeclaration__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getPropertySetterDeclarationAction_0_0_0()); }
	()
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getPropertySetterDeclarationAction_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group_0_0__1__Impl
	norm1_PropertySetterDeclaration__Group_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getSetKeyword_0_0_1()); }
	Set
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getSetKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PropertySetterDeclaration__Group_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PropertySetterDeclaration__Group_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredNameAssignment_0_0_2()); }
	(norm1_PropertySetterDeclaration__DeclaredNameAssignment_0_0_2)
	{ after(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredNameAssignment_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterizedCallExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterizedCallExpression__Group__0__Impl
	rule__ParameterizedCallExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedCallExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedCallExpressionAccess().getConcreteTypeArgumentsParserRuleCall_0()); }
	ruleConcreteTypeArguments
	{ after(grammarAccess.getParameterizedCallExpressionAccess().getConcreteTypeArgumentsParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedCallExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterizedCallExpression__Group__1__Impl
	rule__ParameterizedCallExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedCallExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedCallExpressionAccess().getTargetAssignment_1()); }
	(rule__ParameterizedCallExpression__TargetAssignment_1)
	{ after(grammarAccess.getParameterizedCallExpressionAccess().getTargetAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedCallExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterizedCallExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedCallExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_2()); }
	ruleArgumentsWithParentheses
	{ after(grammarAccess.getParameterizedCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ParameterizedCallExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParameterizedCallExpression__Group__0__Impl
	norm1_ParameterizedCallExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedCallExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedCallExpressionAccess().getConcreteTypeArgumentsParserRuleCall_0()); }
	ruleConcreteTypeArguments
	{ after(grammarAccess.getParameterizedCallExpressionAccess().getConcreteTypeArgumentsParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedCallExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParameterizedCallExpression__Group__1__Impl
	norm1_ParameterizedCallExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedCallExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedCallExpressionAccess().getTargetAssignment_1()); }
	(norm1_ParameterizedCallExpression__TargetAssignment_1)
	{ after(grammarAccess.getParameterizedCallExpressionAccess().getTargetAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedCallExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParameterizedCallExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedCallExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_2()); }
	norm1_ArgumentsWithParentheses
	{ after(grammarAccess.getParameterizedCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConcreteTypeArguments__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConcreteTypeArguments__Group__0__Impl
	rule__ConcreteTypeArguments__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConcreteTypeArgumentsAccess().getLessThanSignKeyword_0()); }
	LessThanSign
	{ after(grammarAccess.getConcreteTypeArgumentsAccess().getLessThanSignKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConcreteTypeArguments__Group__1__Impl
	rule__ConcreteTypeArguments__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_1()); }
	(rule__ConcreteTypeArguments__TypeArgsAssignment_1)
	{ after(grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConcreteTypeArguments__Group__2__Impl
	rule__ConcreteTypeArguments__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConcreteTypeArgumentsAccess().getGroup_2()); }
	(rule__ConcreteTypeArguments__Group_2__0)*
	{ after(grammarAccess.getConcreteTypeArgumentsAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConcreteTypeArguments__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConcreteTypeArgumentsAccess().getGreaterThanSignKeyword_3()); }
	GreaterThanSign
	{ after(grammarAccess.getConcreteTypeArgumentsAccess().getGreaterThanSignKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConcreteTypeArguments__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConcreteTypeArguments__Group_2__0__Impl
	rule__ConcreteTypeArguments__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConcreteTypeArgumentsAccess().getCommaKeyword_2_0()); }
	Comma
	{ after(grammarAccess.getConcreteTypeArgumentsAccess().getCommaKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConcreteTypeArguments__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConcreteTypeArguments__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_2_1()); }
	(rule__ConcreteTypeArguments__TypeArgsAssignment_2_1)
	{ after(grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LeftHandSideExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group__0__Impl
	rule__LeftHandSideExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getMemberExpressionParserRuleCall_0()); }
	ruleMemberExpression
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getMemberExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1()); }
	(rule__LeftHandSideExpression__Group_1__0)?
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LeftHandSideExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1__0__Impl
	rule__LeftHandSideExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1__1__Impl
	rule__LeftHandSideExpression__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_1()); }
	ruleArgumentsWithParentheses
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getAlternatives_1_2()); }
	(rule__LeftHandSideExpression__Alternatives_1_2)*
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getAlternatives_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LeftHandSideExpression__Group_1_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_0__0__Impl
	rule__LeftHandSideExpression__Group_1_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_2_0_1()); }
	ruleArgumentsWithParentheses
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LeftHandSideExpression__Group_1_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_1__0__Impl
	rule__LeftHandSideExpression__Group_1_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_2_1_1()); }
	ruleIndexedAccessExpressionTail
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LeftHandSideExpression__Group_1_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_2__0__Impl
	rule__LeftHandSideExpression__Group_1_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1()); }
	ruleParameterizedPropertyAccessExpressionTail
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LeftHandSideExpression__Group_1_2_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_3__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3_0()); }
	(rule__LeftHandSideExpression__Group_1_2_3_0__0)
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LeftHandSideExpression__Group_1_2_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_3_0__0__Impl
	rule__LeftHandSideExpression__Group_1_2_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LeftHandSideExpression__Group_1_2_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Group_1_2_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getTemplateAssignment_1_2_3_0_1()); }
	(rule__LeftHandSideExpression__TemplateAssignment_1_2_3_0_1)
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getTemplateAssignment_1_2_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LeftHandSideExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group__0__Impl
	norm1_LeftHandSideExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getMemberExpressionParserRuleCall_0()); }
	norm1_MemberExpression
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getMemberExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1()); }
	(norm1_LeftHandSideExpression__Group_1__0)?
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LeftHandSideExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1__0__Impl
	norm1_LeftHandSideExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1__1__Impl
	norm1_LeftHandSideExpression__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_1()); }
	norm1_ArgumentsWithParentheses
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getAlternatives_1_2()); }
	(norm1_LeftHandSideExpression__Alternatives_1_2)*
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getAlternatives_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LeftHandSideExpression__Group_1_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_0__0__Impl
	norm1_LeftHandSideExpression__Group_1_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_2_0_1()); }
	norm1_ArgumentsWithParentheses
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LeftHandSideExpression__Group_1_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_1__0__Impl
	norm1_LeftHandSideExpression__Group_1_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_2_1_1()); }
	norm1_IndexedAccessExpressionTail
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LeftHandSideExpression__Group_1_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_2__0__Impl
	norm1_LeftHandSideExpression__Group_1_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1()); }
	norm1_ParameterizedPropertyAccessExpressionTail
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LeftHandSideExpression__Group_1_2_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_3__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3_0()); }
	(norm1_LeftHandSideExpression__Group_1_2_3_0__0)
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_LeftHandSideExpression__Group_1_2_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_3_0__0__Impl
	norm1_LeftHandSideExpression__Group_1_2_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()); }
	()
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_LeftHandSideExpression__Group_1_2_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_LeftHandSideExpression__Group_1_2_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLeftHandSideExpressionAccess().getTemplateAssignment_1_2_3_0_1()); }
	(norm1_LeftHandSideExpression__TemplateAssignment_1_2_3_0_1)
	{ after(grammarAccess.getLeftHandSideExpressionAccess().getTemplateAssignment_1_2_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ArgumentsWithParentheses__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArgumentsWithParentheses__Group__0__Impl
	rule__ArgumentsWithParentheses__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ArgumentsWithParentheses__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsWithParenthesesAccess().getLeftParenthesisKeyword_0()); }
	LeftParenthesis
	{ after(grammarAccess.getArgumentsWithParenthesesAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArgumentsWithParentheses__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArgumentsWithParentheses__Group__1__Impl
	rule__ArgumentsWithParentheses__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ArgumentsWithParentheses__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsWithParenthesesAccess().getArgumentsParserRuleCall_1()); }
	(ruleArguments)?
	{ after(grammarAccess.getArgumentsWithParenthesesAccess().getArgumentsParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArgumentsWithParentheses__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ArgumentsWithParentheses__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ArgumentsWithParentheses__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsWithParenthesesAccess().getRightParenthesisKeyword_2()); }
	RightParenthesis
	{ after(grammarAccess.getArgumentsWithParenthesesAccess().getRightParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ArgumentsWithParentheses__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArgumentsWithParentheses__Group__0__Impl
	norm1_ArgumentsWithParentheses__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArgumentsWithParentheses__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsWithParenthesesAccess().getLeftParenthesisKeyword_0()); }
	LeftParenthesis
	{ after(grammarAccess.getArgumentsWithParenthesesAccess().getLeftParenthesisKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArgumentsWithParentheses__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArgumentsWithParentheses__Group__1__Impl
	norm1_ArgumentsWithParentheses__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArgumentsWithParentheses__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsWithParenthesesAccess().getArgumentsParserRuleCall_1()); }
	(norm1_Arguments)?
	{ after(grammarAccess.getArgumentsWithParenthesesAccess().getArgumentsParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArgumentsWithParentheses__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ArgumentsWithParentheses__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ArgumentsWithParentheses__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsWithParenthesesAccess().getRightParenthesisKeyword_2()); }
	RightParenthesis
	{ after(grammarAccess.getArgumentsWithParenthesesAccess().getRightParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Arguments__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Arguments__Group__0__Impl
	rule__Arguments__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Arguments__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getArgumentsAssignment_0()); }
	(rule__Arguments__ArgumentsAssignment_0)
	{ after(grammarAccess.getArgumentsAccess().getArgumentsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Arguments__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Arguments__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Arguments__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getGroup_1()); }
	(rule__Arguments__Group_1__0)*
	{ after(grammarAccess.getArgumentsAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Arguments__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Arguments__Group_1__0__Impl
	rule__Arguments__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Arguments__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getCommaKeyword_1_0()); }
	Comma
	{ after(grammarAccess.getArgumentsAccess().getCommaKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Arguments__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Arguments__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Arguments__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getArgumentsAssignment_1_1()); }
	(rule__Arguments__ArgumentsAssignment_1_1)
	{ after(grammarAccess.getArgumentsAccess().getArgumentsAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_Arguments__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Arguments__Group__0__Impl
	norm1_Arguments__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_Arguments__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getArgumentsAssignment_0()); }
	(norm1_Arguments__ArgumentsAssignment_0)
	{ after(grammarAccess.getArgumentsAccess().getArgumentsAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_Arguments__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Arguments__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_Arguments__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getGroup_1()); }
	(norm1_Arguments__Group_1__0)*
	{ after(grammarAccess.getArgumentsAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_Arguments__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Arguments__Group_1__0__Impl
	norm1_Arguments__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_Arguments__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getCommaKeyword_1_0()); }
	Comma
	{ after(grammarAccess.getArgumentsAccess().getCommaKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_Arguments__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Arguments__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_Arguments__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentsAccess().getArgumentsAssignment_1_1()); }
	(norm1_Arguments__ArgumentsAssignment_1_1)
	{ after(grammarAccess.getArgumentsAccess().getArgumentsAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__0__Impl
	rule__Argument__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getSpreadAssignment_0()); }
	(rule__Argument__SpreadAssignment_0)?
	{ after(grammarAccess.getArgumentAccess().getSpreadAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getExpressionAssignment_1()); }
	(rule__Argument__ExpressionAssignment_1)
	{ after(grammarAccess.getArgumentAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_Argument__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Argument__Group__0__Impl
	norm1_Argument__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_Argument__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getSpreadAssignment_0()); }
	(norm1_Argument__SpreadAssignment_0)?
	{ after(grammarAccess.getArgumentAccess().getSpreadAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_Argument__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_Argument__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_Argument__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getExpressionAssignment_1()); }
	(norm1_Argument__ExpressionAssignment_1)
	{ after(grammarAccess.getArgumentAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_0__0__Impl
	rule__MemberExpression__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_0_0()); }
	(rule__MemberExpression__Group_0_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTargetKeyword_0_1()); }
	Target
	{ after(grammarAccess.getMemberExpressionAccess().getTargetKeyword_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_0_0_0()); }
	(rule__MemberExpression__Group_0_0_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_0_0_0__0__Impl
	rule__MemberExpression__Group_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewTargetAction_0_0_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getNewTargetAction_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_0_0_0__1__Impl
	rule__MemberExpression__Group_0_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewKeyword_0_0_0_1()); }
	New
	{ after(grammarAccess.getMemberExpressionAccess().getNewKeyword_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_0_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_0_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getFullStopKeyword_0_0_0_2()); }
	FullStop
	{ after(grammarAccess.getMemberExpressionAccess().getFullStopKeyword_0_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1__0__Impl
	rule__MemberExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_0()); }
	(rule__MemberExpression__Group_1_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1__1__Impl
	rule__MemberExpression__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getCalleeAssignment_1_1()); }
	(rule__MemberExpression__CalleeAssignment_1_1)
	{ after(grammarAccess.getMemberExpressionAccess().getCalleeAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1__2__Impl
	rule__MemberExpression__Group_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getConcreteTypeArgumentsParserRuleCall_1_2()); }
	(ruleConcreteTypeArguments)?
	{ after(grammarAccess.getMemberExpressionAccess().getConcreteTypeArgumentsParserRuleCall_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3()); }
	(rule__MemberExpression__Group_1_3__0)?
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_0_0()); }
	(rule__MemberExpression__Group_1_0_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_0_0__0__Impl
	rule__MemberExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewExpressionAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getNewExpressionAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewKeyword_1_0_0_1()); }
	New
	{ after(grammarAccess.getMemberExpressionAccess().getNewKeyword_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3__0__Impl
	rule__MemberExpression__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getWithArgsAssignment_1_3_0()); }
	(rule__MemberExpression__WithArgsAssignment_1_3_0)
	{ after(grammarAccess.getMemberExpressionAccess().getWithArgsAssignment_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3__1__Impl
	rule__MemberExpression__Group_1_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getArgumentsParserRuleCall_1_3_1()); }
	(ruleArguments)?
	{ after(grammarAccess.getMemberExpressionAccess().getArgumentsParserRuleCall_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3__2__Impl
	rule__MemberExpression__Group_1_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getRightParenthesisKeyword_1_3_2()); }
	RightParenthesis
	{ after(grammarAccess.getMemberExpressionAccess().getRightParenthesisKeyword_1_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getAlternatives_1_3_3()); }
	(rule__MemberExpression__Alternatives_1_3_3)*
	{ after(grammarAccess.getMemberExpressionAccess().getAlternatives_1_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_1_3_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3_3_0__0__Impl
	rule__MemberExpression__Group_1_3_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_3_3_0_1()); }
	ruleIndexedAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_3_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_1_3_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3_3_1__0__Impl
	rule__MemberExpression__Group_1_3_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_3_3_1_1()); }
	ruleParameterizedPropertyAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_3_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_1_3_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3_3_2__0__Impl
	rule__MemberExpression__Group_1_3_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_1_3_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_1_3_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_1_3_3_2_1()); }
	(rule__MemberExpression__TemplateAssignment_1_3_3_2_1)
	{ after(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_1_3_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2__0__Impl
	rule__MemberExpression__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getPrimaryExpressionParserRuleCall_2_0()); }
	rulePrimaryExpression
	{ after(grammarAccess.getMemberExpressionAccess().getPrimaryExpressionParserRuleCall_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getAlternatives_2_1()); }
	(rule__MemberExpression__Alternatives_2_1)*
	{ after(grammarAccess.getMemberExpressionAccess().getAlternatives_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2_1_0__0__Impl
	rule__MemberExpression__Group_2_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_2_1_0_1()); }
	ruleIndexedAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_2_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2_1_1__0__Impl
	rule__MemberExpression__Group_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_2_1_1_1()); }
	ruleParameterizedPropertyAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_2_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MemberExpression__Group_2_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2_1_2__0__Impl
	rule__MemberExpression__Group_2_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MemberExpression__Group_2_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MemberExpression__Group_2_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_2_1_2_1()); }
	(rule__MemberExpression__TemplateAssignment_2_1_2_1)
	{ after(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_2_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_0__0__Impl
	norm1_MemberExpression__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_0_0()); }
	(norm1_MemberExpression__Group_0_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTargetKeyword_0_1()); }
	Target
	{ after(grammarAccess.getMemberExpressionAccess().getTargetKeyword_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_0_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_0_0_0()); }
	(norm1_MemberExpression__Group_0_0_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_0_0_0__0__Impl
	norm1_MemberExpression__Group_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewTargetAction_0_0_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getNewTargetAction_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_0_0_0__1__Impl
	norm1_MemberExpression__Group_0_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewKeyword_0_0_0_1()); }
	New
	{ after(grammarAccess.getMemberExpressionAccess().getNewKeyword_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_0_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_0_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getFullStopKeyword_0_0_0_2()); }
	FullStop
	{ after(grammarAccess.getMemberExpressionAccess().getFullStopKeyword_0_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1__0__Impl
	norm1_MemberExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_0()); }
	(norm1_MemberExpression__Group_1_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1__1__Impl
	norm1_MemberExpression__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getCalleeAssignment_1_1()); }
	(norm1_MemberExpression__CalleeAssignment_1_1)
	{ after(grammarAccess.getMemberExpressionAccess().getCalleeAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1__2__Impl
	norm1_MemberExpression__Group_1__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getConcreteTypeArgumentsParserRuleCall_1_2()); }
	(ruleConcreteTypeArguments)?
	{ after(grammarAccess.getMemberExpressionAccess().getConcreteTypeArgumentsParserRuleCall_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_3()); }
	(norm1_MemberExpression__Group_1_3__0)?
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getGroup_1_0_0()); }
	(norm1_MemberExpression__Group_1_0_0__0)
	{ after(grammarAccess.getMemberExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_0_0__0__Impl
	norm1_MemberExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewExpressionAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getNewExpressionAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getNewKeyword_1_0_0_1()); }
	New
	{ after(grammarAccess.getMemberExpressionAccess().getNewKeyword_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3__0__Impl
	norm1_MemberExpression__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getWithArgsAssignment_1_3_0()); }
	(norm1_MemberExpression__WithArgsAssignment_1_3_0)
	{ after(grammarAccess.getMemberExpressionAccess().getWithArgsAssignment_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3__1__Impl
	norm1_MemberExpression__Group_1_3__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getArgumentsParserRuleCall_1_3_1()); }
	(norm1_Arguments)?
	{ after(grammarAccess.getMemberExpressionAccess().getArgumentsParserRuleCall_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3__2__Impl
	norm1_MemberExpression__Group_1_3__3
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getRightParenthesisKeyword_1_3_2()); }
	RightParenthesis
	{ after(grammarAccess.getMemberExpressionAccess().getRightParenthesisKeyword_1_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getAlternatives_1_3_3()); }
	(norm1_MemberExpression__Alternatives_1_3_3)*
	{ after(grammarAccess.getMemberExpressionAccess().getAlternatives_1_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_1_3_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3_3_0__0__Impl
	norm1_MemberExpression__Group_1_3_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_3_3_0_1()); }
	norm1_IndexedAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_3_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_1_3_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3_3_1__0__Impl
	norm1_MemberExpression__Group_1_3_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_3_3_1_1()); }
	norm1_ParameterizedPropertyAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_3_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_1_3_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3_3_2__0__Impl
	norm1_MemberExpression__Group_1_3_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_1_3_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_1_3_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_1_3_3_2_1()); }
	(norm1_MemberExpression__TemplateAssignment_1_3_3_2_1)
	{ after(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_1_3_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2__0__Impl
	norm1_MemberExpression__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getPrimaryExpressionParserRuleCall_2_0()); }
	norm1_PrimaryExpression
	{ after(grammarAccess.getMemberExpressionAccess().getPrimaryExpressionParserRuleCall_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getAlternatives_2_1()); }
	(norm1_MemberExpression__Alternatives_2_1)*
	{ after(grammarAccess.getMemberExpressionAccess().getAlternatives_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2_1_0__0__Impl
	norm1_MemberExpression__Group_2_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_2_1_0_1()); }
	norm1_IndexedAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_2_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2_1_1__0__Impl
	norm1_MemberExpression__Group_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_2_1_1_1()); }
	norm1_ParameterizedPropertyAccessExpressionTail
	{ after(grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_2_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MemberExpression__Group_2_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2_1_2__0__Impl
	norm1_MemberExpression__Group_2_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()); }
	()
	{ after(grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MemberExpression__Group_2_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MemberExpression__Group_2_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_2_1_2_1()); }
	(norm1_MemberExpression__TemplateAssignment_2_1_2_1)
	{ after(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_2_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IndexedAccessExpressionTail__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IndexedAccessExpressionTail__Group__0__Impl
	rule__IndexedAccessExpressionTail__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IndexedAccessExpressionTail__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getLeftSquareBracketKeyword_0()); }
	LeftSquareBracket
	{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getLeftSquareBracketKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IndexedAccessExpressionTail__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IndexedAccessExpressionTail__Group__1__Impl
	rule__IndexedAccessExpressionTail__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IndexedAccessExpressionTail__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getIndexAssignment_1()); }
	(rule__IndexedAccessExpressionTail__IndexAssignment_1)
	{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getIndexAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IndexedAccessExpressionTail__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IndexedAccessExpressionTail__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IndexedAccessExpressionTail__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getRightSquareBracketKeyword_2()); }
	RightSquareBracket
	{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getRightSquareBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_IndexedAccessExpressionTail__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IndexedAccessExpressionTail__Group__0__Impl
	norm1_IndexedAccessExpressionTail__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_IndexedAccessExpressionTail__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getLeftSquareBracketKeyword_0()); }
	LeftSquareBracket
	{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getLeftSquareBracketKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IndexedAccessExpressionTail__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IndexedAccessExpressionTail__Group__1__Impl
	norm1_IndexedAccessExpressionTail__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_IndexedAccessExpressionTail__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getIndexAssignment_1()); }
	(norm1_IndexedAccessExpressionTail__IndexAssignment_1)
	{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getIndexAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_IndexedAccessExpressionTail__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_IndexedAccessExpressionTail__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_IndexedAccessExpressionTail__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIndexedAccessExpressionTailAccess().getRightSquareBracketKeyword_2()); }
	RightSquareBracket
	{ after(grammarAccess.getIndexedAccessExpressionTailAccess().getRightSquareBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterizedPropertyAccessExpressionTail__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterizedPropertyAccessExpressionTail__Group__0__Impl
	rule__ParameterizedPropertyAccessExpressionTail__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedPropertyAccessExpressionTail__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getFullStopKeyword_0()); }
	FullStop
	{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getFullStopKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedPropertyAccessExpressionTail__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterizedPropertyAccessExpressionTail__Group__1__Impl
	rule__ParameterizedPropertyAccessExpressionTail__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedPropertyAccessExpressionTail__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getConcreteTypeArgumentsParserRuleCall_1()); }
	(ruleConcreteTypeArguments)?
	{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getConcreteTypeArgumentsParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedPropertyAccessExpressionTail__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterizedPropertyAccessExpressionTail__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterizedPropertyAccessExpressionTail__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getPropertyAssignment_2()); }
	(rule__ParameterizedPropertyAccessExpressionTail__PropertyAssignment_2)
	{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getPropertyAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_ParameterizedPropertyAccessExpressionTail__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParameterizedPropertyAccessExpressionTail__Group__0__Impl
	norm1_ParameterizedPropertyAccessExpressionTail__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedPropertyAccessExpressionTail__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getFullStopKeyword_0()); }
	FullStop
	{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getFullStopKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedPropertyAccessExpressionTail__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParameterizedPropertyAccessExpressionTail__Group__1__Impl
	norm1_ParameterizedPropertyAccessExpressionTail__Group__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedPropertyAccessExpressionTail__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getConcreteTypeArgumentsParserRuleCall_1()); }
	(ruleConcreteTypeArguments)?
	{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getConcreteTypeArgumentsParserRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedPropertyAccessExpressionTail__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_ParameterizedPropertyAccessExpressionTail__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_ParameterizedPropertyAccessExpressionTail__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getPropertyAssignment_2()); }
	(norm1_ParameterizedPropertyAccessExpressionTail__PropertyAssignment_2)
	{ after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getPropertyAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostfixExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostfixExpression__Group__0__Impl
	rule__PostfixExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getLeftHandSideExpressionParserRuleCall_0()); }
	ruleLeftHandSideExpression
	{ after(grammarAccess.getPostfixExpressionAccess().getLeftHandSideExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostfixExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getGroup_1()); }
	(rule__PostfixExpression__Group_1__0)?
	{ after(grammarAccess.getPostfixExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostfixExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostfixExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getGroup_1_0()); }
	(rule__PostfixExpression__Group_1_0__0)
	{ after(grammarAccess.getPostfixExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostfixExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostfixExpression__Group_1_0__0__Impl
	rule__PostfixExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()); }
	()
	{ after(grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostfixExpression__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostfixExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getOpAssignment_1_0_1()); }
	(rule__PostfixExpression__OpAssignment_1_0_1)
	{ after(grammarAccess.getPostfixExpressionAccess().getOpAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PostfixExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PostfixExpression__Group__0__Impl
	norm1_PostfixExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PostfixExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getLeftHandSideExpressionParserRuleCall_0()); }
	norm1_LeftHandSideExpression
	{ after(grammarAccess.getPostfixExpressionAccess().getLeftHandSideExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PostfixExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PostfixExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PostfixExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getGroup_1()); }
	(norm1_PostfixExpression__Group_1__0)?
	{ after(grammarAccess.getPostfixExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PostfixExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PostfixExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PostfixExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getGroup_1_0()); }
	(norm1_PostfixExpression__Group_1_0__0)
	{ after(grammarAccess.getPostfixExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_PostfixExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PostfixExpression__Group_1_0__0__Impl
	norm1_PostfixExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_PostfixExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()); }
	()
	{ after(grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_PostfixExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_PostfixExpression__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_PostfixExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostfixExpressionAccess().getOpAssignment_1_0_1()); }
	(norm1_PostfixExpression__OpAssignment_1_0_1)
	{ after(grammarAccess.getPostfixExpressionAccess().getOpAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CastExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CastExpression__Group__0__Impl
	rule__CastExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getPostfixExpressionParserRuleCall_0()); }
	rulePostfixExpression
	{ after(grammarAccess.getCastExpressionAccess().getPostfixExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CastExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getGroup_1()); }
	(rule__CastExpression__Group_1__0)?
	{ after(grammarAccess.getCastExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CastExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CastExpression__Group_1__0__Impl
	rule__CastExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getGroup_1_0()); }
	(rule__CastExpression__Group_1_0__0)
	{ after(grammarAccess.getCastExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CastExpression__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getTargetTypeRefAssignment_1_1()); }
	(rule__CastExpression__TargetTypeRefAssignment_1_1)
	{ after(grammarAccess.getCastExpressionAccess().getTargetTypeRefAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CastExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CastExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getGroup_1_0_0()); }
	(rule__CastExpression__Group_1_0_0__0)
	{ after(grammarAccess.getCastExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CastExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CastExpression__Group_1_0_0__0__Impl
	rule__CastExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CastExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CastExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getAsKeyword_1_0_0_1()); }
	As
	{ after(grammarAccess.getCastExpressionAccess().getAsKeyword_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CastExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CastExpression__Group__0__Impl
	norm1_CastExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getPostfixExpressionParserRuleCall_0()); }
	norm1_PostfixExpression
	{ after(grammarAccess.getCastExpressionAccess().getPostfixExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CastExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getGroup_1()); }
	(norm1_CastExpression__Group_1__0)?
	{ after(grammarAccess.getCastExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CastExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CastExpression__Group_1__0__Impl
	norm1_CastExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getGroup_1_0()); }
	(norm1_CastExpression__Group_1_0__0)
	{ after(grammarAccess.getCastExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CastExpression__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getTargetTypeRefAssignment_1_1()); }
	(norm1_CastExpression__TargetTypeRefAssignment_1_1)
	{ after(grammarAccess.getCastExpressionAccess().getTargetTypeRefAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CastExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CastExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getGroup_1_0_0()); }
	(norm1_CastExpression__Group_1_0_0__0)
	{ after(grammarAccess.getCastExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_CastExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CastExpression__Group_1_0_0__0__Impl
	norm1_CastExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_CastExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_CastExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCastExpressionAccess().getAsKeyword_1_0_0_1()); }
	As
	{ after(grammarAccess.getCastExpressionAccess().getAsKeyword_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnaryExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnaryExpression__Group_1__0__Impl
	rule__UnaryExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnaryExpressionAccess().getUnaryExpressionAction_1_0()); }
	()
	{ after(grammarAccess.getUnaryExpressionAccess().getUnaryExpressionAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnaryExpression__Group_1__1__Impl
	rule__UnaryExpression__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnaryExpressionAccess().getOpAssignment_1_1()); }
	(rule__UnaryExpression__OpAssignment_1_1)
	{ after(grammarAccess.getUnaryExpressionAccess().getOpAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryExpression__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnaryExpression__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryExpression__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnaryExpressionAccess().getExpressionAssignment_1_2()); }
	(rule__UnaryExpression__ExpressionAssignment_1_2)
	{ after(grammarAccess.getUnaryExpressionAccess().getExpressionAssignment_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_UnaryExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_UnaryExpression__Group_1__0__Impl
	norm1_UnaryExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_UnaryExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnaryExpressionAccess().getUnaryExpressionAction_1_0()); }
	()
	{ after(grammarAccess.getUnaryExpressionAccess().getUnaryExpressionAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_UnaryExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_UnaryExpression__Group_1__1__Impl
	norm1_UnaryExpression__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

norm1_UnaryExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnaryExpressionAccess().getOpAssignment_1_1()); }
	(norm1_UnaryExpression__OpAssignment_1_1)
	{ after(grammarAccess.getUnaryExpressionAccess().getOpAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_UnaryExpression__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_UnaryExpression__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_UnaryExpression__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnaryExpressionAccess().getExpressionAssignment_1_2()); }
	(norm1_UnaryExpression__ExpressionAssignment_1_2)
	{ after(grammarAccess.getUnaryExpressionAccess().getExpressionAssignment_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MultiplicativeExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MultiplicativeExpression__Group__0__Impl
	rule__MultiplicativeExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getUnaryExpressionParserRuleCall_0()); }
	ruleUnaryExpression
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getUnaryExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MultiplicativeExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1()); }
	(rule__MultiplicativeExpression__Group_1__0)*
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MultiplicativeExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MultiplicativeExpression__Group_1__0__Impl
	rule__MultiplicativeExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0()); }
	(rule__MultiplicativeExpression__Group_1_0__0)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MultiplicativeExpression__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getRhsAssignment_1_1()); }
	(rule__MultiplicativeExpression__RhsAssignment_1_1)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getRhsAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MultiplicativeExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MultiplicativeExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0_0()); }
	(rule__MultiplicativeExpression__Group_1_0_0__0)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MultiplicativeExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MultiplicativeExpression__Group_1_0_0__0__Impl
	rule__MultiplicativeExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MultiplicativeExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getOpAssignment_1_0_0_1()); }
	(rule__MultiplicativeExpression__OpAssignment_1_0_0_1)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getOpAssignment_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MultiplicativeExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MultiplicativeExpression__Group__0__Impl
	norm1_MultiplicativeExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getUnaryExpressionParserRuleCall_0()); }
	norm1_UnaryExpression
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getUnaryExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MultiplicativeExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1()); }
	(norm1_MultiplicativeExpression__Group_1__0)*
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MultiplicativeExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MultiplicativeExpression__Group_1__0__Impl
	norm1_MultiplicativeExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0()); }
	(norm1_MultiplicativeExpression__Group_1_0__0)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MultiplicativeExpression__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getRhsAssignment_1_1()); }
	(norm1_MultiplicativeExpression__RhsAssignment_1_1)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getRhsAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MultiplicativeExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MultiplicativeExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0_0()); }
	(norm1_MultiplicativeExpression__Group_1_0_0__0)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_MultiplicativeExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MultiplicativeExpression__Group_1_0_0__0__Impl
	norm1_MultiplicativeExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_MultiplicativeExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_MultiplicativeExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMultiplicativeExpressionAccess().getOpAssignment_1_0_0_1()); }
	(norm1_MultiplicativeExpression__OpAssignment_1_0_0_1)
	{ after(grammarAccess.getMultiplicativeExpressionAccess().getOpAssignment_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AdditiveExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AdditiveExpression__Group__0__Impl
	rule__AdditiveExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getMultiplicativeExpressionParserRuleCall_0()); }
	ruleMultiplicativeExpression
	{ after(grammarAccess.getAdditiveExpressionAccess().getMultiplicativeExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AdditiveExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1()); }
	(rule__AdditiveExpression__Group_1__0)*
	{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AdditiveExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AdditiveExpression__Group_1__0__Impl
	rule__AdditiveExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0()); }
	(rule__AdditiveExpression__Group_1_0__0)
	{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AdditiveExpression__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getRhsAssignment_1_1()); }
	(rule__AdditiveExpression__RhsAssignment_1_1)
	{ after(grammarAccess.getAdditiveExpressionAccess().getRhsAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AdditiveExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AdditiveExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0_0()); }
	(rule__AdditiveExpression__Group_1_0_0__0)
	{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AdditiveExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AdditiveExpression__Group_1_0_0__0__Impl
	rule__AdditiveExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AdditiveExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getOpAssignment_1_0_0_1()); }
	(rule__AdditiveExpression__OpAssignment_1_0_0_1)
	{ after(grammarAccess.getAdditiveExpressionAccess().getOpAssignment_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AdditiveExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AdditiveExpression__Group__0__Impl
	norm1_AdditiveExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getMultiplicativeExpressionParserRuleCall_0()); }
	norm1_MultiplicativeExpression
	{ after(grammarAccess.getAdditiveExpressionAccess().getMultiplicativeExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AdditiveExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1()); }
	(norm1_AdditiveExpression__Group_1__0)*
	{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AdditiveExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AdditiveExpression__Group_1__0__Impl
	norm1_AdditiveExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0()); }
	(norm1_AdditiveExpression__Group_1_0__0)
	{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AdditiveExpression__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getRhsAssignment_1_1()); }
	(norm1_AdditiveExpression__RhsAssignment_1_1)
	{ after(grammarAccess.getAdditiveExpressionAccess().getRhsAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AdditiveExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AdditiveExpression__Group_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0_0()); }
	(norm1_AdditiveExpression__Group_1_0_0__0)
	{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


norm1_AdditiveExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AdditiveExpression__Group_1_0_0__0__Impl
	norm1_AdditiveExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	norm1_AdditiveExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

norm1_AdditiveExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAdditiveExpressionAccess().getOpAssignment_1_0_0_1()); }
	(norm1_AdditiveExpression__OpAssignment_1_0_0_1)
	{ after(grammarAccess.getAdditiveExpressionAccess().g