/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.credentials;

import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class LoginDialog
extends Dialog {
    private final URIish uri;
    private final boolean changeCredentials;
    private Text user;
    private Text password;
    private Button storeCheckbox;
    private UserPasswordCredentials credentials;
    private boolean storeInSecureStore;
    private boolean isUserSet;
    private String oldUser;

    LoginDialog(Shell shell, URIish uri) {
        this(shell, uri, false);
    }

    LoginDialog(Shell shell, URIish uri, boolean changeCrendentials) {
        super(shell);
        this.uri = uri;
        this.changeCredentials = changeCrendentials;
        this.isUserSet = uri.getUser() != null && !uri.getUser().isEmpty();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.getShell().setText(this.changeCredentials ? UIText.LoginDialog_changeCredentials : UIText.LoginDialog_login);
        Label uriLabel = new Label(composite, 0);
        uriLabel.setText(UIText.LoginDialog_repository);
        Text uriText = new Text(composite, 8);
        uriText.setText(this.uri.toString());
        Label userLabel = new Label(composite, 0);
        userLabel.setText(UIText.LoginDialog_user);
        if (this.isUserSet) {
            this.user = new Text(composite, 2056);
            this.user.setText(this.uri.getUser());
        } else {
            this.user = new Text(composite, 2048);
            if (this.oldUser != null) {
                this.user.setText(this.oldUser);
            }
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.user);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(UIText.LoginDialog_password);
        this.password = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.password);
        if (!this.changeCredentials) {
            Label storeLabel = new Label(composite, 0);
            storeLabel.setText(UIText.LoginDialog_storeInSecureStore);
            this.storeCheckbox = new Button(composite, 32);
            this.storeCheckbox.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("CloneWizard_StoreInSecureStore"));
        }
        if (this.isUserSet) {
            this.password.setFocus();
        } else {
            this.user.setFocus();
        }
        return composite;
    }

    UserPasswordCredentials getCredentials() {
        return this.credentials;
    }

    boolean getStoreInSecureStore() {
        return this.storeInSecureStore;
    }

    protected void okPressed() {
        if (this.user.getText().length() > 0) {
            this.credentials = new UserPasswordCredentials(this.user.getText(), this.password.getText());
            if (!this.changeCredentials) {
                this.storeInSecureStore = this.storeCheckbox.getSelection();
            }
        }
        super.okPressed();
    }

    public void setOldUser(String oldUser) {
        this.oldUser = oldUser;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.changeCredentials ? UIText.LoginDialog_ButtonSave : UIText.LoginDialog_ButtonLogin, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

