/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum N4Modifier implements Enumerator
{
    UNDEFINED(0, "undefined", "undefined"),
    EXTERNAL(1, "external", "external"),
    PRIVATE(11, "private", "private"),
    PROJECT(12, "project", "project"),
    PROTECTED(13, "protected", "protected"),
    PUBLIC(14, "public", "public"),
    ABSTRACT(21, "abstract", "abstract"),
    STATIC(22, "static", "static"),
    CONST(23, "const", "const");

    public static final int UNDEFINED_VALUE = 0;
    public static final int EXTERNAL_VALUE = 1;
    public static final int PRIVATE_VALUE = 11;
    public static final int PROJECT_VALUE = 12;
    public static final int PROTECTED_VALUE = 13;
    public static final int PUBLIC_VALUE = 14;
    public static final int ABSTRACT_VALUE = 21;
    public static final int STATIC_VALUE = 22;
    public static final int CONST_VALUE = 23;
    private static final N4Modifier[] VALUES_ARRAY;
    public static final List<N4Modifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new N4Modifier[]{UNDEFINED, EXTERNAL, PRIVATE, PROJECT, PROTECTED, PUBLIC, ABSTRACT, STATIC, CONST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static N4Modifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            N4Modifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static N4Modifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            N4Modifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static N4Modifier get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return EXTERNAL;
            }
            case 11: {
                return PRIVATE;
            }
            case 12: {
                return PROJECT;
            }
            case 13: {
                return PROTECTED;
            }
            case 14: {
                return PUBLIC;
            }
            case 21: {
                return ABSTRACT;
            }
            case 22: {
                return STATIC;
            }
            case 23: {
                return CONST;
            }
        }
        return null;
    }

    private N4Modifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

