/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.generator.GeneratorException;
import org.eclipse.n4js.generator.headless.MarkedProject;
import org.eclipse.n4js.generator.headless.N4JSCompileErrorException;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.xtext.validation.Issue;

public class N4ProgressStateRecorder {
    LinkedList<IProgressState> progressEntries = new LinkedList();
    private final long start = System.currentTimeMillis();
    private int indent = 0;

    public void dumpTo(StringBuffer sb) {
        for (IProgressState entry : this.progressEntries) {
            if (entry instanceof TimedState) {
                TimedState timedState = (TimedState)entry;
                sb.append(String.format("%10d - %s \n", timedState.time - this.start, ((IProgressState)timedState.data).getMessage()));
                continue;
            }
            sb.append("           - ").append(entry.getMessage());
        }
    }

    public void info(String msg) {
        this.add(new Info(String.valueOf(this.indentToString()) + msg));
    }

    private String indentToString() {
        return "                                                                                         ".substring(0, this.indent);
    }

    void increaseIndent() {
        this.indent += 2;
    }

    void decreaseIndent() {
        this.indent -= 2;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    private void add(IProgressState info) {
        this.progressEntries.add(new TimedState<IProgressState>(info));
    }

    public void markProcessing(IN4JSProject project) {
        this.info("processing " + project.getProjectName());
        this.increaseIndent();
    }

    public void markEndProcessing(IN4JSProject project) {
        this.decreaseIndent();
        this.info("processing of " + project.getProjectName() + " done ");
    }

    public void markStartLoading(MarkedProject markedProject) {
        this.info("start loading " + markedProject.project.getProjectName());
    }

    public void markFailedCreateResource(URI uri) {
        this.info("failed creating resource with uri=" + uri);
    }

    public void markLoadResourceFailed(Resource res) {
        this.info("loading of resource failed");
    }

    public void markResourceIssues(Resource resource, List<Issue> issues) {
        this.info("issues in resource r=" + resource.getURI() + " " + Joiner.on((String)", ").join(issues.stream().map(i -> i.getSeverity() + " " + i.getMessage() + " " + i.getLineNumber()).iterator()));
    }

    public void markStartCompiling(MarkedProject markedProject) {
        this.info("Project, compiling " + markedProject.project.getProjectName());
        this.increaseIndent();
    }

    public void markEndCompiling(MarkedProject markedProject) {
        this.decreaseIndent();
        this.info("Project, finished compiling of " + markedProject.project.getProjectName());
    }

    public void markStartCompile(Resource input) {
        this.info("about to compile " + input.getURI());
        this.increaseIndent();
    }

    public void markEndCompile(Resource input) {
        this.decreaseIndent();
        this.info("finished compiling " + input.getURI());
    }

    public void markBrokenCompile(GeneratorException e) {
        this.decreaseIndent();
        this.info("failed compiling: '" + e.getMessage() + "' line " + e.getLine() + " in " + e.getFile());
    }

    public void markSkippedCompile(Resource input) {
        this.info("skipped compiling of " + input.getURI());
    }

    public void markStartUnloading(MarkedProject markedProject) {
        this.info("about to unload " + markedProject.project.getProjectName());
        this.increaseIndent();
    }

    public void markFinishedUnloading(MarkedProject markedProject) {
        this.decreaseIndent();
        this.info("finished unloading of " + markedProject.project.getProjectName());
    }

    public void markUnloadingOf(Resource res) {
        this.info("unloading of resource " + res.getURI());
    }

    public void compileException(N4JSCompileErrorException e) {
        this.add(e);
    }

    public void dumpToLogfile(String logFile) {
        if (logFile == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        this.dumpTo(sb);
        try {
            Files.write(new File(logFile).toPath(), sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface IProgressState {
        public String getMessage();
    }

    public static class Info
    implements IProgressState {
        private final String msg;

        Info(String msg) {
            this.msg = msg;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }

    public static class TimedState<E extends IProgressState>
    implements IProgressState {
        long time = System.currentTimeMillis();
        E data;

        public TimedState(E data) {
            this.data = data;
        }

        @Override
        public String getMessage() {
            return this.data.getMessage();
        }
    }
}

