/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.xtext.builder.impl.ToBeBuilt;

@Singleton
public class ClosedProjectQueue {
    private final Deque<Task> internalQueue = new ConcurrentLinkedDeque<Task>();

    void enqueue(Set<String> projectNames, ToBeBuilt toBeBuilt) {
        this.internalQueue.addLast(new Task((Set)ImmutableSet.copyOf(projectNames), toBeBuilt));
    }

    void insert(Set<String> projectNames, ToBeBuilt toBeBuilt) {
        this.internalQueue.addFirst(new Task((Set)ImmutableSet.copyOf(projectNames), toBeBuilt));
    }

    Task exhaust() {
        LinkedHashSet<String> projectNames = new LinkedHashSet<String>();
        ToBeBuilt toBeBuilt = new ToBeBuilt();
        Task next = this.internalQueue.poll();
        while (next != null) {
            projectNames.addAll(next.projectNames);
            toBeBuilt.getToBeDeleted().addAll(next.toBeBuilt.getToBeDeleted());
            next = this.internalQueue.poll();
        }
        return new Task((Set)ImmutableSet.copyOf(projectNames), toBeBuilt);
    }

    class Task {
        public final Set<String> projectNames;
        public final ToBeBuilt toBeBuilt;

        private Task(Set<String> projectNames, ToBeBuilt toBeBuilt) {
            this.projectNames = projectNames;
            this.toBeBuilt = toBeBuilt;
        }

        public boolean isEmpty() {
            return this.toBeBuilt.getToBeDeleted().isEmpty();
        }

        public void reschedule() {
            ClosedProjectQueue.this.insert(this.projectNames, this.toBeBuilt);
        }
    }
}

