/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import java.util.List;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.graphics.Image;

public class WorkingSetLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelDecorator {
    public static WorkingSetLabelProvider INSTANCE = new WorkingSetLabelProvider();

    private WorkingSetLabelProvider() {
    }

    public Image getImage(Object element) {
        if (element instanceof WorkingSet) {
            return (Image)ImageDescriptorCache.ImageRef.WORKING_SET.asImage().orNull();
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof WorkingSet) {
            return ((WorkingSet)element).getName();
        }
        return super.getText(element);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof WorkingSet) {
            List allNames;
            WorkingSet workingSet = (WorkingSet)element;
            WorkingSetManager manager = workingSet.getWorkingSetManager();
            String name = workingSet.getName();
            if (this.containsDuplicates(name, allNames = Arrays2.transform((Object[])manager.getAllWorkingSets(), ws -> ws.getName()))) {
                String suffix = " [" + workingSet.getId() + "]";
                StyledString string = new StyledString(name);
                string.append(suffix, StyledString.COUNTER_STYLER);
                return string;
            }
        }
        return new StyledString(this.getText(element));
    }

    private boolean containsDuplicates(String toCheck, Iterable<String> elements) {
        int counter = 0;
        for (String element : elements) {
            if (counter > 1) {
                return true;
            }
            if (!toCheck.equals(element)) continue;
            ++counter;
        }
        return false;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }
}

