/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.transform.SuperLiteralTransformation;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ClassConstructorAssistant
extends TransformationAssistant {
    @Inject
    private TypeAssistant typeAssistant;

    public FunctionDeclaration createCtorDecl(N4ClassDeclaration classDecl, SymbolTableEntryOriginal superClassSTE) {
        boolean hasExplicitSuperCall;
        TObjectPrototype _errorType;
        FunctionDeclaration funDecl = TranspilerBuilderBlocks._FunDecl((String)classDecl.getName(), (Statement[])new Statement[0]);
        N4MethodDeclaration ownedCtor = classDecl.getOwnedCtor();
        if (ownedCtor != null) {
            EList _fpars = funDecl.getFpars();
            EList _fpars_1 = ownedCtor.getFpars();
            Iterables.addAll((Collection)_fpars, (Iterable)_fpars_1);
        } else {
            TMethod templateCtor = this.getNearestConstructorInHierarchy(classDecl);
            if (templateCtor != null) {
                EList _fpars_2 = funDecl.getFpars();
                Functions.Function1 _function = it -> {
                    FormalParameter _xblockexpression = null;
                    TypeRef typeRefIM = (TypeRef)this.copyAlienElement((EObject)it.getTypeRef());
                    _xblockexpression = TranspilerBuilderBlocks._Fpar((String)it.getName(), (boolean)it.isVariadic(), (TypeRef)typeRefIM, (boolean)AnnotationDefinition.SPEC.hasAnnotation((TAnnotableElement)it));
                    return _xblockexpression;
                };
                List _map = ListExtensions.map((List)templateCtor.getFpars(), (Functions.Function1)_function);
                Iterables.addAll((Collection)_fpars_2, (Iterable)_map);
            }
        }
        Functions.Function1 _function_1 = it -> AnnotationDefinition.SPEC.hasAnnotation((AnnotableElement)it);
        FormalParameter specFpar = (FormalParameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)funDecl.getFpars(), (Functions.Function1)_function_1));
        Block body = TranspilerBuilderBlocks._Block((Statement[])new Statement[0]);
        funDecl.setBody(body);
        IdentifiableElement _originalTarget = null;
        if (superClassSTE != null) {
            _originalTarget = superClassSTE.getOriginalTarget();
        }
        boolean isDirectSubclassOfError = _originalTarget == (_errorType = RuleEnvironmentExtensions.errorType((RuleEnvironment)this.getState().G));
        Block _body = null;
        if (ownedCtor != null) {
            _body = ownedCtor.getBody();
        }
        boolean hasExplicitCtor = _body != null;
        int _xifexpression = 0;
        _xifexpression = hasExplicitCtor ? this.getSuperCallIndex(ownedCtor) : -1;
        int superCallIndex = _xifexpression;
        Statement _xifexpression_1 = null;
        if (superCallIndex >= 0) {
            _xifexpression_1 = (Statement)ownedCtor.getBody().getStatements().get(superCallIndex);
        }
        Statement explicitSuperCall = _xifexpression_1;
        boolean bl = hasExplicitSuperCall = superCallIndex >= 0;
        if (hasExplicitSuperCall) {
            EList _statements = body.getStatements();
            List _subList = ownedCtor.getBody().getStatements().subList(0, superCallIndex);
            Iterables.addAll((Collection)_statements, (Iterable)_subList);
        }
        if (isDirectSubclassOfError) {
            EList _statements_1 = body.getStatements();
            Statement[] _createSubclassingErrorOddities = this.createSubclassingErrorOddities(classDecl, (FormalParameter[])Conversions.unwrapArray((Object)funDecl.getFpars(), FormalParameter.class), explicitSuperCall);
            Iterables.addAll((Collection)_statements_1, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createSubclassingErrorOddities)));
            if (hasExplicitSuperCall) {
                ownedCtor.getBody().getStatements().remove(0);
            }
        } else if (hasExplicitSuperCall) {
            EList _statements_2 = body.getStatements();
            Statement _head = (Statement)IterableExtensions.head((Iterable)ownedCtor.getBody().getStatements());
            _statements_2.add((Object)_head);
        } else {
            boolean _tripleNotEquals;
            ParameterizedTypeRef _superClassRef = classDecl.getSuperClassRef();
            boolean bl2 = _tripleNotEquals = _superClassRef != null;
            if (_tripleNotEquals) {
                EList _statements_3 = body.getStatements();
                ExpressionStatement _createDefaultSuperCall = this.createDefaultSuperCall(classDecl, (SymbolTableEntry)superClassSTE, (FormalParameter[])Conversions.unwrapArray((Object)funDecl.getFpars(), FormalParameter.class));
                _statements_3.add((Object)_createDefaultSuperCall);
            }
        }
        EList _statements_4 = body.getStatements();
        Statement[] _createFieldInitCode = this.createFieldInitCode(classDecl, specFpar);
        Iterables.addAll((Collection)_statements_4, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createFieldInitCode)));
        EList _statements_5 = body.getStatements();
        Statement[] _createDelegationToFieldInitOfImplementedInterfaces = this.createDelegationToFieldInitOfImplementedInterfaces(classDecl, specFpar);
        Iterables.addAll((Collection)_statements_5, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createDelegationToFieldInitOfImplementedInterfaces)));
        if (hasExplicitCtor) {
            EList _statements_6 = body.getStatements();
            EList _statements_7 = ownedCtor.getBody().getStatements();
            Iterables.addAll((Collection)_statements_6, (Iterable)_statements_7);
        }
        return funDecl;
    }

    private Statement[] createFieldInitCode(N4ClassDeclaration classDecl, FormalParameter specFpar) {
        Functions.Function1 _function = it -> !it.isStatic() && !this.isConsumedFromInterface((N4MemberDeclaration)it);
        List allFields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedFields(), (Functions.Function1)_function));
        if (specFpar != null) {
            SymbolTableEntry specFparSTE = this.findSymbolTableEntryForElement((NamedElement)specFpar, true);
            EList structFields = specFpar.getDeclaredTypeRef().getStructuralMembers();
            ArrayList result = CollectionLiterals.newArrayList();
            for (N4FieldDeclaration field : allFields) {
                boolean isSpecced;
                boolean bl = isSpecced = this.isPublic((N4MemberDeclaration)field) || IterableExtensions.exists((Iterable)structFields, it -> {
                    String _name = it.getName();
                    String _name_1 = field.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                });
                if (isSpecced) {
                    Statement _createFieldInitCodeForSingleSpeccedField = this.createFieldInitCodeForSingleSpeccedField(field, specFparSTE);
                    result.add(_createFieldInitCodeForSingleSpeccedField);
                    continue;
                }
                Statement _createFieldInitCodeForSingleField = this.createFieldInitCodeForSingleField(field);
                result.add(_createFieldInitCodeForSingleField);
            }
            Functions.Function1 _function_1 = it -> !it.isStatic() && it.getDeclaredModifiers().contains((Object)N4Modifier.PUBLIC);
            List speccedSetters = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedSetters(), (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = it -> this.createFieldInitCodeForSingleSpeccedSetter((N4SetterDeclaration)it, specFparSTE);
            IfStatement __IfStmnt = TranspilerBuilderBlocks._IfStmnt((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specFparSTE), (Statement)TranspilerBuilderBlocks._Block((Statement[])((Statement[])Conversions.unwrapArray((Object)ListExtensions.map((List)speccedSetters, (Functions.Function1)_function_2), Statement.class))));
            result.add(__IfStmnt);
            return (Statement[])Conversions.unwrapArray((Object)result, Statement.class);
        }
        Functions.Function1 _function_3 = it -> this.createFieldInitCodeForSingleField((N4FieldDeclaration)it);
        return (Statement[])Conversions.unwrapArray((Object)ListExtensions.map((List)allFields, (Functions.Function1)_function_3), Statement.class);
    }

    private Statement createFieldInitCodeForSingleField(N4FieldDeclaration fieldDecl) {
        SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement((NamedElement)fieldDecl, true);
        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE});
        Object _xifexpression = null;
        Expression _expression = fieldDecl.getExpression();
        boolean _tripleNotEquals = _expression != null;
        _xifexpression = _tripleNotEquals ? fieldDecl.getExpression() : this.undefinedRef();
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)__PropertyAccessExpr, (Expression)_xifexpression));
    }

    private Statement createFieldInitCodeForSingleSpeccedField(N4FieldDeclaration fieldDecl, SymbolTableEntry specFparSTE) {
        SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement((NamedElement)fieldDecl, true);
        BinaryLogicalExpression __AND = TranspilerBuilderBlocks._AND((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specFparSTE), (Expression)TranspilerBuilderBlocks._RelationalExpr((Expression)TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)fieldSTE), (RelationalOperator)RelationalOperator.IN, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specFparSTE)));
        ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)specFparSTE, (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE});
        Object _xifexpression = null;
        Expression _expression = fieldDecl.getExpression();
        boolean _tripleNotEquals = _expression != null;
        _xifexpression = _tripleNotEquals ? (Expression)this.copy((EObject)fieldDecl.getExpression()) : this.undefinedRef();
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}), (Expression)TranspilerBuilderBlocks._ConditionalExpr((Expression)__AND, (Expression)__PropertyAccessExpr, (Expression)_xifexpression)));
    }

    private Statement createFieldInitCodeForSingleSpeccedSetter(N4SetterDeclaration setterDecl, SymbolTableEntry specFparSTE) {
        SymbolTableEntry setterSTE = this.findSymbolTableEntryForElement((NamedElement)setterDecl, true);
        return TranspilerBuilderBlocks._IfStmnt((Expression)TranspilerBuilderBlocks._RelationalExpr((Expression)TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)setterSTE), (RelationalOperator)RelationalOperator.IN, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specFparSTE)), (Statement)TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ThisLiteral(), (SymbolTableEntry[])new SymbolTableEntry[]{setterSTE}), (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)specFparSTE, (SymbolTableEntry[])new SymbolTableEntry[]{setterSTE}))));
    }

    private ExpressionStatement createDefaultSuperCall(N4ClassDeclaration classDecl, SymbolTableEntry superClassSTE, FormalParameter[] fpars) {
        boolean variadicCase = !((List)Conversions.doWrapArray((Object)fpars)).isEmpty() && ((FormalParameter)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)fpars)))).isVariadic();
        String _xifexpression = null;
        _xifexpression = variadicCase ? "apply" : "call";
        String genericMethodName = _xifexpression;
        SymbolTableEntryOriginal prototypeSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "prototype", false, true, true);
        SymbolTableEntryOriginal constructorSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "constructor", false, false, true);
        SymbolTableEntryOriginal genericCallSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.functionType((RuleEnvironment)this.getState().G), genericMethodName, false, false, true);
        ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
        Procedures.Procedure1 _function = it -> {
            it.setTarget((Expression)this.__NSSafe_PropertyAccessExpr(superClassSTE, new SymbolTableEntry[]{prototypeSTE, constructorSTE, genericCallSTE}));
            EList _arguments = it.getArguments();
            Argument __Argument = TranspilerBuilderBlocks._Argument((Expression)TranspilerBuilderBlocks._ThisLiteral());
            _arguments.add((Object)__Argument);
            if (variadicCase) {
                SymbolTableEntryOriginal concatSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.arrayType((RuleEnvironment)this.getState().G), "concat", false, false, true);
                EList _arguments_1 = it.getArguments();
                int _size = ((List)Conversions.doWrapArray((Object)fpars)).size();
                int _minus = _size - 1;
                Functions.Function1 _function_1 = it_1 -> this.findSymbolTableEntryForElement((NamedElement)it_1, true);
                Functions.Function1 _function_2 = it_1 -> TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)it_1);
                Argument __Argument_1 = TranspilerBuilderBlocks._Argument((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._ArrLit((Expression[])((Expression[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.take((Iterable)((Iterable)Conversions.doWrapArray((Object)fpars)), (int)_minus), (Functions.Function1)_function_1), (Functions.Function1)_function_2), Expression.class))), (SymbolTableEntry[])new SymbolTableEntry[]{concatSTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)this.findSymbolTableEntryForElement((NamedElement)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)fpars))), true))}));
                _arguments_1.add((Object)__Argument_1);
            } else {
                EList _arguments_2 = it.getArguments();
                Functions.Function1 _function_3 = it_1 -> this.findSymbolTableEntryForElement((NamedElement)it_1, true);
                Functions.Function1 _function_4 = it_1 -> TranspilerBuilderBlocks._Argument((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)it_1));
                List _map = ListExtensions.map((List)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)fpars)), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
                Iterables.addAll((Collection)_arguments_2, (Iterable)_map);
            }
        };
        ParameterizedCallExpression _doubleArrow = (ParameterizedCallExpression)ObjectExtensions.operator_doubleArrow((Object)__CallExpr, (Procedures.Procedure1)_function);
        return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
    }

    private Statement[] createSubclassingErrorOddities(N4ClassDeclaration classDecl, FormalParameter[] fpars, Statement explicitSuperCall) {
        SymbolTableEntryOriginal ErrorSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.errorType((RuleEnvironment)this.getState().G), true);
        IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)ErrorSTE);
        Expression[] _xifexpression = null;
        if (explicitSuperCall != null) {
            _xifexpression = SuperLiteralTransformation.getArgumentsFromExplicitSuperCall(explicitSuperCall);
        } else {
            Functions.Function1 _function = it -> this.findSymbolTableEntryForElement((NamedElement)it, true);
            Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)it);
            _xifexpression = (Expression[])Conversions.unwrapArray((Object)ListExtensions.map((List)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)fpars)), (Functions.Function1)_function), (Functions.Function1)_function_1), Expression.class);
        }
        VariableStatement firstLine = TranspilerBuilderBlocks._VariableStatement((VariableDeclaration[])new VariableDeclaration[]{TranspilerBuilderBlocks._VariableDeclaration((String)"err", (Expression)TranspilerBuilderBlocks._NewExpr((Expression)__IdentRef, (Expression[])_xifexpression))});
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("this.message = err.message;");
        _builder.newLine();
        _builder.append("this.name = this.constructor.n4type.name;");
        _builder.newLine();
        _builder.append("Object.defineProperty(this, 'stack', { get: function() { return err.stack; }, set: function(value) { err.stack = value; } });");
        _builder.newLine();
        ExpressionStatement remainingLines = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._Snippet((String)_builder.toString()));
        return new Statement[]{firstLine, remainingLines};
    }

    private Statement[] createDelegationToFieldInitOfImplementedInterfaces(N4ClassDeclaration classDecl, FormalParameter specFpar) {
        Functions.Function0 _function_8;
        Functions.Function0 _function_7;
        ArrayList result = CollectionLiterals.newArrayList();
        SymbolTableEntryInternal $fieldInitSTE = this.steFor_$fieldInit();
        Functions.Function1 _function = it -> {
            IdentifiableElement _originalTarget = it.getOriginalTarget();
            boolean _builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation = N4JSLanguageUtils.builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation((TInterface)((TInterface)_originalTarget));
            return !_builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation;
        };
        Iterable implementedIfcSTEs = IterableExtensions.filter((Iterable)this.typeAssistant.getSuperInterfacesSTEs((N4ClassifierDeclaration)classDecl), (Functions.Function1)_function);
        LinkedHashSet ownedInstanceDataFieldsSupressMixin = CollectionLiterals.newLinkedHashSet();
        Functions.Function1 _function_1 = it -> {
            boolean _isConsumedFromInterface = this.isConsumedFromInterface((N4MemberDeclaration)it);
            return !_isConsumedFromInterface;
        };
        Functions.Function1 _function_2 = it -> it.getName();
        Iterables.addAll((Collection)ownedInstanceDataFieldsSupressMixin, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedFields(), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> {
            boolean _isConsumedFromInterface = this.isConsumedFromInterface((N4MemberDeclaration)it);
            return !_isConsumedFromInterface;
        };
        Functions.Function1 _function_4 = it -> it.getName();
        Iterables.addAll((Collection)ownedInstanceDataFieldsSupressMixin, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedGetters(), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        Functions.Function1 _function_5 = it -> {
            boolean _isConsumedFromInterface = this.isConsumedFromInterface((N4MemberDeclaration)it);
            return !_isConsumedFromInterface;
        };
        Functions.Function1 _function_6 = it -> it.getName();
        Iterables.addAll((Collection)ownedInstanceDataFieldsSupressMixin, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)classDecl.getOwnedSetters(), (Functions.Function1)_function_5), (Functions.Function1)_function_6));
        SymbolTableEntry _xifexpression = null;
        if (specFpar != null) {
            _xifexpression = this.findSymbolTableEntryForElement((NamedElement)specFpar, false);
        }
        SymbolTableEntry specFparSTE = _xifexpression;
        Functions.Function0 _xifexpression_1 = null;
        _xifexpression_1 = specFpar == null ? (_function_7 = () -> this.undefinedRef()) : (_function_8 = () -> TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)specFparSTE));
        Functions.Function0 refTo_specFpar_or_undefined = _xifexpression_1;
        for (SymbolTableEntryOriginal implementedIfcSTE : implementedIfcSTEs) {
            Functions.Function1 _function_9 = it -> TranspilerBuilderBlocks._PropertyNameValuePair((String)it, (Expression)this.undefinedRef());
            ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)implementedIfcSTE, new SymbolTableEntry[]{$fieldInitSTE, this.steFor_call()}), (Expression[])new Expression[]{TranspilerBuilderBlocks._ThisLiteral(), (Expression)refTo_specFpar_or_undefined.apply(), TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)ownedInstanceDataFieldsSupressMixin, (Functions.Function1)_function_9), PropertyAssignment.class)))}));
            result.add(__ExprStmnt);
        }
        return (Statement[])Conversions.unwrapArray((Object)result, Statement.class);
    }

    private int getSuperCallIndex(N4MethodDeclaration ownedCtor) {
        EList stmnts;
        Block _body = null;
        if (ownedCtor != null) {
            _body = ownedCtor.getBody();
        }
        EList _statements = null;
        if (_body != null) {
            _statements = _body.getStatements();
        }
        if ((stmnts = _statements) != null && !stmnts.isEmpty()) {
            int _size = ownedCtor.getBody().getStatements().size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            for (Integer i : _doubleDotLessThan) {
                boolean _isExplicitSuperCall;
                Expression expr;
                Statement stmnt = (Statement)stmnts.get(i.intValue());
                if (!(stmnt instanceof ExpressionStatement) || !((expr = ((ExpressionStatement)stmnt).getExpression()) instanceof ParameterizedCallExpression) || !(_isExplicitSuperCall = this.getState().info.isExplicitSuperCall((ParameterizedCallExpression)expr))) continue;
                return i;
            }
        }
        return -1;
    }

    private TMethod getNearestConstructorInHierarchy(N4ClassDeclaration classDecl) {
        TClass tClass = this.getState().info.getOriginalDefinedType(classDecl);
        return this.getNearestConstructorInHierarchy((TClassifier)tClass);
    }

    private TMethod getNearestConstructorInHierarchy(TClassifier clazz) {
        TMethod _xifexpression = null;
        if (clazz instanceof TClass) {
            _xifexpression = ((TClass)clazz).getOwnedCtor();
        } else {
            TMethod _xifexpression_1 = null;
            if (clazz instanceof TObjectPrototype) {
                _xifexpression_1 = ((TObjectPrototype)clazz).getOwnedCtor();
            }
            _xifexpression = _xifexpression_1;
        }
        TMethod ownedCtor = _xifexpression;
        if (ownedCtor != null) {
            return ownedCtor;
        }
        Type _xifexpression_2 = null;
        if (clazz instanceof TClass) {
            ParameterizedTypeRef _superClassRef = ((TClass)clazz).getSuperClassRef();
            Type _declaredType = null;
            if (_superClassRef != null) {
                _declaredType = _superClassRef.getDeclaredType();
            }
            _xifexpression_2 = _declaredType;
        } else {
            Type _xifexpression_3 = null;
            if (clazz instanceof TObjectPrototype) {
                ParameterizedTypeRef _superType = ((TObjectPrototype)clazz).getSuperType();
                Type _declaredType_1 = null;
                if (_superType != null) {
                    _declaredType_1 = _superType.getDeclaredType();
                }
                _xifexpression_3 = _declaredType_1;
            }
            _xifexpression_2 = _xifexpression_3;
        }
        Type superType = _xifexpression_2;
        if (superType instanceof TClassifier) {
            return this.getNearestConstructorInHierarchy((TClassifier)superType);
        }
        return null;
    }

    private boolean isConsumedFromInterface(N4MemberDeclaration memberDecl) {
        return this.getState().info.isConsumedFromInterface(memberDecl);
    }

    private boolean isPublic(N4MemberDeclaration memberDecl) {
        MemberAccessModifier accessModifier = ModifierUtils.convertToMemberAccessModifier((Collection)memberDecl.getDeclaredModifiers(), (List)memberDecl.getAnnotations());
        return accessModifier == MemberAccessModifier.PUBLIC;
    }
}

