/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.command;

import com.google.inject.Inject;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.n4js.smith.ui.ResourceLoadingStatistics;
import org.eclipse.n4js.ui.utils.EclipseUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class ResourceLoadStatsHandler
implements IHandler {
    @Inject
    private ResourceLoadingStatistics resourceLoadingStatistics;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Mode mode = this.getModeFromParameters(event.getParameters());
        switch (mode) {
            case Workspace: {
                this.executeForWorkspace();
                break;
            }
            case Editor: {
                this.executeForActiveEditor();
            }
        }
        return null;
    }

    private void executeForWorkspace() {
        EclipseUtils.runInModalDialog((OperationCanceledManager)this.operationCanceledManager, monitor -> this.resourceLoadingStatistics.computeAndShowStatsForWorkspace(this.getConsolePrintStream(), monitor));
    }

    private void executeForActiveEditor() {
        XtextEditor xeddy;
        IEditorPart eddy = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        XtextEditor xtextEditor = xeddy = eddy instanceof XtextEditor ? (XtextEditor)eddy : null;
        if (xeddy != null) {
            xeddy.getDocument().readOnly(resource -> {
                this.resourceLoadingStatistics.computeAndShowStatsForResourceSet(resource.getResourceSet(), this.getConsolePrintStream());
                return null;
            });
        } else {
            this.getConsolePrintStream().println("No active N4JS editor found.");
        }
    }

    private Mode getModeFromParameters(Map<?, ?> parameters) {
        for (Map.Entry<?, ?> entry : parameters.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !((String)key).endsWith(".scope")) continue;
            if ("workspace".equals(value)) {
                return Mode.Workspace;
            }
            if (!"editor".equals(value)) continue;
            return Mode.Editor;
        }
        return Mode.Editor;
    }

    private PrintStream getConsolePrintStream() {
        MessageConsole console = EclipseUtils.getOrCreateConsole((String)"Resource Loading Statistics", (boolean)true, (boolean)true);
        PrintStream out = new PrintStream((OutputStream)console.newMessageStream());
        return out;
    }

    private static enum Mode {
        Workspace,
        Editor;

    }
}

