/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.external.ComputeProjectOrder;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.utils.URIUtils;

public class BuildOrderComputer {
    @Inject
    private IN4JSCore core;
    private final UriToProjectMapper uri2PrjMapper = new UriToProjectMapper();

    public ComputeProjectOrder.VertexOrder<IN4JSProject> getBuildOrder(N4JSExternalProject[] projects) {
        N4JSProject[] n4jsPrjs = new N4JSProject[projects.length];
        int i = 0;
        while (i < projects.length) {
            N4JSExternalProject project = projects[i];
            URI locationURI = URIUtils.convert((IResource)project);
            n4jsPrjs[i] = (N4JSProject)this.uri2PrjMapper.get(locationURI.toString());
            ++i;
        }
        return this.getBuildOrder(n4jsPrjs);
    }

    public ComputeProjectOrder.VertexOrder<IN4JSProject> getBuildOrder(N4JSProject[] requestedProjects) {
        String[] requestedProjectURIs = new String[requestedProjects.length];
        int i = 0;
        while (i < requestedProjectURIs.length) {
            requestedProjectURIs[i] = requestedProjects[i].getLocation().toString();
            ++i;
        }
        ComputeProjectOrder.VertexOrder<String> completeOrder = this.getBuildOrderOfURIs(requestedProjectURIs);
        ComputeProjectOrder.VertexOrder<IN4JSProject> requestedOrder = ComputeProjectOrder.mapVertexOrder(completeOrder, this.uri2PrjMapper);
        return requestedOrder;
    }

    private ComputeProjectOrder.VertexOrder<String> getBuildOrderOfURIs(String[] requestedProjectURIs) {
        FilterUnreqestedOut filter = new FilterUnreqestedOut(requestedProjectURIs);
        ComputeProjectOrder.VertexOrder<String> completeOrder = this.computeVertexOrder(requestedProjectURIs);
        ComputeProjectOrder.VertexOrder<String> requestedOrder = ComputeProjectOrder.filterVertexOrder(completeOrder, filter);
        return requestedOrder;
    }

    private ComputeProjectOrder.VertexOrder<String> computeVertexOrder(String[] requestedProjectURIs) {
        TreeSet<String> worklist = new TreeSet<String>();
        String[] stringArray = requestedProjectURIs;
        int n = requestedProjectURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String projectURI = stringArray[n2];
            IN4JSProject project = this.uri2PrjMapper.get(projectURI);
            if (project != null && project.exists()) {
                worklist.add(projectURI);
            }
            ++n2;
        }
        HashMultimap edges = HashMultimap.create();
        TreeSet<String> projectsClosure = new TreeSet<String>();
        while (!worklist.isEmpty()) {
            String projectURI = (String)worklist.pollFirst();
            projectsClosure.add(projectURI);
            IN4JSProject project = this.uri2PrjMapper.get(projectURI);
            Set<N4JSProject> prjDependencies = this.getDependencies(project);
            HashSet<String> prjDependencyURIs = new HashSet<String>();
            Iterator iterator = prjDependencies.iterator();
            while (iterator.hasNext()) {
                N4JSProject prjDependency = (N4JSProject)iterator.next();
                String depURI = prjDependency.getLocation().toString();
                edges.put((Object)projectURI, (Object)depURI);
                prjDependencyURIs.add(depURI);
            }
            prjDependencyURIs.removeAll(projectsClosure);
            worklist.addAll(prjDependencyURIs);
        }
        ArrayList<String[]> edges2 = new ArrayList<String[]>();
        for (Map.Entry dependency : edges.entries()) {
            String prj = (String)dependency.getKey();
            String depOn = (String)dependency.getValue();
            edges2.add(new String[]{prj, depOn});
        }
        ComputeProjectOrder.VertexOrder<Object> orderedObjects = ComputeProjectOrder.computeVertexOrder(projectsClosure, edges2);
        ComputeProjectOrder.VertexOrder<String> orderedURIs = ComputeProjectOrder.castVertexOrder(orderedObjects, String.class);
        return orderedURIs;
    }

    private Set<N4JSProject> getDependencies(IN4JSProject project) {
        HashSet<N4JSProject> prjDependencies = new HashSet<N4JSProject>();
        ImmutableList deps = project.getAllDirectDependencies();
        for (IN4JSProject dep : deps) {
            IN4JSProject pDep = (IN4JSProject)this.core.findProject(dep.getLocation()).orNull();
            boolean isValidDep = true;
            isValidDep &= pDep != null && pDep.exists();
            if (!(isValidDep &= !(pDep instanceof N4JSEclipseProject) || ((N4JSEclipseProject)pDep).getProject().isOpen())) continue;
            prjDependencies.add((N4JSProject)pDep);
        }
        return prjDependencies;
    }

    private static class FilterUnreqestedOut
    implements ComputeProjectOrder.VertexFilter<String> {
        private final Set<String> requestedProjectNames;

        FilterUnreqestedOut(String[] requestedProjectNames) {
            this.requestedProjectNames = new HashSet<String>(Arrays.asList(requestedProjectNames));
        }

        @Override
        public boolean matches(String vertex) {
            boolean filterOut = !this.requestedProjectNames.contains(vertex);
            return filterOut;
        }
    }

    private class UriToProjectMapper
    implements ComputeProjectOrder.VertexMapper<String, IN4JSProject> {
        private UriToProjectMapper() {
        }

        @Override
        public IN4JSProject get(String projectURI) {
            URI uri = URI.createURI((String)projectURI);
            IN4JSProject project = (IN4JSProject)BuildOrderComputer.this.core.findProject(uri).orNull();
            return project;
        }

        @Override
        public Class<IN4JSProject> getTargetClass() {
            return IN4JSProject.class;
        }
    }
}

