/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property;

import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;

public abstract class NativePropertyListener<S, D extends IDiff>
implements INativePropertyListener<S> {
    private final IProperty property;
    private final ISimplePropertyListener<S, D> listener;

    public NativePropertyListener(IProperty property, ISimplePropertyListener<S, D> listener) {
        this.property = property;
        this.listener = listener;
    }

    @Override
    public final void addTo(S source) {
        if (source != null) {
            this.doAddTo(source);
        }
    }

    protected abstract void doAddTo(S var1);

    @Override
    public final void removeFrom(S source) {
        if (source != null) {
            this.doRemoveFrom(source);
        }
    }

    protected abstract void doRemoveFrom(S var1);

    protected void fireChange(S source, D diff) {
        this.listener.handleEvent(new SimplePropertyEvent<S, D>(SimplePropertyEvent.CHANGE, source, this.property, diff));
    }

    protected void fireStale(S source) {
        this.listener.handleEvent(new SimplePropertyEvent<S, Object>(SimplePropertyEvent.STALE, source, this.property, null));
    }
}

