/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.MissingContentManager;
import org.eclipse.help.internal.base.remote.RemoteStatusData;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.View;
import org.eclipse.help.webapp.AbstractView;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class LayoutData
extends RequestData {
    private static final String VIEW_EXTENSION_POINT = "org.eclipse.help.webapp.view";
    private String query = "";
    private AbstractView[] views;

    public LayoutData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        String qs = request.getQueryString();
        if (qs != null && qs.length() > 0) {
            this.query = "?" + qs;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getBannerURL() {
        String banner = this.preferences.getBanner();
        if (banner == null || banner.trim().length() == 0) {
            banner = "about:blank";
        } else if (!banner.startsWith("http:/") && !banner.startsWith("https:/")) {
            banner = banner.startsWith("file:/") || banner.startsWith("jar:file:/") ? "topic/" + banner : "topic" + banner;
        }
        return banner;
    }

    public String getBannerHeight() {
        String height = this.preferences.getBannerHeight();
        if (height == null || height.length() == 0) {
            height = "0";
        }
        return height;
    }

    public String getFooterURL() {
        String footer = this.preferences.getFooter();
        if (footer == null || footer.trim().length() == 0) {
            footer = "about:blank";
        } else if (!footer.startsWith("http:/") && !footer.startsWith("https:/")) {
            footer = footer.startsWith("file:/") || footer.startsWith("jar:file:/") ? "topic/" + footer : "topic" + footer;
        }
        return footer;
    }

    public String getFooterHeight() {
        String height = this.preferences.getFooterHeight();
        if (height == null || height.length() == 0) {
            height = "0";
        }
        return height;
    }

    public String getFooterRowText() {
        String height = this.getFooterHeight();
        if ("0".equals(height)) {
            return "";
        }
        return "," + height;
    }

    public String getContentURL() {
        String navHref = this.request.getParameter("nav");
        if (navHref != null) {
            return "../nav" + navHref;
        }
        String topicHref = this.request.getParameter("topic");
        if (topicHref == null || topicHref.length() == 0) {
            String helpMissingPage;
            if (BaseHelpSystem.getMode() != 1 && RemoteStatusData.isAnyRemoteHelpUnavailable()) {
                return "../topic/org.eclipse.help.webapp/NetworkHelpStatus.html";
            }
            if (MissingContentManager.getInstance().isUnresolvedPlaceholders() && (helpMissingPage = MissingContentManager.getInstance().getHelpMissingPage(false)) != null) {
                return "../topic" + helpMissingPage;
            }
            return UrlUtil.getHelpURL(this.preferences.getHelpHome());
        }
        TocData tocData = new TocData(this.context, this.request, this.response);
        String topic = tocData.getSelectedTopicWithPath();
        if (topic == null || !UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay(topic)) {
            return UrlUtil.getHelpURL(this.preferences.getHelpHome());
        }
        return topic;
    }

    public AbstractView[] getViews() {
        IConfigurationElement[] elements;
        if (this.views != null) {
            return this.views;
        }
        View tocview = new View("toc", "", String.valueOf(this.preferences.getImagesDirectory()) + "/contents_view.gif", 'C', !HelpPlugin.getTocManager().isTocLoaded(this.getLocale()));
        View indexview = null;
        View searchview = new View("search", "", String.valueOf(this.preferences.getImagesDirectory()) + "/search_results_view.gif", 'R', false);
        View bookmarksview = null;
        if (this.preferences.isIndexView()) {
            indexview = new View("index", "", String.valueOf(this.preferences.getImagesDirectory()) + "/index_view.gif", 'I', false);
        }
        if (this.preferences.isBookmarksView()) {
            bookmarksview = new View("bookmarks", "", String.valueOf(this.preferences.getImagesDirectory()) + "/bookmarks_view.gif", '\u0000', false);
        }
        ArrayList<AbstractView> viewList = new ArrayList<AbstractView>();
        viewList.add(tocview);
        if (indexview != null) {
            viewList.add(indexview);
        }
        viewList.add(searchview);
        if (bookmarksview != null) {
            viewList.add(bookmarksview);
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(VIEW_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Object obj = null;
            try {
                obj = element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                HelpWebappPlugin.logError("Create extension failed:[org.eclipse.help.webapp.view].", e);
            }
            if (obj instanceof AbstractView) {
                viewList.add((AbstractView)obj);
            }
            ++n2;
        }
        this.views = viewList.toArray(new AbstractView[viewList.size()]);
        return this.views;
    }

    public String getVisibleView() {
        AbstractView[] allViews;
        String requestedView = this.request.getParameter("tab");
        AbstractView[] abstractViewArray = allViews = this.getViews();
        int n = allViews.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractView allView = abstractViewArray[n2];
            if (allView.getName().equals(requestedView)) {
                return requestedView;
            }
            ++n2;
        }
        return "toc";
    }

    public AbstractView getCurrentView() {
        String name = this.request.getParameter("view");
        AbstractView[] abstractViewArray = this.views = this.getViews();
        int n = this.views.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractView view = abstractViewArray[n2];
            if (view.getName().equals(name)) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    public String getWindowTitle() {
        String titlePref = this.preferences.getTitleResource();
        int slash = titlePref.indexOf(47);
        if (slash > 0) {
            String resourceContainer = titlePref.substring(0, slash);
            String resource = titlePref.substring(slash + 1);
            try {
                Bundle bundle = Platform.getBundle((String)resourceContainer);
                BundleContext bundleContext = HelpWebappPlugin.getContext();
                ServiceReference ref = bundleContext.getServiceReference(BundleLocalization.class.getName());
                BundleLocalization localization = (BundleLocalization)bundleContext.getService(ref);
                return localization.getLocalization(bundle, this.locale).getString(resource);
            }
            catch (Exception exception) {}
        }
        if (this.preferences.isWindowTitlePrefix()) {
            return ServletResources.getString("browserTitle", BaseHelpSystem.getProductName(), this.request);
        }
        return BaseHelpSystem.getProductName();
    }

    public String getAdvancedURL(AbstractView view, String fileSuffix) {
        return this.createURL(view.getURL(), view.getName(), fileSuffix);
    }

    public String getBasicURL(AbstractView view, String fileSuffix) {
        return this.createURL(view.getBasicURL(), view.getName(), fileSuffix);
    }

    private String createURL(String path, String viewName, String fileSuffix) {
        if (path == null || path.length() == 0) {
            return String.valueOf(viewName) + fileSuffix;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = String.valueOf(path) + '/';
        }
        return String.valueOf(this.request.getContextPath()) + path + viewName + fileSuffix;
    }

    public String getImageURL(AbstractView view) {
        String filename = view.getImageURL();
        if (filename.length() != 0 && filename.charAt(0) == '/') {
            return String.valueOf(this.request.getContextPath()) + filename;
        }
        return filename;
    }

    public String getTitle(AbstractView view) {
        return view.getTitle(UrlUtil.getLocaleObj(this.request, null));
    }
}

