/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.n4js.ui.utils.AutobuildUtils;
import org.eclipse.n4js.ui.utils.TimeoutRuntimeException;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;

public class EclipseUIUtils {
    private static Logger LOGGER = Logger.getLogger(EclipseUIUtils.class);

    public static IWorkbenchWindow getWorkbenchWindow() {
        if (!UIUtils.runsInUIThread()) {
            LOGGER.warn((Object)"Eclipse UI utilities work correctly only when called from the UI thread.");
        }
        IWorkbenchWindow window = null;
        if (Workbench.getInstance() != null) {
            IWorkbench wb = PlatformUI.getWorkbench();
            window = wb.getActiveWorkbenchWindow();
        }
        return window;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchPage page = null;
        IWorkbenchWindow workbenchWindow = EclipseUIUtils.getWorkbenchWindow();
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        return page;
    }

    public static IViewPart showView(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"Provided view ID was null.");
        AtomicReference result = new AtomicReference();
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(() -> {
            try {
                result.set(EclipseUIUtils.getActivePage().showView(id));
            }
            catch (PartInitException e) {
                String message = "Error occurred while initializing view with ID: '" + id + "'.";
                LOGGER.error((Object)message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
        });
        return (IViewPart)result.get();
    }

    public static void waitForEditorToBeActive(IWorkbenchPage page, IEditorPart editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Provided editor was null.");
        }
        boolean runsInUI = UIUtils.runsInUIThread();
        if (runsInUI) {
            LOGGER.warn((Object)"Waiting for editor runs in the UI thread which can lead to UI thread starvation.");
        }
        long maxWait = 5000L;
        boolean editorIsActive = false;
        boolean wasInterrupted = false;
        Stopwatch sw = Stopwatch.createStarted();
        do {
            boolean bl = editorIsActive = page.getActiveEditor() == editor;
            if (editorIsActive) continue;
            try {
                if (runsInUI) {
                    UIUtils.waitForUiThread();
                    continue;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                LOGGER.error((Object)("Waiting for editor was interrupted after " + sw + "."), (Throwable)e);
            }
        } while (sw.elapsed(TimeUnit.MILLISECONDS) < 5000L && !editorIsActive && !wasInterrupted);
        sw.stop();
        if (!editorIsActive && !wasInterrupted) {
            throw new TimeoutRuntimeException("Provided editor " + editor + " was not active after " + sw + ".");
        }
    }

    public static IEditorPart openFileEditor(final IFile file, final IWorkbenchPage page, final String editorId) {
        Preconditions.checkNotNull((Object)file, (Object)"Provided file was null.");
        Preconditions.checkNotNull((Object)page, (Object)"Provided page was null.");
        Preconditions.checkNotNull((Object)editorId, (Object)"Provided editor ID was null.");
        final AtomicReference refFileEditor = new AtomicReference();
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    refFileEditor.set(IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorId, (boolean)true));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        return (IEditorPart)refFileEditor.get();
    }

    public static void toggleAutobuild(boolean enable) {
        AutobuildUtils.set((boolean)enable);
    }
}

