/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.jsdoc2spec.CheckCanceled;

public class SubMonitorMsg
implements IProgressMonitor {
    private final IProgressMonitor monitor;
    private final SubMonitor subMonitor;
    private final Consumer<String> callbackMsg;
    private final Consumer<String> callbackErr;
    private final CheckCanceled checkCanceled;

    public static SubMonitorMsg nullProgressMonitor() {
        return new SubMonitorMsg();
    }

    private SubMonitorMsg() {
        this.subMonitor = null;
        this.monitor = new NullProgressMonitor();
        this.callbackMsg = this::devNull;
        this.callbackErr = this::devNull;
        this.checkCanceled = this::noCheck;
    }

    void devNull(String str) {
    }

    void noCheck(IProgressMonitor m) {
    }

    public SubMonitorMsg(SubMonitor subMonitor, Consumer<String> callbackMsg, CheckCanceled checkCanceled) {
        this(subMonitor, callbackMsg, callbackMsg, checkCanceled);
    }

    public SubMonitorMsg(SubMonitor subMonitor, Consumer<String> callbackMsg, Consumer<String> callbackErr, CheckCanceled checkCanceled) {
        this.subMonitor = subMonitor;
        this.monitor = subMonitor;
        this.callbackMsg = callbackMsg;
        this.callbackErr = callbackErr;
        this.checkCanceled = checkCanceled;
    }

    public SubMonitorMsg newChild(int i) {
        SubMonitor child = this.subMonitor.newChild(i);
        return new SubMonitorMsg(child, this.callbackMsg, this.callbackErr, this.checkCanceled);
    }

    public SubMonitorMsg convert(int i) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)this.subMonitor, (int)i);
        return new SubMonitorMsg(sub, this.callbackMsg, this.callbackErr, this.checkCanceled);
    }

    public void beginTask(String name, int totalWork) {
        this.monitor.beginTask(name, totalWork);
        this.fireMsgString(name);
    }

    public void done() {
        this.monitor.done();
    }

    public void internalWorked(double work) {
        this.monitor.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.monitor.setCanceled(value);
    }

    public void setTaskName(String name) {
        this.monitor.setTaskName(name);
        this.fireMsgString(name);
    }

    public void subTask(String name) {
        this.monitor.subTask(name);
        this.fireMsgString(name);
    }

    public void worked(int work) {
        this.monitor.worked(work);
    }

    private void fireMsgString(String msg) {
        this.callbackMsg.accept(msg);
    }

    private void fireErrString(String msg) {
        this.callbackErr.accept(msg);
    }

    public String pushMessage(String msg) {
        this.fireMsgString(msg);
        return msg;
    }

    public String pushError(String msg) {
        this.fireErrString(msg);
        return msg;
    }

    public void checkCanceled() throws InterruptedException {
        this.checkCanceled.check(this.monitor);
    }
}

