/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceModel;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.internal.N4JSProjectExplorerHelper;
import org.eclipse.n4js.ui.preferences.external.ExternalLibraryPreferencePage;
import org.eclipse.swt.graphics.Image;

class BuiltInLibrariesLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final N4JSProjectExplorerHelper projectExplorerhelper;

    public BuiltInLibrariesLabelProvider(N4JSProjectExplorerHelper projectExplorerhelper) {
        this.projectExplorerhelper = projectExplorerhelper;
    }

    public String getText(Object element) {
        if (element instanceof URI) {
            return this.getCategoryText((URI)element).getString();
        }
        if (element instanceof IN4JSProject) {
            return ((IN4JSProject)element).getProjectName();
        }
        return super.getText(element);
    }

    private StyledString getCategoryText(URI location) {
        String externalLibId = ExternalLibraryPreferencePage.BUILT_IN_LIBS.get(location);
        if (!Strings.isNullOrEmpty((String)externalLibId)) {
            return new StyledString((String)ExternalLibrariesActivator.EXTERNAL_LIBRARY_NAMES.get(externalLibId));
        }
        File file = new File(location);
        if (ExternalLibraryPreferenceModel.isNodeModulesLocation((URI)location)) {
            Path path = file.toPath();
            int pCount = path.getNameCount();
            StyledString styledString = new StyledString(path.getName(pCount - 1).toString());
            styledString.append(" (" + path.getName(pCount - 2) + ")", StyledString.QUALIFIER_STYLER);
            return styledString;
        }
        return new StyledString(file.getAbsolutePath());
    }

    public Image getImage(Object element) {
        if (element instanceof URI) {
            return (Image)ImageDescriptorCache.ImageRef.LIB_PATH.asImage().orNull();
        }
        if (element instanceof IN4JSProject) {
            return (Image)ImageDescriptorCache.ImageRef.EXTERNAL_LIB_PROJECT.asImage().orNull();
        }
        return super.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof URI) {
            return this.getCategoryText((URI)element);
        }
        if (element instanceof IN4JSProject) {
            return this.projectExplorerhelper.getStyledTextForExternalProject((IN4JSProject)element, null);
        }
        return new StyledString("unknown");
    }
}

