/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;

class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private final PreferenceAction fToggle;
    private final TextOperationAction fExpand;
    private final TextOperationAction fExpandAll;
    private final IProjectionListener fProjectionListener;
    private final TextOperationAction fCollapse;
    private final TextOperationAction fCollapseAll;

    public FoldingActionGroup(final ITextEditor editor, ITextViewer viewer) {
        if (!(viewer instanceof ProjectionViewer)) {
            this.fToggle = null;
            this.fExpand = null;
            this.fExpandAll = null;
            this.fCollapse = null;
            this.fCollapseAll = null;
            this.fProjectionListener = null;
            return;
        }
        this.fViewer = (ProjectionViewer)viewer;
        this.fProjectionListener = new IProjectionListener(){

            public void projectionEnabled() {
                FoldingActionGroup.this.update();
            }

            public void projectionDisabled() {
                FoldingActionGroup.this.update();
            }
        };
        this.fViewer.addProjectionListener(this.fProjectionListener);
        this.fToggle = new PreferenceAction(SSEUIMessages.getResourceBundle(), "Projection_Toggle_", 2){

            public void run() {
                IPreferenceStore store;
                boolean current = (store = SSEUIPlugin.getDefault().getPreferenceStore()).getBoolean("foldingEnabled");
                store.setValue("foldingEnabled", !current);
            }

            public void update() {
                ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
                boolean isEnabled = target != null && target.canDoOperation(19);
                this.setEnabled(isEnabled);
            }
        };
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        boolean checked = store.getBoolean("foldingEnabled");
        this.fToggle.setChecked(checked);
        this.fToggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
        editor.setAction("FoldingToggle", (IAction)this.fToggle);
        this.fExpand = new TextOperationAction(SSEUIMessages.getResourceBundle(), "Projection_Expand_", editor, 17, true);
        this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
        editor.setAction("FoldingExpand", (IAction)this.fExpand);
        this.fExpandAll = new TextOperationAction(SSEUIMessages.getResourceBundle(), "Projection_ExpandAll_", editor, 20, true);
        this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
        editor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
        this.fCollapse = new TextOperationAction(SSEUIMessages.getResourceBundle(), "Projection_Collapse_", editor, 18, true);
        this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
        editor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        this.fCollapseAll = new TextOperationAction(SSEUIMessages.getResourceBundle(), "Projection_CollapseAll_", editor, 21, true);
        this.fCollapseAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse_all");
        editor.setAction("FoldingCollapseAll", (IAction)this.fCollapseAll);
    }

    protected boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fToggle.update();
            this.fToggle.setChecked(this.fViewer.isProjectionMode());
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
            this.fCollapseAll.update();
        }
    }

    public void fillMenu(IMenuManager manager) {
        if (this.isEnabled()) {
            this.update();
            manager.add((IAction)this.fToggle);
            manager.add((IAction)this.fExpand);
            manager.add((IAction)this.fExpandAll);
            manager.add((IAction)this.fCollapse);
            manager.add((IAction)this.fCollapseAll);
        }
    }

    public void updateActionBars() {
        this.update();
    }

    private static abstract class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle bundle, String prefix, int style) {
            super(bundle, prefix, style);
        }
    }
}

