/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.FlowEdge;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalker;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorer;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class AllNodesAndEdgesPrintVisitor
extends GraphVisitor {
    final Set<FlowEdge> allEdges = new HashSet<FlowEdge>();
    final List<ControlFlowElement> allNodes = new LinkedList<ControlFlowElement>();
    final Set<ControlFlowElement> allDeadNodesGV = new HashSet<ControlFlowElement>();
    final Set<ControlFlowElement> allDeadNodesBW = new HashSet<ControlFlowElement>();

    public AllNodesAndEdgesPrintVisitor(ControlFlowElement container) {
        super(container, TraverseDirection.Forward);
    }

    @Override
    protected void initializeContainer(ControlFlowElement curContainer) {
        this.requestActivation(new AllNodesAndEdgesExplorer());
    }

    @Override
    protected void visit(ControlFlowElement cfe) {
        this.allNodes.add(cfe);
        if (this.isDeadCodeNode()) {
            this.allDeadNodesGV.add(cfe);
        }
    }

    @Override
    protected void terminateContainer(ControlFlowElement curContainer) {
        Preconditions.checkState((this.allDeadNodesGV.size() == this.allDeadNodesBW.size() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.allDeadNodesGV.containsAll(this.allDeadNodesBW));
        this.allDeadNodesGV.clear();
        this.allDeadNodesBW.clear();
    }

    public List<String> getAllNodeStrings() {
        LinkedList<String> nodeStrings = new LinkedList<String>();
        for (ControlFlowElement node : this.allNodes) {
            nodeStrings.add(FGUtils.getSourceText((EObject)node));
        }
        return nodeStrings;
    }

    public List<String> getAllEdgeStrings() {
        LinkedList<String> edgeStrings = new LinkedList<String>();
        for (FlowEdge edge : this.allEdges) {
            edgeStrings.add(edge.toString());
        }
        return edgeStrings;
    }

    class AllNodesAndEdgesBranchWalker
    extends BranchWalker {
        AllNodesAndEdgesBranchWalker() {
        }

        @Override
        protected BranchWalker forkPath() {
            return new AllNodesAndEdgesBranchWalker();
        }

        @Override
        protected void visit(ControlFlowElement cfe) {
            if (this.isDeadCodeNode()) {
                AllNodesAndEdgesPrintVisitor.this.allDeadNodesBW.add(cfe);
            }
        }

        @Override
        protected void visit(FlowEdge edge) {
            boolean considerEdge = true;
            considerEdge &= !edge.isDead();
            considerEdge &= edge.start != this.getContainer();
            if (considerEdge &= edge.end != this.getContainer()) {
                AllNodesAndEdgesPrintVisitor.this.allEdges.add(edge);
            }
        }
    }

    class AllNodesAndEdgesExplorer
    extends GraphExplorer {
        AllNodesAndEdgesExplorer() {
        }

        @Override
        protected BranchWalker joinBranches(List<BranchWalker> branchWalkers) {
            return new AllNodesAndEdgesBranchWalker();
        }

        @Override
        protected BranchWalkerInternal firstBranchWalker() {
            return new AllNodesAndEdgesBranchWalker();
        }
    }
}

