/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.xtext.builder.MonitorBasedCancelIndicator;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class ResourceLoadingStatistics {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public void computeAndShowStatsForWorkspace(PrintStream out, IProgressMonitor monitor) {
        MonitorBasedCancelIndicator cancelIndicator = new MonitorBasedCancelIndicator(monitor);
        int uriCount = 0;
        LinkedHashMap<IN4JSProject, List<URI>> urisPerProject = new LinkedHashMap<IN4JSProject, List<URI>>();
        Iterable projects = this.n4jsCore.findAllProjects();
        for (IN4JSProject iN4JSProject : projects) {
            this.operationCanceledManager.checkCanceled((CancelIndicator)cancelIndicator);
            if (this.isManagedByLibraryManager(iN4JSProject)) continue;
            List<URI> uris = this.collectURIsToInvestigate(iN4JSProject);
            uriCount += uris.size();
            urisPerProject.put(iN4JSProject, uris);
        }
        monitor.beginTask("Investigate projects in workspace ... ", uriCount);
        for (Map.Entry entry : urisPerProject.entrySet()) {
            this.operationCanceledManager.checkCanceled((CancelIndicator)cancelIndicator);
            Stopwatch stopwatch = Stopwatch.createStarted();
            IN4JSProject project = (IN4JSProject)entry.getKey();
            List uris = (List)entry.getValue();
            List<FileLoadInfo> results = this.investigate(project, uris, out, monitor, false);
            out.println();
            out.println("SUMMARY:");
            out.println();
            FileLoadInfo.printReport(project, results, out, stopwatch.toString());
        }
    }

    public void computeAndShowStatsForResourceSet(ResourceSet resSet, PrintStream out) {
        FileLoadInfo info = this.investigate(resSet);
        info.println(out);
    }

    private List<FileLoadInfo> investigate(IN4JSProject project, List<URI> urisToInvestigate, PrintStream out, IProgressMonitor monitor, boolean printProgressToOut) {
        int urisCount = urisToInvestigate.size();
        ArrayList<FileLoadInfo> results = new ArrayList<FileLoadInfo>(urisCount);
        int i = 0;
        while (i < urisCount) {
            block9: {
                URI uri = urisToInvestigate.get(i);
                monitor.subTask("Investigating file " + uri.lastSegment() + " ...");
                Stopwatch perResource = Stopwatch.createStarted();
                if (printProgressToOut) {
                    int progress = (int)Math.floor((float)i / (float)urisCount * 100.0f);
                    out.println("Investigating file " + uri.lastSegment() + " (" + (i + 1) + "/" + urisCount + ", " + progress + "%) ...");
                }
                try {
                    FileLoadInfo currResult = this.investigate(project, uri, monitor);
                    results.add(currResult);
                    currResult.timeInMs = perResource.elapsed(TimeUnit.MILLISECONDS);
                    currResult.println(out);
                }
                catch (Throwable th) {
                    if (this.operationCanceledManager.isOperationCanceledException(th)) {
                        ArrayList<FileLoadInfo> arrayList = results;
                        monitor.worked(1);
                        return arrayList;
                    }
                    try {
                        th.printStackTrace();
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
                monitor.worked(1);
            }
            ++i;
        }
        return results;
    }

    private FileLoadInfo investigate(IN4JSProject project, URI fileURI, IProgressMonitor monitor) {
        MonitorBasedCancelIndicator cancelIndicator = new MonitorBasedCancelIndicator(monitor);
        this.operationCanceledManager.checkCanceled((CancelIndicator)cancelIndicator);
        ResourceSet resSet = this.n4jsCore.createResourceSet(Optional.of((Object)project));
        N4JSResource res = (N4JSResource)resSet.createResource(fileURI);
        try {
            res.load(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        res.getContents();
        res.resolveLazyCrossReferences((CancelIndicator)cancelIndicator);
        return this.investigate(resSet);
    }

    private FileLoadInfo investigate(ResourceSet resSet) {
        Resource resMain = (Resource)resSet.getResources().get(0);
        FileLoadInfo result = new FileLoadInfo(resMain.getURI());
        result.countTotal = resSet.getResources().size();
        result.countBuiltIn = this.countN4JSResourcesBuiltIn(resSet);
        result.countLoadedFromAST = this.countN4JSResourcesLoadedFromAST(resSet) - 1;
        result.countLoadedFromIndex = this.countN4JSResourcesLoadedFromIndex(resSet);
        return result;
    }

    private int countN4JSResourcesBuiltIn(ResourceSet resSet) {
        int n = 0;
        for (Resource res : resSet.getResources()) {
            if (!this.isBuiltInResource(res)) continue;
            ++n;
        }
        return n;
    }

    private int countN4JSResourcesLoadedFromAST(ResourceSet resSet) {
        int n = 0;
        for (Resource res : resSet.getResources()) {
            N4JSResource resCasted;
            if (this.isBuiltInResource(res) || !(res instanceof N4JSResource) || (resCasted = (N4JSResource)res).isLoadedFromDescription()) continue;
            ++n;
        }
        return n;
    }

    private int countN4JSResourcesLoadedFromIndex(ResourceSet resSet) {
        int n = 0;
        for (Resource res : resSet.getResources()) {
            N4JSResource resCasted;
            if (this.isBuiltInResource(res) || !(res instanceof N4JSResource) || !(resCasted = (N4JSResource)res).isLoadedFromDescription()) continue;
            ++n;
        }
        return n;
    }

    private List<URI> collectURIsToInvestigate(IN4JSProject project) {
        ArrayList urisToInvestigate = Lists.newArrayList();
        for (IN4JSSourceContainer container : project.getSourceContainers()) {
            for (URI uri : container) {
                String fileExtension;
                switch (fileExtension = uri.fileExtension()) {
                    case "n4js": 
                    case "n4jsd": 
                    case "n4jsx": {
                        urisToInvestigate.add(uri);
                    }
                }
            }
        }
        return urisToInvestigate;
    }

    private boolean isBuiltInResource(Resource res) {
        return N4Scheme.isResourceWithN4Scheme((Resource)res);
    }

    private boolean isManagedByLibraryManager(IN4JSProject project) {
        if (project instanceof IN4JSEclipseProject) {
            IProject eclipseProject = ((IN4JSEclipseProject)project).getProject();
            return eclipseProject instanceof ExternalProject;
        }
        return false;
    }

    private static final class FileLoadInfo {
        final URI fileURI;
        int countTotal;
        int countBuiltIn;
        int countLoadedFromAST;
        int countLoadedFromIndex;
        long timeInMs;

        public FileLoadInfo(URI fileURI) {
            this.fileURI = fileURI;
        }

        void println(PrintStream out) {
            String name = this.fileURI.lastSegment();
            out.printf("%-50s   %3d   (%3d = %3d + %3d + %3d) in %5d ms", name, this.countTotal, this.countLoadedFromAST + this.countLoadedFromIndex + this.countBuiltIn, this.countLoadedFromAST, this.countLoadedFromIndex, this.countBuiltIn, this.timeInMs);
            out.println();
        }

        static void printReport(IN4JSProject project, List<FileLoadInfo> results, PrintStream out, String elapsedTime) {
            out.println("------------------------------------------------------------------------------------");
            out.println("Resource loading per file for project: " + project.getLocation().lastSegment() + " took " + elapsedTime);
            out.println();
            List<FileLoadInfo> othersFromAST = results.stream().filter(result -> result.countLoadedFromAST > 0).collect(Collectors.toList());
            List<FileLoadInfo> noOthersFromAST = results.stream().filter(result -> result.countLoadedFromAST == 0).collect(Collectors.toList());
            out.println("Files that triggered other files being loaded from AST:");
            if (!othersFromAST.isEmpty()) {
                othersFromAST.forEach(result -> result.println(out));
            } else {
                out.println("None.");
            }
            out.println();
            out.println("Files that did *not* trigger other files being loaded from AST:");
            if (!noOthersFromAST.isEmpty()) {
                noOthersFromAST.forEach(result -> result.println(out));
            } else {
                out.println("None.");
            }
            out.println();
            out.println("Legend: countTotal (sum = countLoadedFromAST + countLoadedFromIndex + countBuiltIn)");
            out.println();
            out.println("Files that triggered other files being loaded from AST        : " + othersFromAST.size());
            out.println("Files that did *not* trigger other files being loaded from AST: " + noOthersFromAST.size());
            out.println("------------------------------------------------------------------------------------");
        }
    }
}

