/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.refactoring;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.util.TypeModelUtils;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameStrategy;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public class N4JSRenameStrategy
extends DefaultRenameStrategy {
    @Inject
    private GrammarProvider grammarProvider;
    private final List<URI> targetElementNewURIs = new ArrayList<URI>();

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        EObject targetElement = resourceSet.getEObject(this.getTargetElementOriginalURI(), true);
        if (TypeModelUtils.isComposedTElement((EObject)targetElement)) {
            EList constituentMembers = ((TMember)targetElement).getConstituentMembers();
            for (TMember constituentMember : constituentMembers) {
                String text = newName;
                EAttribute att = this.getNameAttribute((EObject)constituentMember);
                ITextRegion nameRegion = this.getOriginalNameRegion((EObject)constituentMember, att);
                ReplaceEdit replaceEdit = new ReplaceEdit(nameRegion.getOffset(), nameRegion.getLength(), text);
                updateAcceptor.accept(EcoreUtil.getURI((EObject)constituentMember).trimFragment(), (TextEdit)replaceEdit);
            }
        } else {
            updateAcceptor.accept(this.getTargetElementOriginalURI().trimFragment(), this.getDeclarationTextEdit(newName));
        }
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        EObject targetElement = resourceSet.getEObject(this.getTargetElementOriginalURI(), true);
        if (TypeModelUtils.isComposedTElement((EObject)targetElement)) {
            this.targetElementNewURIs.clear();
            EList constituentMembers = ((TMember)targetElement).getConstituentMembers();
            for (TMember constituentMember : constituentMembers) {
                URI constituentMemberURI = EcoreUtil.getURI((EObject)constituentMember);
                EObject renamedElement = this.setName(constituentMemberURI, newName, resourceSet);
                this.targetElementNewURIs.add(EcoreUtil.getURI((EObject)renamedElement));
            }
        }
        super.applyDeclarationChange(this.getNameAsValue(newName), resourceSet);
    }

    public void revertDeclarationChange(ResourceSet resourceSet) {
        EObject targetElement = resourceSet.getEObject(this.getTargetElementOriginalURI(), true);
        if (TypeModelUtils.isComposedTElement((EObject)targetElement)) {
            for (URI targetElementNewURI : this.targetElementNewURIs) {
                this.setName(targetElementNewURI, this.getOriginalName(), resourceSet);
            }
        }
        super.revertDeclarationChange(resourceSet);
    }

    protected ITextRegion getOriginalNameRegion(EObject targetElement, EAttribute nameAttribute) {
        EObject nameElement;
        if (targetElement instanceof SyntaxRelatedTElement && (nameElement = ((SyntaxRelatedTElement)targetElement).getAstElement()) instanceof PropertyNameOwner) {
            nameElement = ((PropertyNameOwner)nameElement).getDeclaredName();
            EAttribute nAttribute = SimpleAttributeResolver.newResolver(String.class, (String)"literalName").getAttribute(nameElement);
            return this.getOriginalNameRegion(nameElement, nAttribute);
        }
        return super.getOriginalNameRegion(targetElement, nameAttribute);
    }

    public RefactoringStatus validateNewName(String newName) {
        Grammar grammar;
        ParserRule parserRule;
        IParser parser = (IParser)N4LanguageUtils.getServiceForContext((String)"n4js", IParser.class).get();
        IParseResult parseResult = parser.parse(parserRule = (ParserRule)GrammarUtil.findRuleForName((Grammar)(grammar = this.getTypeExpressionsGrammar()), (String)"org.eclipse.n4js.ts.TypeExpressions.IdentifierName"), (Reader)new StringReader(newName));
        if (parseResult.hasSyntaxErrors()) {
            String parseErrorMessages = Joiner.on((String)"\n").join(Iterables.transform((Iterable)parseResult.getSyntaxErrors(), node -> node.getSyntaxErrorMessage().getMessage()));
            return RefactoringStatus.createFatalErrorStatus((String)parseErrorMessages);
        }
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    protected Grammar getTypeExpressionsGrammar() {
        Grammar grammar = this.grammarProvider.getGrammar((Object)this);
        while (grammar != null) {
            if ("org.eclipse.n4js.ts.TypeExpressions".equals(grammar.getName())) {
                return grammar;
            }
            EList grammars = grammar.getUsedGrammars();
            if (!grammars.isEmpty()) {
                grammar = (Grammar)grammars.iterator().next();
                continue;
            }
            return null;
        }
        return grammar;
    }
}

