/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerModificationStrategy;
import org.eclipse.n4js.utils.Diff;

public abstract class WorkingSetManagerModificationStrategyImpl
implements WorkingSetManagerModificationStrategy {
    protected WorkingSet getWorkingSetByName(WorkingSetManager manager, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        return (WorkingSet)FluentIterable.from(Arrays.asList(manager.getAllWorkingSets())).firstMatch(ws -> name.equals(ws.getName())).orNull();
    }

    protected void updateAndSaveState(WorkingSetManager manager, Diff<WorkingSet> diff) {
        if (!diff.isEmpty()) {
            manager.updateState(diff);
            manager.saveState((IProgressMonitor)new NullProgressMonitor());
            this.refreshNavigator(manager);
        }
    }

    protected void refreshNavigator(WorkingSetManager manager) {
        manager.getWorkingSetManagerBroker().refreshNavigator();
    }
}

