/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.fsm;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.events.SessionFailedEvent;
import org.eclipse.n4js.tester.fsm.FsmState;
import org.eclipse.n4js.tester.fsm.TestFsm;

public class TestFsmImpl
implements TestFsm {
    private static final Logger LOGGER = Logger.getLogger(TestFsmImpl.class);
    private final TesterEventBus bus;
    private final LoadingCache<String, String> visitedTestIds;
    private final LoadingCache<String, String> executedTestIds;
    private final TestTimeouter testTimeouter;
    private final SessionTimeouter setupTimeouter;
    private volatile long setupTimeout;
    private volatile FsmState currentState;
    private String currentSessionId;

    @Inject
    public TestFsmImpl(TesterEventBus bus, @Named(value="setupFsmTimeoutKey") long setupTimeout) {
        this.bus = bus;
        this.setupTimeout = setupTimeout;
        this.visitedTestIds = CacheBuilder.newBuilder().build(this.getTestIdCacheLoader());
        this.executedTestIds = CacheBuilder.newBuilder().build(this.getTestIdCacheLoader());
        this.currentState = FsmState.NOT_INITIALIZED;
        this.setupTimeouter = new SessionTimeouter();
        this.testTimeouter = new TestTimeouter();
    }

    @Override
    public synchronized TestFsmImpl initializeSession(String sessionId) {
        if (this.isFailed()) {
            return this;
        }
        this.currentSessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Session ID argument cannot be null.");
        if (FsmState.NOT_INITIALIZED == this.currentState) {
            this.currentState = FsmState.IDLE;
            this.setupTimeouter.scheduleTimeouter(this.setupTimeout);
            return this;
        }
        return this.fail("Failed when initializing test session. " + this.toString());
    }

    @Override
    public synchronized TestFsmImpl startSession(String sessionId) {
        if (this.isFailed()) {
            return this;
        }
        if (FsmState.IDLE == this.currentState && this.currentSessionId.equals(sessionId)) {
            this.setupTimeouter.scheduleTimeouter(this.setupTimeout);
            this.currentState = FsmState.SESSION_STARTED;
            return this;
        }
        return this.fail("Failed when starting test session. " + this.toString());
    }

    @Override
    public synchronized TestFsmImpl endSession(String sessionId) {
        if (this.isFailed()) {
            return this;
        }
        if ((FsmState.SESSION_STARTED == this.currentState || FsmState.EXECUTING_TESTS == this.currentState || FsmState.IDLE == this.currentState) && this.currentSessionId.equals(sessionId)) {
            return this.dispose(FsmState.NOT_INITIALIZED);
        }
        return this.fail("Failed when ending test session. " + this.toString());
    }

    @Override
    public synchronized TestFsmImpl pingSession(String sessionId, long timeout) {
        if (this.isFailed()) {
            return this;
        }
        if (FsmState.SESSION_STARTED == this.currentState && this.currentSessionId.equals(sessionId)) {
            this.setupTimeout = timeout;
            this.setupTimeouter.scheduleTimeouter(this.setupTimeout);
            return this;
        }
        return this.fail("Failed when pinging test session. " + this.toString());
    }

    @Override
    public synchronized TestFsmImpl startTest(String testId, long timeout) {
        if (this.isFailed()) {
            return this;
        }
        if (!(FsmState.SESSION_STARTED != this.currentState && FsmState.EXECUTING_TESTS != this.currentState || Strings.isNullOrEmpty((String)testId) || this.visitedTestIds.getIfPresent((Object)testId) != null)) {
            this.setupTimeouter.cancel();
            this.currentState = FsmState.EXECUTING_TESTS;
            this.testTimeouter.schedule(testId, timeout);
            this.visitedTestIds.getUnchecked((Object)testId);
            return this;
        }
        return this.fail("Failed when starting test: " + testId + " " + this.toString());
    }

    @Override
    public synchronized TestFsmImpl endTest(String testId) {
        if (this.isFailed()) {
            return this;
        }
        if (FsmState.EXECUTING_TESTS == this.currentState && !Strings.isNullOrEmpty((String)testId) && this.visitedTestIds.getIfPresent((Object)testId) != null) {
            this.currentState = FsmState.EXECUTING_TESTS;
            this.testTimeouter.cancel(testId);
            this.executedTestIds.getUnchecked((Object)testId);
            return this;
        }
        return this.fail("Failed when ending test: " + testId + " " + this.toString());
    }

    @Override
    public synchronized TestFsmImpl pingTest(String testId, long timeout) {
        if (this.isFailed()) {
            return this;
        }
        if (!(FsmState.SESSION_STARTED != this.currentState && FsmState.EXECUTING_TESTS != this.currentState || Strings.isNullOrEmpty((String)testId))) {
            if (this.executedTestIds.getIfPresent((Object)testId) == null) {
                this.testTimeouter.schedule(testId, timeout);
            }
            return this;
        }
        return this.fail("Failed when pinging test: " + testId + " " + this.toString());
    }

    boolean isFailed() {
        return this.currentState == FsmState.FAILED;
    }

    TestFsmImpl fail(String comment) {
        if (FsmState.FAILED != this.currentState) {
            if (comment != null) {
                LOGGER.info((Object)("Test session failed. " + comment));
            }
            this.bus.post(new SessionFailedEvent(this.currentSessionId, comment));
            return this.dispose(FsmState.FAILED);
        }
        return this;
    }

    private CacheLoader<String, String> getTestIdCacheLoader() {
        return new CacheLoader<String, String>(){

            public String load(String testId) throws Exception {
                return testId;
            }
        };
    }

    private TestFsmImpl dispose(FsmState state) {
        this.testTimeouter.purge();
        this.testTimeouter.cancel();
        this.setupTimeouter.purge();
        this.setupTimeouter.cancel();
        this.visitedTestIds.invalidateAll();
        this.currentState = state;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FSM [Session ID: ");
        sb.append(this.currentSessionId);
        sb.append(" Current state: ");
        sb.append((Object)this.currentState);
        sb.append(" Executed test IDs: ");
        sb.append(Iterables.toString(this.executedTestIds.asMap().keySet()));
        sb.append("]");
        return sb.toString();
    }

    private final class SessionTimeouter
    extends Timer {
        private TimerTask task;

        private SessionTimeouter() {
        }

        private TimerTask newTask() {
            return new TimerTask(){

                @Override
                public void run() {
                    LOGGER.error((Object)("Test session was time outed. [Session ID: '" + TestFsmImpl.this.currentSessionId + "']"));
                    TestFsmImpl.this.fail("Test session '" + TestFsmImpl.this.currentSessionId + "' was time outed.");
                }
            };
        }

        private void scheduleTimeouter(long timeout) {
            this.cancelTimeouter();
            this.task = this.newTask();
            this.schedule(this.task, timeout);
        }

        private void cancelTimeouter() {
            if (this.task != null) {
                this.task.cancel();
            }
        }
    }

    private static final class TestIdTimeoutPair {
        private final String testId;
        private final long timeout;

        private TestIdTimeoutPair(String testId, long timeout) {
            this.testId = testId;
            this.timeout = timeout;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.testId == null ? 0 : this.testId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestIdTimeoutPair other = (TestIdTimeoutPair)obj;
            return !(this.testId == null ? other.testId != null : !this.testId.equals(other.testId));
        }
    }

    private final class TestTimeouter
    extends Timer {
        private final LoadingCache<TestIdTimeoutPair, TimerTask> taskCache = CacheBuilder.newBuilder().removalListener(notification -> {
            boolean bl = ((TimerTask)notification.getValue()).cancel();
        }).build((CacheLoader)new CacheLoader<TestIdTimeoutPair, TimerTask>(){

            public TimerTask load(final TestIdTimeoutPair pair) throws Exception {
                return new TimerTask(){

                    @Override
                    public void run() {
                        LOGGER.error((Object)("Test session was time outed. [Session ID: '" + TestFsmImpl.this.currentSessionId + "', Test ID: '" + pair.testId + "']"));
                        TestFsmImpl.this.fail("Test '" + pair.testId + "' for session '" + TestFsmImpl.this.currentSessionId + "' was time outed after '" + pair.timeout + "' milliseconds.");
                    }
                };
            }
        });

        private TestTimeouter() {
        }

        private void schedule(String testId, long timeout) {
            this.cancel(testId);
            this.schedule((TimerTask)this.taskCache.getUnchecked((Object)new TestIdTimeoutPair(testId, timeout)), timeout);
        }

        private void cancel(String testId) {
            this.taskCache.invalidate((Object)new TestIdTimeoutPair(testId, 0L));
        }
    }
}

